/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public final class StringValue {
    private StringValue() {
    }

    public static int setStringConstantValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        i2 = raw[i2 = StreamReaderUtils.skipSpaces(raw, i2)] == 60 && raw[i2 + 1] == 60 ? StringValue.writeConstantInDirectObject(pdfObject, i2, raw, PDFkeyInt, objectReader) : (raw[i2] >= 48 && raw[i2] <= 57 && StringValue.writeConstantInObject(i2, raw) ? StringValue.readFromIndirectObj(PDFkeyInt, pdfObject, i2, raw, objectReader, raw.length, PDFkeyInt) : StringValue.writeConstant(pdfObject, i2, raw, PDFkeyInt));
        return i2 - 1;
    }

    private static boolean writeConstantInObject(int i2, byte[] raw) {
        int aa2 = StreamReaderUtils.skipToEndOfRef(raw, i2);
        return (aa2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, aa2, 47)) < raw.length && raw[aa2] == 82;
    }

    private static int writeConstantInDirectObject(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        PdfObject childObject = new PdfObject(pdfObject.getObjectRefAsString());
        i2 = Dictionary.readDictionary(childObject, i2, raw, PDFkeyInt, objectReader);
        return i2;
    }

    private static int writeConstant(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt) {
        if (raw[i2] == 47 && raw[i2 + 1] == 32) {
            return i2 + 2;
        }
        int keyStart = i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2 + 1, 47);
        while (raw[i2] != 10 && raw[i2] != 13 && raw[i2] != 32 && raw[i2] != 47 && raw[i2] != 60 && raw[i2] != 62) {
            ++i2;
        }
        pdfObject.setConstant(PDFkeyInt, keyStart, i2 - keyStart, raw);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "Set constant in " + pdfObject + " to " + pdfObject.setConstant(PDFkeyInt, keyStart, i2 - keyStart, raw));
        }
        return i2;
    }

    private static int readFromIndirectObj(int PDFkeyInt, PdfObject pdfObject, int i2, byte[] raw, PdfFileReader objectReader, int rawLength, int number) {
        int keyStart = i2 = StreamReaderUtils.skipSpaces(raw, i2);
        i2 = StreamReaderUtils.skipToEndOfRef(raw, i2);
        int generation = NumberUtils.parseInt(keyStart, i2, raw);
        while (raw[i2] == 10 || raw[i2] == 13 || raw[i2] == 32 || raw[i2] == 47 || raw[i2] == 60) {
            ++i2;
        }
        if (raw[i2] != 82) {
            throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
        }
        byte[] data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
        if (data == null) {
            pdfObject.setFullyResolved(false);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Data not yet loaded");
            }
            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (8)");
            return rawLength;
        }
        int[] pos = NumberValue.extractDataFromIndirectRef(data);
        i2 = StringValue.writeConstant(pdfObject, pos[0], raw, PDFkeyInt);
        return i2 - 1;
    }

    public static int setStringKeyValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt) {
        int keyStart = i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2 + 1, 47);
        boolean isNull = false;
        while (raw[i2] != 82 && !isNull) {
            if (PDFkeyInt == 1110793845 && StreamReaderUtils.isNull(raw, i2)) {
                isNull = true;
            }
            ++i2;
        }
        if (!isNull) {
            StringValue.setValue(pdfObject, 1 + i2 - keyStart, raw, PDFkeyInt, keyStart);
        }
        return i2 - 1;
    }

    private static void setValue(PdfObject pdfObject, int keyLength, byte[] raw, int PDFkeyInt, int keyStart) {
        byte[] stringBytes = new byte[keyLength];
        System.arraycopy(raw, keyStart, stringBytes, 0, keyLength);
        pdfObject.setStringKey(PDFkeyInt, stringBytes);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "Set constant in " + pdfObject + " to " + new String(stringBytes));
        }
    }
}

