/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectUtils;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.utils.NumberUtils;

public final class StreamReaderUtils {
    private StreamReaderUtils() {
    }

    static boolean handleIndirect(byte[] raw, int aa2) {
        boolean indirect = true;
        int length = raw.length;
        while (raw[aa2] != 93 && ++aa2 < length && (raw[aa2] != 82 || raw[aa2 - 1] != 32 && raw[aa2 - 1] != 10 && raw[aa2 - 1] != 13)) {
            if ((raw[aa2] != 62 || raw[aa2 - 1] != 62) && raw[aa2] != 47) continue;
            indirect = false;
            break;
        }
        return indirect;
    }

    public static int findDictionaryEnd(int jj, byte[] raw, int length) {
        int keyLength = 0;
        while (raw[jj] != 32 && raw[jj] != 13 && raw[jj] != 9 && raw[jj] != 10 && raw[jj] != 91 && raw[jj] != 47 && raw[jj] != 40 && raw[jj] != 60 && raw[jj] != 62) {
            ++keyLength;
            if (++jj != length) continue;
            break;
        }
        return keyLength;
    }

    public static int skipToEndOfRef(byte[] raw, int i2) {
        byte b2 = raw[i2];
        while (b2 != 10 && b2 != 13 && b2 != 32 && b2 != 47 && b2 != 60 && b2 != 62) {
            b2 = raw[++i2];
        }
        return i2;
    }

    public static boolean isNull(byte[] arrayData, int j2) {
        return arrayData[j2] == 110 && arrayData[j2 + 1] == 117 && arrayData[j2 + 2] == 108 && arrayData[j2 + 3] == 108;
    }

    public static int skipComment(byte[] raw, int i2) {
        int len = raw.length;
        while (i2 < len && raw[i2] != 10 && raw[i2] != 13) {
            ++i2;
        }
        while (i2 < len && (raw[i2] == 10 || raw[i2] == 13 || raw[i2] == 32 || raw[i2] == 9)) {
            ++i2;
        }
        return i2;
    }

    static byte[] handleHexString(byte[] newValues, DecryptionFactory decryptor, String ref) {
        String str = new String(newValues).trim();
        byte[] IDbytes = new byte[str.length() / 2];
        int ptr = 0;
        int length = str.length();
        for (int ii = 0; ii < length; ii += 2) {
            if (ii + 2 > length) continue;
            while (str.charAt(ii) == '\n' || str.charAt(ii) == ' ') {
                ++ii;
            }
            String nextValue = str.substring(ii, ii + 2);
            IDbytes[ptr] = (byte)Integer.parseInt(nextValue, 16);
            ++ptr;
        }
        newValues = new byte[ptr];
        System.arraycopy(IDbytes, 0, newValues, 0, ptr);
        if (decryptor != null) {
            byte[] decryptedValue = decryptor.decryptString(IDbytes, ref);
            newValues = decryptedValue == null ? IDbytes : decryptedValue;
        }
        return newValues;
    }

    public static int skipSpaces(byte[] data, int start) {
        int len = data.length;
        while (start < len && (data[start] == 10 || data[start] == 13 || data[start] == 32 || data[start] == 9)) {
            ++start;
        }
        return start;
    }

    public static int skipSpacesOrOtherCharacter(byte[] data, int start, int character) {
        int length = data.length;
        while (start < length && (data[start] == 10 || data[start] == 13 || data[start] == 32 || data[start] == 9 || data[start] == character)) {
            ++start;
        }
        return start;
    }

    public static int skipToCharacter(byte[] data, int start, int character) {
        int length = data.length;
        while (start < length && data[start] != character) {
            ++start;
        }
        return start;
    }

    static int skipToStartOfObject(byte[] data, int start) {
        int len = data.length;
        while (start < len && data[start = StreamReaderUtils.skipSpaces(data, start)] != 60 && data[start] != 91 && data[start] != 47 && !StreamReaderUtils.isRef(data, start) && !StreamReaderUtils.isNull(data, start)) {
            ++start;
        }
        while (StreamReaderUtils.isSpace(data, start - 1)) {
            --start;
        }
        return start;
    }

    public static int skipToEndOfKey(byte[] data, int start) {
        int len = data.length;
        while (start < len && data[start] != 47 && data[start] != 91 && data[start] != 32 && data[start] != 10 && data[start] != 93 && data[start] != 62 && data[start] != 13 && data[start] != 60 && data[start] != 41 && data[start] != 9 && data[start] != 40) {
            ++start;
        }
        return start;
    }

    private static boolean isSpace(byte[] arrayData, int endPtr) {
        return arrayData[endPtr] == 32 || arrayData[endPtr] == 13 || arrayData[endPtr] == 10;
    }

    static boolean isNumber(byte[] arrayData, int j2) {
        boolean isNumber = true;
        int count = arrayData.length;
        int chars = 0;
        j2 = StreamReaderUtils.skipSpaces(arrayData, j2);
        while (isNumber && j2 < count && (chars <= 0 || arrayData[j2] != 40 && arrayData[j2] != 91 && arrayData[j2] != 60 && arrayData[j2] != 32 && arrayData[j2] != 47)) {
            if (arrayData[j2] >= 48 && arrayData[j2] <= 57) {
                ++j2;
                ++chars;
                continue;
            }
            isNumber = false;
        }
        return isNumber;
    }

    public static boolean isRef(byte[] arrayData, int j2) {
        boolean isRef = true;
        int count = arrayData.length;
        int elementCount = 0;
        j2 = StreamReaderUtils.skipSpaces(arrayData, j2);
        while (isRef && elementCount < 3 && j2 < count && arrayData[j2] != 82) {
            if (arrayData[j2] >= 48 && arrayData[j2] <= 57) {
                ++j2;
                continue;
            }
            if (StreamReaderUtils.isSpace(arrayData, j2)) {
                ++elementCount;
                j2 = StreamReaderUtils.skipSpaces(arrayData, j2);
                continue;
            }
            isRef = false;
        }
        return isRef && elementCount == 2;
    }

    public static int readStartRef(byte[] arrayData, int j2) {
        int count = arrayData.length;
        boolean isRef = count > 2;
        int elementCount = 0;
        j2 = StreamReaderUtils.skipSpaces(arrayData, j2);
        while (isRef && elementCount < 3 && j2 + 2 < count && arrayData[j2] != 111 && arrayData[j2 + 1] != 98 && arrayData[j2 + 2] != 106) {
            if (arrayData[j2] >= 48 && arrayData[j2] <= 57) {
                ++j2;
                continue;
            }
            if (StreamReaderUtils.isSpace(arrayData, j2)) {
                ++elementCount;
                j2 = StreamReaderUtils.skipSpaces(arrayData, j2);
                continue;
            }
            isRef = false;
        }
        if (isRef && elementCount == 2) {
            return j2 + 3;
        }
        return -1;
    }

    public static boolean isArray(byte[] arrayData, int j2) {
        return arrayData[j2] == 91;
    }

    static boolean isEndObj(byte[] arrayData, int j2) {
        return arrayData[j2] == 101 && arrayData[j2 + 1] == 110 && arrayData[j2 + 2] == 100 && arrayData[j2 + 3] == 111 && arrayData[j2 + 4] == 98 && arrayData[j2 + 5] == 106;
    }

    static int skipToEndOfArray(byte[] data, int start) {
        int level = 1;
        ++start;
        boolean inStream = false;
        while (level > 0) {
            if (!inStream && data[start] == 40) {
                inStream = true;
            } else if (inStream && data[start] == 41 && !ObjectUtils.isEscaped(data, start)) {
                inStream = false;
            }
            if (!inStream) {
                if (data[start] == 91) {
                    ++level;
                } else if (data[start] == 93) {
                    --level;
                }
            }
            ++start;
        }
        return start;
    }

    static int skipToEndOfStream(byte[] data, int start) {
        ++start;
        while (data[start] != 41 || data[start - 1] == 92 && data[start - 2] == 92) {
            ++start;
        }
        return start;
    }

    public static int[] readRefFromStream(byte[] raw, int ptr) {
        int startI = ptr;
        ptr = StreamReaderUtils.skipToEndOfRef(raw, ptr);
        int ref = NumberUtils.parseInt(startI, ptr, raw);
        int keyStart = ptr = StreamReaderUtils.skipSpaces(raw, ptr);
        ptr = StreamReaderUtils.skipToEndOfRef(raw, ptr);
        int generation = NumberUtils.parseInt(keyStart, ptr, raw);
        ptr = StreamReaderUtils.skipSpaces(raw, ptr);
        return new int[]{ref, generation, ptr};
    }
}

