/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.objects.raw.PdfObject;

public final class Stream {
    private Stream() {
    }

    public static void readStreamData(PdfObject pdfObject, int i2, byte[] raw, int length, PdfFileReader objectReader) {
        for (int xx = i2; xx < length - 5 && (raw[xx] != 62 || raw[xx + 1] != 62); ++xx) {
            if (raw[xx] != 115 || raw[xx + 1] != 116 || raw[xx + 2] != 114 || raw[xx + 3] != 101 || raw[xx + 4] != 97 || raw[xx + 5] != 109) continue;
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "1. Stream found afterwards");
            }
            if (pdfObject.isCached()) break;
            Stream.readStreamIntoObject(pdfObject, xx, raw, objectReader);
            break;
        }
    }

    private static void readStreamIntoObject(PdfObject pdfObject, int j2, byte[] data, PdfFileReader objectReader) {
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        int count = data.length;
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "Looking for stream");
        }
        byte[] stream = null;
        for (int a10 = j2; a10 < count; ++a10) {
            if (data[a10] != 115 || data[a10 + 1] != 116 || data[a10 + 2] != 114 || data[a10 + 3] != 101 || data[a10 + 4] != 97 || data[a10 + 5] != 109) continue;
            a10 += 6;
            while (data[a10] == 32) {
                ++a10;
            }
            if (data[a10] == 13 && data[a10 + 1] == 10) {
                a10 += 2;
            } else if (data[a10] == 10 && data[a10 + 1] == 10 && data[a10 + 2] == 10 && data[a10 + 3] == -1) {
                a10 += 3;
            } else if (data[a10] == 10 && data[a10 + 1] == 10 && data[a10 + 2] == -1) {
                a10 += 2;
            } else if (data[a10] == 10 || data[a10] == 13) {
                ++a10;
            }
            int start = a10--;
            int streamLength = 0;
            int setStreamLength = pdfObject.getInt(1043816557);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "setStreamLength=" + setStreamLength);
            }
            if (setStreamLength > 0) {
                setStreamLength = Stream.validateLengthValue(count, setStreamLength, data, start);
                if (decryption != null && decryption.getBooleanValue(101)) {
                    streamLength = pdfObject.getInt(1043816557);
                } else if (setStreamLength != -1) {
                    streamLength = setStreamLength;
                    pdfObject.setIntNumber(1043816557, setStreamLength);
                }
            }
            if (setStreamLength < 1) {
                streamLength = Stream.getStreamLengthManually(data, count, a10, start, streamLength, setStreamLength);
            }
            if (!(streamLength <= 1 || decryption != null && decryption.getBooleanValue(101))) {
                boolean ignoreOddCase;
                int ptr = start + streamLength - 1;
                boolean bl2 = ignoreOddCase = count - ptr > 4 && data[ptr] == 10 && data[ptr + 1] == 13 && data[ptr + 2] == 10 && data[ptr + 3] == 101;
                if (ptr < count && (data[ptr] == 10 && !ignoreOddCase || data[ptr] == 13 && ptr > 0 && data[ptr - 1] == 10)) {
                    --streamLength;
                }
            }
            if (start + streamLength > count) {
                streamLength = count - start;
            }
            if (streamLength < 0) {
                return;
            }
            stream = new byte[streamLength];
            System.arraycopy(data, start, stream, 0, streamLength);
            break;
        }
        if (ObjectDecoder.debugFastCode && stream != null) {
            System.out.println(ObjectDecoder.padding + "stream read saved into " + pdfObject);
        }
        if (pdfObject != null) {
            pdfObject.setStream(stream);
            if (pdfObject.decompressStreamWhenRead()) {
                objectReader.readStream(pdfObject, true, true, false, pdfObject.getObjectType() == 1365674082, pdfObject.isCompressedStream(), null);
            }
        }
    }

    private static int validateLengthValue(int count, int setStreamLength, byte[] data, int start) {
        int endStream = start + setStreamLength;
        if (count <= endStream + 9) {
            return -1;
        }
        if (data[endStream] == 13 && data[endStream + 1] == 10 && Stream.isEndStream(data, endStream + 2)) {
            return setStreamLength;
        }
        if (data[endStream] == 10 && data[endStream - 1] != 10 && Stream.isEndStream(data, endStream + 1)) {
            return setStreamLength;
        }
        if (Stream.isEndStream(data, endStream)) {
            return setStreamLength;
        }
        return Stream.findEndStream(count, data, start, endStream);
    }

    private static boolean isEndStream(byte[] data, int endStream) {
        return data[endStream] == 101 && data[endStream + 1] == 110 && data[endStream + 2] == 100 && data[endStream + 3] == 115 && data[endStream + 4] == 116 && data[endStream + 5] == 114 && data[endStream + 6] == 101 && data[endStream + 7] == 97 && data[endStream + 8] == 109;
    }

    private static int findEndStream(int count, byte[] data, int start, int ptr) {
        while (ptr < count) {
            if (count - ++ptr < 9 || data[ptr] != 101 || data[ptr + 1] != 110 || data[ptr + 2] != 100 || data[ptr + 3] != 115 || data[ptr + 4] != 116 || data[ptr + 5] != 114 || data[ptr + 6] != 101 || data[ptr + 7] != 97 || data[ptr + 8] != 109) continue;
            int streamLength = ptr - start;
            if (data[ptr - 1] == 13 && data[ptr - 2] != 10 || data[ptr - 1] == 10) {
                --streamLength;
            }
            return streamLength;
        }
        return -1;
    }

    private static int getStreamLengthManually(byte[] data, int count, int a10, int start, int streamLength, int setStreamLength) {
        while (++a10 != count && (data[a10] != 101 || data[a10 + 1] != 110 || data[a10 + 2] != 100 || data[a10 + 3] != 115 || data[a10 + 4] != 116 || data[a10 + 5] != 114 || data[a10 + 6] != 101 || data[a10 + 7] != 97 || data[a10 + 8] != 109)) {
        }
        int end = a10 - 1;
        if (end > start) {
            streamLength = end - start + 1;
        }
        if (setStreamLength == 0 && streamLength == 2 && data[start] == 13 && data[start + 1] == 10) {
            streamLength = 0;
        }
        return streamLength;
    }
}

