/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.BrokenRefTable;
import org.jpedal.io.types.CompressedObjects;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.ObjectReader;
import org.jpedal.io.types.Offsets;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.io.types.Trailer;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class RefTable {
    private final Set<Long> tablesRead = new HashSet<Long>();
    private PdfObject encryptObj;
    private int size = -1;
    private byte[] ID;
    private static final String pattern = "obj";
    private PdfObject infoObject;
    private PdfObject rootObj;
    private static final int UNSET = -1;
    private static final int COMPRESSED = 1;
    private static final int LEGACY = 2;
    private RandomAccessBuffer pdf_datafile;
    private static final byte[] oldPattern = new byte[]{120, 114, 101, 102};
    private final long eof;
    private final Offsets offset;
    private byte[] lastBytes;

    public RefTable(RandomAccessBuffer pdf_datafile, long eof, Offsets offset) {
        this.pdf_datafile = pdf_datafile;
        this.eof = eof;
        this.offset = offset;
    }

    private long readFirstStartRef() throws PdfException {
        this.offset.setRefTableInvalid(false);
        long pointer = -1L;
        int i2 = 1019;
        StringBuilder startRef = new StringBuilder(10);
        int block = 1024;
        this.lastBytes = new byte[1024];
        i2 = this.getEndPoint(i2);
        i2 = RefTable.findEndRef(i2, this.lastBytes);
        if (i2 == -1) {
            return 0L;
        }
        i2 += 5;
        while (i2 < 1024 && (this.lastBytes[i2] == 10 || this.lastBytes[i2] == 9 || this.lastBytes[i2] == 32 || this.lastBytes[i2] == 13)) {
            ++i2;
        }
        while (i2 < 1024 && this.lastBytes[i2] != 10 && this.lastBytes[i2] != 9 && this.lastBytes[i2] != 32 && this.lastBytes[i2] != 13) {
            startRef.append((char)this.lastBytes[i2]);
            ++i2;
        }
        if (startRef.length() > 0) {
            pointer = Long.parseLong(startRef.toString());
        }
        if (pointer == -1L) {
            LogWriter.writeLog("No Startref found in last 1024 bytes ");
            try {
                this.closeFile();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception " + e1 + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return pointer;
    }

    private static int findEndRef(int i2, byte[] lastBytes) {
        int fileSize = lastBytes.length;
        if (i2 > fileSize) {
            i2 = fileSize - 5;
        }
        while (!(i2 <= -1 || (lastBytes[i2] == 116 && lastBytes[i2 + 1] == 120 || lastBytes[i2] == 114 && lastBytes[i2 + 1] == 116) && lastBytes[i2 + 2] == 114 && lastBytes[i2 + 3] == 101 && lastBytes[i2 + 4] == 102)) {
            --i2;
        }
        return i2;
    }

    private int getEndPoint(int i2) throws PdfException {
        int[] EndOfFileMarker = new int[]{37, 37, 69, 79};
        int valReached = 3;
        boolean EOFFound = false;
        try {
            long end;
            block8: {
                end = this.eof;
                int bufSize = 255;
                do {
                    byte[] buffer = this.getBytes(end - 255L, 255);
                    int bytesScanned = 0;
                    for (int ii = 254; ii > -1; --ii) {
                        if (!EOFFound) {
                            valReached = 3;
                        }
                        if (buffer[ii] == EndOfFileMarker[valReached]) {
                            --valReached;
                            EOFFound = true;
                        } else {
                            EOFFound = false;
                        }
                        ++bytesScanned;
                        if (valReached < 0) break;
                    }
                    if (valReached >= 0) continue;
                    end -= (long)bytesScanned;
                    break block8;
                } while ((end -= 255L) >= 0L);
                end = this.eof;
            }
            long count = end - 1024L;
            if (count < 0L) {
                count = 0L;
                int size = (int)this.eof;
                this.lastBytes = new byte[size];
                i2 = size + 3;
            }
            this.lastBytes = this.getBytes(count, this.lastBytes.length);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " reading last 1024 bytes");
            throw new PdfException(e2 + " reading last 1024 bytes", e2);
        }
        return i2;
    }

    public final PdfObject readReferenceTable(PdfObject linearObj, PdfFileReader currentPdfFile, ObjectReader objectReader) throws PdfException {
        long pointer = -1L;
        long eof = this.eof;
        boolean islinearizedCompressed = false;
        if (linearObj == null) {
            pointer = this.readFirstStartRef();
        } else {
            byte[] data = this.pdf_datafile.getPdfBuffer();
            int count = data.length;
            int ptr = 5;
            for (int i2 = 0; i2 < count; ++i2) {
                if (data[i2] == 101 && data[i2 + 1] == 110 && data[i2 + 2] == 100 && data[i2 + 3] == 111 && data[i2 + 4] == 98 && data[i2 + 5] == 106) {
                    ptr = i2 + 6;
                }
                if (data[i2] == 120 && data[i2 + 1] == 114 && data[i2 + 2] == 101 && data[i2 + 3] == 102) {
                    pointer = i2;
                    break;
                }
                if (data[i2] != 88 || data[i2 + 1] != 82 || data[i2 + 2] != 101 || data[i2 + 3] != 102) continue;
                islinearizedCompressed = true;
                pointer = ptr;
                while (data[(int)pointer] == 10 || data[(int)pointer] == 13 || data[(int)pointer] == 32) {
                    ++pointer;
                }
                break;
            }
        }
        this.offset.addXref(pointer);
        boolean isInvalid = true;
        if (pointer >= eof || pointer == 0L) {
            LogWriter.writeLog("Pointer not if file - trying to manually find startref");
        } else {
            try {
                if (islinearizedCompressed || this.isCompressedStream(pointer, eof)) {
                    this.rootObj = this.readCompressedStream(pointer, currentPdfFile, objectReader, linearObj);
                    isInvalid = false;
                } else {
                    this.rootObj = this.readLegacyReferenceTable(null, pointer, eof, currentPdfFile, objectReader);
                    int offsetSize = this.offset.getSize();
                    if (offsetSize == -1 || this.size == -1 || offsetSize == this.size) {
                        isInvalid = false;
                    }
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("[PDF] Exception reading reg table " + e2 + " - trying to manually find startref");
            }
        }
        if (isInvalid) {
            this.offset.setRefTableInvalid(true);
            try {
                Object[] objs = BrokenRefTable.readCatalogObjects(this.pdf_datafile, this.offset, currentPdfFile, this.ID);
                this.rootObj = (PdfObject)objs[0];
                this.encryptObj = (PdfObject)objs[1];
                this.infoObject = (PdfObject)objs[2];
                this.ID = (byte[])objs[3];
                currentPdfFile.readObject(this.rootObj);
            }
            catch (Error | Exception e3) {
                throw new PdfException(e3.getMessage() + " attempting to manually scan file for objects", e3);
            }
        }
        return this.rootObj;
    }

    private PdfObject readLegacyReferenceTable(PdfObject rootObj, long pointer, long eof, PdfFileReader currentPdfFile, ObjectReader objectReader) throws PdfException {
        byte[] Bytes;
        long lPointer = pointer;
        if (this.tablesRead.contains(lPointer)) {
            throw new RuntimeException("[PDF] Error Recursive refs table");
        }
        int current = 0;
        HashSet<Long> seenPrevPositions = new HashSet<Long>();
        while ((Bytes = this.getByteBlock(pointer, eof)) != null) {
            int i2;
            int maxLen = Bytes.length;
            boolean trailerNotFound = true;
            for (i2 = 0; i2 < maxLen - 7; ++i2) {
                if (Bytes[i2] != 116 || Bytes[i2 + 1] != 114 || Bytes[i2 + 2] != 97 || Bytes[i2 + 3] != 105 || Bytes[i2 + 4] != 108 || Bytes[i2 + 5] != 101 || Bytes[i2 + 6] != 114) continue;
                trailerNotFound = false;
                break;
            }
            int endTable = i2;
            if (i2 == Bytes.length || trailerNotFound) break;
            while (Bytes[i2] != 60 && Bytes[i2 - 1] != 60) {
                ++i2;
            }
            CompressedObject pdfObject = new CompressedObject("0 0 R");
            Dictionary.readDictionary(pdfObject, ++i2, Bytes, -1, currentPdfFile);
            i2 = Dictionary.handleDirectDictionary(i2, Bytes);
            pointer = RefTable.getPointer(pointer, Bytes, i2);
            i2 = StreamReaderUtils.skipSpaces(Bytes, 0);
            if (pointer == -1L) {
                LogWriter.writeLog("No startRef");
            } else if (Bytes[i2] == 120 && Bytes[i2 + 1] == 114 && Bytes[i2 + 2] == 101 && Bytes[i2 + 3] == 102) {
                i2 = StreamReaderUtils.skipSpaces(Bytes, 5);
                current = this.offset.readXRefs(current, Bytes, endTable, i2, eof, this.pdf_datafile);
                int XRefStm = ((PdfObject)pdfObject).getInt(910911090);
                if (XRefStm != -1) {
                    this.movePointer(XRefStm);
                    RefTable.readStreamTableData(currentPdfFile, objectReader, this.offset, this.pdf_datafile);
                }
                rootObj = this.processTrailer(rootObj, pdfObject);
                pointer = ((PdfObject)pdfObject).getLong(541209926);
                if (pointer != -1L && pointer < this.eof) {
                    this.offset.addXref(pointer);
                } else {
                    pointer = -1L;
                }
            } else {
                pointer = -1L;
                Object[] objs = BrokenRefTable.readCatalogObjects(this.pdf_datafile, this.offset, currentPdfFile, this.ID);
                rootObj = (PdfObject)objs[0];
                this.encryptObj = (PdfObject)objs[1];
                this.infoObject = (PdfObject)objs[2];
                this.ID = (byte[])objs[3];
                currentPdfFile.readObject(rootObj);
                this.offset.setRefTableInvalid(true);
            }
            if (pointer != -1L && seenPrevPositions.add(pointer)) continue;
            break;
        }
        if (this.encryptObj == null && rootObj != null) {
            rootObj = RefTable.handleBrokenFile(rootObj, currentPdfFile);
        }
        if (rootObj == null) {
            rootObj = this.handleNullValue(currentPdfFile);
        }
        if (this.encryptObj == null) {
            this.tablesRead.add(lPointer);
        }
        return rootObj;
    }

    private PdfObject handleNullValue(PdfFileReader currentPdfFile) throws PdfException {
        this.offset.clear();
        this.offset.reuse();
        Object[] objs = BrokenRefTable.readCatalogObjects(this.pdf_datafile, this.offset, currentPdfFile, this.ID);
        PdfObject rootObj = (PdfObject)objs[0];
        this.encryptObj = (PdfObject)objs[1];
        this.infoObject = (PdfObject)objs[2];
        this.ID = (byte[])objs[3];
        currentPdfFile.readObject(rootObj);
        this.offset.setRefTableInvalid(true);
        return rootObj;
    }

    private byte[] getByteBlock(long pointer, long eof) throws PdfException {
        byte[] Bytes;
        try {
            Bytes = Trailer.readTrailer(1024, pointer, eof, this.pdf_datafile);
        }
        catch (Exception e2) {
            try {
                this.closeFile();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception " + e2 + " closing file " + e1);
            }
            throw new PdfException("Exception " + e2 + " reading trailer");
        }
        return Bytes;
    }

    private static PdfObject handleBrokenFile(PdfObject rootObj, PdfFileReader currentPdfFile) {
        int type = -1;
        int status = rootObj.getStatus();
        byte[] data = rootObj.getUnresolvedData();
        try {
            ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile);
            objectDecoder.checkResolved(rootObj);
            type = rootObj.getNameAsConstant(608780341);
        }
        catch (Exception e2) {
            rootObj.setUnresolvedData(data, status);
            LogWriter.writeLog("[PDF] Exception reading type on root object " + e2);
        }
        if (type == 373243460) {
            rootObj = null;
        }
        return rootObj;
    }

    private static long getPointer(long pointer, byte[] bytes, int i2) {
        int s2;
        boolean hasRef = true;
        i2 = StreamReaderUtils.skipSpaces(bytes, i2);
        while (bytes[i2] == 37) {
            while (bytes[i2] != 10) {
                ++i2;
            }
            ++i2;
        }
        while (bytes[i2] != 116 && bytes[i2 + 1] != 120 && bytes[i2 + 2] != 114 && bytes[i2 + 3] != 101 && bytes[i2 + 4] != 102) {
            if (bytes[i2] == 111 && bytes[i2 + 1] == 98 && bytes[i2 + 2] == 106) {
                hasRef = false;
                break;
            }
            ++i2;
        }
        if (hasRef && (s2 = (i2 = StreamReaderUtils.skipSpaces(bytes, i2 + 8))) != (i2 = StreamReaderUtils.skipToEndOfKey(bytes, i2))) {
            pointer = NumberUtils.parseInt(s2, i2, bytes);
        }
        return pointer;
    }

    private PdfObject readCompressedStream(long pointer, PdfFileReader currentPdfFile, ObjectReader objectReader, PdfObject linearObj) throws PdfException {
        PdfObject rootObj = null;
        while (pointer != -1L) {
            this.movePointer(pointer);
            PdfObject pdfObject = RefTable.readStreamTableData(currentPdfFile, objectReader, this.offset, this.pdf_datafile);
            rootObj = this.processTrailer(rootObj, pdfObject);
            if (linearObj != null) {
                pointer = -1L;
                continue;
            }
            pointer = pdfObject.getLong(541209926);
            if (pointer > this.eof) {
                pointer = -1L;
                LogWriter.writeLog("Ignoring invalid Prev value attempting to access ref outside file");
            }
            if (pointer == -1L || this.isCompressedStream(pointer, (int)this.eof)) continue;
            return this.readLegacyReferenceTable(rootObj, pointer, (int)this.eof, currentPdfFile, objectReader);
        }
        return rootObj;
    }

    private static PdfObject readStreamTableData(PdfFileReader currentPdfFile, ObjectReader objectReader, Offsets offset, RandomAccessBuffer pdf_datafile) throws PdfException {
        int[] Index;
        byte[] raw = objectReader.readObjectData(-1, null);
        CompressedObject pdfObject = new CompressedObject(RefTable.getObjectName(raw));
        pdfObject.setCompressedStream(true);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile);
        objectDecoder.readDictionaryAsObject(pdfObject, 0, raw);
        int[] fieldSizes = ((PdfObject)pdfObject).getIntArray(39);
        byte[] xrefs = pdfObject.getDecodedStream();
        if (xrefs == null) {
            xrefs = currentPdfFile.readStream(pdfObject, true, true, false, false, true, null);
        }
        if ((Index = ((PdfObject)pdfObject).getIntArray(1043608929)) == null) {
            CompressedObjects.readCompressedOffsets(0, 0, ((PdfObject)pdfObject).getInt(590957109), fieldSizes, xrefs, offset, pdf_datafile);
        } else {
            int count = Index.length;
            int pntr = 0;
            for (int aa2 = 0; aa2 < count; aa2 += 2) {
                pntr = CompressedObjects.readCompressedOffsets(pntr, Index[aa2], Index[aa2 + 1], fieldSizes, xrefs, offset, pdf_datafile);
            }
        }
        return pdfObject;
    }

    private PdfObject processTrailer(PdfObject rootObj, PdfObject pdfObject) {
        if (rootObj == null) {
            rootObj = pdfObject.getDictionary(574570308);
            this.encryptObj = pdfObject.getDictionary(1113489015);
            byte[][] IDs = pdfObject.getStringArray(6420);
            if (IDs != null && this.ID == null) {
                this.ID = IDs[0];
            }
            this.infoObject = pdfObject.getDictionary(423507519);
        }
        if (pdfObject != null) {
            this.size = pdfObject.getInt(590957109);
        }
        return rootObj;
    }

    private static String getObjectName(byte[] raw) {
        StringBuilder objectName = new StringBuilder();
        int last = 32;
        int matched = 0;
        int length = raw.length;
        for (int i1 = 0; i1 < length; ++i1) {
            char current1 = (char)raw[i1];
            if (current1 == '\n' || current1 == '\r') {
                current1 = ' ';
            }
            if (current1 == ' ' && last == 32) {
                matched = 0;
            } else if (current1 == pattern.charAt(matched)) {
                ++matched;
            } else {
                matched = 0;
                objectName.append(current1);
            }
            if (matched == 3) break;
            last = current1;
        }
        objectName.append('R');
        return objectName.toString();
    }

    private byte[] getBytes(long start, int count) {
        byte[] buffer = new byte[count];
        if (start >= 0L) {
            try {
                this.pdf_datafile.seek(start);
                this.pdf_datafile.read(buffer);
            }
            catch (IOException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        return buffer;
    }

    private void closeFile() throws IOException {
        if (this.pdf_datafile != null) {
            this.pdf_datafile.close();
            this.pdf_datafile = null;
        }
    }

    private boolean isCompressedStream(long pointer, long eof) {
        int bufSize = 50;
        int charReached_legacy = 0;
        int charReached_comp1 = 0;
        int charReached_comp2 = 0;
        int[] objStm = new int[]{79, 98, 106, 83, 116, 109};
        int[] XRef = new int[]{88, 82, 101, 102};
        int type = -1;
        int bytesScanned = 0;
        boolean firstRead = true;
        while (true) {
            if ((bufSize = RefTable.setBufferSize(pointer, eof, bufSize)) == 0) {
                return false;
            }
            if (pointer < 0L) {
                pointer += (long)bufSize;
                continue;
            }
            byte[] buffer = this.getBytes(pointer, bufSize);
            if (firstRead && buffer[0] == 114 && buffer[1] == 101 && buffer[2] == 102) {
                charReached_legacy = 1;
            }
            firstRead = false;
            for (int i2 = 0; i2 < bufSize; ++i2) {
                byte currentByte = buffer[i2];
                if (currentByte == oldPattern[charReached_legacy] && type != 1) {
                    ++charReached_legacy;
                    type = 2;
                } else if (currentByte == objStm[charReached_comp1]) {
                    ++charReached_comp1;
                    type = 1;
                } else if (currentByte == XRef[charReached_comp2]) {
                    ++charReached_comp2;
                    type = 1;
                } else {
                    charReached_legacy = 0;
                    charReached_comp1 = 0;
                    charReached_comp2 = 0;
                    type = -1;
                }
                if (bytesScanned > 65536) {
                    type = -1;
                    break;
                }
                ++bytesScanned;
                if (charReached_legacy == 3 || charReached_comp1 == 4 || charReached_comp2 == 4) break;
            }
            if (charReached_legacy == 3 || charReached_comp1 == 4 || charReached_comp2 == 4) break;
            pointer += (long)bufSize;
        }
        return type == 1;
    }

    private static int setBufferSize(long pointer, long eof, int bufSize) {
        if (pointer + (long)bufSize > eof) {
            bufSize = (int)(eof - pointer);
        }
        if (bufSize < 0) {
            bufSize = 50;
        }
        return bufSize;
    }

    public PdfObject getInfoObject() {
        return this.infoObject;
    }

    public PdfObject getRootObject() {
        return this.rootObj;
    }

    public PdfObject getEncryptionObject() {
        return this.encryptObj;
    }

    public byte[] getID() {
        return this.ID;
    }

    private void movePointer(long pointer) {
        try {
            if (pointer > this.pdf_datafile.length()) {
                LogWriter.writeLog("Attempting to access ref outside file");
            } else {
                this.pdf_datafile.seek(pointer);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " moving pointer to  " + pointer + " in file.");
        }
    }
}

