/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Long;
import org.jpedal.utils.repositories.Vector_boolean;

public class Offsets
extends Vector_Long {
    private boolean refTableInvalid;
    private int size = -1;
    private Vector_boolean isCompressed = new Vector_boolean(2000);
    private Vector_Int generation = new Vector_Int(2000);
    private Vector_Long xref = new Vector_Long(100);

    public Offsets(int i2) {
        super(i2);
    }

    public void addXref(long pointer) {
        this.xref.addElement(pointer);
    }

    public int[] calculateObjectLength(long eof) {
        if (this.refTableInvalid) {
            return null;
        }
        this.xref.addElement(eof);
        long[] xrefs = this.xref.get();
        int xrefCount = xrefs.length;
        int[] xrefID = new int[xrefCount];
        for (int i2 = 0; i2 < xrefCount; ++i2) {
            xrefID[i2] = i2;
        }
        Sorts.quicksort(xrefs, xrefID);
        int objectCount = this.getCapacity();
        int[] id2 = new int[objectCount];
        long[] offsets = new long[objectCount];
        long[] off = this.get();
        boolean[] isComp = this.isCompressed.get();
        for (int i3 = 0; i3 < objectCount; ++i3) {
            if (isComp[i3]) continue;
            offsets[i3] = off[i3];
            id2[i3] = i3;
        }
        Sorts.quicksort(offsets, id2);
        return Offsets.calcLengths(offsets, id2, xrefs, xrefID, objectCount, eof);
    }

    private static int skipEmptyValues(long[] offsets, int[] id2) {
        int i2 = 0;
        while (offsets[id2[i2]] == 0L) {
            ++i2;
        }
        return i2;
    }

    private static int[] calcLengths(long[] offsets, int[] id2, long[] xrefs, int[] xrefID, int objectCount, long eof) {
        long end;
        int i2 = Offsets.skipEmptyValues(offsets, id2);
        long start = offsets[id2[i2]];
        int j2 = 0;
        while (xrefs[xrefID[j2]] < start + 1L) {
            ++j2;
        }
        int[] ObjLengthTable = new int[objectCount];
        while (i2 < objectCount - 1 && (end = offsets[id2[i2 + 1]]) <= eof) {
            int objLength = (int)(end - start - 1L);
            if (xrefs[xrefID[j2]] < end) {
                objLength = (int)(xrefs[xrefID[j2]] - start - 1L);
                while (xrefs[xrefID[j2]] < end + 1L) {
                    ++j2;
                }
            }
            ObjLengthTable[id2[i2]] = objLength;
            start = end;
            while (xrefs[xrefID[j2]] < start + 1L) {
                ++j2;
            }
            ++i2;
        }
        ObjLengthTable[id2[i2]] = (int)(xrefs[xrefID[j2]] - start - 1L);
        return ObjLengthTable;
    }

    public void dispose() {
        this.xref = null;
        this.generation = null;
        this.isCompressed = null;
    }

    public int readXRefs(int current, byte[] Bytes, int endTable, int i2, long eof, RandomAccessBuffer pdf_datafile) {
        boolean skipNext = false;
        int[] breaks = new int[5];
        int[] starts = new int[5];
        block4: while (i2 < endTable) {
            int startLine = i2;
            int endLine = -1;
            while (Bytes[i2] != 10 && Bytes[i2] != 13) {
                if (endLine == -1 && Bytes[i2] == 37) {
                    endLine = i2 - 1;
                }
                ++i2;
            }
            if (endLine == -1) {
                endLine = i2 - 1;
            }
            while (Bytes[startLine] == 32) {
                ++startLine;
            }
            while (Bytes[endLine] == 32) {
                --endLine;
            }
            ++i2;
            int tokenCount = 0;
            int lineLen = endLine - startLine + 1;
            if (lineLen <= 0) continue;
            tokenCount = Offsets.getTokenCount(Bytes, tokenCount, lineLen, startLine, breaks, starts);
            breaks[tokenCount] = lineLen;
            switch (++tokenCount) {
                case 1: {
                    if (skipNext) {
                        skipNext = false;
                        continue block4;
                    }
                    current = NumberUtils.parseInt(startLine, startLine + breaks[0], Bytes);
                    skipNext = true;
                    continue block4;
                }
                case 2: {
                    current = NumberUtils.parseInt(startLine, startLine + breaks[0], Bytes);
                    this.size = current + NumberUtils.parseInt(startLine + breaks[0] + 1, startLine + lineLen, Bytes);
                    continue block4;
                }
            }
            current = this.setNextRefValue(current, Bytes, eof, pdf_datafile, startLine, breaks, starts);
        }
        return current;
    }

    private static int getTokenCount(byte[] Bytes, int tokenCount, int lineLen, int startLine, int[] breaks, int[] starts) {
        int lastChar = 1;
        for (int j2 = 1; j2 < lineLen; ++j2) {
            int currentChar = Bytes[startLine + j2];
            if (currentChar == 32 && lastChar != 32) {
                breaks[tokenCount] = j2;
                ++tokenCount;
            } else if (currentChar != 32 && lastChar == 32) {
                starts[tokenCount] = j2;
            }
            lastChar = currentChar;
        }
        return tokenCount;
    }

    private int setNextRefValue(int current, byte[] Bytes, long eof, RandomAccessBuffer pdf_datafile, int startLine, int[] breaks, int[] starts) {
        long id2 = NumberUtils.parseLong(startLine, startLine + breaks[0], Bytes);
        int generation = NumberUtils.parseInt(startLine + starts[1], startLine + breaks[1], Bytes);
        char flag = (char)Bytes[startLine + starts[2]];
        if (flag == 'n') {
            boolean isValid = false;
            int bufSize = 20;
            if (id2 + (long)bufSize > eof) {
                bufSize = (int)(eof - id2);
            }
            if (bufSize > 0) {
                byte[] buffer = Offsets.getBytes(id2, bufSize, pdf_datafile);
                for (int ii = 4; ii < bufSize; ++ii) {
                    if (buffer[ii - 3] != 32 && buffer[ii - 3] != 10 || buffer[ii - 2] != 111 || buffer[ii - 1] != 98 || buffer[ii] != 106) continue;
                    isValid = true;
                    break;
                }
                if (isValid) {
                    int start = StreamReaderUtils.skipSpaces(buffer, 0);
                    int ptr = StreamReaderUtils.skipToEndOfRef(buffer, start);
                    current = NumberUtils.parseInt(start, ptr, buffer);
                    this.storeObjectOffset(current, id2, generation, false, false);
                    this.xref.addElement(id2);
                } else if (LogWriter.isRunningFromIDE) {
                    LogWriter.writeLog(current + " " + id2 + " is bum reference");
                }
            }
        }
        return current;
    }

    private static byte[] getBytes(long start, int count, RandomAccessBuffer pdf_datafile) {
        byte[] buffer = new byte[count];
        try {
            pdf_datafile.seek(start);
            pdf_datafile.read(buffer);
        }
        catch (IOException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return buffer;
    }

    void storeObjectOffset(int current_number, long current_offset, int current_generation, boolean isEntryCompressed, boolean isBumData) {
        int existing_generation = 0;
        long offsetNumber = 0L;
        if (current_number < this.generation.getCapacity()) {
            existing_generation = this.generation.elementAt(current_number);
            offsetNumber = this.elementAt(current_number);
        }
        if (existing_generation < current_generation || offsetNumber == 0L || isBumData && current_offset > this.elementAt(current_number)) {
            this.setElementAt(current_offset, current_number);
            this.generation.setElementAt(current_generation, current_number);
            this.isCompressed.setElementAt(isEntryCompressed, current_number);
        }
    }

    public final boolean isCompressed(int ref) {
        return this.isCompressed.elementAt(ref);
    }

    public boolean isRefTableInvalid() {
        return this.refTableInvalid;
    }

    public void setRefTableInvalid(boolean value) {
        this.refTableInvalid = value;
    }

    public int getSize() {
        return this.size;
    }
}

