/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.ArrayList;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;

public class ObjectArray
extends Array {
    private final ArrayList<Object> objectArray = new ArrayList();

    public ObjectArray(PdfFileReader pdfFileReader, int i2, byte[] raw) {
        super(pdfFileReader, i2, 22, raw);
    }

    @Override
    boolean isFirstKeySingle() {
        return this.arrayData[this.j2] == 47 || this.arrayData[this.j2] == 40 || this.arrayData[this.j2] == 60 || StreamReaderUtils.isRef(this.arrayData, this.j2);
    }

    @Override
    void scanElements(boolean singleKey, PdfObject pdfObject) {
        int currentElement = 0;
        int arrayEnd = this.arrayData.length;
        this.findArrayStart();
        if (debugFastCode) {
            System.out.println(padding + "----scanning elements----arrayData[endPtr]=" + this.arrayData[this.j2] + " type=" + this.type);
        }
        int dataLength = this.arrayData.length;
        while (this.j2 < arrayEnd && this.arrayData[this.j2] != 93) {
            Object newValues;
            int keyStart = this.moveToStartOfNextValue();
            if (StreamReaderUtils.isEndObj(this.arrayData, this.j2) || this.j2 < dataLength - 1 && this.arrayData[this.j2] == 62 && this.arrayData[this.j2 + 1] == 62) break;
            if (this.arrayData[this.j2 - 1] == 47) {
                newValues = this.writeKey();
            } else if (StreamReaderUtils.isRef(this.arrayData, this.j2)) {
                newValues = this.getIndirectRef(pdfObject, keyStart);
            } else if (this.j2 < dataLength - 1 && this.arrayData[this.j2] == 60 && this.arrayData[this.j2 + 1] == 60) {
                newValues = this.writeObject(keyStart);
            } else if (StreamReaderUtils.isNumber(this.arrayData, this.j2)) {
                newValues = this.writeNumber();
            } else if (StreamReaderUtils.isNull(this.arrayData, this.j2)) {
                newValues = this.writeNull();
            } else if (this.arrayData[this.j2] == 40) {
                newValues = this.writeString(pdfObject);
            } else if (this.arrayData[this.j2] == 91) {
                newValues = this.writeValue(pdfObject);
            } else if (this.j2 < dataLength - 2 && this.arrayData[this.j2 + 1] == 60 && this.arrayData[this.j2 + 2] == 60) {
                newValues = this.writeDirectDictionary(keyStart);
            } else if (this.arrayData[this.j2] == 60) {
                newValues = this.writeHexString(pdfObject);
            } else {
                if (this.arrayData[this.j2] == 93) break;
                newValues = this.writeGeneral(keyStart);
            }
            this.objectArray.add(newValues);
            ++currentElement;
            if (!singleKey) continue;
        }
        this.fillArray(currentElement, pdfObject);
    }

    private Object getIndirectRef(PdfObject pdfObject, int keyStart) {
        int a10;
        byte[] ref = this.writeObject(keyStart);
        PdfObject obj = new PdfObject(new String(ref));
        byte[] bytes = this.objectReader.readObjectData(obj);
        int len = bytes.length;
        if (len == 0) {
            return null;
        }
        for (a10 = 0; a10 < len && bytes[a10] != 91 && bytes[a10] != 60; ++a10) {
        }
        if (a10 >= len) {
            if (StreamReaderUtils.isRef(bytes, 0)) {
                return this.extractNumberFromRef(bytes);
            }
            return ObjectArray.writeNumber(bytes);
        }
        if (bytes[a10] == 91) {
            ObjectArray objDecoder = new ObjectArray(this.objectReader, a10, bytes);
            objDecoder.readArray(pdfObject, this.PDFkeyInt);
            return objDecoder.getValues();
        }
        return ref;
    }

    private Object writeValue(PdfObject pdfObject) {
        int j3 = this.j2 + 1;
        int level = 1;
        while (++j3 != this.arrayData.length) {
            if (this.arrayData[j3] == 93) {
                --level;
            } else if (this.arrayData[j3] == 91) {
                ++level;
            }
            if (level != 0) continue;
        }
        if (debugFastCode) {
            padding = padding + "   ";
        }
        ObjectArray objDecoder = new ObjectArray(this.objectReader, this.j2, this.arrayData);
        this.j2 = objDecoder.readArray(pdfObject, this.PDFkeyInt);
        if (this.arrayData[this.j2] != 91) {
            ++this.j2;
        }
        return objDecoder.getValues();
    }

    @Override
    void fillArray(int elementCount, PdfObject pdfObject) {
        Object[] finalByteValues = new Object[elementCount];
        for (int a10 = 0; a10 < elementCount; ++a10) {
            finalByteValues[a10] = this.objectArray.get(a10);
        }
        pdfObject.setObjectArray(this.PDFkeyInt, finalByteValues);
    }

    @Override
    void showValues() {
        String values = '[' + ObjectUtils.showMixedValuesAsString(this.objectArray.toArray(), "") + " ]";
        System.out.println(padding + "values=" + values);
    }

    private Object[] getValues() {
        return this.objectArray.toArray();
    }
}

