/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public final class NumberValue {
    private NumberValue() {
    }

    public static int setNumberValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        int keyStart = i2;
        int rawLength = raw.length;
        while (raw[i2] != 10 && raw[i2] != 9 && raw[i2] != 13 && raw[i2] != 32 && raw[i2] != 47 && raw[i2] != 60 && raw[i2] != 62 && raw[i2] != 40 && raw[i2] != 46) {
            ++i2;
        }
        int number = NumberUtils.parseInt(keyStart, i2, raw);
        int jj = StreamReaderUtils.skipSpaces(raw, i2);
        if (raw[jj] >= 48 && raw[jj] <= 57) {
            boolean isRef;
            int aa2 = StreamReaderUtils.skipToEndOfRef(raw, jj);
            boolean bl2 = isRef = (aa2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, aa2, 47)) < rawLength && raw[aa2] == 82;
            if (isRef) {
                return NumberValue.readNumberFromIndirectObj(PDFkeyInt, pdfObject, i2, raw, objectReader, rawLength, number);
            }
        }
        pdfObject.setIntNumber(PDFkeyInt, number);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "set numberValue=" + number);
        }
        return i2 - 1;
    }

    public static int setLongNumberValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt) {
        int keyStart = i2;
        while (raw[i2] != 10 && raw[i2] != 9 && raw[i2] != 13 && raw[i2] != 32 && raw[i2] != 47 && raw[i2] != 60 && raw[i2] != 62 && raw[i2] != 40 && raw[i2] != 46) {
            ++i2;
        }
        long number = NumberUtils.parseLong(keyStart, i2, raw);
        pdfObject.setLong(PDFkeyInt, number);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "set longNumberValue=" + number);
        }
        return i2 - 1;
    }

    private static int readNumberFromIndirectObj(int PDFkeyInt, PdfObject pdfObject, int i2, byte[] raw, PdfFileReader objectReader, int rawLength, int number) {
        int keyStart = i2 = StreamReaderUtils.skipSpaces(raw, i2);
        i2 = StreamReaderUtils.skipToEndOfRef(raw, i2);
        int generation = NumberUtils.parseInt(keyStart, i2, raw);
        while (raw[i2] == 10 || raw[i2] == 13 || raw[i2] == 32 || raw[i2] == 47 || raw[i2] == 60) {
            ++i2;
        }
        if (raw[i2] != 82) {
            throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
        }
        byte[] data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
        if (data == null) {
            pdfObject.setFullyResolved(false);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Data not yet loaded");
            }
            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (8)");
            return rawLength;
        }
        int[] pos = NumberValue.extractDataFromIndirectRef(data);
        number = NumberUtils.parseInt(pos[0], pos[1], data);
        pdfObject.setIntNumber(PDFkeyInt, number);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "set numberValue=" + number);
        }
        return i2 - 1;
    }

    public static int[] extractDataFromIndirectRef(byte[] data) {
        int count;
        int j2 = 0;
        int len = data.length;
        if (len > 3 && (data[0] != 60 || data[1] != 60)) {
            j2 = 3;
            while (data[j2 - 1] != 106 && data[j2 - 2] != 98 && data[j2 - 3] != 111) {
                if (++j2 != len) continue;
                j2 = 0;
                break;
            }
        }
        if (len > 1) {
            j2 = StreamReaderUtils.skipSpaces(data, j2);
        }
        for (count = j2; count < len && data[count] != 9 && data[count] != 10 && data[count] != 13 && data[count] != 32; ++count) {
        }
        return new int[]{j2, count};
    }
}

