/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public final class Name {
    private Name() {
    }

    public static int setNameTreeValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        boolean isRef = false;
        while (raw[i2] != 91 && raw[i2] != 40) {
            if (raw[i2] >= 48 && raw[i2] <= 57) {
                isRef = true;
                break;
            }
            ++i2;
        }
        byte[] data = raw;
        int start = i2;
        int j2 = i2;
        int count = 0;
        if (isRef) {
            int[] values = StreamReaderUtils.readRefFromStream(raw, i2);
            i2 = values[2];
            int generation = values[1];
            int number = values[0];
            if (raw[i2] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + raw[i2] + " - please send to IDRsolutions for analysis");
            }
            data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
            if (data == null) {
                pdfObject.setFullyResolved(false);
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                }
                return raw.length;
            }
            j2 = 3;
            while (data[j2 - 1] != 106 && data[j2 - 2] != 98 && data[j2 - 3] != 111 && data[j2 - 3] != 60) {
                ++j2;
            }
            start = j2 = StreamReaderUtils.skipSpaces(data, j2);
        }
        while (j2 < data.length) {
            if (data[j2] == 91 || data[j2] == 40) {
                ++count;
            } else if (data[j2] == 93 || data[j2] == 41) {
                --count;
            }
            if (count == 0) break;
            ++j2;
        }
        byte[] newString = Name.getString(pdfObject, objectReader, data, start, j2);
        pdfObject.setTextStreamValue(PDFkeyInt, newString);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "name=" + new String(newString) + " set in " + pdfObject);
        }
        if (!isRef) {
            i2 = j2;
        }
        return i2;
    }

    private static byte[] getString(PdfObject pdfObject, PdfFileReader objectReader, byte[] data, int start, int j2) {
        DecryptionFactory decryption;
        int stringLength = j2 - start + 1;
        byte[] newString = new byte[stringLength];
        System.arraycopy(data, start, newString, 0, stringLength);
        if (pdfObject.getObjectType() != 1113489015 && (decryption = objectReader.getDecryptionObject()) != null) {
            try {
                newString = decryption.decrypt(newString, pdfObject.getObjectRefAsString(), false, null, false, false);
            }
            catch (PdfSecurityException e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        return newString;
    }

    public static int setNameStringValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        while (raw[i2] != 10 && raw[i2] != 13 && raw[i2] != 32 && raw[i2] != 47 && raw[i2] != 40 && raw[i2] != 60) {
            ++i2;
        }
        int j2 = i2 = StreamReaderUtils.skipSpaces(raw, i2);
        byte[] arrayData = raw;
        boolean isIndirect = raw[i2] != 47 && raw[i2] != 40 && raw[i2] != 60 && raw[i2] >= 48 && raw[i2] <= 57;
        boolean startsWithBrace = raw[i2] == 40;
        boolean isInsideArray = false;
        if (isIndirect) {
            int aa2 = StreamReaderUtils.skipToEndOfRef(raw, i2);
            if (raw[aa2 = StreamReaderUtils.skipSpaces(raw, aa2)] == 47 || raw[aa2] == 93) {
                isIndirect = false;
                i2 = aa2 + 1;
                isInsideArray = true;
            }
        }
        if (isIndirect) {
            int[] values = StreamReaderUtils.readRefFromStream(raw, i2);
            int ref = values[0];
            int generation = values[1];
            i2 = values[2];
            if (raw[i2] != 82) {
                throw new RuntimeException(ObjectDecoder.padding + "2. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            arrayData = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(ref, generation), ref, generation);
            if (arrayData == null) {
                pdfObject.setFullyResolved(false);
                return raw.length;
            }
            if (arrayData[0] == 47) {
                j2 = 0;
            } else {
                j2 = 3;
                while (arrayData[j2] != 47) {
                    ++j2;
                }
            }
        }
        if (arrayData[j2] == 47) {
            ++j2;
        }
        if (arrayData[j2] == 47) {
            return j2 - 1;
        }
        int end = j2 + 1;
        if (arrayData[j2] == 62) {
            --end;
        }
        if (isInsideArray) {
            return Name.handleArrayValue(pdfObject, PDFkeyInt, j2, arrayData, end);
        }
        end = Name.countChars(arrayData, startsWithBrace, end);
        int charCount = end - j2;
        byte[] stringBytes = new byte[charCount];
        System.arraycopy(arrayData, j2, stringBytes, 0, charCount);
        pdfObject.setName(PDFkeyInt, stringBytes);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "String set as =" + new String(stringBytes) + "< written to " + pdfObject);
        }
        if (!isIndirect) {
            return end - 1;
        }
        return i2;
    }

    private static int handleArrayValue(PdfObject pdfObject, int PDFkeyInt, int j2, byte[] arrayData, int end) {
        j2 = StreamReaderUtils.skipSpacesOrOtherCharacter(arrayData, j2, 47);
        int slashes = 0;
        int lastChar = 0;
        while (arrayData[end] != 93) {
            if (arrayData[end] == 47 && (lastChar == 32 || lastChar == 10 || lastChar == 13)) {
                ++slashes;
            }
            lastChar = arrayData[end];
            if (++end != arrayData.length) continue;
        }
        byte[] stringBytes = Name.setValue(j2, arrayData, end, slashes);
        pdfObject.setName(PDFkeyInt, stringBytes);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "String set as =" + new String(stringBytes) + "< written to " + pdfObject);
        }
        return end - 1;
    }

    private static byte[] setValue(int j2, byte[] arrayData, int end, int slashes) {
        int charCount = end - slashes;
        int ptr = 0;
        byte[] stringBytes = new byte[charCount - j2];
        int previous = 0;
        for (int ii = j2; ii < charCount; ++ii) {
            int nextChar = arrayData[ii];
            if (nextChar == 47) {
                if (previous != 32 && previous != 10 && previous != 13) {
                    stringBytes[ptr] = 32;
                    ++ptr;
                }
            } else {
                stringBytes[ptr] = nextChar;
                ++ptr;
            }
            previous = nextChar;
        }
        return stringBytes;
    }

    private static int countChars(byte[] arrayData, boolean startsWithBrace, int end) {
        int length = arrayData.length;
        while (end < length && !(startsWithBrace ? arrayData[end] == 41 && !ObjectUtils.isEscaped(arrayData, end) : arrayData[end] == 32 || arrayData[end] == 10 || arrayData[end] == 13 || arrayData[end] == 47 || arrayData[end] == 62)) {
            ++end;
        }
        return end;
    }
}

