/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.ArrayHandler;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.Name;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.io.types.TextStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public final class General {
    private General() {
    }

    public static int readGeneral(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "general case " + i2);
        }
        int jj = i2;
        int j2 = i2 + 1;
        byte[] data = raw;
        int typeFound = 0;
        boolean isNumber = true;
        boolean isRef = false;
        boolean isString = false;
        String objRef = pdfObject.getObjectRefAsString();
        do {
            if (data[j2] == 82 && !isString) {
                isRef = true;
                int end = j2;
                j2 = i2;
                i2 = end;
                while (data[j2] == 91 || data[j2] == 32 || data[j2] == 13 || data[j2] == 10) {
                    ++j2;
                }
                int[] values = StreamReaderUtils.readRefFromStream(data, j2);
                int refStart = j2;
                int ref = values[0];
                int generation = values[1];
                j2 = values[2];
                if (data[j2] != 82) {
                    throw new RuntimeException("ref=" + ref + " gen=" + ref + " 1. Unexpected value " + data[j2] + " in file - please send to IDRsolutions for analysis char=" + (char)data[j2]);
                }
                objRef = new String(data, refStart, 1 + j2 - refStart);
                boolean isCompressed = objectReader.isCompressed(ref, generation);
                data = objectReader.readObjectAsByteArray(pdfObject, isCompressed, ref, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (ObjectDecoder.debugFastCode) {
                        System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                    }
                    i2 = raw.length;
                    break;
                }
                if (data.length == raw.length && ref == pdfObject.getObjectRefID()) {
                    return i2;
                }
                int firstChar = 0;
                if (data.length <= 2 || data[0] != 60 || data[1] != 60) {
                    firstChar = General.findFirstChar(data, firstChar);
                }
                isString = data[firstChar] == 40;
                jj = !isCompressed ? General.skipStartObj(data) : 0;
                j2 = jj;
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(j2 + " >>" + new String(data) + "<<next=" + (char)data[j2]);
                }
            } else {
                if (data[j2] == 91 || data[j2] == 40 || data[j2] == 60) break;
                if (data[j2] == 62 || data[j2] == 47) {
                    typeFound = 1;
                    break;
                }
                if (data[j2] != 32 && data[j2] != 10 && data[j2] != 13 && data[j2] != 9 && data[j2] != 46 && (data[j2] < 48 || data[j2] > 57)) {
                    isNumber = false;
                }
            }
            if (data[j2] == 91 || data[j2] == 47) continue;
            ++j2;
        } while (j2 != data.length);
        if (data != null) {
            jj = General.processData(pdfObject, PDFkeyInt, objectReader, jj, data, typeFound, isNumber, objRef);
        }
        if (!isRef) {
            return jj;
        }
        return i2;
    }

    private static int processData(PdfObject pdfObject, int PDFkeyInt, PdfFileReader objectReader, int jj, byte[] data, int typeFound, boolean isNumber, String objRef) {
        if (data[jj = StreamReaderUtils.skipSpaces(data, jj)] == 47 && General.getKeyCount(jj, data) == 0) {
            jj = Name.setNameStringValue(pdfObject, jj, data, PDFkeyInt, objectReader);
        } else if (data[jj] == 40) {
            jj = TextStream.readTextStream(pdfObject, jj, data, PDFkeyInt, objectReader);
        } else if (data[jj] == 91) {
            jj = ArrayHandler.setArray(pdfObject, jj, data, PDFkeyInt, objectReader);
        } else if (typeFound == 0) {
            try {
                jj = Dictionary.readDictionaryFromRefOrDirect(pdfObject, objRef, jj, data, PDFkeyInt, objectReader);
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        } else {
            jj = isNumber ? NumberValue.setNumberValue(pdfObject, jj, data, PDFkeyInt, objectReader) : Name.setNameStringValue(pdfObject, jj, data, PDFkeyInt, objectReader);
        }
        return jj;
    }

    private static int findFirstChar(byte[] newData, int firstChar) {
        int newLength = newData.length - 3;
        for (int aa2 = 3; aa2 < newLength; ++aa2) {
            if (newData[aa2 - 2] == 111 && newData[aa2 - 1] == 98 && newData[aa2] == 106) {
                return StreamReaderUtils.skipSpaces(newData, aa2 + 1);
            }
            if (newData[aa2] >= 48 && newData[aa2] <= 57 || newData[aa2] == 111 || newData[aa2] == 98 || newData[aa2] == 106 || newData[aa2] == 82 || newData[aa2] == 32 || newData[aa2] == 10 || newData[aa2] == 13) continue;
            return 0;
        }
        return firstChar;
    }

    private static int skipStartObj(byte[] data) {
        int jj = 3;
        if (data.length <= 3) {
            jj = 0;
        } else {
            while (data[jj - 2] != 111 || data[jj - 1] != 98 || data[jj] != 106) {
                if (++jj != data.length) continue;
                jj = 0;
                break;
            }
        }
        if (data[jj] != 91 && data[jj] != 40 && data[jj] != 60) {
            ++jj;
        }
        jj = StreamReaderUtils.skipSpaces(data, jj);
        return jj;
    }

    private static int getKeyCount(int jj, byte[] data) {
        int count = 0;
        for (int aa2 = jj + 1; aa2 < data.length; ++aa2) {
            if (data[aa2] != 47) continue;
            ++count;
        }
        return count;
    }
}

