/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;

public final class FloatValue {
    private FloatValue() {
    }

    public static int setFloatValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        ++i2;
        int keyStart = i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 47);
        i2 = StreamReaderUtils.skipToEndOfRef(raw, i2);
        float number = NumberUtils.parseFloat(keyStart, i2, raw);
        int jj = i2;
        if (raw[jj = StreamReaderUtils.skipSpaces(raw, jj)] >= 48 && raw[jj] <= 57) {
            int j2;
            int count;
            while (raw[i2] == 10 || raw[i2] == 13 || raw[i2] == 32 || raw[i2] == 47 || raw[i2] == 60) {
                ++i2;
            }
            keyStart = i2;
            i2 = StreamReaderUtils.skipToEndOfRef(raw, i2);
            int generation = NumberUtils.parseInt(keyStart, i2, raw);
            while (raw[i2] == 10 || raw[i2] == 13 || raw[i2] == 32 || raw[i2] == 47 || raw[i2] == 60) {
                ++i2;
            }
            if (raw[i2] != 82) {
                throw new RuntimeException("3. Unexpected value in file - please send to IDRsolutions for analysis");
            }
            byte[] data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed((int)number, generation), (int)number, generation);
            if (data == null) {
                pdfObject.setFullyResolved(false);
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                }
                return raw.length;
            }
            for (count = j2 = StreamReaderUtils.skipSpaces(data, 0); count < data.length && data[count] != 10 && data[count] != 13 && data[count] != 32; ++count) {
            }
            number = NumberUtils.parseFloat(j2, count, data);
        }
        pdfObject.setFloatNumber(PDFkeyInt, number);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "set key in numberValue=" + number);
        }
        return --i2;
    }
}

