/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.ArrayList;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.DirectDictionaryToObject;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;

public final class Dictionary {
    private Dictionary() {
    }

    public static int readDictionary(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        boolean ignoreRecursion = pdfObject.ignoreRecursion();
        if (raw[i2] != 60) {
            ++i2;
        }
        if (raw[i2 = StreamReaderUtils.skipSpaces(raw, i2)] == 47) {
            i2 = Dictionary.readKey(pdfObject, i2 + 1, raw, PDFkeyInt);
        } else if (StreamReaderUtils.isEndObj(raw, i2)) {
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Empty object" + new String(raw) + "<<");
            }
        } else {
            i2 = !ignoreRecursion ? Dictionary.readDictionaryFromRefOrDirect(pdfObject, pdfObject.getObjectRefAsString(), i2, raw, PDFkeyInt, objectReader) : Dictionary.readRef(pdfObject, i2, raw, PDFkeyInt, objectReader);
        }
        return i2;
    }

    private static int readRef(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "1.About to read ref orDirect i=" + i2 + " char=" + (char)raw[i2]);
        }
        i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 91);
        i2 = Dictionary.readDictionaryFromRefOrDirect(pdfObject, pdfObject.getObjectRefAsString(), i2, raw, PDFkeyInt, objectReader);
        return i2;
    }

    private static int readKey(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt) {
        int keyStart = i2;
        i2 = StreamReaderUtils.skipToEndOfRef(raw, i2);
        PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
        valueObj.setID(PDFkeyInt);
        valueObj.setConstant(PDFkeyInt, keyStart, i2 - keyStart, raw);
        valueObj.setGeneralStringValue(new String(Dictionary.getByteKeyFromStream(i2 - keyStart, raw, keyStart)));
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "Set Dictionary as String=" + valueObj.getGeneralStringValue() + "  in " + pdfObject + " to " + valueObj);
        }
        pdfObject.setDictionary(PDFkeyInt, valueObj);
        return i2;
    }

    public static int setDictionaryValue(PdfObject pdfObject, int i2, byte[] raw, PdfFileReader objectReader, int PDFkeyInt, boolean dictionaryOnly) {
        int endJ;
        int j2;
        byte[] data;
        boolean isRef;
        boolean ignoreRecursion = pdfObject.ignoreRecursion();
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + ">>>Reading Dictionary Pairs i=" + i2 + ' ' + (char)raw[i2] + (char)raw[i2 + 1] + (char)raw[i2 + 2] + (char)raw[i2 + 3] + (char)raw[i2 + 4] + (char)raw[i2 + 5] + (char)raw[i2 + 6]);
        }
        boolean bl2 = isRef = (data = raw)[j2 = (i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 47))] != 60;
        if (isRef) {
            int[] values = StreamReaderUtils.readRefFromStream(raw, i2);
            int number = values[0];
            int generation = values[1];
            i2 = values[2];
            if (!ignoreRecursion) {
                data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (ObjectDecoder.debugFastCode) {
                        System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                    }
                    return raw.length;
                }
                if (data[0] == 60 && data[1] == 60) {
                    j2 = 0;
                } else {
                    j2 = 3;
                    while (data[j2 - 1] != 106 && data[j2 - 2] != 98 && data[j2 - 3] != 111) {
                        if (data[j2] == 47) {
                            j2 = 0;
                            break;
                        }
                        if (++j2 != data.length) continue;
                        j2 = 0;
                        break;
                    }
                    if (data[j2 = StreamReaderUtils.skipSpaces(data, j2)] == 37) {
                        j2 = StreamReaderUtils.skipComment(data, j2);
                    }
                }
            }
        }
        if (data[endJ = StreamReaderUtils.skipSpacesOrOtherCharacter(data, j2, 60)] == 62) {
            j2 = endJ + 1;
        } else {
            PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
            valueObj.setID(PDFkeyInt);
            j2 = dictionaryOnly ? Dictionary.readKeyPairs(data, j2, valueObj) : Dictionary.readMixedKeyPairs(data, j2, valueObj);
            pdfObject.setDictionary(PDFkeyInt, valueObj);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Set Dictionary pairs type in " + pdfObject + " to " + valueObj);
            }
        }
        if (!isRef) {
            i2 = j2;
            if (ObjectDecoder.debugFastCode) {
                System.out.println(i2 + ">>>>" + data[i2 - 2] + ' ' + data[i2 - 1] + " >" + data[i2] + "< " + data[i2 + 1] + ' ' + data[i2 + 2]);
            }
        }
        return i2;
    }

    private static int readMixedKeyPairs(byte[] data, int start, PdfObject pdfObject) {
        ArrayList<byte[]> keys = new ArrayList<byte[]>(100);
        ArrayList<byte[]> values = new ArrayList<byte[]>(100);
        while (true) {
            start = StreamReaderUtils.skipSpacesOrOtherCharacter(data, start, 60);
            if (data[start = StreamReaderUtils.skipSpacesOrOtherCharacter(data, start, 41)] == 37) {
                start = StreamReaderUtils.skipComment(data, start);
            }
            if (data[start] == 62 || StreamReaderUtils.isEndObj(data, start)) break;
            int tokenStart = start + 1;
            start = StreamReaderUtils.skipToEndOfKey(data, tokenStart);
            keys.add(Dictionary.getByteKeyFromStream(start - tokenStart, data, tokenStart));
            int refStart = start = StreamReaderUtils.skipSpaces(data, start);
            if (StreamReaderUtils.isNull(data, start)) {
                start += 4;
                values.add(null);
                continue;
            }
            if (data[start] == 60 || data[start] == 91 || data[start] == 47 || data[start] == 40) {
                switch (data[start]) {
                    case 60: {
                        start = ObjectUtils.skipToEndOfObject(start, data);
                        break;
                    }
                    case 91: {
                        start = StreamReaderUtils.skipToEndOfArray(data, start);
                        break;
                    }
                    case 47: {
                        start = StreamReaderUtils.skipToEndOfKey(data, start + 1);
                        break;
                    }
                    case 40: {
                        ++refStart;
                        start = StreamReaderUtils.skipToEndOfStream(data, start);
                        break;
                    }
                }
            } else {
                while (data[start] != 82 && (data[start] != 47 || data[start - 1] == 92 && data[start - 2] == 92) && data[start] != 62 && data[start - 1] != 62) {
                    ++start;
                }
                if (data[start] == 82) {
                    ++start;
                }
            }
            values.add(Dictionary.getByteKeyFromStream(start - refStart, data, refStart));
        }
        int size = keys.size();
        byte[][] returnKeys = new byte[size][];
        byte[][] returnValues = new byte[size][];
        for (int a10 = 0; a10 < size; ++a10) {
            returnKeys[a10] = (byte[])keys.get(a10);
            returnValues[a10] = (byte[])values.get(a10);
        }
        pdfObject.setDictionaryPairs(returnKeys, returnValues);
        return start;
    }

    private static int readKeyPairs(byte[] data, int start, PdfObject pdfObject) {
        ArrayList<byte[]> keys = new ArrayList<byte[]>(100);
        ArrayList<byte[]> values = new ArrayList<byte[]>(100);
        while (true) {
            if (data[start = StreamReaderUtils.skipSpacesOrOtherCharacter(data, start, 60)] == 37) {
                start = StreamReaderUtils.skipComment(data, start);
            }
            if (data[start] == 62 || StreamReaderUtils.isEndObj(data, start)) break;
            int tokenStart = start + 1;
            start = StreamReaderUtils.skipToStartOfObject(data, tokenStart);
            keys.add(Dictionary.getByteKeyFromStream(start - tokenStart, data, tokenStart));
            int refStart = start = StreamReaderUtils.skipSpaces(data, start);
            if (StreamReaderUtils.isNull(data, start)) {
                start += 4;
                values.add(null);
                continue;
            }
            if (data[start] == 60 || data[start] == 91 || data[start] == 47) {
                switch (data[start]) {
                    case 60: {
                        start = ObjectUtils.skipToEndOfObject(start, data);
                        break;
                    }
                    case 91: {
                        start = StreamReaderUtils.skipToEndOfArray(data, start);
                        break;
                    }
                    case 47: {
                        start = StreamReaderUtils.skipToEndOfKey(data, start + 1);
                        break;
                    }
                }
            } else {
                while (data[start] != 82) {
                    ++start;
                }
                ++start;
            }
            values.add(Dictionary.getByteKeyFromStream(start - refStart, data, refStart));
        }
        int size = keys.size();
        byte[][] returnKeys = new byte[size][];
        byte[][] returnValues = new byte[size][];
        for (int a10 = 0; a10 < size; ++a10) {
            returnKeys[a10] = (byte[])keys.get(a10);
            returnValues[a10] = (byte[])values.get(a10);
        }
        pdfObject.setDictionaryPairs(returnKeys, returnValues);
        return start;
    }

    private static byte[] getByteKeyFromStream(int tokenLength, byte[] data, int tokenStart) {
        byte[] tokenKey = new byte[tokenLength];
        System.arraycopy(data, tokenStart, tokenKey, 0, tokenLength);
        return tokenKey;
    }

    public static int setUnreadDictionaryValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, boolean isInlineImage) {
        if (raw[i2] != 60) {
            ++i2;
        }
        int start = i2 = StreamReaderUtils.skipSpaces(raw, i2);
        PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
        valueObj.setID(PDFkeyInt);
        if (!StreamReaderUtils.isNull(raw, i2)) {
            pdfObject.setDictionary(PDFkeyInt, valueObj);
        }
        int status = 2;
        if (raw[i2] == 47) {
            i2 = Dictionary.getDirectValue(i2, raw, PDFkeyInt, isInlineImage, valueObj);
            status = 0;
        } else if (raw[i2] != 101 || raw[i2 + 1] != 110 || raw[i2 + 2] != 100 || raw[i2 + 3] != 111 || raw[i2 + 4] != 98) {
            if (raw[i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 91)] == 60 && raw[i2 + 1] == 60) {
                i2 = Dictionary.handleDirectDictionary(i2, raw);
            } else if (raw[i2] == 91) {
                ++i2;
                i2 = Dictionary.handleLevels(i2, raw);
            } else if (StreamReaderUtils.isNull(raw, i2)) {
                i2 += 4;
            } else {
                status = 1;
                while ((raw[i2] != 82 || raw[i2 - 1] == 101) && ++i2 != raw.length) {
                }
                if (++i2 >= raw.length) {
                    i2 = raw.length - 1;
                }
            }
        }
        valueObj.setStatus(status);
        if (status != 0) {
            Dictionary.decodeObject(i2, raw, PDFkeyInt, start, valueObj);
        }
        if (raw[i2] == 47 || raw[i2] == 62) {
            --i2;
        }
        return i2;
    }

    private static void decodeObject(int i2, byte[] raw, int PDFkeyInt, int start, PdfObject valueObj) {
        int StrLength = i2 - start;
        byte[] unresolvedData = new byte[StrLength];
        System.arraycopy(raw, start, unresolvedData, 0, StrLength);
        if (unresolvedData[StrLength - 1] == 82) {
            for (int jj = 0; jj < StrLength; ++jj) {
                if (unresolvedData[jj] != 10 && unresolvedData[jj] != 13) continue;
                unresolvedData[jj] = 32;
            }
        }
        valueObj.setUnresolvedData(unresolvedData, PDFkeyInt);
    }

    static int handleDirectDictionary(int i2, byte[] raw) {
        i2 += 2;
        int reflevel = 1;
        while (reflevel > 0) {
            if (raw[i2] == 60 && raw[i2 + 1] == 60) {
                i2 += 2;
                ++reflevel;
                continue;
            }
            if (raw[i2] == 40) {
                ++i2;
                while (raw[i2] != 41 || ObjectUtils.isEscaped(raw, i2)) {
                    ++i2;
                }
                continue;
            }
            if (raw[i2] == 62 && i2 + 1 == raw.length) {
                reflevel = 0;
                continue;
            }
            if (raw[i2] == 62 && raw[i2 + 1] == 62) {
                i2 += 2;
                --reflevel;
                continue;
            }
            ++i2;
        }
        return i2;
    }

    private static int handleLevels(int i2, byte[] raw) {
        int reflevel = 1;
        while (reflevel > 0) {
            switch (raw[i2]) {
                case 40: {
                    ++i2;
                    while (raw[i2] != 41 || ObjectUtils.isEscaped(raw, i2)) {
                        ++i2;
                    }
                    break;
                }
                case 91: {
                    ++reflevel;
                    break;
                }
                case 93: {
                    --reflevel;
                    break;
                }
            }
            ++i2;
        }
        return --i2;
    }

    private static int getDirectValue(int i2, byte[] raw, int PDFkeyInt, boolean isInlineImage, PdfObject valueObj) {
        while (raw[i2] == 10 || raw[i2] == 13 || raw[i2] == 32 || raw[i2] == 47 || raw[i2] == 60) {
            ++i2;
        }
        int keyStart = i2;
        int keyLength = 0;
        while (raw[i2] != 10 && raw[i2] != 13 && raw[i2] != 32 && raw[i2] != 47 && raw[i2] != 60 && raw[i2] != 62) {
            ++i2;
            ++keyLength;
        }
        --i2;
        int constant = valueObj.setConstant(PDFkeyInt, keyStart, keyLength, raw);
        if (constant == -1 || isInlineImage) {
            byte[] newStr = new byte[keyLength];
            System.arraycopy(raw, keyStart, newStr, 0, keyLength);
            String s2 = new String(newStr);
            valueObj.setGeneralStringValue(s2);
        }
        return i2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int readDictionaryFromRefOrDirect(PdfObject pdfObject, String objectRef, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        int generation;
        int ref;
        byte[] data;
        int j2;
        block4: while (true) {
            if (raw[i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 91)] == 37) {
                i2 = StreamReaderUtils.skipComment(raw, i2);
                i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 91);
            }
            switch (raw[i2]) {
                case 60: {
                    return Dictionary.handleBrackets(pdfObject, objectRef, i2, raw, PDFkeyInt, objectReader);
                }
                case 47: {
                    return ObjectUtils.setDirectValue(pdfObject, i2, raw, PDFkeyInt);
                }
            }
            j2 = i2;
            data = raw;
            while (true) {
                int[] values;
                block16: {
                    if (data[j2 = StreamReaderUtils.skipSpacesOrOtherCharacter(data, j2, 91)] == 93) {
                        return j2;
                    }
                    boolean hasNull = false;
                    do {
                        if (hasNull && data[j2] == 93) {
                            return j2;
                        }
                        values = StreamReaderUtils.readRefFromStream(data, j2);
                        ref = values[0];
                        int keyStart = j2;
                        j2 = StreamReaderUtils.skipToEndOfRef(data, j2);
                        j2 = StreamReaderUtils.skipSpaces(data, j2);
                        if (ref != 69560 || data[keyStart] != 110) break block16;
                        hasNull = true;
                    } while (data[j2] != 60);
                    i2 = j2;
                    continue block4;
                }
                generation = values[1];
                j2 = values[2];
                data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(ref, generation), ref, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    return raw.length;
                }
                if (data.length > 4 && data[0] == 37 && data[1] == 80 && data[2] == 68 && data[3] == 70 || StreamReaderUtils.isNull(data, 0)) {
                    data = null;
                }
                if (data == null) break block4;
                int j22 = 0;
                if (data[j22] == 37) {
                    j22 = StreamReaderUtils.skipComment(data, j22);
                }
                if (data[j22] != 91 && data[0] != 60 && data[1] != 60 && (j22 = Dictionary.handleOddRef(data, j22)) >= data.length) {
                    return i2;
                }
                if (data[j22] != 91) {
                    j2 = 0;
                    break block4;
                }
                if (data[j22] == 91 && data[j22 + 1] == 60) {
                    j2 = ++j22;
                    break block4;
                }
                j2 = j22;
            }
            break;
        }
        if (data == null) return i2;
        if ((i2 = Dictionary.handlePairs(pdfObject, objectRef, i2, raw, PDFkeyInt)) >= 0) return Dictionary.readObj(j2, data, raw, ref, generation, i2, pdfObject, PDFkeyInt, objectReader);
        return -i2;
    }

    private static int handleBrackets(PdfObject pdfObject, String objectRef, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        i2 = (i2 = Dictionary.handlePairs(pdfObject, objectRef, i2, raw, PDFkeyInt)) < 0 ? -i2 : DirectDictionaryToObject.convert(pdfObject, objectRef, i2, raw, PDFkeyInt, objectReader);
        return i2;
    }

    private static int handleOddRef(byte[] data, int j2) {
        while ((j2 < 3 || data[j2 - 1] != 106 && data[j2 - 2] != 98 && data[j2 - 3] != 111) && data[j2] != 47) {
            ++j2;
        }
        j2 = StreamReaderUtils.skipSpaces(data, j2);
        return j2;
    }

    private static int handlePairs(PdfObject pdfObject, String objectRef, int i2, byte[] raw, int PDFkeyInt) {
        boolean isPairs = false;
        int parentType = pdfObject.getPDFkeyInt();
        if (parentType != 4369 && parentType != -1567847737 && (PDFkeyInt == 30 || PDFkeyInt == 34 || PDFkeyInt == 20 || PDFkeyInt == 893600855)) {
            isPairs = Dictionary.isDictionaryPairs(i2, raw);
        }
        if (isPairs) {
            FormObject APobj = new FormObject(objectRef);
            pdfObject.setDictionary(PDFkeyInt, APobj);
            i2 = -Dictionary.readKeyPairs(raw, i2, APobj);
        }
        return i2;
    }

    private static int readObj(int j2, byte[] data, byte[] raw, int ref, int generation, int i2, PdfObject pdfObject, int PDFkeyInt, PdfFileReader objectReader) {
        boolean isMissingValue;
        boolean bl2 = isMissingValue = (j2 = StreamReaderUtils.skipSpaces(data, j2)) < raw.length && raw[j2] == 60 && raw[StreamReaderUtils.skipSpacesOrOtherCharacter(raw, j2, 60)] != 47;
        if (isMissingValue) {
            int keyStart = j2;
            j2 = StreamReaderUtils.skipToEndOfRef(data, j2);
            ref = NumberUtils.parseInt(keyStart, j2, data);
            keyStart = j2 = StreamReaderUtils.skipSpaces(data, j2);
            j2 = StreamReaderUtils.skipToEndOfRef(data, j2);
            generation = NumberUtils.parseInt(keyStart, j2, data);
            while (data[j2 - 1] != 106 && data[j2 - 2] != 98 && data[j2 - 3] != 111 && data[j2] != 60) {
                ++j2;
            }
        }
        j2 = StreamReaderUtils.skipSpaces(data, j2);
        boolean streamIsNull = false;
        while (data[j2] != 60 && data[j2 + 1] != 60 && data[j2] != 47 && !(streamIsNull = StreamReaderUtils.isNull(data, j2))) {
            ++j2;
        }
        i2 = streamIsNull ? j2 + 4 : Dictionary.handleValue(pdfObject, i2, PDFkeyInt, j2, ref, generation, data, objectReader);
        return i2;
    }

    public static int setDictionaryValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        int end = i2;
        int nextC = i2;
        if (StreamReaderUtils.isNull(raw, nextC = StreamReaderUtils.skipSpaces(raw, nextC))) {
            i2 = nextC + 4;
            return i2;
        }
        if (raw[nextC] == 91 && raw[nextC + 1] == 93) {
            i2 = nextC;
            return i2;
        }
        if (raw[i2] != 60 && raw[i2 + 1] != 60) {
            end += 2;
        }
        boolean inDictionary = true;
        boolean isKey = raw[end + 1] == 47;
        int strLen = raw.length;
        if (!isKey) {
            while (inDictionary && end < strLen) {
                if (raw[end] == 60 && raw[end + 1] == 60) {
                    int level2 = 1;
                    ++end;
                    while (level2 > 0) {
                        if (raw[end] == 60 && raw[end + 1] == 60) {
                            ++level2;
                            end += 2;
                            continue;
                        }
                        if (raw[end - 1] == 62 && raw[end] == 62) {
                            if (--level2 <= 0) continue;
                            end += 2;
                            continue;
                        }
                        if (raw[end] == 40) {
                            ++end;
                            while (raw[end] != 41 || ObjectUtils.isEscaped(raw, end)) {
                                ++end;
                            }
                            continue;
                        }
                        ++end;
                    }
                    inDictionary = false;
                    continue;
                }
                if (raw[end] == 82) {
                    inDictionary = false;
                    continue;
                }
                if (raw[end] == 47 || raw[end] == 62 && raw[end + 1] == 62) {
                    inDictionary = false;
                    --end;
                    continue;
                }
                ++end;
            }
        }
        int keyEnd = Dictionary.readDictionary(pdfObject, i2, raw, PDFkeyInt, objectReader);
        if (isKey) {
            return keyEnd;
        }
        return end;
    }

    private static int handleValue(PdfObject pdfObject, int i2, int PDFkeyInt, int j2, int ref, int generation, byte[] data, PdfFileReader objectReader) {
        int dataLen = data.length;
        if (data[j2] == 47) {
            int keyStart = ++j2;
            int keyLength = 0;
            while (j2 < dataLen && data[j2] != 10 && data[j2] != 13 && data[j2] != 32 && data[j2] != 47 && data[j2] != 60 && data[j2] != 62) {
                ++j2;
                ++keyLength;
            }
            --i2;
            if (PDFkeyInt == -1) {
                pdfObject.setConstant(-1, keyStart, keyLength, data);
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(ObjectDecoder.padding + "Set object Constant directly to " + pdfObject.setConstant(-1, keyStart, keyLength, data));
                }
            } else {
                PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, null, pdfObject.getObjectType(), pdfObject.getID());
                valueObj.setID(PDFkeyInt);
                valueObj.setConstant(PDFkeyInt, keyStart, keyLength, data);
                pdfObject.setDictionary(PDFkeyInt, valueObj);
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!ObjectDecoder.resolveFully(valueObj, objectReader)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else {
            PdfObject valueObj;
            if (PDFkeyInt == -1) {
                valueObj = pdfObject;
            } else {
                valueObj = ObjectFactory.createObject(PDFkeyInt, ref, generation, pdfObject.getObjectType());
                valueObj.setID(PDFkeyInt);
                valueObj.setInCompressedStream(pdfObject.isInCompressedStream());
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!ObjectDecoder.resolveFully(valueObj, objectReader)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
                if (PDFkeyInt != 2004251818) {
                    valueObj.ignoreRecursion(pdfObject.ignoreRecursion());
                }
            }
            if (PDFkeyInt == -1 || ref != pdfObject.getObjectRefID()) {
                ObjectDecoder objDecoder = new ObjectDecoder(objectReader);
                objDecoder.readDictionaryAsObject(valueObj, j2, data);
            }
            if (PDFkeyInt != -1) {
                pdfObject.setDictionary(PDFkeyInt, valueObj);
            }
        }
        return i2;
    }

    private static boolean isDictionaryPairs(int i2, byte[] raw) {
        int length = raw.length;
        while (i2 < length) {
            if (raw[i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 60)] == 62 && raw[i2 + 1] == 62) {
                return true;
            }
            if (raw[i2] != 47) {
                return false;
            }
            int keyStart = ++i2;
            int keyLength = StreamReaderUtils.findDictionaryEnd(i2, raw, length);
            i2 += keyLength;
            int possibleKey = PdfDictionary.getIntKey(keyStart, keyLength, raw);
            if (possibleKey != -1 && keyLength > 3 && PdfDictionary.getKeyType(possibleKey, -1) != -1) {
                return false;
            }
            ++i2;
            if (StreamReaderUtils.isRef(raw, i2 = StreamReaderUtils.skipSpaces(raw, i2))) {
                while (raw[i2] != 82) {
                    ++i2;
                }
                ++i2;
                continue;
            }
            if (StreamReaderUtils.isNull(raw, i2)) {
                i2 += 4;
                continue;
            }
            if (raw[i2] == 60 && raw[i2 + 1] == 60) {
                i2 = ObjectUtils.skipToEndOfObject(i2, raw) + 1;
                continue;
            }
            if (raw[i2] == 91) {
                i2 = StreamReaderUtils.skipToEndOfArray(raw, i2);
                continue;
            }
            return false;
        }
        return true;
    }
}

