/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.Offsets;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public final class CompressedObjects {
    private CompressedObjects() {
    }

    public static void extractCompressedObjectOffset(Map<String, String> offsetStart, Map<String, String> offsetEnd, int first, byte[] compressedStream, int compressedID, Offsets offset) {
        String lastKey = null;
        for (int ii = 0; ii < first; ++ii) {
            int startKey;
            if (compressedStream.length == 0 || (startKey = (ii = StreamReaderUtils.skipSpaces(compressedStream, ii))) == first) continue;
            while (compressedStream[ii] != 32 && compressedStream[ii] != 13 && compressedStream[ii] != 10 && compressedStream[ii] != 0) {
                ++ii;
            }
            int endKey = ii - 1;
            int length = endKey - startKey + 1;
            String key = CompressedObjects.getString(compressedStream, startKey, length);
            int id2 = NumberUtils.parseInt(startKey, startKey + length, compressedStream);
            int startOff = ii = StreamReaderUtils.skipSpacesOrOtherCharacter(compressedStream, ii, 0);
            while (compressedStream[ii] != 32 && compressedStream[ii] != 13 && compressedStream[ii] != 10 && compressedStream[ii] != 0 && compressedStream[ii] != 60 && ii < first) {
                ++ii;
            }
            int endOff = ii - 1;
            length = endOff - startOff + 1;
            String offsetRef = CompressedObjects.getString(compressedStream, startOff, length);
            if ((long)compressedID != offset.elementAt(id2)) continue;
            offsetStart.put(key, offsetRef);
            if (lastKey != null) {
                offsetEnd.put(lastKey, offsetRef);
            }
            lastKey = key;
        }
    }

    private static String getString(byte[] compressedStream, int startOff, int length) {
        char[] newCommand = new char[length];
        for (int i2 = 0; i2 < length; ++i2) {
            newCommand[i2] = (char)compressedStream[startOff + i2];
        }
        return new String(newCommand);
    }

    public static int readCompressedOffsets(int pntr, int current, int numbEntries, int[] fieldSizes, byte[] xrefs, Offsets offset, RandomAccessBuffer pdf_datafile) throws PdfException {
        int[] defaultValue = new int[]{1, 0, 0};
        block5: for (int i2 = 0; i2 < numbEntries; ++i2) {
            long[] nextValue = new long[3];
            for (int ii = 0; ii < 3; ++ii) {
                if (fieldSizes[ii] == 0) {
                    nextValue[ii] = defaultValue[ii];
                    continue;
                }
                nextValue[ii] = CompressedObjects.getWord(xrefs, pntr, fieldSizes[ii]);
                pntr += fieldSizes[ii];
            }
            switch ((int)nextValue[0]) {
                case 0: {
                    ++current;
                    continue block5;
                }
                case 1: {
                    long nextOffset = nextValue[1];
                    int gen = (int)nextValue[2];
                    if (CompressedObjects.checkValid(pdf_datafile, nextOffset, current)) {
                        offset.storeObjectOffset(current, nextOffset, gen, false, false);
                    }
                    ++current;
                    continue block5;
                }
                case 2: {
                    long id2 = nextValue[1];
                    offset.storeObjectOffset(current, id2, 0, true, false);
                    ++current;
                    continue block5;
                }
                default: {
                    throw new PdfException("Exception Unsupported Compression mode with value " + nextValue[0]);
                }
            }
        }
        return pntr;
    }

    private static boolean checkValid(RandomAccessBuffer pdf_datafile, long nextOffset, int current) {
        boolean refIsvalid = false;
        try {
            int ref;
            int size = 20;
            byte[] data = new byte[20];
            pdf_datafile.seek(nextOffset);
            pdf_datafile.read(data);
            int start = CompressedObjects.ignoreJunkAtStart(data);
            start = StreamReaderUtils.skipSpaces(data, start);
            int ptr = 0;
            for (int ii = start; ii < 20; ++ii) {
                if (data[ii] != 32 && data[ii] != 10 && data[ii] != 13) continue;
                ptr = ii;
                break;
            }
            if (ptr > 0 && (ref = NumberUtils.parseInt(start, ptr, data)) == current) {
                refIsvalid = true;
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Ref is invalid " + ee);
        }
        return refIsvalid;
    }

    private static int ignoreJunkAtStart(byte[] data) {
        int start = 0;
        for (int ii = 0; ii < data.length - 4; ++ii) {
            if (data[ii] == 100 || data[ii + 1] != 111 || data[ii + 2] != 98 || data[ii + 3] != 106) continue;
            start = ii;
            break;
        }
        int numberCount = 0;
        while (start > 0 && numberCount < 2) {
            if (--start <= 0 || data[start] < 48 || data[start] > 57) continue;
            ++numberCount;
            while (start > 0 && data[start] >= 48 && data[start] <= 57) {
                --start;
            }
        }
        return start;
    }

    private static long getWord(byte[] content, int index, int size) {
        long result = 0L;
        for (int i2 = 0; i2 < size; ++i2) {
            result = (result << 8) + (long)(content[index + i2] & 0xFF);
        }
        return result;
    }
}

