/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.Offsets;
import org.jpedal.objects.raw.CatalogObject;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

final class BrokenRefTable {
    private BrokenRefTable() {
    }

    public static Object[] readCatalogObjects(RandomAccessBuffer pdf_datafile, Offsets offset, PdfFileReader currentPdfFile, byte[] ID2) throws PdfException {
        LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
        CatalogObject root = null;
        PdfObject encrypt = null;
        PdfObject info = null;
        boolean hasEncryption = false;
        long rootPtr = 0L;
        String line = null;
        int i2 = 0;
        try {
            pdf_datafile.seek(0L);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " reading line");
        }
        while (true) {
            try {
                i2 = (int)pdf_datafile.getFilePointer();
                line = pdf_datafile.readLine();
            }
            catch (Exception e3) {
                LogWriter.writeLog("Exception " + e3 + " reading line");
            }
            if (line == null) break;
            if (line.contains(" obj")) {
                int start;
                int length = line.length();
                for (start = 0; start < length && line.charAt(start) != '%' && line.charAt(start) != '/' && (line.charAt(start) < '0' || line.charAt(start) > '9'); ++start) {
                }
                if (start > 0 && (start == length || line.charAt(start) == '/')) {
                    start = 0;
                }
                int pointer = line.indexOf(32, start);
                try {
                    if (pointer > 0) {
                        offset.storeObjectOffset(Integer.parseInt(line.substring(start, pointer)), i2 + start, 1, false, true);
                    }
                }
                catch (Exception e4) {
                    LogWriter.writeLog("[PDF] Exception " + e4 + " Unable to manually read line " + line);
                }
            }
            if (line.contains("/Root")) {
                root = new CatalogObject(BrokenRefTable.readID(line, pdf_datafile));
                rootPtr = i2;
            }
            if (!line.contains("/Encrypt")) continue;
            hasEncryption = true;
        }
        if (hasEncryption) {
            try {
                pdf_datafile.seek(rootPtr);
            }
            catch (IOException ex) {
                LogWriter.writeLog("[PDF] Exception " + ex + " Unable to manually read Encryption object");
            }
            byte[] rootDictBytes = currentPdfFile.getObjectReader().readObjectData(-1, null);
            if (rootDictBytes != null) {
                CompressedObject pdfObject = new CompressedObject("0 0 R");
                Dictionary.readDictionary(pdfObject, 0, rootDictBytes, -1, currentPdfFile);
                encrypt = ((PdfObject)pdfObject).getDictionary(1113489015);
                byte[][] IDs = ((PdfObject)pdfObject).getStringArray(6420);
                if (IDs != null && ID2 == null) {
                    ID2 = IDs[0];
                }
                info = ((PdfObject)pdfObject).getDictionary(423507519);
            }
        }
        if (root == null) {
            throw new PdfException("[PDF] Unable to find root object");
        }
        return new Object[]{root, encrypt, info, ID2};
    }

    private static String readID(String line, RandomAccessBuffer pdf_datafile) {
        int start = line.indexOf("/Root") + 5;
        int pointer = line.indexOf(82, start);
        while (pointer == -1) {
            start = 0;
            try {
                line = pdf_datafile.readLine();
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception " + e2 + " reading line");
            }
            pointer = line.indexOf(82, start);
        }
        return line.substring(start, pointer + 1).trim();
    }
}

