/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public final class BooleanValue {
    private BooleanValue() {
    }

    public static int set(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        ++i2;
        if (raw[i2 = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i2, 47)] == 40) {
            ++i2;
        }
        int keyStart = i2;
        while (raw[i2] != 10 && raw[i2] != 13 && raw[i2] != 32 && raw[i2] != 47 && raw[i2] != 60 && raw[i2] != 62 && raw[i2] != 41) {
            ++i2;
        }
        --i2;
        if (StreamReaderUtils.isRef(raw, keyStart)) {
            i2 = BooleanValue.readBooleanFromIndirectObj(PDFkeyInt, pdfObject, keyStart, raw, objectReader, raw.length);
        } else {
            BooleanValue.setValue(pdfObject, PDFkeyInt, raw, keyStart);
        }
        return i2;
    }

    private static int readBooleanFromIndirectObj(int PDFkeyInt, PdfObject pdfObject, int keyStart, byte[] raw, PdfFileReader objectReader, int rawLength) {
        int[] ref = StreamReaderUtils.readRefFromStream(raw, keyStart);
        int i2 = StreamReaderUtils.skipToCharacter(raw, keyStart, 82);
        int number = ref[0];
        int generation = ref[1];
        if (raw[i2] != 82) {
            throw new RuntimeException("Unexpected boolean value in file - please send to IDRsolutions for analysis");
        }
        byte[] data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
        if (data == null) {
            pdfObject.setFullyResolved(false);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Data not yet loaded");
            }
            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (8)");
            return rawLength;
        }
        BooleanValue.setValue(pdfObject, PDFkeyInt, data, 0);
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "set numberValue=" + number);
        }
        return i2 - 1;
    }

    private static void setValue(PdfObject pdfObject, int PDFkeyInt, byte[] raw, int keyStart) {
        if (raw[keyStart] == 116 && raw[keyStart + 1] == 114 && raw[keyStart + 2] == 117 && raw[keyStart + 3] == 101) {
            pdfObject.setBoolean(PDFkeyInt, true);
        } else if (raw[keyStart] == 102 && raw[keyStart + 1] == 97 && raw[keyStart + 2] == 108 && raw[keyStart + 3] == 115 && raw[keyStart + 4] == 101) {
            pdfObject.setBoolean(PDFkeyInt, false);
        } else if (raw[keyStart] == 70 && raw[keyStart + 1] == 97 && raw[keyStart + 2] == 108 && raw[keyStart + 3] == 115 && raw[keyStart + 4] == 101) {
            pdfObject.setBoolean(PDFkeyInt, false);
        } else if (raw[keyStart] == 84 && raw[keyStart + 1] == 114 && raw[keyStart + 2] == 117 && raw[keyStart + 3] == 101) {
            pdfObject.setBoolean(PDFkeyInt, true);
        } else if (raw[keyStart] == 48) {
            pdfObject.setBoolean(PDFkeyInt, false);
        } else if (raw[keyStart] == 49) {
            pdfObject.setBoolean(PDFkeyInt, true);
        } else {
            throw new RuntimeException("Unexpected value for Boolean value for" + PDFkeyInt);
        }
    }
}

