/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.security;

public class CryptoIDR {
    private final byte[] password;
    private final int passwordLength;
    private int bytesProcessed;

    public CryptoIDR(byte[] password) {
        if (password == null) {
            password = "mabel".getBytes();
        }
        this.password = password;
        this.passwordLength = password.length;
    }

    public void skip(long n2) {
        this.bytesProcessed = (int)((long)this.bytesProcessed + n2);
    }

    public byte[] encrypt(byte[] pdfBytes, int salt) {
        int length = pdfBytes.length;
        byte[] returnBytes = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            returnBytes[i2] = this.encrypt(pdfBytes[i2], salt + i2);
        }
        return returnBytes;
    }

    public byte[] decrypt(byte[] pdfBytes, int salt) {
        int length = pdfBytes.length;
        byte[] returnBytes = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            returnBytes[i2] = this.decrypt(pdfBytes[i2], salt + i2);
        }
        return returnBytes;
    }

    public byte encrypt(byte b2, int salt) {
        int remainder = salt % this.passwordLength;
        byte realSalt = this.password[remainder];
        b2 = ~b2;
        b2 = (byte)(b2 ^ realSalt);
        return b2;
    }

    public byte decrypt(byte b2, int salt) {
        int remainder = salt % this.passwordLength;
        byte realSalt = this.password[remainder];
        b2 = (byte)(b2 ^ realSalt);
        b2 = ~b2;
        return b2;
    }

    public byte[] encrypt(byte[] data) {
        data = this.encrypt(data, this.bytesProcessed);
        this.bytesProcessed += data.length;
        return data;
    }

    public byte encrypt(byte data, boolean rollOn) {
        data = this.encrypt(data, this.bytesProcessed);
        if (rollOn) {
            ++this.bytesProcessed;
        }
        return data;
    }

    public byte[] decrypt(byte[] data) {
        data = this.decrypt(data, this.bytesProcessed);
        this.bytesProcessed += data.length;
        return data;
    }

    public byte[] decrypt(byte[] data, int offset, int length) {
        byte[] returnBytes = new byte[length];
        System.arraycopy(data, offset, returnBytes, 0, length);
        return this.decrypt(returnBytes);
    }

    public int getBytesProcessed() {
        return this.bytesProcessed;
    }
}

