/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.outline;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.io.annotation.utils.AnnotBuffer;
import org.jpedal.io.annotation.utils.AnnotInfo;
import org.jpedal.io.annotation.utils.AnnotLEX;
import org.jpedal.io.outline.OutlineStruct;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class OutlineWriter
implements OutlineStruct.ReferenceGenerator {
    private final File input;
    private final Document outline;
    private int newRefStart = -1;
    private int firstNewRef = -1;
    private final PdfDecoder pdfDecoder;
    private int lastOffset;
    private String pagesRef;

    public OutlineWriter(File input, Document outline) {
        this.input = input;
        this.outline = outline;
        this.pdfDecoder = new PdfDecoder();
    }

    public OutlineWriter(String input, Document outline) {
        this(new File(input), outline);
    }

    public void writeOutline() throws IOException, PdfException {
        AnnotBuffer mainBuff;
        if (this.outline == null || !this.outline.hasChildNodes()) {
            throw new IllegalArgumentException("Outline has no nodes");
        }
        NodeList rootNode = this.outline.getChildNodes();
        if (rootNode.getLength() != 1 || !"root".equals(rootNode.item(0).getNodeName())) {
            throw new IllegalStateException("Outline has no root node");
        }
        this.pdfDecoder.openPdfFile(this.input.getAbsolutePath());
        AnnotInfo info = new AnnotInfo();
        info.mainBuffer = mainBuff = new AnnotBuffer(this.input, info);
        int prev = mainBuff.findFirstXREFOffset();
        mainBuff.movePos(prev);
        mainBuff.readSimpleXREF();
        this.newRefStart = 1 + info.offsetMap.maxKey;
        this.firstNewRef = 1 + this.newRefStart;
        this.pagesRef = mainBuff.getPagesRef();
        int fileLength = (int)this.input.length();
        OutlineStruct outlineStruct = this.createOutlineStruct(rootNode.item(0).getChildNodes());
        LinkedHashMap<Tuple<String, Integer>, byte[]> outlineObjectString = this.createOutlineObjects(outlineStruct, fileLength);
        Tuple3<String, Integer, String> catalog = this.createNewCatalog((String)((Tuple)outlineObjectString.entrySet().iterator().next().getKey()).a, String.valueOf(info.mainCatalog.num));
        byte[] writeableData = info.xrefType == 1 ? this.createWritableByteArrayWithStream(outlineObjectString, catalog, fileLength, prev) : this.createWritableByteArrayWithTable(outlineObjectString, catalog, fileLength, prev);
        mainBuff.close();
        try (FileOutputStream fos = new FileOutputStream(this.input, true);){
            fos.write(writeableData);
        }
        this.pdfDecoder.closePdfFile();
    }

    private OutlineStruct createOutlineStruct(NodeList nodeList) {
        OutlineStruct outlineDictionary = new OutlineStruct(this);
        ArrayDeque<Tuple<NodeList, OutlineStruct>> stack = new ArrayDeque<Tuple<NodeList, OutlineStruct>>();
        stack.push(new Tuple<NodeList, OutlineStruct>(nodeList, outlineDictionary));
        while (!stack.isEmpty()) {
            Tuple stackItem = (Tuple)stack.pop();
            NodeList nodes = (NodeList)stackItem.a;
            for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
                Node node = nodes.item(i2);
                OutlineStruct outlineItem = ((OutlineStruct)stackItem.b).insert();
                if (node.hasAttributes()) {
                    NamedNodeMap attributes = node.getAttributes();
                    block14: for (int index = 0; index < attributes.getLength(); ++index) {
                        Node attribute = attributes.item(index);
                        switch (attribute.getNodeName()) {
                            case "isClosed": {
                                outlineItem.setClosed(Boolean.parseBoolean(attribute.getTextContent()));
                                continue block14;
                            }
                            case "page": {
                                outlineItem.setPage(attribute.getTextContent());
                                continue block14;
                            }
                            case "title": {
                                byte[] title = attribute.getTextContent().getBytes(StandardCharsets.UTF_16);
                                ByteArrayOutputStream unicodeTitle = new ByteArrayOutputStream();
                                for (byte b2 : title) {
                                    if (b2 == 40 || b2 == 41 || b2 == 92) {
                                        unicodeTitle.write(92);
                                    }
                                    unicodeTitle.write(b2);
                                }
                                outlineItem.setTitle(unicodeTitle.toByteArray());
                                continue block14;
                            }
                            case "zoom": {
                                outlineItem.setZoom(attribute.getTextContent());
                                continue block14;
                            }
                        }
                    }
                }
                if (!node.hasChildNodes()) continue;
                stack.push(new Tuple<NodeList, OutlineStruct>(node.getChildNodes(), outlineItem));
            }
        }
        return outlineDictionary;
    }

    @Override
    public String generate() {
        ++this.newRefStart;
        return String.valueOf(this.newRefStart);
    }

    private LinkedHashMap<Tuple<String, Integer>, byte[]> createOutlineObjects(OutlineStruct outlineStruct, int fileLength) throws IOException {
        LinkedHashMap<Tuple<String, Integer>, byte[]> offsetMap = new LinkedHashMap<Tuple<String, Integer>, byte[]>();
        this.lastOffset = fileLength;
        ArrayList<OutlineStruct> outlineItems = outlineStruct.getDescendants();
        byte[] outlineDictionaryBytes = (outlineStruct.getRef() + " 0 obj\n<<\n/Type /Outlines\n/First " + outlineStruct.getFirst().getRef() + " 0 R\n/Last " + outlineStruct.getLast().getRef() + " 0 R\n/Count " + outlineItems.size() + "\n>>\nendobj\n").getBytes();
        this.lastOffset += OutlineWriter.putAndGetLength(offsetMap, this.lastOffset - 1, outlineStruct.getRef(), outlineDictionaryBytes);
        for (OutlineStruct outlineItem : outlineItems) {
            String pageRef;
            OutlineStruct first;
            OutlineStruct next;
            ByteArrayOutputStream outlineObjects = new ByteArrayOutputStream();
            outlineObjects.write((outlineItem.getRef() + " 0").getBytes());
            outlineObjects.write(" obj\n<<\n/Title (".getBytes());
            outlineObjects.write(outlineItem.getTitle());
            outlineObjects.write(")\n/Parent ".getBytes());
            outlineObjects.write((outlineItem.getParent().getRef() + " 0").getBytes());
            outlineObjects.write(" R\n/Count ".getBytes());
            outlineObjects.write(String.valueOf(outlineItem.getDescendants().size()).getBytes());
            outlineObjects.write(10);
            OutlineStruct prev = outlineItem.getPrev();
            if (prev != null) {
                outlineObjects.write("/Prev ".getBytes());
                outlineObjects.write((prev.getRef() + " 0").getBytes());
                outlineObjects.write(" R\n".getBytes());
            }
            if ((next = outlineItem.getNext()) != null) {
                outlineObjects.write("/Next ".getBytes());
                outlineObjects.write((next.getRef() + " 0").getBytes());
                outlineObjects.write(" R\n".getBytes());
            }
            if ((first = outlineItem.getFirst()) != null) {
                OutlineStruct last = outlineItem.getLast();
                outlineObjects.write("/First ".getBytes());
                outlineObjects.write((first.getRef() + " 0").getBytes());
                outlineObjects.write(" R\n/Last ".getBytes());
                outlineObjects.write((last.getRef() + " 0").getBytes());
                outlineObjects.write(" R\n/Count ".getBytes());
                outlineObjects.write((outlineItem.isClosed() ? "-" : "").getBytes());
                outlineObjects.write(String.valueOf(outlineItem.getDescendants().size()).getBytes());
                outlineObjects.write(10);
            }
            if ((pageRef = this.pdfDecoder.getIO().getReferenceforPage(outlineItem.getPage())) != null) {
                outlineObjects.write("/Dest [".getBytes());
                outlineObjects.write(pageRef.getBytes());
                outlineObjects.write(" /".getBytes());
                outlineObjects.write(outlineItem.getZoom().getBytes());
                outlineObjects.write("]\n".getBytes());
            }
            outlineObjects.write(">>\nendobj\n".getBytes());
            this.lastOffset += OutlineWriter.putAndGetLength(offsetMap, this.lastOffset, outlineItem.getRef(), outlineObjects.toByteArray());
        }
        return offsetMap;
    }

    private Tuple3<String, Integer, String> createNewCatalog(String outlineDictRef, String catRef) {
        return new Tuple3<String, Integer, String>(catRef, this.lastOffset, catRef + " 0 obj <</Type /Catalog /Pages " + this.pagesRef + " /Outlines " + outlineDictRef + " 0 R>>endobj\n");
    }

    private static int putAndGetLength(LinkedHashMap<Tuple<String, Integer>, byte[]> map, Integer offset, String ref, byte[] data) {
        map.put(new Tuple<String, Integer>(ref, offset), data);
        return data.length;
    }

    private byte[] createWritableByteArrayWithTable(LinkedHashMap<Tuple<String, Integer>, byte[]> offsetsMap, Tuple3<String, Integer, String> catalog, int fileLength, int prevTrailer) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StringBuilder xrefBuilder = new StringBuilder();
        ArrayList<Tuple> xrefs = new ArrayList<Tuple>();
        for (Map.Entry<Tuple<String, Integer>, byte[]> entry : offsetsMap.entrySet()) {
            bos.write(entry.getValue());
            Tuple<String, Integer> key = entry.getKey();
            xrefs.add(new Tuple<String, String>((String)((Tuple)key).a, (String)((Tuple)key).a + " 1\n" + AnnotLEX.getZeroLead((Integer)((Tuple)key).b) + " 00000 n \n"));
        }
        xrefs.add(new Tuple<String, String>((String)((Tuple3)catalog).a, (String)((Tuple3)catalog).a + " 1\n" + AnnotLEX.getZeroLead((Integer)((Tuple3)catalog).b) + " 00000 n \n"));
        bos.write(((String)((Tuple3)catalog).c).getBytes());
        xrefs.sort(Comparator.comparingInt(o2 -> Integer.parseInt((String)((Tuple)o2).a)));
        for (Tuple xref : xrefs) {
            xrefBuilder.append((String)xref.b);
        }
        int startxref = fileLength + bos.size();
        bos.write(new byte[]{120, 114, 101, 102, 10});
        bos.write(xrefBuilder.toString().getBytes());
        String trailerBuilder = "trailer\n<</Size " + this.generate() + " /Root " + (String)((Tuple3)catalog).a + " 0 R /Prev " + prevTrailer + ">>\nstartxref\n" + startxref + "\n%%EOF\n";
        bos.write(trailerBuilder.getBytes());
        return bos.toByteArray();
    }

    private byte[] createWritableByteArrayWithStream(LinkedHashMap<Tuple<String, Integer>, byte[]> offsetsMap, Tuple3<String, Integer, String> catalog, int fileLength, int prev) throws IOException {
        String dictStr;
        int startxref;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int totalObjects = offsetsMap.size();
        StringBuilder indexBuilder = new StringBuilder();
        indexBuilder.append('[');
        try (ByteArrayOutputStream wBytes = new ByteArrayOutputStream();){
            wBytes.write(1);
            wBytes.write(AnnotLEX.toBytes32((Integer)((Tuple3)catalog).b));
            wBytes.write(0);
            indexBuilder.append((String)((Tuple3)catalog).a);
            indexBuilder.append(" 1 ");
            ArrayList<Tuple> xrefs = new ArrayList<Tuple>();
            for (Map.Entry<Tuple<String, Integer>, byte[]> entry : offsetsMap.entrySet()) {
                bos.write(entry.getValue());
                xrefs.add(new Tuple<String, byte[]>((String)((Tuple)entry.getKey()).a, AnnotLEX.toBytes32((Integer)((Tuple)entry.getKey()).b)));
            }
            xrefs.sort(Comparator.comparingInt(o2 -> Integer.parseInt((String)((Tuple)o2).a)));
            for (Tuple xref : xrefs) {
                wBytes.write(1);
                wBytes.write((byte[])xref.b);
                wBytes.write(0);
            }
            indexBuilder.append(this.firstNewRef).append(' ').append(totalObjects).append(']');
            bos.write(((String)((Tuple3)catalog).c).getBytes());
            startxref = fileLength + bos.size();
            wBytes.close();
            String dictRef = this.generate();
            dictStr = dictRef + " 0 obj\n<</Type /XRef /Root " + (String)((Tuple3)catalog).a + " 0 R /Prev " + prev + " /Index " + indexBuilder + " /W [1 4 1] /Size " + (this.firstNewRef + totalObjects + 1) + " /Length " + wBytes.size() + ">>stream\n";
            bos.write(dictStr.getBytes());
            bos.write(wBytes.toByteArray());
        }
        dictStr = "\nendstream\nendobj\nstartxref\n" + startxref + "\n%%EOF\n";
        bos.write(dictStr.getBytes());
        return bos.toByteArray();
    }

    private static final class Tuple3<A, B, C> {
        private final A a;
        private final B b;
        private final C c;

        Tuple3(A a10, B b2, C c2) {
            this.a = a10;
            this.b = b2;
            this.c = c2;
        }
    }

    private static final class Tuple<A, B> {
        private final A a;
        private final B b;

        Tuple(A a10, B b2) {
            this.a = a10;
            this.b = b2;
        }
    }
}

