/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.outline;

import java.util.ArrayList;

final class OutlineStruct {
    private final ReferenceGenerator referenceGenerator;
    private OutlineStruct first;
    private OutlineStruct last;
    private OutlineStruct prev;
    private OutlineStruct next;
    private OutlineStruct parent;
    private final String ref;
    private byte[] title;
    private String page;
    private String zoom;
    private boolean isClosed;

    public OutlineStruct(ReferenceGenerator referenceGenerator) {
        this.referenceGenerator = referenceGenerator;
        this.ref = referenceGenerator.generate();
    }

    public OutlineStruct insert() {
        OutlineStruct node = new OutlineStruct(this.referenceGenerator);
        if (this.first == null) {
            this.first = node;
            this.last = node;
        } else if (this.first == this.last) {
            this.first.next = node;
            node.prev = this.first;
            this.last = node;
        } else {
            this.last.next = node;
            node.prev = this.last;
            this.last = node;
        }
        node.parent = this;
        return node;
    }

    public void setTitle(byte[] title) {
        this.title = title;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setZoom(String zoom) {
        this.zoom = zoom;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public String getRef() {
        return this.ref;
    }

    public byte[] getTitle() {
        return this.title;
    }

    public int getPage() {
        return Integer.parseInt(this.page);
    }

    public String getZoom() {
        return this.zoom;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public OutlineStruct getFirst() {
        return this.first;
    }

    public OutlineStruct getLast() {
        return this.last;
    }

    public OutlineStruct getPrev() {
        return this.prev;
    }

    public OutlineStruct getNext() {
        return this.next;
    }

    public OutlineStruct getParent() {
        return this.parent;
    }

    public ArrayList<OutlineStruct> getDescendants() {
        ArrayList<OutlineStruct> descendants = new ArrayList<OutlineStruct>();
        OutlineStruct currentNode = this.first;
        while (currentNode != null) {
            descendants.add(currentNode);
            if (currentNode.first != null) {
                descendants.addAll(currentNode.getDescendants());
            }
            currentNode = currentNode.next;
        }
        return descendants;
    }

    static interface ReferenceGenerator {
        public String generate();
    }
}

