/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

public class RunLength
extends Filter {
    public RunLength(FilterOptions options) {
        super(options);
    }

    @Override
    public byte[] decode(byte[] data) {
        int count = data.length - 1;
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(data.length);
        for (int i2 = 0; i2 < count; ++i2) {
            int j2;
            byte value;
            int len = data[i2];
            if (len < 0) {
                len = 256 + len;
            }
            if (len == 128) break;
            if (len > 128) {
                len = 257 - len;
                value = data[++i2];
                for (j2 = 0; j2 < len; ++j2) {
                    bos.write((int)value);
                }
                continue;
            }
            ++i2;
            ++len;
            for (j2 = 0; j2 < len; ++j2) {
                value = data[i2 + j2];
                bos.write((int)value);
            }
            i2 = i2 + len - 1;
        }
        return bos.toByteArray();
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) {
        this.bis = bis;
        this.streamCache = streamCache;
        this.cachedObjects = cachedObjects;
        try {
            int count = bis.available();
            for (int i2 = 0; i2 < count; ++i2) {
                int j2;
                int value2;
                int len;
                int nextLen = bis.read();
                if (nextLen >= 128) {
                    nextLen -= 256;
                }
                if ((len = nextLen) < 0) {
                    len = 256 + len;
                }
                if (len == 128) break;
                if (len > 128) {
                    ++i2;
                    len = 257 - len;
                    value2 = bis.read();
                    if (value2 >= 128) {
                        value2 -= 256;
                    }
                    for (j2 = 0; j2 < len; ++j2) {
                        streamCache.write(value2);
                    }
                    continue;
                }
                ++i2;
                ++len;
                for (j2 = 0; j2 < len; ++j2) {
                    value2 = bis.read();
                    if (value2 >= 128) {
                        value2 -= 256;
                    }
                    streamCache.write(value2);
                }
                i2 = i2 + len - 1;
            }
        }
        catch (IOException e1) {
            LogWriter.writeLog("IO exception in RunLength " + e1);
        }
    }

    @Override
    public byte[] encode(byte[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encode(BufferedInputStream bis, BufferedOutputStream bos) throws Exception {
        throw new UnsupportedOperationException();
    }
}

