/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import com.idrsolutions.image.filter.LZWFilterOptions;
import com.idrsolutions.image.utility.ByteWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.jpedal.utils.LogWriter;

public class LZW
extends Filter {
    private int predictor = 1;
    private int earlyChange = 1;
    private int colors = 1;
    private int bitsPerComponent = 8;
    private int rows;
    private int columns;
    private byte[][] codes;
    private byte[] input;
    private byte[] output;
    private BufferedInputStream inputBuff;
    private BufferedOutputStream outputBuff;
    private ByteArrayOutputStream bos;
    private int bitsToGet = 9;
    private int bp;
    private int tp;
    private int op;
    private int putBuffer;
    private int putBits;
    private static final int MIN_BITS = 9;
    private static final int MAX_BITS = 12;
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private final short[] CHILDREN = new short[4096];
    private final short[] SIBLINGS = new short[4096];
    private final short[] SUFFIXES = new short[4096];
    private int bits;
    private int bitPos;
    private int bytePos;
    private int parent;
    private int bitsPerCode;
    private int nextValidCode;
    private int maxCode;

    public LZW(FilterOptions options, int width, int height) {
        super(options);
        LZWFilterOptions ops = (LZWFilterOptions)options;
        this.rows = height;
        this.columns = width;
        if (ops != null) {
            int columnsSet;
            int newColors;
            int newBitsPerComponent = ops.getBitsPerComponent();
            if (newBitsPerComponent != -1) {
                this.bitsPerComponent = newBitsPerComponent;
            }
            if ((newColors = ops.getColors()) != -1) {
                this.colors = newColors;
            }
            if ((columnsSet = ops.getColumns()) != -1) {
                this.columns = columnsSet;
            }
            this.earlyChange = ops.getEarlyChange();
            this.predictor = ops.getPredictor();
            int rowsSet = ops.getRows();
            if (rowsSet != -1) {
                this.rows = rowsSet;
            }
        }
    }

    @Override
    public byte[] decode(byte[] data) throws Exception {
        if (this.rows * this.columns == 1) {
            if (data != null) {
                int bitsPerComponent1 = 8;
                byte[] processed_data = new byte[8 * this.rows * (this.columns + 7 >> 3)];
                this.decompress(processed_data, data, true);
                return this.applyPredictor(this.predictor, processed_data, this.colors, 8, this.columns);
            }
        } else {
            if (data != null) {
                data = this.decompress(data, this.earlyChange == 1);
            }
            data = this.applyPredictor(this.predictor, data, this.colors, this.bitsPerComponent, this.columns);
        }
        return data;
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) throws Exception {
        if (this.rows * this.columns != 1) {
            if (bis != null) {
                this.decompress(streamCache, bis, true);
            }
            if (this.predictor != 1 && this.predictor != 10) {
                streamCache.flush();
                streamCache.close();
                if (cacheName != null) {
                    this.setupCachedObjectForDecoding(cacheName);
                }
            }
            this.applyPredictor(this.predictor, null, this.colors, this.bitsPerComponent, this.columns);
        }
    }

    @Override
    public void encode(BufferedInputStream bis, BufferedOutputStream bos) throws Exception {
        this.initEncode();
        ByteWriter stream = new ByteWriter();
        if (this.parent == -1) {
            this.putCode(stream, 256);
            this.parent = bis.read() & 0xFF;
        }
        block0: while (bis.available() != 0) {
            int value = bis.read() & 0xFF;
            int child = this.CHILDREN[this.parent];
            if (child > 0) {
                if (this.SUFFIXES[child] == value) {
                    this.parent = child;
                    continue;
                }
                int sibling = child;
                while (this.SIBLINGS[sibling] > 0) {
                    if (this.SUFFIXES[sibling = this.SIBLINGS[sibling]] != value) continue;
                    this.parent = sibling;
                    continue block0;
                }
                this.SIBLINGS[sibling] = (short)this.nextValidCode;
                this.SUFFIXES[this.nextValidCode] = (short)value;
                this.putCode(stream, this.parent);
                this.parent = value;
                ++this.nextValidCode;
                this.incrementCodeSize(stream);
                continue;
            }
            this.CHILDREN[this.parent] = (short)this.nextValidCode;
            this.SUFFIXES[this.nextValidCode] = (short)value;
            this.putCode(stream, this.parent);
            this.parent = value;
            ++this.nextValidCode;
            this.incrementCodeSize(stream);
        }
        if (bis.available() == 0) {
            this.putCode(stream, this.parent);
            this.putCode(stream, 257);
            if (this.bitPos > 0) {
                this.putCode(stream, 0);
            }
        }
        bos.write(stream.toArray());
    }

    private void initEncode() {
        this.bits = 0;
        this.bitPos = 0;
        this.bytePos = 0;
        this.parent = -1;
        this.bitsPerCode = 9;
        this.nextValidCode = 258;
        this.maxCode = LZW.maxValue(this.bitsPerCode);
    }

    @Override
    public byte[] encode(byte[] buffer) {
        this.initEncode();
        int remaining = buffer.length;
        ByteWriter stream = new ByteWriter();
        if (this.parent == -1) {
            this.putCode(stream, 256);
            this.parent = buffer[this.bytePos++] & 0xFF;
        }
        block0: while (this.bytePos < buffer.length) {
            int value = buffer[this.bytePos++] & 0xFF;
            int child = this.CHILDREN[this.parent];
            if (child > 0) {
                if (this.SUFFIXES[child] == value) {
                    this.parent = child;
                    continue;
                }
                int sibling = child;
                while (this.SIBLINGS[sibling] > 0) {
                    if (this.SUFFIXES[sibling = this.SIBLINGS[sibling]] != value) continue;
                    this.parent = sibling;
                    continue block0;
                }
                this.SIBLINGS[sibling] = (short)this.nextValidCode;
                this.SUFFIXES[this.nextValidCode] = (short)value;
                this.putCode(stream, this.parent);
                this.parent = value;
                ++this.nextValidCode;
                this.incrementCodeSize(stream);
                continue;
            }
            this.CHILDREN[this.parent] = (short)this.nextValidCode;
            this.SUFFIXES[this.nextValidCode] = (short)value;
            this.putCode(stream, this.parent);
            this.parent = value;
            ++this.nextValidCode;
            this.incrementCodeSize(stream);
        }
        if ((remaining -= buffer.length) <= 0) {
            this.putCode(stream, this.parent);
            this.putCode(stream, 257);
            if (this.bitPos > 0) {
                this.putCode(stream, 0);
            }
        }
        return stream.toArray();
    }

    private void incrementCodeSize(ByteWriter stream) {
        if (this.nextValidCode > this.maxCode) {
            if (this.bitsPerCode == 12) {
                this.putCode(stream, 256);
                this.reset();
            } else {
                ++this.bitsPerCode;
                this.maxCode = LZW.maxValue(this.bitsPerCode);
            }
        }
    }

    private void reset() {
        Arrays.fill(this.CHILDREN, (short)0);
        Arrays.fill(this.SIBLINGS, (short)0);
        this.bitsPerCode = 9;
        this.maxCode = LZW.maxValue(this.bitsPerCode);
        this.nextValidCode = 258;
    }

    private void putCode(ByteWriter stream, int code) {
        this.bits = this.bits << this.bitsPerCode | code & this.maxCode;
        this.bitPos += this.bitsPerCode;
        while (this.bitPos >= 8) {
            stream.putU8(this.bits >> this.bitPos - 8 & 0xFF);
            this.bitPos -= 8;
        }
        this.bits &= LZW.maxValue(this.bitPos);
    }

    private static int maxValue(int codeLen) {
        return (1 << codeLen) - 1;
    }

    public byte[] decompress(byte[] input, boolean earlyChange) throws IOException {
        this.init();
        this.input = input;
        this.bos = new ByteArrayOutputStream();
        this.earlyChange = earlyChange ? 1 : 0;
        this.decompress();
        this.bos.close();
        return this.bos.toByteArray();
    }

    public void decompress(byte[] output, byte[] input, boolean earlyChange) {
        this.init();
        this.input = input;
        this.output = output;
        this.earlyChange = earlyChange ? 1 : 0;
        try {
            this.decompress();
        }
        catch (IOException e2) {
            LogWriter.writeLog("Exception: " + e2);
        }
    }

    public void decompress(BufferedOutputStream output, BufferedInputStream input, boolean earlyChange) throws IOException {
        this.init();
        this.inputBuff = input;
        this.outputBuff = output;
        this.earlyChange = earlyChange ? 1 : 0;
        this.decompress();
    }

    private void decompress() throws IOException {
        int code;
        int len;
        this.bp = 0;
        this.op = 0;
        this.putBuffer = 0;
        this.putBits = 0;
        int oldCode = 0;
        int n2 = len = this.output != null ? this.output.length : 0;
        while ((code = this.findNext()) != 257 && (len == 0 || this.op < len)) {
            byte[] chars;
            if (code == 256) {
                this.init();
                code = this.findNext();
                if (code == 257) break;
                this.addCodes(this.codes[code]);
            } else if (code < this.tp) {
                chars = this.codes[code];
                this.addCodes(chars);
                this.addCodeToCodes(this.codes[oldCode], chars[0]);
            } else {
                chars = this.codes[oldCode];
                chars = LZW.generateCodeArray(chars, chars[0]);
                this.addCodes(chars);
                this.addCodeArrToCodes(chars);
            }
            oldCode = code;
        }
    }

    private void init() {
        this.codes = new byte[4096][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.codes[i2] = new byte[1];
            this.codes[i2][0] = (byte)i2;
        }
        this.tp = 258;
        this.bitsToGet = 9;
    }

    private void addCodes(byte[] codes) {
        try {
            if (this.bos != null) {
                this.bos.write(codes);
            } else if (this.outputBuff != null) {
                this.outputBuff.write(codes);
            } else {
                for (byte code : codes) {
                    this.output[this.op++] = code;
                }
            }
        }
        catch (IOException ex) {
            LogWriter.writeLog(ex.getMessage());
        }
    }

    private void addCodeToCodes(byte[] oldCodes, byte code) {
        int length = oldCodes.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldCodes, 0, string, 0, length);
        string[length] = code;
        this.addCodeArrToCodes(string);
    }

    private void addCodeArrToCodes(byte[] codeArr) {
        if (this.earlyChange == 1) {
            this.codes[this.tp++] = codeArr;
        }
        switch (this.tp) {
            case 511: {
                this.bitsToGet = 10;
                break;
            }
            case 1023: {
                this.bitsToGet = 11;
                break;
            }
            case 2047: {
                this.bitsToGet = 12;
                break;
            }
        }
        if (this.earlyChange != 1) {
            this.codes[this.tp++] = codeArr;
        }
    }

    private static byte[] generateCodeArray(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldString, 0, string, 0, length);
        string[length] = newString;
        return string;
    }

    private int findNext() throws IOException {
        int[] combinator = new int[]{511, 1023, 2047, 4095};
        try {
            if (this.inputBuff == null) {
                this.putBuffer = this.putBuffer << 8 | this.input[this.bp++] & 0xFF;
                this.putBits += 8;
                if (this.putBits < this.bitsToGet) {
                    this.putBuffer = this.putBuffer << 8 | this.input[this.bp++] & 0xFF;
                    this.putBits += 8;
                }
            } else {
                this.putBuffer = this.putBuffer << 8 | this.inputBuff.read();
                this.putBits += 8;
                if (this.putBits < this.bitsToGet) {
                    this.putBuffer = this.putBuffer << 8 | this.inputBuff.read();
                    this.putBits += 8;
                }
            }
            int code = this.putBuffer >> this.putBits - this.bitsToGet & combinator[this.bitsToGet - 9];
            this.putBits -= this.bitsToGet;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            LogWriter.writeLog("Exception in findNext " + e2);
            return 257;
        }
    }
}

