/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import com.idrsolutions.image.jpeg2000.data.Info;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.util.Map;

public class JPX
extends Filter {
    int rawColorSpace = -1;

    public JPX(FilterOptions options) {
        super(options);
    }

    @Override
    public byte[] decode(byte[] data) throws Exception {
        Jpeg2000Decoder jpxDecoder = new Jpeg2000Decoder();
        data = jpxDecoder.readComponentsAsUnConvertedBytes(data);
        Info info = jpxDecoder.getInfo();
        this.rawColorSpace = JPX.convertJPXValueToColorSpace(info.enumerateCS);
        return data;
    }

    private static int convertJPXValueToColorSpace(int colorspace) {
        int value = -1;
        switch (colorspace) {
            case 17: {
                value = 1785221209;
                break;
            }
            case 16: {
                value = 1568372915;
                break;
            }
            case 12: {
                value = 1498837125;
                break;
            }
            case 18: {
                value = 319951691;
            }
        }
        return value;
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) throws Exception {
        int size = bis.available();
        byte[] data = new byte[size];
        bis.read(data);
        data = this.decode(data);
        streamCache.write(data);
    }

    @Override
    public byte[] encode(byte[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encode(BufferedInputStream bis, BufferedOutputStream bos) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int getRawColorSpace() {
        return this.rawColorSpace;
    }
}

