/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import com.idrsolutions.image.filter.FlateFilterOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

public class Flate
extends Filter {
    private int predictor = 1;
    private int colors = 1;
    private int bitsPerComponent = 8;
    private int columns = 1;
    private boolean hasError;

    public Flate(FilterOptions options) {
        super(options);
        int columnsSet;
        int newColors;
        FlateFilterOptions ops = (FlateFilterOptions)options;
        int newBitsPerComponent = ops.getBitsPerComponent();
        if (newBitsPerComponent != -1) {
            this.bitsPerComponent = newBitsPerComponent;
        }
        if ((newColors = ops.getColors()) != -1) {
            this.colors = newColors;
        }
        if ((columnsSet = ops.getColumns()) != -1) {
            this.columns = columnsSet;
        }
        this.predictor = ops.getPredictor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decode(byte[] data) throws Exception {
        if (data[0] == 0 && data[1] == 0 && data[2] == 0) {
            return data;
        }
        int bufSize = 512000;
        FastByteArrayOutputStream bos = null;
        boolean failed = true;
        int orgSize = data.length;
        while (failed) {
            Inflater inf = new Inflater();
            inf.setInput(data);
            int size = data.length;
            bos = new FastByteArrayOutputStream(size);
            if (size < bufSize) {
                bufSize = size;
            }
            byte[] buf = new byte[bufSize];
            try {
                while (!inf.finished()) {
                    int count = inf.inflate(buf);
                    if (count == 0 && inf.needsDictionary()) {
                        LogWriter.writeLog("Error in flate stream, unable to inflate");
                        this.hasError = true;
                        byte[] byArray = null;
                        return byArray;
                    }
                    bos.write(buf, 0, count);
                    if (inf.getRemaining() != 0) continue;
                }
                failed = false;
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception in Flate " + ee);
                failed = true;
                this.hasError = true;
                if (data.length == orgSize && data.length > 10000) {
                    bos = new FastByteArrayOutputStream(size);
                    byte[] fdata = Flate.inflateFailedStream(data);
                    if (fdata != null) {
                        bos.write(fdata);
                        break;
                    }
                    failed = false;
                    continue;
                }
                if (data.length > 10) {
                    byte[] newData = new byte[data.length - 1];
                    System.arraycopy(data, 0, newData, 0, data.length - 1);
                    data = newData;
                    continue;
                }
                failed = false;
            }
            finally {
                inf.end();
            }
        }
        data = bos.toByteArray();
        return this.applyPredictor(this.predictor, data, this.colors, this.bitsPerComponent, this.columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] inflateFailedStream(byte[] data) {
        Inflater inf = null;
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(data.length);
        try {
            byte[] buf = new byte[8];
            inf = new Inflater();
            inf.setInput(data);
            while (!inf.finished()) {
                int count = inf.inflate(buf);
                if (count == 0 && inf.needsDictionary()) {
                    byte[] byArray = null;
                    return byArray;
                }
                bos.write(buf, 0, count);
                if (inf.getRemaining() != 0) continue;
                break;
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception in Flate " + ee);
        }
        finally {
            if (inf != null) {
                inf.end();
            }
        }
        return bos.toByteArray();
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) throws Exception {
        this.bis = bis;
        this.streamCache = streamCache;
        this.cachedObjects = cachedObjects;
        if (bis != null) {
            try (InflaterInputStream inf = new InflaterInputStream(bis);){
                int b2;
                while ((b2 = ((InputStream)inf).read()) != -1) {
                    streamCache.write(b2);
                }
                if (this.predictor != 1 && this.predictor != 10) {
                    streamCache.flush();
                    streamCache.close();
                    if (cacheName != null) {
                        this.setupCachedObjectForDecoding(cacheName);
                    }
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception " + e2 + " accessing Flate filter ");
            }
        }
        this.applyPredictor(this.predictor, null, this.colors, this.bitsPerComponent, this.columns);
    }

    @Override
    public byte[] encode(byte[] data) {
        return this.encode(data, 8);
    }

    public byte[] encode(byte[] data, int compressionLevel) {
        byte[] byArray;
        Deflater deflater = new Deflater(compressionLevel);
        deflater.setInput(data);
        int min = Math.min(data.length / 2, 4096);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(min);
        try {
            deflater.finish();
            byte[] buffer = new byte[min];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            deflater.end();
            outputStream.close();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        outputStream.close();
        return byArray;
    }

    @Override
    public void encode(BufferedInputStream bis, BufferedOutputStream bos) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }
}

