/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import com.idrsolutions.image.filter.DCTFilterOptions;
import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg.data.Component;
import com.idrsolutions.image.jpeg.data.Info;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.util.Map;

public class DCT
extends Filter {
    public static final TRANSFORM vp8_short_fdct8x4 = (input, output, pitch) -> {
        DCT.fdct4x4(input, output, pitch);
        input.incBy(4);
        output.incBy(16);
        DCT.fdct4x4(input, output, pitch);
        input.incBy(-4);
        output.incBy(-16);
    };
    public static final TRANSFORM vp8_short_fdct4x4 = DCT::fdct4x4;
    public static final TRANSFORM vp8_short_walsh4x4 = DCT::walsh4x4;
    private static final double[][] a = new double[8][8];
    private static final double[][] b = new double[8][8];
    private final DCTFilterOptions ops;

    public DCT(FilterOptions options) {
        this.ops = (DCTFilterOptions)options;
    }

    public static void IDCTQ12(Component component, int offset) {
        int k2;
        int j2;
        int i2;
        short[] pixels = component.codeBlock;
        int[] qt = component.qTable;
        int p2 = 0;
        double[][] input = new double[8][8];
        for (int i3 = 0; i3 < 8; ++i3) {
            for (int j3 = 0; j3 < 8; ++j3) {
                input[i3][j3] = pixels[offset + p2] * qt[p2];
                ++p2;
            }
        }
        double[][] temp = new double[8][8];
        for (i2 = 0; i2 < 8; ++i2) {
            for (j2 = 0; j2 < 8; ++j2) {
                temp[i2][j2] = 0.0;
                for (k2 = 0; k2 < 8; ++k2) {
                    double[] dArray = temp[i2];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] + input[i2][k2] * a[k2][j2];
                }
            }
        }
        p2 = 0;
        for (i2 = 0; i2 < 8; ++i2) {
            for (j2 = 0; j2 < 8; ++j2) {
                double temp1 = 0.0;
                for (k2 = 0; k2 < 8; ++k2) {
                    temp1 += b[i2][k2] * temp[k2][j2];
                }
                if ((temp1 += 2048.0) < 0.0) {
                    pixels[offset + p2] = 0;
                } else if (temp1 > 4095.0) {
                    pixels[offset + p2] = 255;
                } else {
                    int v2 = (int)Math.round(temp1);
                    pixels[offset + p2] = (short)(v2 >> 4);
                }
                ++p2;
            }
        }
    }

    public static void IDCTQ(Component component, int offset, int[] p2) {
        int[] qt = component.qTable;
        short[] inp = component.codeBlock;
        DCT.processRows(offset, p2, qt, inp);
        DCT.processCols(offset, p2, inp);
    }

    private static void processRows(int offset, int[] p2, int[] qt, short[] inp) {
        for (int row = 0; row < 64; row += 8) {
            int t2;
            int temp = offset + row;
            int p0 = inp[temp];
            int p1 = inp[temp + 1];
            int p22 = inp[temp + 2];
            int p3 = inp[temp + 3];
            int p4 = inp[temp + 4];
            int p5 = inp[temp + 5];
            int p6 = inp[temp + 6];
            int p7 = inp[temp + 7];
            p0 *= qt[row];
            if ((p1 | p22 | p3 | p4 | p5 | p6 | p7) == 0) {
                p2[row] = t2 = 5793 * p0 + 512 >> 10;
                p2[row + 1] = t2;
                p2[row + 2] = t2;
                p2[row + 3] = t2;
                p2[row + 4] = t2;
                p2[row + 5] = t2;
                p2[row + 6] = t2;
                p2[row + 7] = t2;
                continue;
            }
            p1 *= qt[row + 1];
            p22 *= qt[row + 2];
            p3 *= qt[row + 3];
            p5 *= qt[row + 5];
            p6 *= qt[row + 6];
            int v0 = 5793 * p0 + 128 >> 8;
            int v1 = 5793 * (p4 *= qt[row + 4]) + 128 >> 8;
            int v4 = 2896 * (p1 - (p7 *= qt[row + 7])) + 128 >> 8;
            int v7 = 2896 * (p1 + p7) + 128 >> 8;
            int v5 = p3 << 4;
            int v6 = p5 << 4;
            v0 = v0 + v1 + 1 >> 1;
            v1 = v0 - v1;
            t2 = p22 * 3784 + p6 * 1567 + 128 >> 8;
            int v2 = p22 * 1567 - p6 * 3784 + 128 >> 8;
            v4 = v4 + v6 + 1 >> 1;
            v6 = v4 - v6;
            v7 = v7 + v5 + 1 >> 1;
            v5 = v7 - v5;
            v0 = v0 + t2 + 1 >> 1;
            int v3 = v0 - t2;
            v1 = v1 + v2 + 1 >> 1;
            v2 = v1 - v2;
            t2 = v4 * 2276 + v7 * 3406 + 2048 >> 12;
            v4 = v4 * 3406 - v7 * 2276 + 2048 >> 12;
            v7 = t2;
            t2 = v5 * 799 + v6 * 4017 + 2048 >> 12;
            v5 = v5 * 4017 - v6 * 799 + 2048 >> 12;
            p2[row] = v0 + v7;
            p2[row + 7] = v0 - v7;
            p2[row + 1] = v1 + t2;
            p2[row + 6] = v1 - t2;
            p2[row + 2] = v2 + v5;
            p2[row + 5] = v2 - v5;
            p2[row + 3] = v3 + v4;
            p2[row + 4] = v3 - v4;
        }
    }

    private static void processCols(int offset, int[] p2, short[] inp) {
        for (int col = 0; col < 8; ++col) {
            int tt;
            int p0 = p2[col];
            int p1 = p2[col + 8];
            int p22 = p2[col + 16];
            int p3 = p2[col + 24];
            int p4 = p2[col + 32];
            int p5 = p2[col + 40];
            int p6 = p2[col + 48];
            int p7 = p2[col + 56];
            int temp = offset + col;
            if ((p1 | p22 | p3 | p4 | p5 | p6 | p7) == 0) {
                int t2;
                tt = 5793 * p0 + 8192 >> 14;
                inp[temp] = t2 = (short)(tt < -2040 ? 0 : (short)(tt >= 2024 ? 255 : (short)(tt + 2056 >> 4)));
                inp[temp + 8] = t2;
                inp[temp + 16] = t2;
                inp[temp + 24] = t2;
                inp[temp + 32] = t2;
                inp[temp + 40] = t2;
                inp[temp + 48] = t2;
                inp[temp + 56] = t2;
                continue;
            }
            int v0 = 5793 * p0 + 2048 >> 12;
            int v1 = 5793 * p4 + 2048 >> 12;
            int v4 = 2896 * (p1 - p7) + 2048 >> 12;
            int v7 = 2896 * (p1 + p7) + 2048 >> 12;
            v0 = (v0 + v1 + 1 >> 1) + 4112;
            v1 = v0 - v1;
            int v3 = p22 * 3784 + p6 * 1567 + 2048 >> 12;
            int v2 = p22 * 1567 - p6 * 3784 + 2048 >> 12;
            v4 = v4 + p5 + 1 >> 1;
            int v6 = v4 - p5;
            v7 = v7 + p3 + 1 >> 1;
            int v5 = v7 - p3;
            v0 = v0 + v3 + 1 >> 1;
            v3 = v0 - v3;
            v1 = v1 + v2 + 1 >> 1;
            v2 = v1 - v2;
            tt = v4 * 2276 + v7 * 3406 + 2048 >> 12;
            v4 = v4 * 3406 - v7 * 2276 + 2048 >> 12;
            v7 = tt;
            tt = v5 * 799 + v6 * 4017 + 2048 >> 12;
            v5 = v5 * 4017 - v6 * 799 + 2048 >> 12;
            p0 = v0 + v7;
            p7 = v0 - v7;
            p1 = v1 + tt;
            p6 = v1 - tt;
            p22 = v2 + v5;
            p5 = v2 - v5;
            p3 = v3 + v4;
            p4 = v3 - v4;
            short s2 = (short)(p0 < 16 ? 0 : (short)(inp[temp] = (short)(p0 >= 4080 ? 255 : (short)(p0 >> 4))));
            short s3 = (short)(p1 < 16 ? 0 : (short)(inp[temp + 8] = (short)(p1 >= 4080 ? 255 : (short)(p1 >> 4))));
            short s4 = (short)(p22 < 16 ? 0 : (short)(inp[temp + 16] = (short)(p22 >= 4080 ? 255 : (short)(p22 >> 4))));
            short s5 = (short)(p3 < 16 ? 0 : (short)(inp[temp + 24] = (short)(p3 >= 4080 ? 255 : (short)(p3 >> 4))));
            short s6 = (short)(p4 < 16 ? 0 : (short)(inp[temp + 32] = (short)(p4 >= 4080 ? 255 : (short)(p4 >> 4))));
            short s7 = (short)(p5 < 16 ? 0 : (short)(inp[temp + 40] = (short)(p5 >= 4080 ? 255 : (short)(p5 >> 4))));
            short s8 = (short)(p6 < 16 ? 0 : (short)(inp[temp + 48] = (short)(p6 >= 4080 ? 255 : (short)(p6 >> 4))));
            inp[temp + 56] = (short)(p7 < 16 ? 0 : (short)(p7 >= 4080 ? 255 : (short)(p7 >> 4)));
        }
    }

    public static void IDCTQInts(Component component, int[] p2) {
        int[] qt = component.qTable;
        int[] inp = component.codeInts;
        DCT.processRowsInts(p2, qt, inp);
        DCT.processColsInts(p2, inp);
    }

    private static void processRowsInts(int[] p2, int[] qt, int[] inp) {
        for (int row = 0; row < 64; row += 8) {
            int t2;
            int temp = row;
            int p0 = inp[temp];
            int p1 = inp[temp + 1];
            int p22 = inp[temp + 2];
            int p3 = inp[temp + 3];
            int p4 = inp[temp + 4];
            int p5 = inp[temp + 5];
            int p6 = inp[temp + 6];
            int p7 = inp[temp + 7];
            p0 *= qt[row];
            if ((p1 | p22 | p3 | p4 | p5 | p6 | p7) == 0) {
                p2[row] = t2 = 5793 * p0 + 512 >> 10;
                p2[row + 1] = t2;
                p2[row + 2] = t2;
                p2[row + 3] = t2;
                p2[row + 4] = t2;
                p2[row + 5] = t2;
                p2[row + 6] = t2;
                p2[row + 7] = t2;
                continue;
            }
            p1 *= qt[row + 1];
            p22 *= qt[row + 2];
            p3 *= qt[row + 3];
            p5 *= qt[row + 5];
            p6 *= qt[row + 6];
            int v0 = 5793 * p0 + 128 >> 8;
            int v1 = 5793 * (p4 *= qt[row + 4]) + 128 >> 8;
            int v4 = 2896 * (p1 - (p7 *= qt[row + 7])) + 128 >> 8;
            int v7 = 2896 * (p1 + p7) + 128 >> 8;
            int v5 = p3 << 4;
            int v6 = p5 << 4;
            v0 = v0 + v1 + 1 >> 1;
            v1 = v0 - v1;
            t2 = p22 * 3784 + p6 * 1567 + 128 >> 8;
            int v2 = p22 * 1567 - p6 * 3784 + 128 >> 8;
            v4 = v4 + v6 + 1 >> 1;
            v6 = v4 - v6;
            v7 = v7 + v5 + 1 >> 1;
            v5 = v7 - v5;
            v0 = v0 + t2 + 1 >> 1;
            int v3 = v0 - t2;
            v1 = v1 + v2 + 1 >> 1;
            v2 = v1 - v2;
            t2 = v4 * 2276 + v7 * 3406 + 2048 >> 12;
            v4 = v4 * 3406 - v7 * 2276 + 2048 >> 12;
            v7 = t2;
            t2 = v5 * 799 + v6 * 4017 + 2048 >> 12;
            v5 = v5 * 4017 - v6 * 799 + 2048 >> 12;
            p2[row] = v0 + v7;
            p2[row + 7] = v0 - v7;
            p2[row + 1] = v1 + t2;
            p2[row + 6] = v1 - t2;
            p2[row + 2] = v2 + v5;
            p2[row + 5] = v2 - v5;
            p2[row + 3] = v3 + v4;
            p2[row + 4] = v3 - v4;
        }
    }

    private static void processColsInts(int[] p2, int[] inp) {
        for (int col = 0; col < 8; ++col) {
            int tt;
            int p0 = p2[col];
            int p1 = p2[col + 8];
            int p22 = p2[col + 16];
            int p3 = p2[col + 24];
            int p4 = p2[col + 32];
            int p5 = p2[col + 40];
            int p6 = p2[col + 48];
            int p7 = p2[col + 56];
            int temp = col;
            if ((p1 | p22 | p3 | p4 | p5 | p6 | p7) == 0) {
                int t2;
                tt = 5793 * p0 + 8192 >> 14;
                inp[temp] = t2 = (byte)(tt < -2040 ? 0 : (byte)(tt >= 2024 ? -1 : (byte)(tt + 2056 >> 4)));
                inp[temp + 8] = t2;
                inp[temp + 16] = t2;
                inp[temp + 24] = t2;
                inp[temp + 32] = t2;
                inp[temp + 40] = t2;
                inp[temp + 48] = t2;
                inp[temp + 56] = t2;
                continue;
            }
            int v0 = 5793 * p0 + 2048 >> 12;
            int v1 = 5793 * p4 + 2048 >> 12;
            int v4 = 2896 * (p1 - p7) + 2048 >> 12;
            int v7 = 2896 * (p1 + p7) + 2048 >> 12;
            v0 = (v0 + v1 + 1 >> 1) + 4112;
            v1 = v0 - v1;
            int v3 = p22 * 3784 + p6 * 1567 + 2048 >> 12;
            int v2 = p22 * 1567 - p6 * 3784 + 2048 >> 12;
            v4 = v4 + p5 + 1 >> 1;
            int v6 = v4 - p5;
            v7 = v7 + p3 + 1 >> 1;
            int v5 = v7 - p3;
            v0 = v0 + v3 + 1 >> 1;
            v3 = v0 - v3;
            v1 = v1 + v2 + 1 >> 1;
            v2 = v1 - v2;
            tt = v4 * 2276 + v7 * 3406 + 2048 >> 12;
            v4 = v4 * 3406 - v7 * 2276 + 2048 >> 12;
            v7 = tt;
            tt = v5 * 799 + v6 * 4017 + 2048 >> 12;
            v5 = v5 * 4017 - v6 * 799 + 2048 >> 12;
            p0 = v0 + v7;
            p7 = v0 - v7;
            p1 = v1 + tt;
            p6 = v1 - tt;
            p22 = v2 + v5;
            p5 = v2 - v5;
            p3 = v3 + v4;
            p4 = v3 - v4;
            int n2 = p0 < 16 ? 0 : (inp[temp] = p0 >= 4080 ? -1 : p0 >> 4);
            int n3 = p1 < 16 ? 0 : (inp[temp + 8] = p1 >= 4080 ? -1 : p1 >> 4);
            int n4 = p22 < 16 ? 0 : (inp[temp + 16] = p22 >= 4080 ? -1 : p22 >> 4);
            int n5 = p3 < 16 ? 0 : (inp[temp + 24] = p3 >= 4080 ? -1 : p3 >> 4);
            int n6 = p4 < 16 ? 0 : (inp[temp + 32] = p4 >= 4080 ? -1 : p4 >> 4);
            int n7 = p5 < 16 ? 0 : (inp[temp + 40] = p5 >= 4080 ? -1 : p5 >> 4);
            int n8 = p6 < 16 ? 0 : (inp[temp + 48] = p6 >= 4080 ? -1 : p6 >> 4);
            inp[temp + 56] = p7 < 16 ? 0 : (p7 >= 4080 ? -1 : p7 >> 4);
        }
    }

    static void fdct4x4(GetSetPointer input, FullGetSetPointer output, int pitch) {
        int d1;
        int c1;
        int b1;
        int a12;
        short in0;
        int i2;
        pitch >>= 1;
        input.savePos();
        output.savePos();
        for (i2 = 0; i2 < 4; ++i2) {
            in0 = input.get();
            short in1 = input.getRel(1);
            short in2 = input.getRel(2);
            short in3 = input.getRel(3);
            a12 = in0 + in3 << 3;
            b1 = in1 + in2 << 3;
            c1 = in1 - in2 << 3;
            d1 = in0 - in3 << 3;
            output.set((short)(a12 + b1));
            output.setRel(2, (short)(a12 - b1));
            output.setRel(1, (short)(c1 * 2217 + d1 * 5352 + 14500 >> 12));
            output.setRel(3, (short)(d1 * 2217 - c1 * 5352 + 7500 >> 12));
            input.incBy(pitch);
            output.incBy(4);
        }
        input.rewindToSaved();
        output.rewindToSaved();
        for (i2 = 0; i2 < 4; ++i2) {
            in0 = output.get();
            short in4 = output.getRel(4);
            short in8 = output.getRel(8);
            short in12 = output.getRel(12);
            a12 = in0 + in12;
            b1 = in4 + in8;
            c1 = in4 - in8;
            d1 = in0 - in12;
            output.set((short)(a12 + b1 + 7 >> 4));
            output.setRel(8, (short)(a12 - b1 + 7 >> 4));
            output.setRel(4, (short)((c1 * 2217 + d1 * 5352 + 12000 >> 16) + (d1 != 0 ? 1 : 0)));
            output.setRel(12, (short)(d1 * 2217 - c1 * 5352 + 51000 >> 16));
            output.inc();
        }
        output.rewindToSaved();
    }

    static void walsh4x4(GetSetPointer input, FullGetSetPointer output, int pitch) {
        int b1;
        int c1;
        int d1;
        int a12;
        short in0;
        int i2;
        pitch >>= 1;
        input.savePos();
        output.savePos();
        for (i2 = 0; i2 < 4; ++i2) {
            in0 = input.get();
            short in1 = input.getRel(1);
            short in2 = input.getRel(2);
            short in3 = input.getRel(3);
            a12 = in0 + in2 << 2;
            d1 = in1 + in3 << 2;
            c1 = in1 - in3 << 2;
            b1 = in0 - in2 << 2;
            output.setAndInc((short)(a12 + d1 + (a12 != 0 ? 1 : 0)));
            output.setAndInc((short)(b1 + c1));
            output.setAndInc((short)(b1 - c1));
            output.setAndInc((short)(a12 - d1));
            input.incBy(pitch);
        }
        input.rewindToSaved();
        output.rewindToSaved();
        for (i2 = 0; i2 < 4; ++i2) {
            in0 = output.get();
            short in4 = output.getRel(4);
            short in8 = output.getRel(8);
            short in12 = output.getRel(12);
            a12 = in0 + in8;
            d1 = in4 + in12;
            c1 = in4 - in12;
            b1 = in0 - in8;
            int a22 = a12 + d1;
            int b2 = b1 + c1;
            int c2 = b1 - c1;
            int d2 = a12 - d1;
            if (a22 < 0) {
                ++a22;
            }
            if (b2 < 0) {
                ++b2;
            }
            if (c2 < 0) {
                ++c2;
            }
            if (d2 < 0) {
                ++d2;
            }
            output.set((short)(a22 + 3 >> 3));
            output.setRel(4, (short)(b2 + 3 >> 3));
            output.setRel(8, (short)(c2 + 3 >> 3));
            output.setRel(12, (short)(d2 + 3 >> 3));
            output.inc();
        }
        output.rewindToSaved();
    }

    @Override
    public byte[] decode(byte[] data) throws Exception {
        int adobeColorTransform = this.ops.getColorTransform();
        JpegDecoder decoder = new JpegDecoder();
        Info info = new Info();
        return decoder.readAsUnconvertedBytes(data, adobeColorTransform, info);
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) throws Exception {
        int size = bis.available();
        byte[] data = new byte[size];
        bis.read(data);
        data = this.decode(data);
        streamCache.write(data);
    }

    @Override
    public byte[] encode(byte[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encode(BufferedInputStream bis, BufferedOutputStream bos) throws Exception {
        throw new UnsupportedOperationException();
    }

    static {
        for (int j2 = 0; j2 < 8; ++j2) {
            DCT.a[0][j2] = 1.0 / Math.sqrt(8.0);
            DCT.b[j2][0] = a[0][j2];
        }
        for (int i2 = 1; i2 < 8; ++i2) {
            for (int j3 = 0; j3 < 8; ++j3) {
                DCT.a[i2][j3] = Math.sqrt(0.25) * Math.cos(2.0 * (double)j3 * (double)i2 * Math.PI / 16.0);
                DCT.b[j3][i2] = a[i2][j3];
            }
        }
    }

    public static interface TRANSFORM {
        public void call(GetSetPointer var1, FullGetSetPointer var2, int var3);
    }
}

