/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import com.idrsolutions.image.filter.CCITTFilterOptions;
import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.util.BitSet;
import java.util.Map;
import org.jpedal.utils.LogWriter;

public class CCITT
extends Filter {
    private static final int EOL = -1;
    protected static final int[][][] b = new int[][][]{new int[][]{{3, 2, 0}, {2, 3, 0}}, new int[][]{{2, 1, 0}, {3, 4, 0}}, new int[][]{{3, 5, 0}, {2, 6, 0}}, new int[][]{{3, 7, 0}}, new int[][]{{5, 8, 0}, {4, 9, 0}}, new int[][]{{4, 10, 0}, {5, 11, 0}, {7, 12, 0}}, new int[][]{{4, 13, 0}, {7, 14, 0}}, new int[][]{{24, 15, 0}}, new int[][]{{55, 0, 0}, {23, 16, 0}, {24, 17, 0}, {8, 18, 0}, {15, 64, 1}}, new int[][]{{103, 19, 0}, {104, 20, 0}, {108, 21, 0}, {55, 22, 0}, {40, 23, 0}, {23, 24, 0}, {24, 25, 0}, {8, 1792, 1}, {12, 1856, 1}, {13, 1920, 1}}, new int[][]{{202, 26, 0}, {203, 27, 0}, {204, 28, 0}, {205, 29, 0}, {104, 30, 0}, {105, 31, 0}, {106, 32, 0}, {107, 33, 0}, {210, 34, 0}, {211, 35, 0}, {212, 36, 0}, {213, 37, 0}, {214, 38, 0}, {215, 39, 0}, {108, 40, 0}, {109, 41, 0}, {218, 42, 0}, {219, 43, 0}, {84, 44, 0}, {85, 45, 0}, {86, 46, 0}, {87, 47, 0}, {100, 48, 0}, {101, 49, 0}, {82, 50, 0}, {83, 51, 0}, {36, 52, 0}, {55, 53, 0}, {56, 54, 0}, {39, 55, 0}, {40, 56, 0}, {88, 57, 0}, {89, 58, 0}, {43, 59, 0}, {44, 60, 0}, {90, 61, 0}, {102, 62, 0}, {103, 63, 0}, {200, 128, 1}, {201, 192, 1}, {91, 256, 1}, {51, 320, 1}, {52, 384, 1}, {53, 448, 1}, {1, -1, 1}, {18, 1984, 1}, {19, 2048, 1}, {20, 2112, 1}, {21, 2176, 1}, {22, 2240, 1}, {23, 2304, 1}, {28, 2368, 1}, {29, 2432, 1}, {30, 2496, 1}, {31, 2560, 1}}, new int[][]{{108, 512, 1}, {109, 576, 1}, {74, 640, 1}, {75, 704, 1}, {76, 768, 1}, {77, 832, 1}, {114, 896, 1}, {115, 960, 1}, {116, 1024, 1}, {117, 1088, 1}, {118, 1152, 1}, {119, 1216, 1}, {82, 1280, 1}, {83, 1344, 1}, {84, 1408, 1}, {85, 1472, 1}, {90, 1536, 1}, {91, 1600, 1}, {100, 1664, 1}, {101, 1728, 1}}};
    protected static final int[][][] w = new int[][][]{new int[][]{{7, 2, 0}, {8, 3, 0}, {11, 4, 0}, {12, 5, 0}, {14, 6, 0}, {15, 7, 0}}, new int[][]{{19, 8, 0}, {20, 9, 0}, {7, 10, 0}, {8, 11, 0}, {27, 64, 1}, {18, 128, 1}}, new int[][]{{7, 1, 0}, {8, 12, 0}, {3, 13, 0}, {52, 14, 0}, {53, 15, 0}, {42, 16, 0}, {43, 17, 0}, {23, 192, 1}, {24, 1664, 1}}, new int[][]{{39, 18, 0}, {12, 19, 0}, {8, 20, 0}, {23, 21, 0}, {3, 22, 0}, {4, 23, 0}, {40, 24, 0}, {43, 25, 0}, {19, 26, 0}, {36, 27, 0}, {24, 28, 0}, {55, 256, 1}}, new int[][]{{53, 0, 0}, {2, 29, 0}, {3, 30, 0}, {26, 31, 0}, {27, 32, 0}, {18, 33, 0}, {19, 34, 0}, {20, 35, 0}, {21, 36, 0}, {22, 37, 0}, {23, 38, 0}, {40, 39, 0}, {41, 40, 0}, {42, 41, 0}, {43, 42, 0}, {44, 43, 0}, {45, 44, 0}, {4, 45, 0}, {5, 46, 0}, {10, 47, 0}, {11, 48, 0}, {82, 49, 0}, {83, 50, 0}, {84, 51, 0}, {85, 52, 0}, {36, 53, 0}, {37, 54, 0}, {88, 55, 0}, {89, 56, 0}, {90, 57, 0}, {91, 58, 0}, {74, 59, 0}, {75, 60, 0}, {50, 61, 0}, {51, 62, 0}, {52, 63, 0}, {54, 320, 1}, {55, 384, 1}, {100, 448, 1}, {101, 512, 1}, {104, 576, 1}, {103, 640, 1}}, new int[][]{{204, 704, 1}, {205, 768, 1}, {210, 832, 1}, {211, 896, 1}, {212, 960, 1}, {213, 1024, 1}, {214, 1088, 1}, {215, 1152, 1}, {216, 1216, 1}, {217, 1280, 1}, {218, 1344, 1}, {219, 1408, 1}, {152, 1472, 1}, {153, 1536, 1}, {154, 1600, 1}, {155, 1728, 1}}, new int[0][], new int[][]{{8, 1792, 1}, {12, 1856, 1}, {13, 1920, 1}}, new int[][]{{1, -1, 1}, {18, 1984, 1}, {19, 2048, 1}, {20, 2112, 1}, {21, 2176, 1}, {22, 2240, 1}, {23, 2304, 1}, {28, 2368, 1}, {29, 2432, 1}, {30, 2496, 1}, {31, 2560, 1}}};
    private static final int[] INITBLACKS = new int[]{3226, 6412, 200, 168, 38, 38, 134, 134, 100, 100, 100, 100, 68, 68, 68, 68};
    private static final byte[] LITTLEENDIANS = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};
    private static final byte[] CODE2D = new byte[]{80, 88, 23, 71, 30, 30, 62, 62, 4, 4, 4, 4, 4, 4, 4, 4, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41};
    private static final int[] BLACKS = new int[]{62, 62, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 588, 588, 588, 588, 588, 588, 588, 588, 1680, 1680, 20499, 22547, 24595, 26643, 1776, 1776, 1808, 1808, -24557, -22509, -20461, -18413, 1904, 1904, 1936, 1936, -16365, -14317, 782, 782, 782, 782, 814, 814, 814, 814, -12269, -10221, 10257, 10257, 12305, 12305, 14353, 14353, 16403, 18451, 1712, 1712, 1744, 1744, 28691, 30739, -32749, -30701, -28653, -26605, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 750, 750, 750, 750, 1616, 1616, 1648, 1648, 1424, 1424, 1456, 1456, 1488, 1488, 1520, 1520, 1840, 1840, 1872, 1872, 1968, 1968, 8209, 8209, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 1552, 1552, 1584, 1584, 2000, 2000, 2032, 2032, 976, 976, 1008, 1008, 1040, 1040, 1072, 1072, 1296, 1296, 1328, 1328, 718, 718, 718, 718, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 4113, 4113, 6161, 6161, 848, 848, 880, 880, 912, 912, 944, 944, 622, 622, 622, 622, 654, 654, 654, 654, 1104, 1104, 1136, 1136, 1168, 1168, 1200, 1200, 1232, 1232, 1264, 1264, 686, 686, 686, 686, 1360, 1360, 1392, 1392, 12, 12, 12, 12, 12, 12, 12, 12, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390};
    private static final int[] additionalMakeup = new int[]{28679, 28679, 31752, 32777, 33801, 34825, 35849, 36873, 29703, 29703, 30727, 30727, 37897, 38921, 39945, 40969};
    private static final int[] WHITES = new int[]{6430, 6400, 6400, 6400, 3225, 3225, 3225, 3225, 944, 944, 944, 944, 976, 976, 976, 976, 1456, 1456, 1456, 1456, 1488, 1488, 1488, 1488, 718, 718, 718, 718, 718, 718, 718, 718, 750, 750, 750, 750, 750, 750, 750, 750, 1520, 1520, 1520, 1520, 1552, 1552, 1552, 1552, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 654, 654, 654, 654, 654, 654, 654, 654, 1072, 1072, 1072, 1072, 1104, 1104, 1104, 1104, 1136, 1136, 1136, 1136, 1168, 1168, 1168, 1168, 1200, 1200, 1200, 1200, 1232, 1232, 1232, 1232, 622, 622, 622, 622, 622, 622, 622, 622, 1008, 1008, 1008, 1008, 1040, 1040, 1040, 1040, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 1712, 1712, 1712, 1712, 1744, 1744, 1744, 1744, 846, 846, 846, 846, 846, 846, 846, 846, 1264, 1264, 1264, 1264, 1296, 1296, 1296, 1296, 1328, 1328, 1328, 1328, 1360, 1360, 1360, 1360, 1392, 1392, 1392, 1392, 1424, 1424, 1424, 1424, 686, 686, 686, 686, 686, 686, 686, 686, 910, 910, 910, 910, 910, 910, 910, 910, 1968, 1968, 1968, 1968, 2000, 2000, 2000, 2000, 2032, 2032, 2032, 2032, 16, 16, 16, 16, 10257, 10257, 10257, 10257, 12305, 12305, 12305, 12305, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 878, 878, 878, 878, 878, 878, 878, 878, 1904, 1904, 1904, 1904, 1936, 1936, 1936, 1936, -18413, -18413, -16365, -16365, -14317, -14317, -10221, -10221, 590, 590, 590, 590, 590, 590, 590, 590, 782, 782, 782, 782, 782, 782, 782, 782, 1584, 1584, 1584, 1584, 1616, 1616, 1616, 1616, 1648, 1648, 1648, 1648, 1680, 1680, 1680, 1680, 814, 814, 814, 814, 814, 814, 814, 814, 1776, 1776, 1776, 1776, 1808, 1808, 1808, 1808, 1840, 1840, 1840, 1840, 1872, 1872, 1872, 1872, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, 14353, 14353, 14353, 14353, 16401, 16401, 16401, 16401, 22547, 22547, 24595, 24595, 20497, 20497, 20497, 20497, 18449, 18449, 18449, 18449, 26643, 26643, 28691, 28691, 30739, 30739, -32749, -32749, -30701, -30701, -28653, -28653, -26605, -26605, -24557, -24557, -22509, -22509, -20461, -20461, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232};
    private int changingElemSize;
    private int bitReached;
    private static final int[] twoBitBlack = new int[]{292, 260, 226, 226};
    private static final boolean debug = false;
    protected boolean blackIs1;
    protected boolean isByteAligned;
    private boolean isWhite = true;
    private boolean isTerminating;
    private boolean isEndOfLine;
    private boolean EOS;
    private int cRTC;
    private int line;
    private BitSet inputBits;
    private int inputBitCount;
    private boolean is2D;
    protected int bitOffset;
    protected int currIndex;
    private int fillBits;
    boolean eofLineMarker;
    private int encoding;
    private final int width;
    private final int height;
    int outPtr;
    byte[] data;
    private final BitSet out;
    private int endianOrder;
    protected int bytesNeeded;

    public CCITT(int w2, int h2) {
        this.width = w2;
        this.height = h2;
        this.bitReached = 0;
        this.bytesNeeded = this.height * (this.width + 7 >> 3);
        this.out = new BitSet(this.bytesNeeded << 3);
        this.blackIs1 = true;
    }

    public CCITT(FilterOptions options) {
        CCITTFilterOptions ops = (CCITTFilterOptions)options;
        this.bitReached = 0;
        this.width = ops.getWidth();
        this.bytesNeeded = ops.getHeight() * (this.width + 7 >> 3);
        this.blackIs1 = ops.isBlack1();
        this.isByteAligned = ops.isByteAligned();
        this.eofLineMarker = ops.isEOL();
        this.encoding = ops.getEncoding();
        this.height = ops.getHeight();
        this.endianOrder = ops.getFillOrder();
        this.out = new BitSet(this.bytesNeeded << 3);
    }

    @Override
    public byte[] decode(byte[] rawData) {
        boolean needSwitch;
        byte[] buffer;
        this.data = rawData;
        this.inputBitCount = this.data.length << 3;
        this.inputBits = this.fromByteArray(this.data, this.inputBitCount);
        if (this.encoding == 0 || this.encoding == 4) {
            buffer = this.decode1D();
            needSwitch = this.blackIs1;
        } else if (this.encoding < 0) {
            buffer = this.decode2D();
            needSwitch = !this.blackIs1;
        } else {
            buffer = this.decodeMix();
            needSwitch = !this.blackIs1;
        }
        int len = buffer.length;
        if (needSwitch) {
            for (int i2 = 0; i2 < len; ++i2) {
                buffer[i2] = (byte)(255 - buffer[i2]);
            }
        }
        return buffer;
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) throws Exception {
        this.data = new byte[4096];
        bis.read(this.data);
        byte[] buffer = this.decode(this.data);
        streamCache.write(buffer);
    }

    @Override
    public byte[] encode(byte[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encode(BufferedInputStream bis, BufferedOutputStream bos) throws Exception {
        throw new UnsupportedOperationException();
    }

    byte[] createOutputFromBitset() {
        byte[] output = new byte[this.bytesNeeded];
        int bytePtr = 0;
        int bitPtr = 7;
        int entry = 0;
        for (int j2 = 0; j2 < this.outPtr; ++j2) {
            if (this.out.get(j2)) {
                int mask = 1 << bitPtr;
                entry = (byte)(entry | mask);
            }
            --bitPtr;
            if ((j2 + 1) % this.width == 0 && j2 != 0) {
                bitPtr = -1;
            }
            if (bitPtr >= 0 || bytePtr >= output.length) continue;
            output[bytePtr] = entry;
            ++bytePtr;
            bitPtr = 7;
            entry = 0;
        }
        return output;
    }

    private byte[] decode1D() {
        this.moveToEOLMarker();
        this.decode1DRunFor1D();
        return this.createOutputFromBitset();
    }

    private byte[] decode2D() {
        this.is2D = true;
        this.decode2DRunFor2D();
        return this.createOutputFromBitset();
    }

    private byte[] decodeMix() {
        try {
            int[] prev = new int[this.width + 1];
            int[] curr = new int[this.width + 1];
            int[] currentChangeElement = new int[2];
            if (this.readEOL(true) != 1) {
                throw new Exception("TIFFFaxDecoder3");
            }
            this.decode1DRunForMix(curr);
            for (int lines = 1; lines < this.height; ++lines) {
                if (this.readEOL(false) == 0) {
                    int[] temp = prev;
                    prev = curr;
                    curr = temp;
                    this.set2D(prev, curr, this.changingElemSize, currentChangeElement);
                    curr[this.currIndex++] = this.bitOffset;
                    this.changingElemSize = this.currIndex;
                    continue;
                }
                this.decode1DRunForMix(curr);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return this.createOutputFromBitset();
    }

    private void decode1DRunFor1D() {
        while (!this.EOS) {
            if (this.isTerminating) {
                this.isTerminating = false;
                boolean bl2 = this.isWhite = !this.isWhite;
                if (this.isEndOfLine) {
                    this.isEndOfLine = false;
                    this.isWhite = true;
                }
            }
            boolean pixelIsWhite = this.isWhite;
            int pixelCount = this.getCodeWord();
            if (pixelCount <= 0) continue;
            if (pixelIsWhite) {
                this.out.set(this.outPtr, this.outPtr + pixelCount, true);
            }
            this.outPtr += pixelCount;
        }
    }

    private int getCodeWord() {
        int pixelCount = 0;
        int itemFound = -1;
        int maskAdj = 0;
        int startBitLength = 2;
        int endBit = 14;
        int code = 0;
        int bits = 0;
        if (this.isWhite) {
            startBitLength = 4;
            endBit = 13;
        }
        for (int bitLength = startBitLength; bitLength < endBit; ++bitLength) {
            code = this.get1DBits(bitLength, true) & 0xFF;
            itemFound = CCITT.checkTables(code, bitLength, this.isWhite);
            if (itemFound != -1) {
                bits = bitLength;
                break;
            }
            if (bitLength != 8) continue;
            ++maskAdj;
            ++this.bitReached;
        }
        if (itemFound != -1) {
            this.bitReached = this.bitReached + bits - maskAdj;
            pixelCount = this.processCodeWord(itemFound, code, bits);
        } else if (this.bitReached > this.inputBitCount) {
            this.EOS = true;
        }
        return pixelCount;
    }

    private int processCodeWord(int itemFound, int code, int bits) {
        boolean isT;
        int pixelCount;
        if (this.isWhite) {
            pixelCount = w[bits - 4][itemFound][1];
            isT = w[bits - 4][itemFound][2] == 0;
        } else {
            pixelCount = b[bits - 2][itemFound][1];
            boolean bl2 = isT = b[bits - 2][itemFound][2] == 0;
        }
        if (isT) {
            this.isTerminating = true;
        }
        if (pixelCount == -1) {
            if (this.line != 0) {
                LogWriter.writeLog("EOF marker encountered but not EOL yet!");
            }
            this.line = 0;
            this.isWhite = true;
            this.isTerminating = false;
        }
        if (pixelCount != -1) {
            this.line += pixelCount;
            if (this.line == this.width) {
                if (isT) {
                    this.line = 0;
                    this.isEndOfLine = true;
                }
            } else if (this.line > this.width) {
                this.line = 0;
                this.isEndOfLine = true;
            }
        }
        if (bits == 12 && code == 1) {
            ++this.cRTC;
            if (this.cRTC == 6) {
                this.EOS = true;
            }
        } else {
            this.cRTC = 0;
        }
        if (this.cRTC != 6 && this.isEndOfLine && this.isByteAligned && !this.eofLineMarker) {
            int iPart = this.bitReached % 8;
            int iDrop = 8 - iPart;
            if (iPart > 0) {
                this.bitReached += iDrop;
            }
        }
        return pixelCount;
    }

    private int get1DBits(int bitsToGet) {
        int b2 = this.get1DBits(bitsToGet, false);
        this.bitReached += bitsToGet;
        return b2;
    }

    private int get1DBits(int bitsToGet, boolean is1D) {
        int tmp = 0;
        int maskAdj = 0;
        if (is1D && bitsToGet > 8) {
            ++maskAdj;
        }
        for (int y2 = 0; y2 < bitsToGet; ++y2) {
            if (!this.inputBits.get(y2 + this.bitReached)) continue;
            int mask = 1 << bitsToGet - y2 - 1 - maskAdj;
            tmp |= mask;
        }
        return tmp;
    }

    private static int checkTables(int possCode, int bitLength, boolean isWhite) {
        int[][] table = isWhite ? w[bitLength - 4] : b[bitLength - 2];
        int size = table.length;
        for (int z2 = 0; z2 < size; ++z2) {
            if (possCode != table[z2][0]) continue;
            return z2;
        }
        return -1;
    }

    private BitSet fromByteArray(byte[] bytes, int bitsNeeded) {
        int bitSetPtr = 0;
        BitSet bits = new BitSet(bitsNeeded);
        for (byte aByte : bytes) {
            byte tmp = this.endianOrder == 2 ? LITTLEENDIANS[aByte & 0xFF] : aByte;
            for (int z2 = 7; z2 >= 0; --z2) {
                int value = tmp & 0xFF & 1 << z2;
                if (value >= 1) {
                    bits.set(bitSetPtr, true);
                }
                ++bitSetPtr;
            }
        }
        return bits;
    }

    private void moveToEOLMarker() {
        boolean isEOL = false;
        int i2 = 0;
        while (!isEOL) {
            isEOL = true;
            for (i2 = 0; i2 < 12; ++i2) {
                boolean bit = this.inputBits.get(i2 + this.bitReached);
                if (i2 == 11) {
                    if (bit) continue;
                    isEOL = false;
                    continue;
                }
                if (!bit) continue;
                isEOL = false;
            }
            ++this.bitReached;
            if (this.bitReached <= 26) continue;
            this.bitReached = 0;
            return;
        }
        this.bitReached = this.bitReached + i2 - 1;
    }

    private void decode2DRunFor2D() {
        int[] prev = new int[this.width + 1];
        int[] curr = new int[this.width + 1];
        this.changingElemSize = 2;
        curr[0] = this.width;
        curr[1] = this.width;
        int[] currentChangeElement = new int[2];
        for (int lines = 0; lines < this.height; ++lines) {
            if (this.isByteAligned && this.bitReached > 0) {
                int iPart = this.bitReached % 8;
                int iDrop = 8 - iPart;
                if (iPart > 0) {
                    this.bitReached += iDrop;
                }
            }
            int[] temp = prev;
            prev = curr;
            curr = temp;
            this.set2D(prev, curr, this.changingElemSize, currentChangeElement);
            if (curr.length != this.currIndex) {
                curr[this.currIndex++] = this.bitOffset;
            }
            this.changingElemSize = this.currIndex;
        }
    }

    private void set2D(int[] prev, int[] curr, int changingElemSize, int[] currentChangeElement) {
        this.isWhite = true;
        this.currIndex = 0;
        this.bitOffset = 0;
        int bits = 0;
        int a02 = -1;
        block5: while (this.bitOffset < this.width) {
            CCITT.getNextChangingElement(a02, this.isWhite, currentChangeElement, prev, changingElemSize);
            int bitCode = this.get1DBits(7);
            int entry = CODE2D[bitCode] & 0xFF;
            int code = (entry & 0x78) >>> 3;
            if (!this.is2D) {
                bits = entry & 7;
            } else if (code != 11) {
                this.bitReached -= 7 - (entry & 7);
            }
            switch (code) {
                case 0: {
                    a02 = this.setA0Case0(currentChangeElement, bits);
                    continue block5;
                }
                case 1: {
                    a02 = this.setA0Case1(bits, curr);
                    continue block5;
                }
                case 11: {
                    this.handleCase11(curr);
                    continue block5;
                }
            }
            a02 = this.setA0Default(curr, currentChangeElement, code, bits);
        }
    }

    private int setA0Default(int[] curr, int[] currentChangeElement, int code, int bits) {
        int a02;
        curr[this.currIndex++] = currentChangeElement[0] + (code - 5);
        int pixelCount = currentChangeElement[0] + (code - 5) - this.bitOffset;
        if (!this.isWhite) {
            this.out.set(this.outPtr, this.outPtr + pixelCount, true);
        }
        this.outPtr += pixelCount;
        this.bitOffset = a02 = currentChangeElement[0] + (code - 5);
        boolean bl2 = this.isWhite = !this.isWhite;
        if (!this.is2D) {
            this.bitReached -= 7 - bits;
        }
        return a02;
    }

    private void handleCase11(int[] curr) throws RuntimeException {
        int nextValue = this.get1DBits(3);
        if (nextValue != 7) {
            throw new RuntimeException("Unexpected value " + nextValue);
        }
        int zeroBits = 0;
        boolean isDone = false;
        while (!isDone) {
            int bitCode;
            while ((bitCode = this.get1DBits(1)) != 1) {
                ++zeroBits;
            }
            if (zeroBits > 5) {
                if (!this.isWhite && (zeroBits -= 6) > 0) {
                    curr[this.currIndex++] = this.bitOffset;
                }
                this.bitOffset += zeroBits;
                if (zeroBits > 0) {
                    this.isWhite = true;
                }
                if ((bitCode = this.get1DBits(1)) == 0) {
                    if (!this.isWhite) {
                        curr[this.currIndex++] = this.bitOffset;
                    }
                    this.isWhite = true;
                } else {
                    if (this.isWhite) {
                        curr[this.currIndex++] = this.bitOffset;
                    }
                    this.isWhite = false;
                }
                isDone = true;
            }
            if (zeroBits == 5) {
                if (!this.isWhite) {
                    curr[this.currIndex++] = this.bitOffset;
                }
                this.bitOffset += 5;
                this.isWhite = true;
                continue;
            }
            this.bitOffset += zeroBits;
            curr[this.currIndex++] = this.bitOffset++;
            this.out.set(this.outPtr, this.outPtr + 1, true);
            ++this.outPtr;
            this.isWhite = false;
        }
    }

    private int setA0Case1(int bits, int[] curr) {
        int pixelCount;
        if (!this.is2D) {
            this.bitReached -= 7 - bits;
        }
        if (this.isWhite) {
            pixelCount = this.getWhiteRunCodeWord();
            this.outPtr += pixelCount;
            this.bitOffset += pixelCount;
            curr[this.currIndex++] = this.bitOffset;
            pixelCount = this.getBlackRunCodeWord();
            this.out.set(this.outPtr, this.outPtr + pixelCount, true);
        } else {
            pixelCount = this.getBlackRunCodeWord();
            this.out.set(this.outPtr, this.outPtr + pixelCount, true);
            this.outPtr += pixelCount;
            this.bitOffset += pixelCount;
            curr[this.currIndex++] = this.bitOffset;
            pixelCount = this.getWhiteRunCodeWord();
        }
        this.outPtr += pixelCount;
        this.bitOffset += pixelCount;
        curr[this.currIndex++] = this.bitOffset;
        int a02 = this.bitOffset;
        return a02;
    }

    private int setA0Case0(int[] currentChangeElement, int bits) {
        int pixelCount = currentChangeElement[1] - this.bitOffset;
        if (!this.isWhite) {
            this.out.set(this.outPtr, this.outPtr + pixelCount, true);
        }
        this.outPtr += pixelCount;
        this.bitOffset = currentChangeElement[1];
        int a02 = currentChangeElement[1];
        if (!this.is2D) {
            this.bitReached -= 7 - bits;
        }
        return a02;
    }

    private int getBlackRunCodeWord() {
        int length = 0;
        boolean isBlack = true;
        block8: while (isBlack) {
            int bitCode = this.get1DBits(4);
            int entry = INITBLACKS[bitCode];
            int bits = entry >>> 1 & 0xF;
            int code = entry >>> 5 & 0x7FF;
            switch (code) {
                case 100: {
                    bitCode = this.get1DBits(9);
                    entry = BLACKS[bitCode];
                    int isT = entry & 1;
                    bits = entry >>> 1 & 0xF;
                    code = entry >>> 5 & 0x7FF;
                    switch (bits) {
                        case 12: {
                            this.bitReached -= 5;
                            bitCode = this.get1DBits(4);
                            entry = additionalMakeup[bitCode];
                            bits = entry >>> 1 & 7;
                            code = entry >>> 4 & 0xFFF;
                            length += code;
                            this.bitReached -= 4 - bits;
                            continue block8;
                        }
                        case 15: {
                            throw new RuntimeException("CCITT unexpected EOL");
                        }
                    }
                    length += code;
                    this.bitReached -= 9 - bits;
                    if (isT != 0) continue block8;
                    isBlack = false;
                    continue block8;
                }
                case 200: {
                    bitCode = this.get1DBits(2);
                    entry = twoBitBlack[bitCode];
                    code = entry >>> 5 & 0x7FF;
                    length += code;
                    bits = entry >>> 1 & 0xF;
                    this.bitReached -= 2 - bits;
                    isBlack = false;
                    continue block8;
                }
            }
            length += code;
            this.bitReached -= 4 - bits;
            isBlack = false;
        }
        return length;
    }

    private int getWhiteRunCodeWord() {
        int length = 0;
        boolean isWhite = true;
        block4: while (isWhite) {
            int code;
            int current = this.get1DBits(10);
            int entry = WHITES[current];
            int isT = entry & 1;
            int bits = entry >>> 1 & 0xF;
            switch (bits) {
                case 12: {
                    int twoBits = this.get1DBits(2);
                    current = current << 2 & 0xC | twoBits;
                    entry = additionalMakeup[current];
                    bits = entry >>> 1 & 7;
                    code = entry >>> 4 & 0xFFF;
                    length += code;
                    this.bitReached -= 4 - bits;
                    continue block4;
                }
                case 0: 
                case 15: {
                    throw new RuntimeException("CCITT Error in getWhiteRunCodeWord");
                }
            }
            code = entry >>> 5 & 0x7FF;
            length += code;
            this.bitReached -= 10 - bits;
            if (isT != 0) continue;
            isWhite = false;
        }
        return length;
    }

    private static void getNextChangingElement(int a02, boolean isWhite, int[] ret, int[] prevChangingElems, int changingElemSize) {
        int i2;
        int start = 0;
        if (!isWhite) {
            start |= 1;
        }
        for (i2 = start; i2 < changingElemSize; i2 += 2) {
            int temp = prevChangingElems[i2];
            if (temp <= a02) continue;
            ret[0] = temp;
            break;
        }
        if (i2 + 1 < changingElemSize) {
            ret[1] = prevChangingElems[i2 + 1];
        }
    }

    private void decode1DRunForMix(int[] curr) throws Exception {
        this.bitOffset = 0;
        this.isWhite = true;
        this.changingElemSize = 0;
        while (this.bitOffset < this.width) {
            int bits;
            int entry;
            int current;
            block14: while (this.isWhite) {
                current = this.get1DBits(10);
                entry = WHITES[current];
                bits = entry >>> 1 & 0xF;
                switch (bits) {
                    case 12: {
                        this.bitOffset = this.handle12BitsWhenWhite(current, this.bitOffset);
                        continue block14;
                    }
                    case 0: {
                        throw new Exception("1Derror");
                    }
                    case 15: {
                        throw new Exception("1Derror");
                    }
                }
                this.bitOffset = this.handleDefaultBitsWhenWhite(entry, this.bitOffset, bits, curr);
            }
            if (this.bitOffset == this.width) break;
            block15: while (!this.isWhite) {
                current = this.get1DBits(4);
                entry = INITBLACKS[current];
                bits = entry >>> 1 & 0xF;
                int code = entry >>> 5 & 0x7FF;
                switch (code) {
                    case 100: {
                        current = this.get1DBits(9);
                        entry = BLACKS[current];
                        int isT = entry & 1;
                        bits = entry >>> 1 & 0xF;
                        code = entry >>> 5 & 0x7FF;
                        switch (bits) {
                            case 12: {
                                this.bitOffset = this.handle12BitsWhenBlack(this.bitOffset);
                                continue block15;
                            }
                            case 15: {
                                throw new Exception("1D error");
                            }
                        }
                        this.bitOffset = this.handleDefaultBitsWhenBlack(code, this.bitOffset, bits, isT, curr);
                        continue block15;
                    }
                    case 200: {
                        this.bitOffset = this.handleCodeIs200(this.bitOffset, curr);
                        continue block15;
                    }
                }
                this.bitOffset = this.handleDefaultCode(code, this.bitOffset, bits, curr);
            }
            if (this.bitOffset != this.width) continue;
        }
        curr[this.changingElemSize++] = this.bitOffset;
    }

    private int handleDefaultCode(int code, int bitOffset1, int bits, int[] curr) {
        this.out.set(this.outPtr, this.outPtr + code, true);
        this.outPtr += code;
        this.bitReached -= 4 - bits;
        this.isWhite = true;
        curr[this.changingElemSize++] = bitOffset1 += code;
        return bitOffset1;
    }

    private int handleCodeIs200(int bitOffset1, int[] curr) {
        int current = this.get1DBits(2);
        int entry = twoBitBlack[current];
        int code = entry >>> 5 & 0x7FF;
        int bits = entry >>> 1 & 0xF;
        this.out.set(this.outPtr, this.outPtr + code, true);
        this.outPtr += code;
        this.bitReached -= 2 - bits;
        this.isWhite = true;
        curr[this.changingElemSize++] = bitOffset1 += code;
        return bitOffset1;
    }

    private int handleDefaultBitsWhenBlack(int code, int bitOffset1, int bits, int isT, int[] curr) {
        this.out.set(this.outPtr, this.outPtr + code, true);
        this.outPtr += code;
        bitOffset1 += code;
        this.bitReached -= 9 - bits;
        if (isT == 0) {
            this.isWhite = true;
            curr[this.changingElemSize++] = bitOffset1;
        }
        return bitOffset1;
    }

    private int handle12BitsWhenBlack(int bitOffset1) {
        this.bitReached -= 5;
        int current = this.get1DBits(4);
        int entry = additionalMakeup[current];
        int bits = entry >>> 1 & 7;
        int code = entry >>> 4 & 0xFFF;
        this.out.set(this.outPtr, this.outPtr + code, true);
        this.outPtr += code;
        this.bitReached -= 4 - bits;
        return bitOffset1 += code;
    }

    private int handle12BitsWhenWhite(int current, int bitOffset1) {
        int twoBits = this.get1DBits(2);
        current = current << 2 & 0xC | twoBits;
        int entry = additionalMakeup[current];
        int bits = entry >>> 1 & 7;
        int code = entry >>> 4 & 0xFFF;
        this.outPtr += code;
        this.bitReached -= 4 - bits;
        return bitOffset1 += code;
    }

    private int readEOL(boolean isFirstEOL) throws Exception {
        if (this.fillBits == 0) {
            int aa2;
            if (this.isByteAligned && this.bitReached % 8 != 0) {
                this.bitReached += 8 - this.bitReached % 8;
            }
            int next12Bits = this.get1DBits(12);
            if (isFirstEOL && next12Bits == 0 && (aa2 = this.get1DBits(4)) == 1) {
                this.fillBits = 1;
                ++this.bitReached;
                return 1;
            }
            if (next12Bits != 1) {
                throw new Exception("EOL error1");
            }
        } else if (this.fillBits == 1) {
            int rr2;
            int bitsLeft = 8 - (this.bitReached & 7);
            int rr = this.get1DBits(bitsLeft);
            if (rr != 0) {
                throw new Exception("EOL error2");
            }
            if (bitsLeft < 4 && (rr2 = this.get1DBits(8)) != 0) {
                throw new Exception("EOL error3");
            }
            int n2 = this.get1DBits(8);
            if (isFirstEOL && (n2 & 0xF0) == 16) {
                this.fillBits = 0;
            } else {
                while (n2 != 1) {
                    if (n2 != 0) {
                        throw new Exception("EOL error4");
                    }
                    n2 = this.get1DBits(8);
                }
            }
        }
        return this.get1DBits(1);
    }

    private int handleDefaultBitsWhenWhite(int entry, int bitOffset, int bits, int[] curr) {
        int code = entry >>> 5 & 0x7FF;
        int isT = entry & 1;
        bitOffset += code;
        this.bitReached -= 10 - bits;
        if (isT == 0) {
            this.isWhite = false;
            curr[this.changingElemSize++] = bitOffset;
        }
        this.outPtr += code;
        return bitOffset;
    }
}

