/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jpedal.parser.text.CoreHexTextUtils;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

public class ASCIIHex
extends Filter {
    public ASCIIHex(FilterOptions options) {
        super(options);
    }

    @Override
    public byte[] decode(byte[] data) {
        int length = data.length;
        if (data[length - 1] == 62) {
            --length;
        }
        FastByteArrayOutputStream bos2 = new FastByteArrayOutputStream(length + 1 >> 1);
        int b2 = ASCIIHex.skipSpaces(data, 0);
        while (b2 < length) {
            int charCount = CoreHexTextUtils.getHexCharCount(b2, data, 2);
            bos2.write(CoreHexTextUtils.getHexValue(b2, charCount, data));
            if (charCount == 0) break;
            b2 = ASCIIHex.skipSpaces(data, b2 + charCount);
        }
        return bos2.toByteArray();
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) {
        this.bis = bis;
        this.streamCache = streamCache;
        this.cachedObjects = cachedObjects;
        try {
            StringBuilder value = new StringBuilder();
            int count = bis.available();
            for (int i2 = 0; i2 < count; ++i2) {
                char current = (char)bis.read();
                while (current == '\n') {
                    current = (char)bis.read();
                }
                if (current >= '0' && current <= '9' || current >= 'a' && current <= 'f' || current >= 'A' && current <= 'F') {
                    value.append(current);
                    if (count == 1) {
                        streamCache.write(Integer.valueOf(value.toString(), 16));
                        count = 0;
                        value = new StringBuilder();
                    } else {
                        ++count;
                    }
                }
                if (current == '>') break;
            }
            if (count == 1) {
                value.append('0');
                streamCache.write(Integer.valueOf(value.toString(), 16));
            }
        }
        catch (IOException e1) {
            LogWriter.writeLog("IO exception in RunLength " + e1);
        }
    }

    @Override
    public byte[] encode(byte[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encode(BufferedInputStream bis, BufferedOutputStream bos) throws Exception {
        throw new UnsupportedOperationException();
    }

    private static int skipSpaces(byte[] data, int start) {
        int len = data.length;
        while (start < len && (data[start] == 10 || data[start] == 13 || data[start] == 32 || data[start] == 9)) {
            ++start;
        }
        return start;
    }
}

