/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FilterOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jpedal.utils.LogWriter;

public class ASCII85
extends Filter {
    private static final long[] hex_indices = new long[]{0x1000000L, 65536L, 256L, 1L};
    private static final long[] base_85_indices = new long[]{52200625L, 614125L, 7225L, 85L, 1L};

    public ASCII85(FilterOptions options) {
        super(options);
    }

    @Override
    public byte[] decode(byte[] valuesRead) {
        int special_cases = 0;
        int returns = 0;
        int data_size = valuesRead.length;
        for (int i2 = 0; i2 < data_size; ++i2) {
            if (valuesRead[i2] == 122) {
                ++special_cases;
                continue;
            }
            if (valuesRead[i2] != 10) continue;
            ++returns;
        }
        if (returns == 5 && special_cases == 0 && (data_size - returns) % 5 == 4) {
            ++data_size;
        }
        int output_pointer = 0;
        byte[] temp_data = new byte[data_size - returns + 1 + special_cases * 3];
        for (int i3 = 0; i3 < data_size; ++i3) {
            long value = 0L;
            byte next = valuesRead[i3];
            while (next == 10 || next == 13) {
                if (++i3 == data_size) {
                    next = 0;
                    continue;
                }
                next = valuesRead[i3];
            }
            if (next == 122) {
                for (int i32 = 0; i32 < 4; ++i32) {
                    temp_data[output_pointer] = 0;
                    ++output_pointer;
                }
                continue;
            }
            if (data_size - i3 <= 4 || next <= 32 || next >= 118) continue;
            int cut = 4;
            for (int ii = 0; ii < 5; ++ii) {
                if (i3 < valuesRead.length) {
                    next = valuesRead[i3];
                }
                while (next == 10 || next == 13) {
                    if (++i3 == data_size) {
                        next = 0;
                        continue;
                    }
                    next = valuesRead[i3];
                }
                if (next == 126 && valuesRead[++i3] == 62) {
                    cut = ii - 1;
                }
                if ((next <= 32 || next >= 118) && next != 126) continue;
                value += (long)(next - 33) * base_85_indices[ii];
            }
            for (int i33 = 0; i33 < 4 && i33 < cut; ++i33) {
                temp_data[output_pointer] = (byte)(value / hex_indices[i33] & 0xFFL);
                ++output_pointer;
            }
            --i3;
        }
        byte[] processed_data = new byte[output_pointer];
        System.arraycopy(temp_data, 0, processed_data, 0, output_pointer);
        return processed_data;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) {
        this.bis = bis;
        this.streamCache = streamCache;
        this.cachedObjects = cachedObjects;
lbl4:
        // 3 sources

        try {
            while (bis.available() > 0) {
                block7: {
                    value = 0L;
                    nextValue = ASCII85.read(bis);
                    if (nextValue != 122) break block7;
                    for (i3 = 0; i3 < 4; ++i3) {
                        streamCache.write(0);
                    }
                    ** GOTO lbl4
                }
                if (bis.available() < 4 || nextValue <= 32 || nextValue >= 118) continue;
                value += (long)(nextValue - 33) * ASCII85.base_85_indices[0];
                for (ii = 1; ii < 5; ++ii) {
                    nextValue = ASCII85.read(bis);
                    if (nextValue == -1) {
                        nextValue = 0;
                    }
                    if ((nextValue <= 32 || nextValue >= 118) && nextValue != 126) continue;
                    value += (long)(nextValue - 33) * ASCII85.base_85_indices[ii];
                }
                for (i3 = 0; i3 < 4; ++i3) {
                    b = (byte)(value / ASCII85.hex_indices[i3] & 255L);
                    streamCache.write(b);
                }
                ** GOTO lbl4
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing Ascii85Decode filter ");
        }
    }

    @Override
    public byte[] encode(byte[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encode(BufferedInputStream bis, BufferedOutputStream bos) throws Exception {
        throw new UnsupportedOperationException();
    }

    private static int read(BufferedInputStream bis) throws IOException {
        int nextValue = bis.read();
        while (nextValue == 13 || nextValue == 10) {
            nextValue = bis.read();
        }
        return nextValue;
    }
}

