/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoderInt;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.creation.AnnotationFactory;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.ResourcesObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.Strip;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static boolean isEditableAnnotation(FormObject form) {
        int annotType = form.getNameAsConstant(1147962727);
        return annotType == 1110658926 || annotType == 1160865142 || annotType == 473513525 || annotType == 1654331 || annotType == 1230470778 || annotType == 1014528638 || annotType == 1919840408 || annotType == 980909433 || annotType == 607471684 || AnnotationUtils.isURLLink(form);
    }

    public static boolean isDraggableAnnotation(FormObject form) {
        int annotType = form.getNameAsConstant(1147962727);
        return annotType == 1110658926 || annotType == 1160865142 || annotType == 473513525 || annotType == 1654331 || annotType == 1230470778 || annotType == 1014528638 || annotType == 980909433 || annotType == 607471684;
    }

    public static boolean isResizableAnnotation(FormObject form) {
        int annotType = form.getNameAsConstant(1147962727);
        return annotType == 1110658926 || annotType == 1160865142 || annotType == 473513525 || annotType == 1654331 || annotType == 980909433 || annotType == 1230470778 || annotType == 1014528638;
    }

    public static boolean isURLLink(FormObject form) {
        FormObject link;
        boolean isLink = false;
        if (form != null && form.getNameAsConstant(1147962727) == 473513531 && (link = (FormObject)form.getDictionary(17)) != null) {
            isLink = "URI".equals(link.getName(35));
        }
        return isLink;
    }

    public static FormObject isOverForm(PdfDecoderInt decode_pdf, int x2, int y2) {
        return AnnotationUtils.isOverForm(decode_pdf, x2, y2, 0);
    }

    public static FormObject isOverForm(PdfDecoderInt decode_pdf, int x2, int y2, int range) {
        List<FormObject> forms;
        List<FormObject>[] formList;
        GUIData compData;
        AcroRenderer formRenderer;
        if (decode_pdf.isOpen() && (formRenderer = decode_pdf.getFormRenderer()) != null && (compData = formRenderer.getCompData()) != null && (formList = compData.getFormList(true)) != null && decode_pdf.getPageNumber() < formList.length && (forms = formList[decode_pdf.getPageNumber()]) != null) {
            for (FormObject form : forms) {
                if (form == null) continue;
                Rectangle bounds = form.getBoundingRectangle();
                if (bounds.x - range > x2 || x2 > bounds.x + bounds.width + range || bounds.y - range > y2 || y2 > bounds.y + bounds.height + range) continue;
                return form;
            }
        }
        return null;
    }

    public static float[] validateCoordinates(float sx, float sy, float ex, float ey) {
        float[] values = new float[4];
        if (sx < ex) {
            values[0] = sx;
            values[2] = ex;
        } else {
            values[0] = ex;
            values[2] = sx;
        }
        if (sy < ey) {
            values[1] = sy;
            values[3] = ey;
        } else {
            values[1] = ey;
            values[3] = sy;
        }
        return values;
    }

    public static String readDSFontName(byte[] DS) {
        int position = StreamReaderUtils.skipSpaces(DS, 0);
        boolean isSize = true;
        boolean hasDecimal = false;
        int dsLength = DS.length;
        int valueStart = position;
        int valueEnd = position;
        while (position < dsLength && DS[position] != 59) {
            byte value = DS[position];
            if (value == 34) {
                position = StreamReaderUtils.skipToCharacter(DS, position, 34) + 1;
                isSize = false;
                continue;
            }
            if (value == 32) {
                if (isSize) {
                    valueStart = position = StreamReaderUtils.skipSpaces(DS, 0);
                    valueEnd = position;
                    continue;
                }
                return new String(DS, valueStart, valueEnd - valueStart);
            }
            if (isSize && (value < 48 || 57 < value)) {
                if (!(position >= DS.length - 2 || value != 112 && value != 80 || DS[position + 1] != 116 && DS[position + 1] != 84)) {
                    position += 2;
                    continue;
                }
                if (!hasDecimal && value == 46) {
                    hasDecimal = true;
                } else {
                    isSize = false;
                }
            }
            valueEnd = ++position;
        }
        return "";
    }

    public static float readDSFontSize(byte[] DS) {
        int position = StreamReaderUtils.skipSpaces(DS, 0);
        boolean hasDecimal = false;
        int valueStart = position;
        int valueEnd = position;
        int dsLength = DS.length;
        while (position < dsLength && DS[position] != 59) {
            byte value = DS[position];
            if (value < 48 || 57 < value) {
                if (position < DS.length - 2 && (value == 112 || value == 80) && (DS[position + 1] == 116 || DS[position + 1] == 84)) break;
                if (!hasDecimal && value == 46) {
                    hasDecimal = true;
                } else {
                    if (value == 32) {
                        position = StreamReaderUtils.skipToCharacter(DS, position, 32);
                        valueStart = position = StreamReaderUtils.skipSpaces(DS, position);
                        valueEnd = position;
                        continue;
                    }
                    if (value == 34) {
                        position = StreamReaderUtils.skipToCharacter(DS, position, 34);
                    }
                }
            }
            valueEnd = ++position;
        }
        if (valueEnd == valueStart) {
            return -1.0f;
        }
        return NumberUtils.parseFloat(valueStart, valueEnd, DS);
    }

    public static String getFontNameForForm(FormObject form) {
        byte[] DS = form.getTextStreamValueAsByte(5155);
        if (DS != null) {
            int dsLength = DS.length - 5;
            for (int i2 = 0; i2 < dsLength; ++i2) {
                if (DS[i2] != 102 || DS[i2 + 1] != 111 || DS[i2 + 2] != 110 || DS[i2 + 3] != 116 || DS[i2 + 4] != 58) continue;
                int start = i2 + 5;
                int endOfFont = StreamReaderUtils.skipToCharacter(DS, start, 59);
                byte[] fontSegment = Arrays.copyOfRange(DS, start, endOfFont);
                return AnnotationUtils.readDSFontName(fontSegment);
            }
        }
        return form.getFontName();
    }

    public static float getFontSizeForForm(FormObject form) {
        float fontSize = form.getFontSize();
        byte[] DS = form.getTextStreamValueAsByte(5155);
        if (DS != null) {
            int dsLength = DS.length - 5;
            for (int i2 = 0; i2 < dsLength; ++i2) {
                if (DS[i2] != 102 || DS[i2 + 1] != 111 || DS[i2 + 2] != 110 || DS[i2 + 3] != 116 || DS[i2 + 4] != 58) continue;
                int start = i2 + 5;
                int endOfFont = StreamReaderUtils.skipToCharacter(DS, start, 59);
                byte[] fontSegment = Arrays.copyOfRange(DS, start, endOfFont);
                fontSize = AnnotationUtils.readDSFontSize(fontSegment);
            }
        }
        return fontSize;
    }

    public static Color getFontColorFromFormAsHexString(FormObject form) {
        byte[] DS = form.getTextStreamValueAsByte(5155);
        if (DS != null) {
            int dsLength = DS.length - 6;
            for (int i2 = 0; i2 < dsLength; ++i2) {
                if (DS[i2] != 99 || DS[i2 + 1] != 111 || DS[i2 + 2] != 108 || DS[i2 + 3] != 111 || DS[i2 + 4] != 114 || DS[i2 + 5] != 58) continue;
                int start = StreamReaderUtils.skipSpaces(DS, i2 + 6);
                int endOfFont = StreamReaderUtils.skipToCharacter(DS, start, 59);
                byte[] colorSegment = Arrays.copyOfRange(DS, start, endOfFont);
                int[] rgb = AnnotationUtils.readDSColorValues(colorSegment);
                return new Color(rgb[0], rgb[1], rgb[2]);
            }
        }
        return Color.BLACK;
    }

    public static int[] readDSColorValues(byte[] dsColorSegment) {
        int position = StreamReaderUtils.skipSpaces(dsColorSegment, 0);
        if (dsColorSegment[position] == 35) {
            int colorStart = position;
            int colorEnd = position = StreamReaderUtils.skipToCharacter(dsColorSegment, position, 59);
            String colString = new String(Arrays.copyOfRange(dsColorSegment, colorStart, colorEnd));
            return new int[]{Integer.valueOf(colString.substring(1, 3), 16), Integer.valueOf(colString.substring(3, 5), 16), Integer.valueOf(colString.substring(5, 7), 16)};
        }
        LogWriter.writeLog("Unknown color for FreeText annotation.");
        return new int[]{0, 0, 0};
    }

    public static void createAPObjectForFormObject(FormObject form, PdfObjectReader currentPdfFile) {
        switch (form.getNameAsConstant(1147962727)) {
            case 473513525: 
            case 980909433: 
            case 1014528638: 
            case 1110658926: 
            case 1160865142: 
            case 1230470778: {
                AnnotationUtils.createBasicAPObject(form, currentPdfFile);
                break;
            }
            case 607471684: {
                AnnotationUtils.createTextAPObject(form, currentPdfFile);
                break;
            }
            case 1654331: {
                AnnotationUtils.createInkAPObject(form, currentPdfFile);
                break;
            }
            case 1919840408: {
                float[] quads = form.getFloatArray(1785890247);
                if (quads == null) break;
                AnnotationUtils.createHighlightAPObject(form, currentPdfFile);
            }
        }
    }

    private static String createBasicAPObject(FormObject form, PdfObjectReader currentPdfFile) {
        PdfObject N2;
        String APString = AnnotationUtils.createAPStream(form);
        if (APString == null) {
            return "";
        }
        boolean newAP = false;
        PdfObject AP = form.getDictionary(4384);
        if (AP != null) {
            N2 = AP.getDictionary(30);
            if (N2 == null) {
                N2 = new FormObject(30);
                newAP = true;
            }
        } else {
            AP = new FormObject(4384);
            N2 = new FormObject(30);
        }
        float ca = form.getFloatNumber(4881);
        StringBuilder builder = new StringBuilder();
        builder.append("<<");
        if (ca != 1.0f) {
            builder.append("/ExtGState <</GS0 <</Type /ExtGState /AIS false /CA ").append(ca).append(" /ca ").append(ca).append(" >> >>");
            APString = "/GS0 gs " + APString;
        }
        if (form.getNameAsConstant(1147962727) == 980909433) {
            String fontName = StandardFonts.expandName(AnnotationUtils.getFontNameForForm(form));
            builder.append("/Font <</").append(fontName).append(" <</Type /Font /Subtype /Type1 /Name /").append(fontName).append(" /BaseFont /").append(fontName).append(" >> >>");
        }
        builder.append(" >>");
        ResourcesObject resources = AnnotationUtils.getResObjectFromDirect(currentPdfFile, builder.toString().getBytes());
        N2.setDictionary(2004251818, resources);
        float[] formRect = form.getFloatArray(573911876);
        float[] rect = formRect != null ? AnnotationUtils.validateCoordinates(formRect[0], formRect[1], formRect[2], formRect[3]) : null;
        byte[] bytes = APString.getBytes();
        N2.setDecodedStream(bytes);
        N2.setIntNumber(1043816557, bytes.length);
        if (rect == null) {
            Rectangle bounds = form.getBoundingRectangle();
            N2.setFloatArray(303185736, new float[]{0.0f, 0.0f, bounds.width, bounds.height});
        } else {
            N2.setFloatArray(303185736, new float[]{0.0f, 0.0f, rect[2] - rect[0], rect[3] - rect[1]});
        }
        if (newAP) {
            N2.setConstant(1147962727, 373244477);
            N2.setConstant(608780341, 979194486);
            N2.setIntNumber(982024818, 1);
            AP.setDictionary(30, N2);
        }
        N2.setName(1011108731, new byte[0]);
        N2.setFloatArray(1145198201, null);
        form.setDictionary(4384, AP);
        return APString;
    }

    private static void createInkAPObject(FormObject form, PdfObjectReader currentPdfFile) {
        AnnotationUtils.createBasicAPObject(form, currentPdfFile);
        PdfObject AP = form.getDictionary(4384);
        PdfObject N2 = AP.getDictionary(30);
        float[] rect = form.getFloatArray(573911876);
        N2.setFloatArray(303185736, new float[]{rect[0], rect[1], rect[2], rect[3]});
        N2.setFloatArray(1145198201, new float[]{1.0f, 0.0f, 0.0f, 1.0f, -rect[0], -rect[1]});
    }

    private static void createTextAPObject(FormObject form, PdfObjectReader currentPdfFile) {
        String apStream = AnnotationUtils.createBasicAPObject(form, currentPdfFile);
        PdfObject AP = form.getDictionary(4384);
        PdfObject N2 = AP.getDictionary(30);
        float[] apSize = AnnotationUtils.getTextIconDimensions(form.getName(506543413));
        N2.setFloatArray(303185736, new float[]{0.0f, 0.0f, apSize[0], apSize[1]});
        if (apStream.contains("GS0")) {
            String sb = "<</ExtGState << /GS0 << /ca 0.6 /Type /ExtGState /CA 0.6 /AIS false /BM /Normal >> >> >>";
            ResourcesObject resources = AnnotationUtils.getResObjectFromDirect(currentPdfFile, "<</ExtGState << /GS0 << /ca 0.6 /Type /ExtGState /CA 0.6 /AIS false /BM /Normal >> >> >>".getBytes());
            N2.setDictionary(2004251818, resources);
        }
    }

    private static void createHighlightAPObject(FormObject form, PdfObjectReader currentPdfFile) {
        String apStream = AnnotationUtils.createBasicAPObject(form, currentPdfFile);
        PdfObject AP = form.getDictionary(4384);
        PdfObject N2 = AP.getDictionary(30);
        float[] rect = form.getFloatArray(573911876);
        N2.setFloatArray(303185736, new float[]{rect[0], rect[1], rect[2], rect[3]});
        N2.setFloatArray(1145198201, new float[]{1.0f, 0.0f, 0.0f, 1.0f, -rect[0], -rect[1]});
        if (apStream.contains("GS0")) {
            String sb = "<</ExtGState << /GS0 << /Type /ExtGState /AIS false /BM /Multiply >> >> >>";
            ResourcesObject resources = AnnotationUtils.getResObjectFromDirect(currentPdfFile, "<</ExtGState << /GS0 << /Type /ExtGState /AIS false /BM /Multiply >> >> >>".getBytes());
            N2.setDictionary(2004251818, resources);
        }
    }

    public static String createAPStream(FormObject form) {
        switch (form.getNameAsConstant(1147962727)) {
            case 980909433: {
                return AnnotationUtils.createFreeTextAPStream(form);
            }
            case 1160865142: {
                return AnnotationUtils.createSquareAPStream(form);
            }
            case 473513525: {
                return AnnotationUtils.createLineAPStream(form);
            }
            case 607471684: {
                return AnnotationUtils.createTextAPStream(form);
            }
            case 1230470778: {
                return AnnotationUtils.createPolygonAPStream(form, true);
            }
            case 1014528638: {
                return AnnotationUtils.createPolygonAPStream(form, false);
            }
            case 1654331: {
                return AnnotationUtils.createInkAPStream(form);
            }
            case 1110658926: {
                return AnnotationUtils.createCircleAPStream(form);
            }
            case 1919840408: {
                return AnnotationUtils.createHighlightAPStream(form);
            }
        }
        return null;
    }

    private static String createCircleAPStream(FormObject form) {
        float[] rect;
        int width;
        StringBuilder stream = new StringBuilder();
        String drawCommand = AnnotationUtils.getDrawCommand(form, stream);
        int w2 = 1;
        PdfObject bs2 = form.getDictionary(4643);
        if (bs2 != null && (width = bs2.getInt(39)) != -1) {
            w2 = width;
            stream.append(w2);
            stream.append(" w\n");
        }
        if ((rect = form.getFloatArray(573911876))[0] == rect[2] && rect[1] == rect[3]) {
            AnnotationUtils.getSquare(stream, rect);
        } else {
            AnnotationUtils.getRectangle(stream, drawCommand, w2, rect);
        }
        return stream.toString();
    }

    private static void getRectangle(StringBuilder stream, String drawCommand, int w2, float[] rect) {
        float width = rect[2] - rect[0] - (float)(w2 * 2);
        float height = rect[3] - rect[1] - (float)(w2 * 2);
        float longRatio = 0.777f;
        float shortRatio = 0.222f;
        stream.append(w2);
        stream.append(' ');
        stream.append((float)w2 + height / 2.0f);
        stream.append(" m\n");
        stream.append(w2);
        stream.append(' ');
        stream.append((float)w2 + height * 0.777f);
        stream.append(' ');
        stream.append((float)w2 + width * 0.222f);
        stream.append(' ');
        stream.append((float)w2 + height);
        stream.append(' ');
        stream.append((float)w2 + width / 2.0f);
        stream.append(' ');
        stream.append((float)w2 + height);
        stream.append(" c\n");
        stream.append((float)w2 + width * 0.777f);
        stream.append(' ');
        stream.append((float)w2 + height);
        stream.append(' ');
        stream.append((float)w2 + width);
        stream.append(' ');
        stream.append((float)w2 + height * 0.777f);
        stream.append(' ');
        stream.append((float)w2 + width);
        stream.append(' ');
        stream.append((float)w2 + height / 2.0f);
        stream.append(" c\n");
        stream.append((float)w2 + width);
        stream.append(' ');
        stream.append((float)w2 + height * 0.222f);
        stream.append(' ');
        stream.append((float)w2 + width * 0.777f);
        stream.append(' ');
        stream.append(w2);
        stream.append(' ');
        stream.append((float)w2 + width / 2.0f);
        stream.append(' ');
        stream.append(w2);
        stream.append(" c\n");
        stream.append((float)w2 + width * 0.222f);
        stream.append(' ');
        stream.append(w2);
        stream.append(' ');
        stream.append(w2);
        stream.append(' ');
        stream.append((float)w2 + height * 0.222f);
        stream.append(' ');
        stream.append(w2);
        stream.append(' ');
        stream.append((float)w2 + height / 2.0f);
        stream.append(" c\n");
        stream.append("h\n");
        stream.append(drawCommand);
    }

    private static void getSquare(StringBuilder stream, float[] rect) {
        stream.append(rect[0]);
        stream.append(' ');
        stream.append(rect[1]);
        stream.append(" m\n");
        stream.append(rect[0]);
        stream.append(' ');
        stream.append(rect[1]);
        stream.append(" l\n");
        stream.append(" S\n");
    }

    private static String createSquareAPStream(FormObject form) {
        int width;
        StringBuilder stream = new StringBuilder();
        String drawCommand = AnnotationUtils.getDrawCommand(form, stream);
        int w2 = 1;
        PdfObject bs2 = form.getDictionary(4643);
        if (bs2 != null && (width = bs2.getInt(39)) != -1) {
            w2 = width;
            stream.append(w2);
            stream.append(" w\n");
        }
        float[] rect = form.getFloatArray(573911876);
        stream.append((float)(w2 / 2));
        stream.append(' ');
        stream.append((float)w2);
        stream.append(' ');
        stream.append(rect[2] - rect[0] - (float)w2);
        stream.append(' ');
        stream.append(rect[3] - rect[1] - (float)(w2 * 2));
        stream.append(" re\n");
        stream.append(drawCommand);
        return stream.toString();
    }

    private static String getDrawCommand(FormObject form, StringBuilder stream) {
        String fillCommand;
        String drawCommand = null;
        String strokeCommand = AnnotationUtils.createStrokeColorCommands(form);
        if (!strokeCommand.isEmpty()) {
            stream.append(strokeCommand);
            drawCommand = "S";
        }
        if (!(fillCommand = AnnotationUtils.createFillColorCommands(form)).isEmpty()) {
            stream.append(fillCommand);
            drawCommand = drawCommand != null ? "B" : "F";
        }
        return drawCommand;
    }

    private static String createHighlightAPStream(FormObject form) {
        StringBuilder stream = new StringBuilder();
        stream.append("/GS0 gs\n");
        float[] color = form.getFloatArray(19);
        if (color != null && color.length == 3) {
            stream.append(color[0]);
            stream.append(' ');
            stream.append(color[1]);
            stream.append(' ');
            stream.append(color[2]);
            stream.append(" rg\n");
        }
        float[] quads = form.getFloatArray(1785890247);
        float[] rect = form.getFloatArray(573911876);
        float[] modRect = new float[4];
        System.arraycopy(rect, 0, modRect, 0, 4);
        for (int i2 = 0; i2 < quads.length; i2 += 8) {
            float controlPointDistance = (quads[i2 + 1] - rect[1] - (quads[i2 + 7] - rect[1])) / 4.24f;
            if (modRect[0] > quads[i2] - controlPointDistance) {
                modRect[0] = quads[i2] - controlPointDistance;
            }
            if (modRect[2] < quads[i2 + 2] + controlPointDistance) {
                modRect[2] = quads[i2 + 2] + controlPointDistance;
            }
            stream.append((int)quads[i2 + 4]);
            stream.append(' ');
            stream.append((int)quads[i2 + 5]);
            stream.append(" m\n");
            stream.append((float)((int)quads[i2 + 4]) - controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i2 + 5]) + controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i2]) - controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i2 + 1]) - controlPointDistance);
            stream.append(' ');
            stream.append((int)quads[i2]);
            stream.append(' ');
            stream.append((int)quads[i2 + 1]);
            stream.append(" c\n");
            stream.append((int)quads[i2 + 2]);
            stream.append(' ');
            stream.append((int)quads[i2 + 3]);
            stream.append(" l\n");
            stream.append((float)((int)quads[i2 + 2]) + controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i2 + 3]) - controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i2 + 6]) + controlPointDistance);
            stream.append(' ');
            stream.append((float)((int)quads[i2 + 7]) + controlPointDistance);
            stream.append(' ');
            stream.append((int)quads[i2 + 6]);
            stream.append(' ');
            stream.append((int)quads[i2 + 7]);
            stream.append(" c\n");
            stream.append("f\n");
        }
        form.setFloatArray(573911876, modRect);
        return stream.toString();
    }

    private static String createTextAPStream(FormObject form) {
        String name = form.getName(506543413);
        if (name == null || name.isEmpty()) {
            name = "Note";
        }
        return AnnotationUtils.loadApTemplate(form, name);
    }

    private static String loadApTemplate(FormObject form, String name) {
        StringBuilder stream = new StringBuilder();
        String iconFile = "/org/jpedal/objects/acroforms/res/" + name + ".txt";
        URL apFile = AnnotationUtils.class.getResource(iconFile);
        try {
            InputStream inputStream = apFile.openStream();
            try (InputStreamReader streamReader = new InputStreamReader(inputStream);
                 BufferedReader in = new BufferedReader(streamReader);){
                String line;
                while ((line = in.readLine()) != null) {
                    stream.append(line);
                    if (line.endsWith(" ")) continue;
                    stream.append(' ');
                }
            }
        }
        catch (IOException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        String apStream = stream.toString();
        float[] color = form.getFloatArray(19);
        if (color != null && color.length == 3) {
            String colorString = color[0] + " " + color[1] + ' ' + color[2] + " rg";
            apStream = apStream.replace("1 0.819611 0 rg", colorString);
        }
        return apStream;
    }

    private static String createFreeTextAPStream(FormObject form) {
        String content;
        float[] rect = form.getFloatArray(573911876);
        String bounds = "0 0 " + Math.abs(rect[2] - rect[0]) + ' ' + Math.abs(rect[3] - rect[1]) + " re\n";
        String fontName = StandardFonts.expandName(AnnotationUtils.getFontNameForForm(form));
        float fontSize = AnnotationUtils.getFontSizeForForm(form);
        String fontString = '/' + fontName + ' ' + fontSize + " Tf\n";
        Color c2 = AnnotationUtils.getFontColorFromFormAsHexString(form);
        String colorString = (float)c2.getRed() / 255.0f + " " + (float)c2.getGreen() / 255.0f + ' ' + (float)c2.getBlue() / 255.0f + " rg\n";
        String richContent = form.getTextStreamValue(8723);
        if (richContent != null) {
            String escapedRichContent = Strip.stripXMLArrows(new StringBuilder(richContent), true).toString();
            content = AnnotationUtils.unescapeCharacters(escapedRichContent);
        } else {
            String plainText = form.getTextStreamValue(1216184967);
            content = plainText != null ? plainText : "";
        }
        String[] contentLines = content.split("\\r\\n|\\n|\\r");
        StringBuilder stream = new StringBuilder();
        stream.append("0 w\n");
        stream.append(bounds);
        stream.append("n\nq\n1 0 0 1 0 0 cm\n");
        stream.append(bounds);
        stream.append("W\nn\n0 g\n1 w\nBT\n");
        stream.append(fontString);
        stream.append(colorString);
        stream.append(0.01);
        stream.append(' ');
        stream.append(Math.abs(rect[3] - rect[1]) - fontSize);
        stream.append(" Td\n");
        FontRenderContext fontContext = new FontRenderContext(null, true, true);
        Font font = new Font(fontName, 0, (int)fontSize);
        for (int i2 = 0; i2 != contentLines.length; ++i2) {
            int lineCurrentPoint = 0;
            StringTokenizer tokens = new StringTokenizer(contentLines[i2], Character.toString('\t'), true);
            if (tokens.countTokens() == 1) {
                stream.append('(');
                stream.append(contentLines[i2]);
                stream.append(") Tj\n");
            } else {
                int tabWidth = 36;
                int textWidth = 0;
                while (tokens.hasMoreTokens()) {
                    String tab = tokens.nextToken();
                    if (tab.equals(Character.toString('\t'))) {
                        int nextTab = lineCurrentPoint + textWidth;
                        nextTab += 36 - nextTab % 36;
                        stream.append(nextTab - lineCurrentPoint);
                        stream.append(" 0 Td\n");
                        lineCurrentPoint += nextTab - lineCurrentPoint;
                        continue;
                    }
                    stream.append('(');
                    stream.append(tab);
                    stream.append(") Tj\n");
                    textWidth = (int)font.getStringBounds(tab, fontContext).getWidth();
                }
            }
            if (i2 == contentLines.length - 1) continue;
            stream.append(-lineCurrentPoint);
            stream.append(' ');
            stream.append(-fontSize * 1.3f);
            stream.append(" Td\n");
        }
        stream.append("ET\n");
        stream.append('Q');
        return stream.toString();
    }

    private static String unescapeCharacters(String content) {
        int escapeStart = -1;
        boolean isHex = false;
        StringBuilder contentBuilder = new StringBuilder();
        for (int i2 = 0; i2 != content.length(); ++i2) {
            char character = content.charAt(i2);
            if (escapeStart != -1) {
                if (i2 == escapeStart + 1 && character == 'x') {
                    isHex = true;
                    continue;
                }
                if (character == ';') {
                    int start = isHex ? escapeStart + 3 : escapeStart + 2;
                    String code = content.substring(start, i2);
                    int iChar = isHex ? Integer.parseInt(code, 16) : Integer.parseInt(code);
                    if (iChar < 128) {
                        contentBuilder.append((char)iChar);
                    } else {
                        contentBuilder.append(String.format("\\u%04x", iChar));
                    }
                    escapeStart = -1;
                    isHex = false;
                    continue;
                }
                if (Character.isDigit(character)) continue;
                contentBuilder.append(escapeStart);
                i2 = escapeStart + 1;
                escapeStart = -1;
                isHex = false;
                continue;
            }
            if (character == '&' && i2 < content.length() - 1 && content.charAt(i2 + 1) == '#') {
                escapeStart = i2++;
                isHex = false;
                continue;
            }
            contentBuilder.append(character);
        }
        return contentBuilder.toString();
    }

    private static String createPolygonAPStream(FormObject form, boolean closeShape) {
        String fillCommand;
        int width;
        float[] coords = form.getFloatArray(1600681863);
        float[] rect = form.getFloatArray(573911876);
        int w2 = 1;
        PdfObject bs2 = form.getDictionary(4643);
        if (bs2 != null && (width = bs2.getInt(39)) != -1) {
            w2 = width;
        }
        StringBuilder stream = new StringBuilder();
        String drawCommand = null;
        stream.append(w2);
        stream.append(" w\n");
        String strokeCommand = AnnotationUtils.createStrokeColorCommands(form);
        if (!strokeCommand.isEmpty()) {
            stream.append(strokeCommand);
            drawCommand = "s";
        }
        if (!(fillCommand = AnnotationUtils.createFillColorCommands(form)).isEmpty()) {
            stream.append(fillCommand);
            drawCommand = drawCommand != null ? "b" : "f";
        }
        stream.append(coords[0] - rect[0]);
        stream.append(' ');
        stream.append(coords[1] - rect[1]);
        stream.append(" m\n");
        for (int i2 = 2; i2 != coords.length; i2 += 2) {
            stream.append(coords[i2] - rect[0]);
            stream.append(' ');
            stream.append(coords[i2 + 1] - rect[1]);
            stream.append(" l\n");
        }
        if (closeShape) {
            stream.append("h\n");
            stream.append(drawCommand);
        } else if (drawCommand != null) {
            stream.append(drawCommand.toUpperCase());
        }
        return stream.toString();
    }

    private static String createInkAPStream(FormObject form) {
        int width;
        float[][] inkList = form.getFloat2DArray(475169151);
        int w2 = 1;
        PdfObject bs2 = form.getDictionary(4643);
        if (bs2 != null && (width = bs2.getInt(39)) != -1) {
            w2 = width;
        }
        StringBuilder stream = new StringBuilder();
        stream.append(w2);
        stream.append(" w\n");
        stream.append(AnnotationUtils.createStrokeColorCommands(form));
        float[] rect = form.getFloatArray(573911876);
        Rectangle2D bounds = new Rectangle2D.Float(rect[0], rect[1], rect[2] - rect[0], rect[3] - rect[1]);
        for (float[] coords : inkList) {
            stream.append(coords[0]);
            stream.append(' ');
            stream.append(coords[1]);
            stream.append(" m\n");
            if (coords.length > 4) {
                coords = AnnotationFactory.createInkCurve(coords);
                CubicCurve2D.Float curve = new CubicCurve2D.Float();
                for (int i2 = 2; i2 < coords.length - 5; i2 += 6) {
                    stream.append(coords[i2]);
                    stream.append(' ');
                    stream.append(coords[i2 + 1]);
                    stream.append(' ');
                    stream.append(coords[i2 + 2]);
                    stream.append(' ');
                    stream.append(coords[i2 + 3]);
                    stream.append(' ');
                    stream.append(coords[i2 + 4]);
                    stream.append(' ');
                    stream.append(coords[i2 + 5]);
                    stream.append(" c\n");
                    ((CubicCurve2D)curve).setCurve(coords[i2 - 2], coords[i2 - 1], coords[i2], coords[i2 + 1], coords[i2 + 2], coords[i2 + 3], coords[i2 + 4], coords[i2 + 5]);
                    bounds = ((Rectangle2D)bounds).createUnion(curve.getBounds2D());
                }
                continue;
            }
            if (coords.length == 4) {
                stream.append(coords[2]);
                stream.append(' ');
                stream.append(coords[3]);
                stream.append(" l\n");
                continue;
            }
            stream.append(coords[0]);
            stream.append(' ');
            stream.append(coords[1]);
            stream.append(" l\n");
        }
        stream.append("S\n");
        form.setFloatArray(573911876, AnnotationUtils.validateCoordinates((float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getMaxX(), (float)bounds.getMaxY()));
        return stream.toString();
    }

    private static String createLineAPStream(FormObject form) {
        int width;
        StringBuilder stream = new StringBuilder();
        float[] coords = form.getFloatArray(28);
        float[] rect = form.getFloatArray(573911876);
        String coordString = coords[0] - rect[0] + " " + (coords[1] - rect[1]) + " m\n" + (coords[2] - rect[0]) + ' ' + (coords[3] - rect[1]) + " l\n";
        int w2 = 1;
        PdfObject bs2 = form.getDictionary(4643);
        if (bs2 != null && (width = bs2.getInt(39)) != -1) {
            w2 = width;
        }
        String widthString = w2 + " w\n";
        stream.append(widthString);
        stream.append(AnnotationUtils.createStrokeColorCommands(form));
        stream.append(coordString);
        stream.append('S');
        return stream.toString();
    }

    private static ResourcesObject getResObjectFromDirect(PdfObjectReader currentPdfFile, byte[] data) {
        ResourcesObject resObj = new ResourcesObject(new String(data));
        resObj.setUnresolvedData(data, 2004251818);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        objectDecoder.checkResolved(resObj);
        return resObj;
    }

    public static float[] getTextIconDimensions(String name) {
        if (name == null || name.isEmpty()) {
            name = "Note";
        }
        switch (name) {
            case "Comment": {
                return new float[]{18.0f, 18.0f};
            }
            case "Check": 
            case "Cross": {
                return new float[]{19.0f, 19.0f};
            }
            case "Checkmark": 
            case "RightArrow": 
            case "Paragraph": 
            case "Help": 
            case "CrossHairs": 
            case "Circle": {
                return new float[]{20.0f, 20.0f};
            }
            case "Insert": 
            case "UpArrow": {
                return new float[]{17.0f, 20.0f};
            }
            case "Key": {
                return new float[]{13.0f, 18.0f};
            }
            case "NewParagraph": {
                return new float[]{13.0f, 20.0f};
            }
            case "RightPointer": {
                return new float[]{20.0f, 17.0f};
            }
            case "Star": {
                return new float[]{20.0f, 19.0f};
            }
            case "UpLeftArrow": {
                return new float[]{17.0f, 17.0f};
            }
        }
        return new float[]{18.0f, 20.0f};
    }

    private static String createStrokeColorCommands(FormObject form) {
        StringBuilder stream = new StringBuilder();
        float[] stroke = form.getFloatArray(19);
        if (stroke != null && stroke.length == 3) {
            stream.append(stroke[0]);
            stream.append(' ');
            stream.append(stroke[1]);
            stream.append(' ');
            stream.append(stroke[2]);
            stream.append(" RG\n");
        }
        return stream.toString();
    }

    private static String createFillColorCommands(FormObject form) {
        StringBuilder stream = new StringBuilder();
        float[] fill = form.getFloatArray(6419);
        if (fill != null && fill.length == 3) {
            stream.append(fill[0]);
            stream.append(' ');
            stream.append(fill[1]);
            stream.append(' ');
            stream.append(fill[2]);
            stream.append(" rg\n");
        }
        return stream.toString();
    }
}

