/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jpedal.io.annotation.utils.AnnotObject;
import org.jpedal.utils.LogWriter;

public class AnnotString
implements AnnotObject {
    private final String str;
    private final byte[] data;

    public AnnotString(String str, byte[] data) {
        this.str = str;
        this.data = data;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(40);
        try {
            buffer.write(this.data);
        }
        catch (IOException e2) {
            LogWriter.writeLog(e2);
        }
        buffer.write(41);
        return buffer.toByteArray();
    }

    @Override
    public String toText() {
        String localStr = this.str;
        if (localStr != null) {
            if (localStr.contains("\\")) {
                localStr = localStr.replaceAll("\\\\", "\\\\\\\\");
            }
            if (localStr.contains("(") && !localStr.contains("\\(")) {
                localStr = localStr.replaceAll("(?<!\\\\)\\(", "\\\\(");
            }
            if (localStr.contains(")") && !localStr.contains("\\)")) {
                localStr = localStr.replaceAll("(?<!\\\\)\\)", "\\\\)");
            }
            if (localStr.contains("\b")) {
                localStr = localStr.replaceAll("\b", "\\\\b");
            }
            if (localStr.contains("\n")) {
                localStr = localStr.replaceAll("\n", "\\\\n");
            }
            if (localStr.contains("\f")) {
                localStr = localStr.replaceAll("\f", "\\\\f");
            }
        }
        return '(' + localStr + ')';
    }
}

