/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation.utils;

import org.jpedal.io.annotation.utils.AnnotLEX;
import org.jpedal.io.annotation.utils.AnnotObject;

public class AnnotNumber
implements AnnotObject {
    private Integer intVal;
    private Float floatVal;
    private int decimalPlaces;

    public AnnotNumber(Float val, int decimalPlaces) {
        this.floatVal = val;
        this.decimalPlaces = decimalPlaces;
    }

    public AnnotNumber(Integer val) {
        this.intVal = val;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public byte[] toByteArray() {
        if (this.intVal != null) {
            return AnnotLEX.textToBytes(this.intVal.toString());
        }
        if (this.decimalPlaces > 0) {
            return AnnotLEX.textToBytes(String.format("%." + this.decimalPlaces + 'f', this.floatVal));
        }
        return AnnotLEX.textToBytes(this.floatVal.toString());
    }

    @Override
    public String toText() {
        if (this.intVal != null) {
            return this.intVal.toString();
        }
        if (this.decimalPlaces > 0) {
            return String.format("%." + this.decimalPlaces + 'f', this.floatVal);
        }
        return this.floatVal.toString();
    }

    public Number toValue() {
        if (this.intVal != null) {
            return this.intVal;
        }
        return this.floatVal;
    }
}

