/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation.utils;

import java.util.Arrays;
import org.jpedal.io.annotation.utils.AnnotDict;
import org.jpedal.io.annotation.utils.AnnotName;
import org.jpedal.io.annotation.utils.AnnotOREF;
import org.jpedal.io.annotation.utils.AnnotObject;

public final class AnnotLEX {
    private static final int[] delimiters = new int[]{37, 40, 41, 47, 60, 62, 91, 93, 123, 125};

    private AnnotLEX() {
    }

    public static boolean isWhiteSpace(int ch) {
        return Character.isWhitespace((char)ch);
    }

    public static boolean isEOL(int ch) {
        return ch == 10 || ch == 13;
    }

    public static boolean isDelimiter(int ch) {
        return Arrays.stream(delimiters).anyMatch(value -> value == ch);
    }

    public static boolean isComment(int ch) {
        return ch == 37;
    }

    public static boolean isBacklash(int ch) {
        return ch == 92;
    }

    public static boolean isEscSeq(int ch1, int ch2) {
        if (ch1 == 252) {
            switch (ch2) {
                case 10: 
                case 13: 
                case 40: 
                case 41: 
                case 92: 
                case 98: 
                case 102: 
                case 110: 
                case 114: 
                case 116: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isDigit(int ch) {
        return Character.isDigit(ch);
    }

    public static boolean isBoolean(AnnotObject x2) {
        return x2.getType() == 0;
    }

    public static boolean isNull(AnnotObject x2) {
        return x2.getType() == 7;
    }

    public static boolean isNumber(AnnotObject x2) {
        return x2.getType() == 3;
    }

    public static boolean isString(AnnotObject x2) {
        return x2.getType() == 1;
    }

    public static boolean isHexString(AnnotObject x2) {
        return x2.getType() == 2;
    }

    public static boolean isDirectString(AnnotObject x2) {
        return x2.getType() == 9;
    }

    public static boolean isArray(AnnotObject x2) {
        return x2.getType() == 6;
    }

    public static boolean isName(AnnotObject x2) {
        return x2.getType() == 4;
    }

    public static boolean isDict(AnnotObject x2) {
        return x2.getType() == 5;
    }

    public static boolean isRef(AnnotObject x2) {
        return x2.getType() == 8;
    }

    public static boolean isStreamDict(AnnotDict x2) {
        return x2.keys.containsKey("Length");
    }

    public static boolean isObjStemDict(AnnotDict x2) {
        if (x2.keys.containsKey("Type")) {
            AnnotName type = (AnnotName)x2.keys.get("Type");
            return type.name.equals("ObjStm");
        }
        return false;
    }

    public static AnnotOREF getRefFromString(String s2) {
        String[] strs = s2.trim().split(" ");
        return new AnnotOREF(Integer.parseInt(strs[0]), Integer.parseInt(strs[1]));
    }

    public static String getZeroLead(int num) {
        StringBuilder numStr = new StringBuilder(String.valueOf(num));
        int balance = 10 - numStr.length();
        for (int i2 = 0; i2 < balance; ++i2) {
            numStr.insert(0, '0');
        }
        return numStr.toString();
    }

    public static String toPDFString(String str) {
        return str;
    }

    public static byte[] toBytes32(int num) {
        return new byte[]{(byte)((num & 0xFF000000) >> 24), (byte)((num & 0xFF0000) >> 16), (byte)((num & 0xFF00) >> 8), (byte)(num & 0xFF)};
    }

    public static byte[] textToBytes(String str) {
        byte[] bytes = new byte[str.length()];
        for (int i2 = 0; i2 < str.length(); ++i2) {
            bytes[i2] = (byte)(str.charAt(i2) & 0xFF);
        }
        return bytes;
    }

    public static String bytesToText(byte[] b2) {
        return new String(b2);
    }
}

