/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jpedal.io.annotation.utils.AnnotData;

public class AnnotFileData
implements AnnotData {
    private long pos;
    private final RandomAccessFile ra;
    private final long len;
    private long mp;
    private final byte[] temp;
    private int tSize = 4096;
    private long ts;
    private long te;

    public AnnotFileData(File file) throws IOException {
        this.ra = new RandomAccessFile(file, "r");
        this.len = file.length();
        if (this.len < (long)this.tSize) {
            this.tSize = (int)this.len;
        }
        this.temp = new byte[this.tSize];
        this.te = this.tSize;
        this.ra.read(this.temp);
    }

    @Override
    public int getByte() throws IOException {
        if (this.pos < this.len) {
            if (this.pos >= this.ts && this.pos < this.te) {
                int v2 = this.temp[(int)(this.pos - this.ts)] & 0xFF;
                ++this.pos;
                return v2;
            }
            this.ts = this.pos;
            this.te = this.ts + (long)this.tSize;
            this.ra.seek(this.pos);
            int max = Math.min((int)(this.len - this.pos), this.tSize);
            this.ra.read(this.temp, 0, max);
            ++this.pos;
            return this.temp[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int getByte(long p2) throws IOException {
        if (p2 < this.len) {
            if (p2 >= this.ts && p2 < this.te) {
                return this.temp[(int)(p2 - this.ts)] & 0xFF;
            }
            this.ra.seek(p2);
            int v2 = this.ra.read();
            this.ra.seek(this.pos);
            return v2;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.ra.close();
    }

    @Override
    public void movePos(long p2) {
        this.pos = p2;
    }

    @Override
    public void mark() {
        this.mp = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mp;
    }

    @Override
    public long getPos() {
        return this.pos;
    }
}

