/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.annotation.utils.AnnotArray;
import org.jpedal.io.annotation.utils.AnnotBuffer;
import org.jpedal.io.annotation.utils.AnnotInfo;
import org.jpedal.io.annotation.utils.AnnotLEX;
import org.jpedal.io.annotation.utils.AnnotName;
import org.jpedal.io.annotation.utils.AnnotNumber;
import org.jpedal.io.annotation.utils.AnnotObject;
import org.jpedal.io.filter.Predictor;
import org.jpedal.utils.LogWriter;

public class AnnotDict
implements AnnotObject {
    public AnnotBuffer rawStream;
    public final LinkedHashMap<String, AnnotObject> keys = new LinkedHashMap();

    @Override
    public int getType() {
        return 5;
    }

    public AnnotBuffer getStream(AnnotInfo info) throws IOException {
        AnnotObject filter = this.keys.get("Filter");
        byte[] res = AnnotDict.getRes(filter, this.rawStream);
        AnnotObject decodeParms = this.keys.get("DecodeParms");
        if (decodeParms != null) {
            int predictor = 1;
            int colors = 1;
            int bitsPerComponent = 8;
            int columns = 1;
            if (AnnotLEX.isArray(decodeParms)) {
                AnnotArray da = (AnnotArray)decodeParms;
                int ii = da.items.size();
                for (int i2 = 0; i2 < ii; ++i2) {
                    AnnotDict decodeDict = (AnnotDict)info.mainBuffer.getObjectValue(da.items.get(i2));
                    AnnotObject tt = decodeDict.keys.get("Predictor");
                    if (tt != null) {
                        predictor = ((AnnotNumber)tt).toValue().intValue();
                    }
                    if ((tt = decodeDict.keys.get("Colors")) != null) {
                        colors = ((AnnotNumber)tt).toValue().intValue();
                    }
                    if ((tt = decodeDict.keys.get("BitsPerComponent")) != null) {
                        bitsPerComponent = ((AnnotNumber)tt).toValue().intValue();
                    }
                    if ((tt = decodeDict.keys.get("Columns")) == null) continue;
                    columns = ((AnnotNumber)tt).toValue().intValue();
                }
            } else {
                AnnotDict decodeDict = (AnnotDict)info.mainBuffer.getObjectValue(decodeParms);
                AnnotObject tt = decodeDict.keys.get("Predictor");
                if (tt != null) {
                    predictor = ((AnnotNumber)tt).toValue().intValue();
                }
                if ((tt = decodeDict.keys.get("Colors")) != null) {
                    colors = ((AnnotNumber)tt).toValue().intValue();
                }
                if ((tt = decodeDict.keys.get("BitsPerComponent")) != null) {
                    bitsPerComponent = ((AnnotNumber)tt).toValue().intValue();
                }
                if ((tt = decodeDict.keys.get("Columns")) != null) {
                    columns = ((AnnotNumber)tt).toValue().intValue();
                }
            }
            if (predictor != 1) {
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(res);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    Predictor.applyPredictor(predictor, bis, bos, colors, bitsPerComponent, columns);
                    res = bos.toByteArray();
                }
                catch (Exception e2) {
                    throw new IOException(e2.getMessage());
                }
            }
        }
        return new AnnotBuffer(res, info);
    }

    private static byte[] getRes(AnnotObject filter, AnnotBuffer rawStream) throws IOException {
        byte[] res;
        block7: {
            res = new byte[rawStream.getByteData().length];
            System.arraycopy(rawStream.getByteData(), 0, res, 0, rawStream.length);
            if (filter == null) break block7;
            if (AnnotLEX.isArray(filter)) {
                AnnotArray ff = (AnnotArray)filter;
                int ii = ff.items.size();
                for (int i2 = 0; i2 < ii; ++i2) {
                    PdfFilteredReader fr = new PdfFilteredReader();
                    AnnotName fa = (AnnotName)ff.items.get(i2);
                    try {
                        res = fr.getDecodedData(res, 0, 0, null, null, null, AnnotDict.getFilterID(fa.name), null);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new IOException(ex.getMessage());
                    }
                }
            } else {
                AnnotName fa = (AnnotName)filter;
                PdfFilteredReader fr = new PdfFilteredReader();
                try {
                    res = fr.getDecodedData(res, 0, 0, null, null, null, AnnotDict.getFilterID(fa.name), null);
                }
                catch (Exception ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }
        return res;
    }

    private static int getFilterID(String filterName) {
        if ("A85".equals(filterName)) {
            return 1116165;
        }
        if ("AHx".equals(filterName)) {
            return 0x111848;
        }
        if ("ASCII85Decode".equals(filterName)) {
            return 1582784916;
        }
        if ("ASCIIHexDecode".equals(filterName)) {
            return 2074112677;
        }
        if ("CCF".equals(filterName)) {
            return 0x131316;
        }
        if ("CCITTFaxDecode".equals(filterName)) {
            return 2108391315;
        }
        if ("Crypt".equals(filterName)) {
            return 1112096855;
        }
        if ("DCTDecode".equals(filterName)) {
            return 1180911742;
        }
        if ("F1".equals(filterName)) {
            return 5692;
        }
        if ("FlateDecode".equals(filterName)) {
            return 2005566619;
        }
        if ("JBIG2Decode".equals(filterName)) {
            return 1247500931;
        }
        if ("JPXDecode".equals(filterName)) {
            return 1399277700;
        }
        if ("LZW".equals(filterName)) {
            return 1845799;
        }
        if ("LZWDecode".equals(filterName)) {
            return 1566984326;
        }
        if ("RL".equals(filterName)) {
            return 8732;
        }
        if ("RunLengthDecode".equals(filterName)) {
            return -1815163937;
        }
        return -1;
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream sb = new ByteArrayOutputStream();
        try {
            sb.write("<<".getBytes(StandardCharsets.UTF_8));
            for (String k2 : this.keys.keySet()) {
                if (this.keys.get(k2) == null) continue;
                sb.write(47);
                sb.write(k2.getBytes(StandardCharsets.UTF_8));
                sb.write(32);
                AnnotObject obj = this.keys.get(k2);
                sb.write(obj.toByteArray());
                sb.write(32);
            }
            sb.write(">>".getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e2) {
            LogWriter.writeLog(e2);
        }
        return sb.toByteArray();
    }

    @Override
    public String toText() {
        StringBuilder sb = new StringBuilder();
        sb.append("<<");
        for (String k2 : this.keys.keySet()) {
            sb.append('/');
            sb.append(k2);
            sb.append(' ');
            AnnotObject obj = this.keys.get(k2);
            sb.append(obj.toText());
            sb.append(' ');
        }
        sb.append(">>");
        return sb.toString();
    }
}

