/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jpedal.io.annotation.utils.AnnotArray;
import org.jpedal.io.annotation.utils.AnnotBoolean;
import org.jpedal.io.annotation.utils.AnnotByteData;
import org.jpedal.io.annotation.utils.AnnotData;
import org.jpedal.io.annotation.utils.AnnotDict;
import org.jpedal.io.annotation.utils.AnnotFileData;
import org.jpedal.io.annotation.utils.AnnotHexString;
import org.jpedal.io.annotation.utils.AnnotInfo;
import org.jpedal.io.annotation.utils.AnnotLEX;
import org.jpedal.io.annotation.utils.AnnotName;
import org.jpedal.io.annotation.utils.AnnotNull;
import org.jpedal.io.annotation.utils.AnnotNumber;
import org.jpedal.io.annotation.utils.AnnotOBJOFF;
import org.jpedal.io.annotation.utils.AnnotOREF;
import org.jpedal.io.annotation.utils.AnnotObject;
import org.jpedal.io.annotation.utils.AnnotString;
import org.jpedal.io.annotation.utils.AnnotUnknown;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.utils.NumberUtils;

public class AnnotBuffer {
    private final AnnotData dr;
    private final AnnotInfo annotInfo;
    public final int length;
    private byte[] byteData;
    final HashMap<Integer, AnnotObject> updatedObjects;
    int[] objectOrderForFile;

    public AnnotBuffer(byte[] data, AnnotInfo annotInfo) {
        this.dr = new AnnotByteData(data);
        this.annotInfo = annotInfo;
        this.length = data.length;
        this.byteData = data;
        this.updatedObjects = new HashMap();
    }

    public AnnotBuffer(File file, AnnotInfo annotInfo) throws IOException {
        this.dr = new AnnotFileData(file);
        this.annotInfo = annotInfo;
        this.length = (int)file.length();
        this.updatedObjects = new HashMap();
    }

    public void close() throws IOException {
        this.dr.close();
    }

    private int getByte() throws IOException {
        return this.dr.getByte();
    }

    private int getByte(long seekPos) throws IOException {
        return this.dr.getByte(seekPos);
    }

    public void movePos(long p2) {
        this.dr.movePos(p2);
    }

    private void mark() {
        this.dr.mark();
    }

    private void reset() {
        this.dr.reset();
    }

    private String getNextLine() throws IOException {
        StringBuilder bb2 = new StringBuilder();
        int v2 = this.getByte();
        boolean getNextByte = true;
        block4: while (getNextByte) {
            switch (v2) {
                case 13: {
                    if (this.getByte(this.dr.getPos()) == 10) {
                        this.getByte();
                    }
                    getNextByte = false;
                    continue block4;
                }
                case 10: {
                    getNextByte = false;
                    continue block4;
                }
            }
            bb2.append((char)v2);
            v2 = this.getByte();
            getNextByte = v2 != -1;
        }
        return bb2.toString();
    }

    private void skipLine() throws IOException {
        int v2 = this.getByte();
        boolean process = true;
        block4: while (process) {
            switch (v2) {
                case -1: 
                case 10: {
                    process = false;
                    continue block4;
                }
                case 13: {
                    if (this.getByte(this.dr.getPos()) == 10) {
                        v2 = this.getByte();
                    }
                    process = false;
                    continue block4;
                }
            }
            v2 = this.getByte();
        }
    }

    private AnnotNumber getNumberValue() throws IOException {
        int n2;
        int v2 = this.getByte();
        int multi = 1;
        int decimalPlaces = -1;
        if (v2 == 43) {
            v2 = this.getByte();
        } else if (v2 == 45) {
            multi = -1;
            v2 = this.getByte();
        }
        StringBuilder sb = new StringBuilder();
        if (v2 == 46) {
            sb.append("0.");
            v2 = this.getByte();
            decimalPlaces += 2;
        }
        if (v2 < 48 || v2 > 57) {
            return new AnnotNumber(0);
        }
        sb.append((char)v2);
        while ((n2 = this.getByte(this.dr.getPos())) == 46 || AnnotLEX.isDigit(n2)) {
            if (n2 == 46 || decimalPlaces >= 0) {
                ++decimalPlaces;
            }
            v2 = this.getByte();
            sb.append((char)v2);
        }
        String numStr = sb.toString();
        if (decimalPlaces > 0) {
            return new AnnotNumber(Float.valueOf((float)multi * Float.parseFloat(numStr)), decimalPlaces);
        }
        return new AnnotNumber(multi * Integer.parseInt(numStr));
    }

    private String getNameValue() throws IOException {
        int n2;
        StringBuilder sb = new StringBuilder();
        this.getByte();
        while ((n2 = this.getByte(this.dr.getPos())) >= 0 && !AnnotLEX.isDelimiter(n2) && !AnnotLEX.isWhiteSpace(n2)) {
            sb.append((char)this.getByte());
        }
        return sb.toString();
    }

    private AnnotString getNormalString() throws IOException {
        ByteArrayOutputStream bb2 = new ByteArrayOutputStream();
        this.getByte();
        int pCount = 1;
        int v2 = this.getByte();
        boolean finished = false;
        while (true) {
            switch (v2) {
                case -1: {
                    finished = true;
                    break;
                }
                case 40: {
                    bb2.write(v2 & 0xFF);
                    ++pCount;
                    break;
                }
                case 41: {
                    if (--pCount != 0) {
                        bb2.write(v2 & 0xFF);
                        break;
                    }
                    finished = true;
                    break;
                }
                case 92: {
                    bb2.write(v2 & 0xFF);
                    v2 = this.getByte();
                    if (v2 == -1) {
                        finished = true;
                        break;
                    }
                    this.handleEscapeCharacter(v2, bb2);
                    break;
                }
                default: {
                    bb2.write(v2 & 0xFF);
                }
            }
            if (finished) break;
            v2 = this.getByte();
        }
        return new AnnotString(new String(bb2.toByteArray(), StandardCharsets.UTF_8), bb2.toByteArray());
    }

    private void handleEscapeCharacter(int v2, ByteArrayOutputStream bb2) throws IOException {
        switch (v2) {
            case 110: {
                bb2.write(110);
                break;
            }
            case 114: {
                bb2.write(114);
                break;
            }
            case 116: {
                bb2.write(116);
                break;
            }
            case 98: {
                bb2.write(98);
                break;
            }
            case 102: {
                bb2.write(102);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                bb2.write(v2 & 0xFF);
                int b1 = this.getByte(this.dr.getPos() + 1L);
                if (b1 < 48 || b1 > 55) break;
                bb2.write(this.getByte() & 0xFF);
                int b2 = this.getByte(this.dr.getPos() + 1L);
                if (b2 < 48 || b2 > 55) break;
                bb2.write(this.getByte() & 0xFF);
                break;
            }
            default: {
                bb2.write(v2 & 0xFF);
            }
        }
    }

    private AnnotHexString getHexString() throws IOException {
        this.getByte();
        int ch = this.getByte();
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        while (true) {
            if (ch < 0 || ch == 62) break;
            if (AnnotLEX.isWhiteSpace(ch)) {
                ch = this.getByte();
                continue;
            }
            sb.append((char)ch);
            ch = this.getByte();
        }
        sb.append('>');
        return new AnnotHexString(sb.toString());
    }

    private AnnotArray getArray() throws IOException {
        this.getByte();
        AnnotArray arr = new AnnotArray();
        List<AnnotObject> res = arr.items;
        ByteArrayOutputStream unknownValue = new ByteArrayOutputStream();
        boolean readingArray = true;
        block13: while (readingArray) {
            int n2 = this.getByte(this.dr.getPos());
            switch (n2) {
                case -1: {
                    readingArray = false;
                    continue block13;
                }
                case 32: {
                    if (unknownValue.size() > 0) {
                        res.add(new AnnotUnknown(unknownValue.toByteArray()));
                        unknownValue.reset();
                    }
                    this.getByte();
                    continue block13;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.addNumberToArray(res);
                    continue block13;
                }
                case 47: {
                    res.add(new AnnotName(this.getNameValue()));
                    continue block13;
                }
                case 40: {
                    res.add(this.getNormalString());
                    continue block13;
                }
                case 60: {
                    if (this.getByte(this.dr.getPos() + 1L) == 60) {
                        res.add(this.getDictionary());
                        continue block13;
                    }
                    res.add(this.getHexString());
                    continue block13;
                }
                case 91: {
                    res.add(this.getArray());
                    continue block13;
                }
                case 93: {
                    this.getByte();
                    readingArray = false;
                    continue block13;
                }
                case 116: {
                    this.handlePossibleTrueForArray(res);
                    continue block13;
                }
                case 102: {
                    this.handlePossibleFalseForArray(res);
                    continue block13;
                }
                case 110: {
                    this.handlePossibleNullForArray(res);
                    continue block13;
                }
            }
            unknownValue.write(n2);
            this.getByte();
        }
        unknownValue.close();
        return arr;
    }

    private void handlePossibleNullForArray(List<AnnotObject> res) throws IOException {
        if (this.getByte(this.dr.getPos() + 1L) == 117 && this.getByte(this.dr.getPos() + 2L) == 108 && this.getByte(this.dr.getPos() + 3L) == 108) {
            res.add(null);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.getByte();
            }
        } else {
            this.getByte();
        }
    }

    private void handlePossibleFalseForArray(List<AnnotObject> res) throws IOException {
        if (this.getByte(this.dr.getPos() + 1L) == 97 && this.getByte(this.dr.getPos() + 2L) == 108 && this.getByte(this.dr.getPos() + 3L) == 115 && this.getByte(this.dr.getPos() + 4L) == 101) {
            res.add(new AnnotBoolean(false));
            for (int i2 = 0; i2 < 5; ++i2) {
                this.getByte();
            }
        } else {
            this.getByte();
        }
    }

    private void handlePossibleTrueForArray(List<AnnotObject> res) throws IOException {
        if (this.getByte(this.dr.getPos() + 1L) == 114 && this.getByte(this.dr.getPos() + 2L) == 117 && this.getByte(this.dr.getPos() + 3L) == 101) {
            res.add(new AnnotBoolean(true));
            for (int i2 = 0; i2 < 4; ++i2) {
                this.getByte();
            }
        } else {
            this.getByte();
        }
    }

    private void addNumberToArray(List<AnnotObject> res) throws IOException {
        AnnotNumber number = this.getNumberValue();
        this.mark();
        int whitespaceCount = this.skipWhiteSpace();
        int possibleGeneration = this.getByte(this.dr.getPos());
        if (whitespaceCount > 0 && AnnotLEX.isDigit(possibleGeneration)) {
            AnnotNumber generation = this.getNumberValue();
            this.skipWhiteSpace();
            int referenceMarker = this.getByte();
            int n4 = this.getByte(this.dr.getPos());
            if (referenceMarker == 82 && (AnnotLEX.isWhiteSpace(n4) || AnnotLEX.isDelimiter(n4))) {
                res.add(new AnnotOREF(number.toValue().intValue(), generation.toValue().intValue()));
            } else {
                res.add(number);
                this.reset();
            }
        } else {
            res.add(number);
        }
    }

    private int skipWhiteSpace() throws IOException {
        int nextPos = 0;
        while (Character.isWhitespace(this.getByte(this.dr.getPos() + (long)nextPos))) {
            ++nextPos;
        }
        this.dr.movePos(this.dr.getPos() + (long)nextPos);
        return nextPos;
    }

    private AnnotDict getDictionary() throws IOException {
        AnnotDict dictObj = new AnnotDict();
        this.getByte();
        this.getByte();
        ArrayDeque<AnnotName> nameBuf = new ArrayDeque<AnnotName>();
        boolean canRead = true;
        block12: while (canRead) {
            int n2 = this.getByte(this.dr.getPos());
            switch (n2) {
                case -1: {
                    return dictObj;
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.handleNumber(dictObj, nameBuf);
                    continue block12;
                }
                case 47: {
                    this.handleName(dictObj, nameBuf);
                    continue block12;
                }
                case 40: {
                    this.handleLiteralString(dictObj, nameBuf);
                    continue block12;
                }
                case 60: {
                    if (this.getByte(this.dr.getPos() + 1L) == 60) {
                        this.handleStartOfDictionary(dictObj, nameBuf);
                        continue block12;
                    }
                    this.handleHexString(dictObj, nameBuf);
                    continue block12;
                }
                case 91: {
                    this.handleArray(dictObj, nameBuf);
                    continue block12;
                }
                case 116: {
                    this.handleTrueValue(dictObj, nameBuf);
                    continue block12;
                }
                case 102: {
                    this.handleFalseValue(dictObj, nameBuf);
                    continue block12;
                }
                case 110: {
                    this.hanleNullValue(dictObj, nameBuf);
                    continue block12;
                }
                case 62: {
                    canRead = this.hanleEndOfDictionary();
                    continue block12;
                }
            }
            this.getByte();
        }
        if (this.streamFollowsDict()) {
            this.updateStream(dictObj);
        }
        return dictObj;
    }

    private boolean streamFollowsDict() throws IOException {
        this.skipWhiteSpace();
        int n2 = this.getByte(this.dr.getPos());
        if (n2 == 115 && this.getByte(this.dr.getPos() + 1L) == 116 && this.getByte(this.dr.getPos() + 2L) == 114 && this.getByte(this.dr.getPos() + 3L) == 101 && this.getByte(this.dr.getPos() + 4L) == 97 && this.getByte(this.dr.getPos() + 5L) == 109) {
            return true;
        }
        if (n2 == -1) {
            return false;
        }
        return false;
    }

    private static void addAnnotToDictionary(AnnotDict dictObj, AnnotObject annotObject, ArrayDeque<AnnotName> nameBuf) {
        AnnotName k2 = nameBuf.pop();
        String key = k2.name;
        dictObj.keys.put(key, annotObject);
    }

    private boolean hanleEndOfDictionary() throws IOException {
        boolean canRead = true;
        this.getByte();
        if (this.getByte(this.dr.getPos()) == 62) {
            this.getByte();
            canRead = false;
        }
        return canRead;
    }

    private void hanleNullValue(AnnotDict dictObj, ArrayDeque<AnnotName> nameBuf) throws IOException {
        if (this.getByte(this.dr.getPos() + 1L) == 117 && this.getByte(this.dr.getPos() + 2L) == 108 && this.getByte(this.dr.getPos() + 3L) == 108) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.getByte();
            }
            if (!nameBuf.isEmpty()) {
                AnnotBuffer.addAnnotToDictionary(dictObj, new AnnotNull(), nameBuf);
            }
        } else {
            this.getByte();
        }
    }

    private void handleFalseValue(AnnotDict dictObj, ArrayDeque<AnnotName> nameBuf) throws IOException {
        if (this.getByte(this.dr.getPos() + 1L) == 97 && this.getByte(this.dr.getPos() + 2L) == 108 && this.getByte(this.dr.getPos() + 3L) == 115 && this.getByte(this.dr.getPos() + 4L) == 101) {
            for (int i2 = 0; i2 < 5; ++i2) {
                this.getByte();
            }
            if (!nameBuf.isEmpty()) {
                AnnotBuffer.addAnnotToDictionary(dictObj, new AnnotBoolean(false), nameBuf);
            }
        } else {
            this.getByte();
        }
    }

    private void handleTrueValue(AnnotDict dictObj, ArrayDeque<AnnotName> nameBuf) throws IOException {
        if (this.getByte(this.dr.getPos() + 1L) == 114 && this.getByte(this.dr.getPos() + 2L) == 117 && this.getByte(this.dr.getPos() + 3L) == 101) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.getByte();
            }
            if (!nameBuf.isEmpty()) {
                AnnotBuffer.addAnnotToDictionary(dictObj, new AnnotBoolean(true), nameBuf);
            }
        } else {
            this.getByte();
        }
    }

    private void handleLiteralString(AnnotDict dictObj, ArrayDeque<AnnotName> nameBuf) throws IOException {
        AnnotString nStr = this.getNormalString();
        if (!nameBuf.isEmpty()) {
            AnnotBuffer.addAnnotToDictionary(dictObj, nStr, nameBuf);
        }
    }

    private void handleArray(AnnotDict dictObj, ArrayDeque<AnnotName> nameBuf) throws IOException {
        AnnotArray arr = this.getArray();
        if (!nameBuf.isEmpty()) {
            AnnotBuffer.addAnnotToDictionary(dictObj, arr, nameBuf);
        }
    }

    private void handleStartOfDictionary(AnnotDict dictObj, ArrayDeque<AnnotName> nameBuf) throws IOException {
        AnnotDict dict = this.getDictionary();
        if (!nameBuf.isEmpty()) {
            AnnotBuffer.addAnnotToDictionary(dictObj, dict, nameBuf);
        }
    }

    private void handleHexString(AnnotDict dictObj, ArrayDeque<AnnotName> nameBuf) throws IOException {
        AnnotHexString hStr = this.getHexString();
        if (!nameBuf.isEmpty()) {
            AnnotBuffer.addAnnotToDictionary(dictObj, hStr, nameBuf);
        }
    }

    private void handleName(AnnotDict dictObj, ArrayDeque<AnnotName> nameBuf) throws IOException {
        String str = this.getNameValue();
        AnnotName aName = new AnnotName(str);
        if (nameBuf.isEmpty()) {
            nameBuf.push(aName);
        } else {
            AnnotName k2 = nameBuf.pop();
            String key = k2.name;
            dictObj.keys.put(key, aName);
        }
    }

    private void handleNumber(AnnotDict dictObj, ArrayDeque<AnnotName> nameBuf) throws IOException {
        AnnotNumber n1 = this.getNumberValue();
        int sp = this.getByte(this.dr.getPos());
        int n2 = this.getByte(this.dr.getPos() + 1L);
        if (!nameBuf.isEmpty()) {
            AnnotName k2 = nameBuf.pop();
            String key = k2.name;
            if (AnnotLEX.isWhiteSpace(sp) && AnnotLEX.isDigit(n2)) {
                this.getByte();
                n2 = this.getNumberValue().toValue().intValue();
                this.getByte();
                this.getByte();
                dictObj.keys.put(key, new AnnotOREF(n1.toValue().intValue(), n2));
            } else {
                dictObj.keys.put(key, n1);
            }
        }
    }

    private void updateStream(AnnotDict dictObj) throws IOException {
        int n2;
        while (true) {
            int n3;
            if ((n3 = this.getByte(this.dr.getPos())) == 115 && this.getByte(this.dr.getPos() + 1L) == 116 && this.getByte(this.dr.getPos() + 2L) == 114 && this.getByte(this.dr.getPos() + 3L) == 101 && this.getByte(this.dr.getPos() + 4L) == 97 && this.getByte(this.dr.getPos() + 5L) == 109) {
                for (int i2 = 0; i2 < 6; ++i2) {
                    this.getByte();
                }
                break;
            }
            if (n3 == -1) {
                return;
            }
            this.getByte();
        }
        this.skipLine();
        long oldPos = this.dr.getPos();
        this.movePos(oldPos);
        ByteArrayOutputStream streamBuilder = new ByteArrayOutputStream();
        while ((n2 = this.getByte(this.dr.getPos())) != -1) {
            if (n2 == 101 && this.getByte(this.dr.getPos() + 1L) == 110 && this.getByte(this.dr.getPos() + 2L) == 100 && this.getByte(this.dr.getPos() + 3L) == 115 && this.getByte(this.dr.getPos() + 4L) == 116 && this.getByte(this.dr.getPos() + 5L) == 114 && this.getByte(this.dr.getPos() + 6L) == 101 && this.getByte(this.dr.getPos() + 7L) == 97 && this.getByte(this.dr.getPos() + 8L) == 109) {
                for (int i3 = 0; i3 < 9; ++i3) {
                    this.getByte();
                }
                break;
            }
            streamBuilder.write(this.getByte());
        }
        dictObj.rawStream = new AnnotBuffer(streamBuilder.toByteArray(), this.annotInfo);
    }

    public AnnotObject getObjectValue(AnnotObject obj) throws IOException {
        if (AnnotLEX.isRef(obj)) {
            int refNum = ((AnnotOREF)obj).num;
            if (this.updatedObjects.containsKey(refNum)) {
                return this.updatedObjects.get(refNum);
            }
            AnnotObject io = this.getIndirectObject(obj);
            return this.getObjectValue(io);
        }
        return obj;
    }

    private AnnotObject getIndirectObject(AnnotObject oo) throws IOException {
        AnnotOREF objRef = (AnnotOREF)oo;
        AnnotOBJOFF objoff = this.annotInfo.offsetMap.get(objRef.num);
        if (objoff != null) {
            long offset = objoff.offset;
            AnnotBuffer subBuffer = objoff.data;
            boolean isStream = objoff.isStream;
            if (isStream) {
                if (objoff.data != null) {
                    subBuffer.movePos(offset);
                    return subBuffer.getObj();
                }
                return new AnnotNull();
            }
            subBuffer.movePos(offset);
            while (true) {
                int n2;
                if ((n2 = subBuffer.getByte(this.dr.getPos())) == -1) {
                    return new AnnotNull();
                }
                if (n2 == 111 && subBuffer.getByte(subBuffer.dr.getPos() + 1L) == 98 && subBuffer.getByte(subBuffer.dr.getPos() + 2L) == 106) {
                    for (int i2 = 0; i2 < 3; ++i2) {
                        subBuffer.getByte();
                    }
                    break;
                }
                subBuffer.getByte();
            }
            return subBuffer.getObj();
        }
        return new AnnotNull();
    }

    private AnnotObject getObj() throws IOException {
        boolean inComment = false;
        block13: while (true) {
            int n2 = this.getByte(this.dr.getPos());
            if (!inComment) {
                switch (n2) {
                    case -1: {
                        return new AnnotNull();
                    }
                    case 37: {
                        inComment = true;
                        continue block13;
                    }
                    case 43: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        return this.handle2EValue();
                    }
                    case 47: {
                        return new AnnotName(this.getNameValue());
                    }
                    case 40: {
                        return this.getNormalString();
                    }
                    case 60: {
                        if (this.getByte(this.dr.getPos() + 1L) == 60) {
                            return this.getDictionary();
                        }
                        return this.getHexString();
                    }
                    case 91: {
                        return this.getArray();
                    }
                    case 116: {
                        if (this.isCurrentValueTrue()) {
                            return new AnnotBoolean(true);
                        }
                    }
                    case 101: {
                        if (this.getByte(this.dr.getPos() + 1L) == 110 && this.getByte(this.dr.getPos() + 2L) == 100 && this.getByte(this.dr.getPos() + 3L) == 111 && this.getByte(this.dr.getPos() + 4L) == 98 && this.getByte(this.dr.getPos() + 5L) == 106) {
                            return new AnnotUnknown();
                        }
                    }
                    case 102: {
                        if (this.isCurrentValueFalse()) {
                            return new AnnotBoolean(false);
                        }
                    }
                    case 110: {
                        if (!this.isCurrentValueNull()) break;
                        return new AnnotNull();
                    }
                }
                this.getByte();
                continue;
            }
            this.getByte();
            if (n2 != 10 && n2 != 13 && n2 != -1) continue;
            inComment = false;
        }
    }

    private boolean isCurrentValueNull() throws IOException {
        if (this.getByte(this.dr.getPos() + 1L) == 117 && this.getByte(this.dr.getPos() + 2L) == 108 && this.getByte(this.dr.getPos() + 3L) == 108) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.getByte();
            }
            return true;
        }
        this.getByte();
        return false;
    }

    private boolean isCurrentValueFalse() throws IOException {
        if (this.getByte(this.dr.getPos() + 1L) == 97 && this.getByte(this.dr.getPos() + 2L) == 108 && this.getByte(this.dr.getPos() + 3L) == 115 && this.getByte(this.dr.getPos() + 4L) == 101) {
            for (int i2 = 0; i2 < 5; ++i2) {
                this.getByte();
            }
            return true;
        }
        this.getByte();
        return false;
    }

    private boolean isCurrentValueTrue() throws IOException {
        if (this.getByte(this.dr.getPos() + 1L) == 114 && this.getByte(this.dr.getPos() + 2L) == 117 && this.getByte(this.dr.getPos() + 3L) == 101) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.getByte();
            }
            return true;
        }
        this.getByte();
        return false;
    }

    private AnnotObject handle2EValue() throws IOException {
        AnnotNumber n1 = this.getNumberValue();
        int sp = this.getByte(this.dr.getPos());
        int n2 = this.getByte(this.dr.getPos() + 1L);
        int sp2 = this.getByte(this.dr.getPos() + 2L);
        int sp3 = this.getByte(this.dr.getPos() + 3L);
        if (AnnotLEX.isWhiteSpace(sp) && AnnotLEX.isDigit(n2) && AnnotLEX.isWhiteSpace(sp2) && sp3 == 82) {
            this.getByte();
            n2 = this.getNumberValue().toValue().intValue();
            this.getByte();
            this.getByte();
            return new AnnotOREF(n1.toValue().intValue(), n2);
        }
        if (AnnotLEX.isWhiteSpace(sp) && n2 == 48 && AnnotLEX.isWhiteSpace(sp2) && sp3 == 111) {
            this.getByte();
            this.getByte();
            return this.getObj();
        }
        return n1;
    }

    public void readSimpleXREF() throws IOException {
        HashSet<Long> seenPrevPositions = new HashSet<Long>();
        this.handleXRefSection(seenPrevPositions);
        seenPrevPositions.clear();
    }

    private void handleXRefSection(Set<Long> seenPrevPositions) throws IOException {
        long prevOffset;
        AnnotObject prev;
        AnnotObject obj;
        seenPrevPositions.add(this.dr.getPos());
        int nn = this.getByte(this.dr.getPos());
        if (AnnotLEX.isDigit(nn)) {
            this.readStreamXREF();
            return;
        }
        if (nn == 120 && this.getByte(this.dr.getPos() + 1L) == 114 && this.getByte(this.dr.getPos() + 2L) == 101 && this.getByte(this.dr.getPos() + 3L) == 102) {
            this.skipLine();
        } else if (!this.findMissingXRef()) {
            throw new IOException("Unable to find XRef table in file");
        }
        int start = this.getNumberValue().toValue().intValue();
        this.getByte();
        this.getNumberValue();
        this.skipLine();
        int objectCount = 0;
        while ((obj = this.getObj()).getType() == 3) {
            int objNum;
            int offset = ((AnnotNumber)obj).toValue().intValue();
            this.getObj();
            String end = this.getNextLine().trim();
            boolean used = "n".equals(end);
            if (start + objectCount == 0 || !used) {
                objNum = 0;
            } else {
                byte[] buffer = new byte[20];
                for (int j2 = 0; j2 < buffer.length; ++j2) {
                    buffer[j2] = (byte)this.dr.getByte(offset + j2);
                }
                int objStart = StreamReaderUtils.skipSpaces(buffer, 0);
                int ptr = StreamReaderUtils.skipToEndOfRef(buffer, objStart);
                objNum = NumberUtils.parseInt(objStart, ptr, buffer);
            }
            if (this.annotInfo.offsetMap.get(objNum) == null) {
                this.annotInfo.offsetMap.put(objNum, new AnnotOBJOFF(offset, this, false, used));
            }
            ++objectCount;
        }
        AnnotDict trailer = (AnnotDict)obj;
        if (this.annotInfo.mainCatalog == null) {
            this.annotInfo.mainCatalog = (AnnotOREF)trailer.keys.get("Root");
        }
        if ((prev = trailer.keys.get("Prev")) != null && !seenPrevPositions.contains(prevOffset = ((AnnotNumber)this.getObjectValue(prev)).toValue().longValue())) {
            this.movePos(prevOffset);
            seenPrevPositions.add(prevOffset);
            this.handleXRefSection(seenPrevPositions);
        }
        this.annotInfo.trailer = trailer;
    }

    private boolean findMissingXRef() throws IOException {
        for (int i2 = this.length - 10; i2 > 0; --i2) {
            int ch = this.getByte(i2);
            if (ch == 115 && this.getByte(i2 + 1) == 116 && this.getByte(i2 + 2) == 97 && this.getByte(i2 + 3) == 114 && this.getByte(i2 + 4) == 116 || this.getByte(i2 + 5) != 120 || this.getByte(i2 + 6) != 114 || this.getByte(i2 + 7) != 101 || this.getByte(i2 + 8) != 102) continue;
            this.movePos(i2 + 5);
            this.skipLine();
            return true;
        }
        return false;
    }

    private void readStreamXREF() throws IOException {
        AnnotObject prev;
        this.annotInfo.xrefType = 1;
        AnnotDict refDict = (AnnotDict)this.getObj();
        AnnotBuffer buf = refDict.getStream(this.annotInfo);
        AnnotArray wArrObj = (AnnotArray)refDict.keys.get("W");
        int[] wArr = new int[wArrObj.items.size()];
        for (int i2 = 0; i2 < wArr.length; ++i2) {
            wArr[i2] = ((AnnotNumber)wArrObj.items.get(i2)).toValue().intValue();
        }
        int[] indexArr = AnnotBuffer.getIntArray(refDict);
        int typeLen = wArr[0];
        int offsetLen = wArr[1];
        int generationLen = wArr[2];
        int total = indexArr.length;
        int p2 = 0;
        while (total > p2) {
            int start = indexArr[p2++];
            int end = start + indexArr[p2++];
            for (int i3 = start; i3 < end; ++i3) {
                int type = 0;
                int offset = 0;
                type = typeLen == 0 ? 1 : AnnotBuffer.getType(buf, typeLen, type);
                offset = AnnotBuffer.getType(buf, offsetLen, offset);
                if (this.annotInfo.offsetMap.get(i3) == null) {
                    switch (type) {
                        case 0: {
                            this.annotInfo.offsetMap.put(i3, new AnnotOBJOFF(offset, this.annotInfo.mainBuffer, false, false));
                            break;
                        }
                        case 1: {
                            this.annotInfo.offsetMap.put(i3, new AnnotOBJOFF(offset, this.annotInfo.mainBuffer, false, true));
                            break;
                        }
                        case 2: {
                            this.annotInfo.offsetMap.put(i3, new AnnotOBJOFF(offset, null, true, true));
                        }
                    }
                }
                for (int j2 = 0; j2 < generationLen; ++j2) {
                    buf.getByte();
                }
            }
        }
        if (this.annotInfo.mainCatalog == null) {
            this.annotInfo.mainCatalog = (AnnotOREF)refDict.keys.get("Root");
        }
        if ((prev = refDict.keys.get("Prev")) != null) {
            int prevOffset = ((AnnotNumber)this.getObjectValue(prev)).toValue().intValue();
            this.movePos(prevOffset);
            this.readSimpleXREF();
        }
    }

    private static int[] getIntArray(AnnotDict refDict) {
        int[] indexArr;
        AnnotArray indexArrObj = (AnnotArray)refDict.keys.get("Index");
        if (indexArrObj == null) {
            int size = ((AnnotNumber)refDict.keys.get("Size")).toValue().intValue();
            indexArr = new int[]{0, size};
        } else {
            indexArr = new int[indexArrObj.items.size()];
            for (int i2 = 0; i2 < indexArr.length; ++i2) {
                indexArr[i2] = ((AnnotNumber)indexArrObj.items.get(i2)).toValue().intValue();
            }
        }
        return indexArr;
    }

    private static int getType(AnnotBuffer buf, int typeLen, int type) throws IOException {
        for (int j2 = 0; j2 < typeLen; ++j2) {
            type = type << 8 | buf.getByte();
        }
        return type;
    }

    public int findFirstXREFOffset() throws IOException {
        for (int i2 = this.length - 10; i2 > 0; --i2) {
            int ch = this.getByte(i2);
            if (ch != 115 || this.getByte(i2 + 1) != 116 || this.getByte(i2 + 2) != 97 || this.getByte(i2 + 3) != 114 || this.getByte(i2 + 4) != 116 || this.getByte(i2 + 5) != 120 || this.getByte(i2 + 6) != 114 || this.getByte(i2 + 7) != 101 || this.getByte(i2 + 8) != 102) continue;
            this.movePos(i2);
            this.skipLine();
            return ((AnnotNumber)this.getObj()).toValue().intValue();
        }
        return -1;
    }

    public void updateAllObjStm() throws IOException {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.annotInfo.offsetMap.maxKey; ++i2) {
            if (this.annotInfo.offsetMap.offs[i2] == null) continue;
            keys.add(i2);
        }
        for (Integer ee : keys) {
            AnnotDict dd;
            AnnotOREF tref = new AnnotOREF(ee, 0);
            AnnotObject tempD = this.getIndirectObject(tref);
            if (!AnnotLEX.isDict(tempD) || !AnnotLEX.isObjStemDict(dd = (AnnotDict)tempD)) continue;
            int nn = ((AnnotNumber)dd.keys.get("N")).toValue().intValue();
            int first = ((AnnotNumber)dd.keys.get("First")).toValue().intValue();
            AnnotBuffer subBuf = dd.getStream(this.annotInfo);
            for (int i3 = 0; i3 < nn; ++i3) {
                int id2 = subBuf.getNumberValue().toValue().intValue();
                subBuf.getByte();
                int offset = subBuf.getNumberValue().toValue().intValue();
                subBuf.getByte();
                AnnotOBJOFF objoff = new AnnotOBJOFF(first + offset, subBuf, true, true);
                if (this.annotInfo.offsetMap.offs[id2] != null) {
                    AnnotOBJOFF oo = this.annotInfo.offsetMap.get(id2);
                    if (!oo.isStream || oo.offset != (long)ee.intValue() || oo.data != null) continue;
                    this.annotInfo.offsetMap.put(id2, objoff);
                    continue;
                }
                this.annotInfo.offsetMap.put(id2, objoff);
            }
        }
    }

    public void updatePageOffsets() throws IOException {
        AnnotObject pageDict;
        AnnotDict mc = (AnnotDict)this.getObjectValue(this.annotInfo.mainCatalog);
        AnnotObject pageTree = mc.keys.get("Pages");
        if (pageTree != null && (pageDict = this.getObjectValue(pageTree)).getType() == 5) {
            this.getPagesFromPageTree((AnnotDict)pageDict);
        }
    }

    public String getPagesRef() throws IOException {
        AnnotDict mc = (AnnotDict)this.getObjectValue(this.annotInfo.mainCatalog);
        return AnnotLEX.bytesToText(mc.keys.get("Pages").toByteArray());
    }

    private void getPagesFromPageTree(AnnotDict pageTreeDict) throws IOException {
        ArrayList<AnnotOREF> offsets = new ArrayList<AnnotOREF>();
        this.getPagesOffsets(pageTreeDict, offsets, 1);
        this.annotInfo.pageOffsets = offsets.toArray(new AnnotOREF[0]);
    }

    private void getPagesOffsets(AnnotDict pageTreeDict, ArrayList<AnnotOREF> offsets, int lastPage) throws IOException {
        AnnotObject kidsObj = pageTreeDict.keys.get("Kids");
        AnnotArray kids = (AnnotArray)this.getObjectValue(kidsObj);
        int totalPages = kids.items.size();
        for (int i2 = 0; i2 < totalPages; ++i2) {
            AnnotObject kid = kids.items.get(i2);
            if (kid.getType() != 8) continue;
            AnnotDict kDict = (AnnotDict)this.getObjectValue(kid);
            AnnotName type = (AnnotName)kDict.keys.get("Type");
            AnnotObject kidsObj2 = kDict.keys.get("Kids");
            if (type != null && type.name.equals("Pages") || kidsObj2 != null) {
                this.getPagesOffsets(kDict, offsets, lastPage);
                AnnotArray kids2 = (AnnotArray)this.getObjectValue(kidsObj2);
                lastPage += kids2.items.size();
                continue;
            }
            if (type != null && !type.name.equals("Page")) continue;
            offsets.add((AnnotOREF)kid);
            ++lastPage;
        }
    }

    public byte[] getByteData() {
        return this.byteData;
    }

    public void updateObject(int ref, AnnotObject obj) {
        this.updatedObjects.put(ref, obj);
    }

    public int[] getObjectOrderForFile() {
        return this.objectOrderForFile;
    }

    public void setObjectOrderForFile(int[] objectOrderForFile) {
        this.objectOrderForFile = objectOrderForFile;
    }
}

