/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jpedal.io.annotation.utils.AnnotNumber;
import org.jpedal.io.annotation.utils.AnnotObject;
import org.jpedal.io.annotation.utils.AnnotString;
import org.jpedal.utils.LogWriter;

public class AnnotArray
implements AnnotObject {
    public final List<AnnotObject> items = new ArrayList<AnnotObject>();

    public AnnotArray() {
    }

    public AnnotArray(float[] ff) {
        for (float f2 : ff) {
            float fraction = f2 % 1.0f;
            if (fraction > 0.0f) {
                this.items.add(new AnnotNumber(Float.valueOf(f2), Float.toString(fraction).length() - 2));
                continue;
            }
            this.items.add(new AnnotNumber(Float.valueOf(f2), 0));
        }
    }

    public AnnotArray(int[] ff) {
        for (int f2 : ff) {
            this.items.add(new AnnotNumber(f2));
        }
    }

    public AnnotArray(String[] strings) {
        for (String s2 : strings) {
            this.items.add(new AnnotString(s2, s2.getBytes()));
        }
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public String toText() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (AnnotObject a10 : this.items) {
            if (a10 == null) continue;
            if (sb.length() != 1) {
                sb.append(' ');
            }
            sb.append(a10.toText());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream sb = new ByteArrayOutputStream();
        try {
            sb.write(91);
            for (AnnotObject a10 : this.items) {
                if (a10 == null) continue;
                if (sb.size() != 1) {
                    sb.write(32);
                }
                sb.write(a10.toByteArray());
            }
            sb.write(93);
        }
        catch (IOException e2) {
            LogWriter.writeLog(e2);
        }
        return sb.toByteArray();
    }
}

