/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import java.awt.Color;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;

public class WritableAnnotation {
    final float[] rect;
    private final AnnotationType type;
    private final int page;
    private int textSize = 10;
    float[] strokeColor = new float[]{0.0f, 0.0f, 0.0f};
    float[] nonStrokeColor = new float[]{1.0f, 1.0f, 1.0f};
    final FormObject form;
    int apRef = -1;
    int resRef = -1;

    WritableAnnotation(AnnotationType type, int page, float x0, float y0, float x1, float y1) {
        this.type = type;
        this.page = page;
        this.rect = new float[]{x0, y0, x1, y1};
        this.form = null;
    }

    WritableAnnotation(AnnotationType type, int page, float x0, float y0, float x1, float y1, FormObject form) {
        this.type = type;
        this.page = page;
        this.rect = new float[]{x0, y0, x1, y1};
        this.form = form;
    }

    String getTypeString() {
        switch (this.type) {
            case CARET: {
                return "Caret";
            }
            case CIRCLE: {
                return "Circle";
            }
            case FILEATTACHMENT: {
                return "FileAttachment";
            }
            case FREETEXT: {
                return "FreeText";
            }
            case HIGHLIGHT: {
                return "Highlight";
            }
            case INK: {
                return "Ink";
            }
            case LINK: {
                return "Link";
            }
            case LINE: {
                return "Line";
            }
            case POLYGON: {
                return "Polygon";
            }
            case POLYLINE: {
                return "PolyLine";
            }
            case SOUND: {
                return "Sound";
            }
            case SQUARE: {
                return "Square";
            }
            case SQUIGGLY: {
                return "Squiggly";
            }
            case STAMP: {
                return "Stamp";
            }
            case STRIKEOUT: {
                return "StrikeOut";
            }
            case TEXT: {
                return "Text";
            }
            case UNDERLINE: {
                return "Underline";
            }
        }
        return "null";
    }

    public int getPage() {
        return this.page;
    }

    int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
    }

    public void setNonStrokeColor(Color color) {
        this.nonStrokeColor = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
    }

    public float[] getStrokeColor() {
        return this.strokeColor;
    }

    public float[] getNonStrokeColor() {
        return this.nonStrokeColor;
    }

    String getStrokeColorString() {
        if (this.strokeColor == null) {
            return "";
        }
        return "/C [" + this.strokeColor[0] + ' ' + this.strokeColor[1] + ' ' + this.strokeColor[2] + ']';
    }

    String getNonStrokeColorString() {
        if (this.nonStrokeColor == null) {
            return "";
        }
        return "/IC [" + this.nonStrokeColor[0] + ' ' + this.nonStrokeColor[1] + ' ' + this.nonStrokeColor[2] + ']';
    }

    static String convertFloatArrayToString(float[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 4; ++i2) {
            sb.append(array[i2]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public FormObject getFormObject() {
        return this.form;
    }

    public String getDictString() {
        return null;
    }

    public String getPopupString(int parentObj) {
        LogWriter.writeLog("Popup not added to annotation object " + parentObj + "0 Obj. Popup for this annotation currently no supported.");
        return null;
    }

    public String getAPString(int parentObj) {
        this.apRef = parentObj;
        return null;
    }

    public byte[][] getResources(int parentObj) {
        this.resRef = parentObj;
        return new byte[0][];
    }

    public static enum AnnotationType {
        CARET,
        CIRCLE,
        FILEATTACHMENT,
        FREETEXT,
        HIGHLIGHT,
        INK,
        LINK,
        LINE,
        POLYGON,
        POLYLINE,
        SOUND,
        SQUARE,
        SQUIGGLY,
        STAMP,
        STRIKEOUT,
        TEXT,
        UNDERLINE;

    }
}

