/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class TextAnnotation
extends WritableAnnotation {
    private final String text;

    public TextAnnotation(int page, float x0, float y0, float x1, float y1, FormObject form) {
        super(WritableAnnotation.AnnotationType.TEXT, page, x0, y0, x1, y1, form);
        this.strokeColor = new float[]{0.1607f, 0.4784f, 0.8f};
        this.nonStrokeColor = null;
        this.text = null;
    }

    public TextAnnotation(int page, float x0, float y0, float x1, float y1, String text) {
        super(WritableAnnotation.AnnotationType.TEXT, page, x0, y0, x1, y1);
        this.strokeColor = new float[]{0.1607f, 0.4784f, 0.8f};
        this.nonStrokeColor = null;
        this.text = text;
    }

    @Override
    public String getDictString() {
        if (this.form != null && this.form.getNameAsConstant(608780341) == -1 && this.form.getNameAsConstant(1147962727) == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<</Type /Annot /Subtype /");
        sb.append(this.getTypeString());
        if (this.form != null) {
            float[] rect = this.form.getFloatArray(573911876);
            sb.append(" /Rect [ ");
            for (int i2 = 0; i2 < 4; ++i2) {
                sb.append(rect[i2]);
                sb.append(' ');
            }
            sb.append(']');
            float[] c2 = this.form.getFloatArray(19);
            if (c2 != null) {
                sb.append(" /C [ ");
                for (float aC2 : c2) {
                    sb.append(aC2);
                    sb.append(' ');
                }
                sb.append(']');
            }
            byte[] bContents = this.form.getTextStreamValueAsByte(1216184967);
            sb.append(" /Contents (");
            if (bContents != null) {
                sb.append(StringUtils.getTextString(bContents, true, true));
            }
            sb.append(')');
            sb.append(" /M (");
            sb.append(this.form.getTextStreamValue(29));
            sb.append(')');
            sb.append(" /T (");
            sb.append(this.form.getTextStreamValue(36));
            sb.append(')');
            sb.append(" /F ");
            sb.append(this.form.getInt(22));
            sb.append(' ');
            String name = this.form.getName(506543413);
            if (name != null && !name.isEmpty()) {
                sb.append(" /Name /");
                sb.append(name);
            }
            if (this.apRef != -1) {
                sb.append(" /AP << /N ");
                sb.append(this.apRef);
                sb.append(" 0 R >>");
            }
        } else {
            sb.append(" /Rect [ ");
            for (int i3 = 0; i3 < 4; ++i3) {
                sb.append(this.rect[i3]);
                sb.append(' ');
            }
            sb.append(']');
            sb.append(this.getStrokeColorString());
            sb.append(" /Contents (");
            sb.append(this.text);
            sb.append(')');
        }
        sb.append(">>");
        return sb.toString();
    }

    @Override
    public String getPopupString(int parentObj) {
        PdfObject popup;
        if (this.form != null && this.form.getNameAsConstant(608780341) == -1 && this.form.getNameAsConstant(1147962727) == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.form != null && (popup = this.form.getDictionary(1061176672)) != null) {
            sb.append("<</Type /Annot /Subtype /Popup");
            sb.append(" /Parent ");
            sb.append(parentObj);
            sb.append(" 0 R");
            float[] popupRect = popup.getFloatArray(573911876);
            if (popupRect != null) {
                sb.append(" /Rect [ ");
                for (int i2 = 0; i2 < 4; ++i2) {
                    sb.append(popupRect[i2]);
                    sb.append(' ');
                }
                sb.append(']');
            }
            sb.append(" /Open ");
            sb.append(popup.getBoolean(524301630));
            int fValue = popup.getInt(22);
            if (fValue != -1) {
                sb.append(" /F ");
                sb.append(fValue);
            }
            sb.append(">>");
            return sb.toString();
        }
        return null;
    }

    @Override
    public String getAPString(int parentObj) {
        FormObject N2;
        PdfObject AP;
        super.getAPString(parentObj);
        StringBuilder sb = new StringBuilder();
        if (this.form != null && (AP = this.form.getDictionary(4384)) != null && (N2 = (FormObject)AP.getDictionary(30)) != null) {
            byte[] stream = N2.getDecodedStream();
            sb.append("<< /Type /XObject /Subtype /Form");
            sb.append(" /FormType ");
            sb.append(N2.getInt(982024818));
            float[] matrix = N2.getFloatArray(1145198201);
            if (matrix != null) {
                sb.append(" /Matrix [ ");
                for (float value : matrix) {
                    sb.append(value);
                    sb.append(' ');
                }
                sb.append(']');
            }
            sb.append(" /Length ");
            sb.append(stream.length);
            float[] bbox = N2.getFloatArray(303185736);
            sb.append(" /BBox [ ");
            for (float value : bbox) {
                sb.append(value);
                sb.append(' ');
            }
            sb.append(']');
            PdfObject res = N2.getDictionary(2004251818);
            if (res != null && res.getDictionary(-1938465939) != null) {
                sb.append(" /Resources << /ExtGState << /GS0 << /ca 0.6 /Type /ExtGState /CA 0.6 /AIS false /BM /Normal >> >> >>");
            }
            sb.append(">>");
            sb.append("stream\n");
            sb.append(StringUtils.getTextString(N2.getDecodedStream(), true));
            sb.append("\nendstream");
        }
        return sb.toString();
    }
}

