/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.objects.raw.FormObject;

public class LinkAnnotation
extends WritableAnnotation {
    private final String url;

    public LinkAnnotation(int page, float x0, float y0, float x1, float y1, String url) {
        super(WritableAnnotation.AnnotationType.LINK, page, x0, y0, x1, y1);
        this.url = url;
    }

    public LinkAnnotation(int page, float x0, float y0, float x1, float y1, FormObject form) {
        super(WritableAnnotation.AnnotationType.LINK, page, x0, y0, x1, y1, form);
        this.url = null;
    }

    @Override
    public String getDictString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<</Type /Annot /Subtype /");
        sb.append(this.getTypeString());
        sb.append(" /Rect [ ");
        for (int i2 = 0; i2 < 4; ++i2) {
            sb.append(this.rect[i2]);
            sb.append(' ');
        }
        sb.append(']');
        sb.append("/A <</Type /Action /S /URI /URI (");
        if (this.form != null) {
            sb.append(this.form.getDictionary(17).getTextStreamValue(2433561));
            sb.append(")>>");
            String M2 = this.form.getTextStreamValue(29);
            if (M2 != null) {
                sb.append(" /M (");
                sb.append(this.form.getTextStreamValue(29));
                sb.append(')');
            }
            sb.append(" /T (");
            sb.append(this.form.getTextStreamValue(36));
            sb.append(')');
            sb.append(" /F ");
            sb.append(this.form.getInt(22));
            sb.append(' ');
        } else {
            sb.append(this.url);
            sb.append(")>>");
        }
        sb.append(">>");
        return sb.toString();
    }
}

