/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class LineAnnotation
extends WritableAnnotation {
    private final float linex0;
    private final float linex1;
    private final float liney0;
    private final float liney1;

    public LineAnnotation(int page, float x0, float y0, float x1, float y1, float linex0, float liney0, float linex1, float liney1) {
        super(WritableAnnotation.AnnotationType.LINE, page, x0, y0, x1, y1);
        this.strokeColor = new float[]{0.1607f, 0.4784f, 0.8f};
        this.nonStrokeColor = null;
        this.linex0 = linex0;
        this.liney0 = liney0;
        this.linex1 = linex1;
        this.liney1 = liney1;
    }

    public LineAnnotation(int page, float x0, float y0, float x1, float y1, FormObject form) {
        super(WritableAnnotation.AnnotationType.LINE, page, x0, y0, x1, y1, form);
        this.strokeColor = new float[]{0.1607f, 0.4784f, 0.8f};
        this.nonStrokeColor = null;
        this.linex0 = 0.0f;
        this.liney0 = 0.0f;
        this.linex1 = 0.0f;
        this.liney1 = 0.0f;
    }

    @Override
    public String getDictString() {
        if (this.form != null && this.form.getNameAsConstant(608780341) == -1 && this.form.getNameAsConstant(1147962727) == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<</Type /Annot /Subtype /");
        sb.append(this.getTypeString());
        if (this.form != null) {
            LineAnnotation.getFormString(sb, this.form, this.apRef);
        } else {
            sb.append(" /Rect [ ");
            for (int i2 = 0; i2 < 4; ++i2) {
                sb.append(this.rect[i2]);
                sb.append(' ');
            }
            sb.append(']');
            sb.append(" /L [ ");
            sb.append(this.linex0).append(' ').append(this.liney0).append(' ');
            sb.append(this.linex1).append(' ').append(this.liney1).append(" ]");
            sb.append(this.getStrokeColorString());
        }
        sb.append(">>");
        return sb.toString();
    }

    private static void getFormString(StringBuilder sb, FormObject form, int apRef) {
        PdfObject bs2;
        float[] c2;
        float[] rect = form.getFloatArray(573911876);
        sb.append(" /Rect [ ");
        for (int i2 = 0; i2 < 4; ++i2) {
            sb.append(rect[i2]);
            sb.append(' ');
        }
        sb.append(']');
        float[] localVert = form.getFloatArray(28);
        if (localVert != null) {
            sb.append(" /L [ ");
            for (float aLocalVert : localVert) {
                sb.append(aLocalVert);
                sb.append(' ');
            }
            sb.append(']');
        }
        if ((c2 = form.getFloatArray(19)) != null) {
            sb.append(" /C [ ");
            for (float aC2 : c2) {
                sb.append(aC2);
                sb.append(' ');
            }
            sb.append(']');
        }
        sb.append(" /M (");
        sb.append(form.getTextStreamValue(29));
        sb.append(')');
        sb.append(" /T (");
        sb.append(form.getTextStreamValue(36));
        sb.append(')');
        sb.append(" /F ");
        sb.append(form.getInt(22));
        sb.append(' ');
        float CA = form.getFloatNumber(4881);
        if (CA != 1.0f) {
            sb.append(" /CA ");
            sb.append(form.getFloatNumber(4881));
            sb.append(' ');
        }
        if ((bs2 = form.getDictionary(4643)) != null) {
            sb.append(" /BS << ");
            if (bs2.getInt(39) != -1) {
                sb.append("/W ");
                sb.append(bs2.getInt(39));
            }
            sb.append(" >>");
        }
        if (apRef != -1) {
            sb.append(" /AP << /N ");
            sb.append(apRef);
            sb.append(" 0 R >>");
        }
    }

    @Override
    public String getAPString(int parentObj) {
        FormObject N2;
        PdfObject AP;
        super.getAPString(parentObj);
        StringBuilder sb = new StringBuilder();
        if (this.form != null && (AP = this.form.getDictionary(4384)) != null && (N2 = (FormObject)AP.getDictionary(30)) != null) {
            byte[] stream = N2.getDecodedStream();
            sb.append("<< /Type /XObject /Subtype /Form");
            sb.append(" /FormType ");
            sb.append(N2.getInt(982024818));
            float[] matrix = N2.getFloatArray(1145198201);
            if (matrix != null) {
                sb.append(" /Matrix [ ");
                for (float aMatrix : matrix) {
                    sb.append(aMatrix);
                    sb.append(' ');
                }
                sb.append(']');
            }
            sb.append(" /Length ");
            sb.append(stream.length);
            float[] bbox = N2.getFloatArray(303185736);
            sb.append(" /BBox [ ");
            for (float aBbox : bbox) {
                sb.append(aBbox);
                sb.append(' ');
            }
            sb.append(']');
            float ca = this.form.getFloatNumber(4881);
            if (ca != 1.0f) {
                sb.append(" /Resources <<");
                sb.append("/ExtGState <</GS0 <</Type /ExtGState /AIS false /CA ").append(ca).append(" /ca ").append(ca).append(" >> >>");
                sb.append(" >>");
            }
            sb.append(">>");
            sb.append("stream\n");
            sb.append(StringUtils.getTextString(N2.getDecodedStream(), true));
            sb.append("\nendstream");
        }
        return sb.toString();
    }
}

