/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import java.util.List;
import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class InkAnnotation
extends WritableAnnotation {
    private final List<float[]> inkList;

    public InkAnnotation(int page, float x0, float y0, float x1, float y1, List<float[]> inkList) {
        super(WritableAnnotation.AnnotationType.INK, page, x0, y0, x1, y1);
        this.inkList = inkList;
        this.strokeColor = new float[]{0.1607f, 0.4784f, 0.8f};
        this.nonStrokeColor = null;
    }

    public InkAnnotation(int page, float x0, float y0, float x1, float y1, FormObject form) {
        super(WritableAnnotation.AnnotationType.INK, page, x0, y0, x1, y1, form);
        this.inkList = null;
        this.strokeColor = new float[]{0.1607f, 0.4784f, 0.8f};
        this.nonStrokeColor = null;
    }

    @Override
    public String getDictString() {
        if (this.form != null && this.form.getNameAsConstant(608780341) == -1 && this.form.getNameAsConstant(1147962727) == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<</Type /Annot /Subtype /");
        sb.append(this.getTypeString());
        if (this.form != null) {
            sb.append((CharSequence)InkAnnotation.getDictStringForFormObject(this.form, this.apRef));
        } else {
            sb.append((CharSequence)this.getDictStringForValues());
        }
        sb.append(">>");
        return sb.toString();
    }

    private StringBuilder getDictStringForValues() {
        StringBuilder sb = new StringBuilder();
        sb.append(" /Rect [ ");
        for (int i2 = 0; i2 < 4; ++i2) {
            sb.append(this.rect[i2]);
            sb.append(' ');
        }
        sb.append(']');
        if (this.inkList != null) {
            sb.append(" /InkList [");
            for (float[] fs : this.inkList) {
                sb.append(" [ ");
                for (float f2 : fs) {
                    sb.append(f2);
                    sb.append(' ');
                }
                sb.append(']');
            }
            sb.append(" ]");
        }
        sb.append(this.getStrokeColorString());
        sb.append(this.getNonStrokeColorString());
        return sb;
    }

    private static StringBuilder getDictStringForFormObject(FormObject form, int apRef) {
        PdfObject bs2;
        float[] ic;
        float[][] verts;
        StringBuilder sb = new StringBuilder();
        float[] rect = form.getFloatArray(573911876);
        sb.append(" /Rect [ ");
        for (float rectValue : rect) {
            sb.append(rectValue);
            sb.append(' ');
        }
        sb.append(']');
        sb.append(" /InkList [");
        for (float[] vert : verts = form.getFloat2DArray(475169151)) {
            sb.append('[');
            for (float v2 : vert) {
                sb.append(v2);
                sb.append(' ');
            }
            sb.append(']');
        }
        sb.append(']');
        float[] c2 = form.getFloatArray(19);
        if (c2 != null) {
            sb.append(" /C [ ");
            for (float cValue : c2) {
                sb.append(cValue);
                sb.append(' ');
            }
            sb.append(']');
        }
        if ((ic = form.getFloatArray(6419)) != null) {
            sb.append(" /IC [ ");
            for (float icValue : ic) {
                sb.append(icValue);
                sb.append(' ');
            }
            sb.append(']');
        }
        sb.append(" /M (");
        sb.append(form.getTextStreamValue(29));
        sb.append(')');
        sb.append(" /T (");
        sb.append(form.getTextStreamValue(36));
        sb.append(')');
        sb.append(" /F ");
        sb.append(form.getInt(22));
        sb.append(' ');
        float CA = form.getFloatNumber(4881);
        if (CA != 1.0f) {
            sb.append(" /CA ");
            sb.append(form.getFloatNumber(4881));
            sb.append(' ');
        }
        if ((bs2 = form.getDictionary(4643)) != null) {
            sb.append(" /BS << ");
            if (bs2.getInt(39) != -1) {
                sb.append("/W ");
                sb.append(bs2.getInt(39));
            }
            sb.append(" >>");
        }
        if (apRef != -1) {
            sb.append(" /AP << /N ");
            sb.append(apRef);
            sb.append(" 0 R >>");
        }
        return sb;
    }

    @Override
    public String getAPString(int parentObj) {
        FormObject nAP;
        PdfObject ap2;
        super.getAPString(parentObj);
        StringBuilder sb = new StringBuilder();
        if (this.form != null && (ap2 = this.form.getDictionary(4384)) != null && (nAP = (FormObject)ap2.getDictionary(30)) != null) {
            float ca;
            byte[] stream = nAP.getDecodedStream();
            sb.append("<< /Type /XObject /Subtype /Form");
            sb.append(" /FormType ");
            sb.append(nAP.getInt(982024818));
            sb.append(" /Length ");
            sb.append(stream.length);
            float[] bbox = nAP.getFloatArray(303185736);
            sb.append(" /BBox [ ");
            for (float value : bbox) {
                sb.append(value);
                sb.append(' ');
            }
            sb.append(']');
            float[] matrix = nAP.getFloatArray(1145198201);
            if (matrix != null) {
                sb.append(" /Matrix [ ");
                for (float mValue : matrix) {
                    sb.append(mValue);
                    sb.append(' ');
                }
                sb.append(']');
            }
            if ((ca = this.form.getFloatNumber(4881)) != 1.0f) {
                sb.append(" /Resources <<");
                sb.append("/ExtGState <</GS0 <</Type /ExtGState /AIS false /CA ").append(ca).append(" /ca ").append(ca).append(" >> >>");
                sb.append(" >>");
            }
            sb.append(">>");
            sb.append("stream\n");
            sb.append(StringUtils.getTextString(nAP.getDecodedStream(), true));
            sb.append("\nendstream");
        }
        return sb.toString();
    }
}

