/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import com.idrsolutions.image.filter.FlateFilterOptions;
import com.idrsolutions.image.pdf.PdfEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.io.annotation.utils.AnnotLEX;
import org.jpedal.io.filter.Flate;
import org.jpedal.utils.LogWriter;

public class ImageAnnotation
extends WritableAnnotation {
    private final BufferedImage image;
    private final float width;
    private final float height;

    public ImageAnnotation(int page, float x0, float y0, float x1, float y1, BufferedImage image) {
        super(WritableAnnotation.AnnotationType.STAMP, page, x0, y0, x1, y1);
        this.height = Math.abs(y1 - y0);
        this.width = Math.abs(x1 - x0);
        this.image = image;
    }

    @Override
    public String getDictString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<</Type /Annot /Subtype /").append(this.getTypeString());
        sb.append(" /IT /StampImage /Rect [ ");
        for (float value : this.rect) {
            sb.append(value).append(' ');
        }
        sb.append("] /F 4 ");
        sb.append("/AP << /N ").append(this.apRef).append(" 0 R >>>>");
        return sb.toString();
    }

    @Override
    public String getAPString(int parentObj) {
        super.getAPString(parentObj);
        String stream = "q\n" + this.width + " 0 0 " + this.height + " 0 0 cm\n/Im1 Do\nQ";
        return "<</Type /XObject /Subtype /Form /FormType 1 /BBox [ 0 0 " + this.width + ' ' + this.height + "] /Resources << /XObject << /Im1 " + this.resRef + " 0 R >>>> /Length " + stream.length() + " >>stream\n" + stream + "\nendstream";
    }

    @Override
    public byte[][] getResources(int parentObj) {
        super.getResources(parentObj);
        try {
            byte[] pixels;
            StringBuilder xObject = new StringBuilder();
            xObject.append("<< /Type /XObject /Subtype /Image /Name /Im1 /Width ").append(this.image.getWidth()).append(" /Height ").append(this.image.getHeight());
            byte[] alphas = null;
            switch (this.image.getType()) {
                case 10: {
                    pixels = PdfEncoder.handleByteGray(this.image, xObject);
                    break;
                }
                case 12: {
                    pixels = PdfEncoder.handleByteBinary(this.image, xObject);
                    break;
                }
                case 2: 
                case 3: {
                    alphas = new byte[this.image.getWidth() * this.image.getHeight()];
                    pixels = PdfEncoder.handleIntARGBRef(this.image, alphas, xObject, parentObj + 1);
                    break;
                }
                case 6: 
                case 7: {
                    alphas = new byte[this.image.getWidth() * this.image.getHeight()];
                    pixels = PdfEncoder.handle4ByteABGRRef(this.image, alphas, xObject, parentObj + 1);
                    break;
                }
                default: {
                    pixels = PdfEncoder.handleDefault(this.image, xObject);
                }
            }
            ByteArrayOutputStream xObjectBos = new ByteArrayOutputStream();
            xObjectBos.write(AnnotLEX.textToBytes(xObject.toString()));
            xObjectBos.write(AnnotLEX.textToBytes("stream\n"));
            xObjectBos.write(pixels);
            xObjectBos.write(AnnotLEX.textToBytes("\nendstream"));
            if (alphas == null) {
                return new byte[][]{xObjectBos.toByteArray()};
            }
            StringBuilder sMask = new StringBuilder();
            Flate flate = new Flate(new FlateFilterOptions());
            alphas = flate.encode(alphas, 9);
            sMask.append("<< /Type /XObject /Subtype /Image /Name /Sm1 /Width ").append(this.image.getWidth()).append(" /Height ").append(this.image.getHeight()).append(" /Length ").append(alphas.length).append(" /Filter /FlateDecode /ColorSpace /DeviceGray /BitsPerComponent 8 >>\nstream\n");
            ByteArrayOutputStream sMaskBos = new ByteArrayOutputStream();
            sMaskBos.write(AnnotLEX.textToBytes(sMask.toString()));
            sMaskBos.write(alphas);
            sMaskBos.write(AnnotLEX.textToBytes("\nendstream"));
            return new byte[][]{xObjectBos.toByteArray(), sMaskBos.toByteArray()};
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
            return new byte[0][];
        }
    }
}

