/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class HighlightAnnotation
extends WritableAnnotation {
    private final float[] quadPoints;

    public HighlightAnnotation(int page, float x0, float y0, float x1, float y1, float[] quadPoints) {
        super(WritableAnnotation.AnnotationType.HIGHLIGHT, page, x0, y0, x1, y1);
        this.quadPoints = quadPoints;
        this.strokeColor = new float[]{1.0f, 1.0f, 0.0f};
    }

    public HighlightAnnotation(int page, float x0, float y0, float x1, float y1, FormObject form) {
        super(WritableAnnotation.AnnotationType.HIGHLIGHT, page, x0, y0, x1, y1, form);
        this.quadPoints = null;
        this.strokeColor = new float[]{1.0f, 1.0f, 0.0f};
    }

    @Override
    public String getDictString() {
        if (this.form != null && this.form.getNameAsConstant(608780341) == -1 && this.form.getNameAsConstant(1147962727) == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<</Type /Annot /Subtype /");
        sb.append(this.getTypeString());
        if (this.form != null) {
            float[] ic;
            float[] c2;
            float[] rect = this.form.getFloatArray(573911876);
            HighlightAnnotation.setValue(sb, rect, " /Rect [ ");
            float[] localVert = this.form.getFloatArray(1785890247);
            if (localVert != null) {
                HighlightAnnotation.setValue(sb, localVert, " /QuadPoints [ ");
            }
            if ((c2 = this.form.getFloatArray(19)) != null) {
                HighlightAnnotation.setValue(sb, c2, " /C [ ");
            }
            if ((ic = this.form.getFloatArray(6419)) != null) {
                HighlightAnnotation.setValue(sb, ic, " /IC [ ");
            }
            sb.append(" /M (");
            sb.append(this.form.getTextStreamValue(29));
            sb.append(')');
            sb.append(" /T (");
            sb.append(this.form.getTextStreamValue(36));
            sb.append(')');
            sb.append(" /F ");
            sb.append(this.form.getInt(22));
            sb.append(' ');
            if (this.apRef != -1) {
                sb.append(" /AP << /N ");
                sb.append(this.apRef);
                sb.append(" 0 R >>");
            }
        } else {
            HighlightAnnotation.setValue(sb, this.rect, " /Rect [ ");
            if (this.quadPoints != null) {
                HighlightAnnotation.setValue(sb, this.quadPoints, " /QuadPoints [ ");
            }
            sb.append(this.getStrokeColorString());
            sb.append(this.getNonStrokeColorString());
        }
        sb.append(">>");
        return sb.toString();
    }

    private static void setValue(StringBuilder sb, float[] values, String s2) {
        sb.append(s2);
        for (float value : values) {
            sb.append(value);
            sb.append(' ');
        }
        sb.append(']');
    }

    @Override
    public String getAPString(int parentObj) {
        FormObject N2;
        PdfObject AP;
        super.getAPString(parentObj);
        StringBuilder sb = new StringBuilder();
        if (this.form != null && (AP = this.form.getDictionary(4384)) != null && (N2 = (FormObject)AP.getDictionary(30)) != null) {
            byte[] stream = N2.getDecodedStream();
            sb.append("<< /Type /XObject /Subtype /Form");
            sb.append(" /FormType ");
            sb.append(N2.getInt(982024818));
            sb.append(" /Length ");
            sb.append(stream.length);
            float[] bbox = N2.getFloatArray(303185736);
            HighlightAnnotation.setValue(sb, bbox, " /BBox [ ");
            float[] matrix = N2.getFloatArray(1145198201);
            HighlightAnnotation.setValue(sb, matrix, " /Matrix [ ");
            PdfObject res = N2.getDictionary(2004251818);
            if (res != null && res.getDictionary(-1938465939) != null) {
                sb.append(" /Resources <</ExtGState << /GS0 << /Type /ExtGState /AIS false /BM /Multiply >> >> >>");
            }
            sb.append(">>");
            sb.append("stream\n");
            sb.append(StringUtils.getTextString(N2.getDecodedStream(), true));
            sb.append("\nendstream");
        }
        return sb.toString();
    }
}

