/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.io.annotation.utils.AnnotationUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class FreeTextAnnotation
extends WritableAnnotation {
    private final String htmlText;

    public FreeTextAnnotation(int page, float x0, float y0, float x1, float y1, FormObject form) {
        super(WritableAnnotation.AnnotationType.FREETEXT, page, x0, y0, x1, y1, form);
        this.htmlText = null;
    }

    public FreeTextAnnotation(int page, float x0, float y0, float x1, float y1, String htmlText) {
        super(WritableAnnotation.AnnotationType.FREETEXT, page, x0, y0, x1, y1);
        this.htmlText = htmlText;
    }

    @Override
    public String getDictString() {
        if (this.form != null && this.form.getNameAsConstant(608780341) == -1 && this.form.getNameAsConstant(1147962727) == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<</Type /Annot /Subtype /");
        sb.append(this.getTypeString());
        sb.append(" /DA (Arial ");
        sb.append(this.getTextSize());
        sb.append("Tf)");
        if (this.form != null) {
            float[] rect = this.form.getFloatArray(573911876);
            FreeTextAnnotation.addRect(sb, rect);
            String richContents = this.form.getTextStreamValue(8723);
            if (richContents != null) {
                sb.append("/RC (");
                sb.append(richContents);
                sb.append(')');
            }
            byte[] bContents = this.form.getTextStreamValueAsByte(1216184967);
            sb.append(" /Contents (");
            if (bContents != null) {
                sb.append(StringUtils.getTextString(bContents, true, true));
            }
            sb.append(')');
            sb.append(" /IT ");
            sb.append(this.form.getName(6436));
            sb.append(" /DS (");
            sb.append(this.form.getTextStreamValue(5155));
            sb.append(')');
            sb.append(" /M (");
            sb.append(this.form.getTextStreamValue(29));
            sb.append(')');
            sb.append(" /T (");
            sb.append(this.form.getTextStreamValue(36));
            sb.append(')');
            sb.append(" /F ");
            sb.append(this.form.getInt(22));
            sb.append(' ');
            float CA = this.form.getFloatNumber(4881);
            if (CA != 1.0f) {
                sb.append(" /CA ");
                sb.append(this.form.getFloatNumber(4881));
                sb.append(' ');
            }
            if (this.apRef != -1) {
                sb.append(" /AP << /N ");
                sb.append(this.apRef);
                sb.append(" 0 R >>");
            }
        } else {
            FreeTextAnnotation.addRect(sb, this.rect);
            sb.append(" /RC (");
            sb.append(this.htmlText);
            sb.append(')');
            sb.append("/BS <</Type /Border /W 0>>");
        }
        sb.append(" >>");
        return sb.toString();
    }

    private static void addRect(StringBuilder sb, float[] rect2) {
        sb.append(" /Rect [ ");
        for (int i2 = 0; i2 < 4; ++i2) {
            sb.append(rect2[i2]);
            sb.append(' ');
        }
        sb.append(']');
    }

    @Override
    public String getAPString(int parentObj) {
        FormObject N2;
        PdfObject AP;
        super.getAPString(parentObj);
        StringBuilder sb = new StringBuilder();
        if (this.form != null && (AP = this.form.getDictionary(4384)) != null && (N2 = (FormObject)AP.getDictionary(30)) != null) {
            byte[] stream = N2.getDecodedStream();
            sb.append("<< /Type /XObject /Subtype /Form");
            sb.append(" /FormType ");
            sb.append(N2.getInt(982024818));
            float[] matrix = N2.getFloatArray(1145198201);
            if (matrix != null) {
                sb.append(" /Matrix [ ");
                for (float aMatrix : matrix) {
                    sb.append(aMatrix);
                    sb.append(' ');
                }
                sb.append(']');
            }
            sb.append(" /Length ");
            sb.append(stream.length);
            float[] bbox = N2.getFloatArray(303185736);
            sb.append(" /BBox [ ");
            for (float aBbox : bbox) {
                sb.append(aBbox);
                sb.append(' ');
            }
            sb.append(']');
            sb.append(" /Resources <<");
            String fontName = AnnotationUtils.getFontNameForForm(this.form);
            sb.append("/Font <</");
            sb.append(fontName);
            sb.append(" <</Type /Font /Subtype /Type1");
            sb.append(" /Name /");
            sb.append(fontName);
            sb.append(" /BaseFont /");
            sb.append(fontName);
            sb.append(" >> >>");
            float ca = this.form.getFloatNumber(4881);
            if (ca != 1.0f) {
                sb.append("/ExtGState <</GS0 <</Type /ExtGState /AIS false /CA ").append(ca).append(" /ca ").append(ca).append(" >> >>");
            }
            sb.append(" >> >>");
            sb.append("stream\n");
            sb.append(StringUtils.getTextString(N2.getDecodedStream(), true));
            sb.append("\nendstream");
        }
        return sb.toString();
    }
}

