/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jpedal.io.annotation.utils.AnnotArray;
import org.jpedal.io.annotation.utils.AnnotBuffer;
import org.jpedal.io.annotation.utils.AnnotDict;
import org.jpedal.io.annotation.utils.AnnotDirectString;
import org.jpedal.io.annotation.utils.AnnotInfo;
import org.jpedal.io.annotation.utils.AnnotLEX;
import org.jpedal.io.annotation.utils.AnnotName;
import org.jpedal.io.annotation.utils.AnnotNumber;
import org.jpedal.io.annotation.utils.AnnotOREF;
import org.jpedal.io.annotation.utils.AnnotObject;
import org.jpedal.io.annotation.utils.AnnotString;
import org.jpedal.io.annotation.utils.AnnotationUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.ResourcesObject;
import org.jpedal.utils.StringUtils;

public final class FormWriter {
    private static final int[] ARIAL = new int[]{750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 750, 278, 278, 355, 556, 556, 889, 667, 191, 333, 333, 389, 584, 278, 333, 278, 278, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 278, 278, 584, 584, 584, 556, 1015, 667, 667, 722, 722, 667, 611, 778, 722, 278, 500, 667, 556, 833, 722, 778, 667, 778, 722, 667, 611, 722, 667, 944, 667, 667, 611, 278, 278, 278, 469, 556, 333, 556, 556, 500, 556, 556, 278, 556, 556, 222, 222, 500, 222, 833, 556, 556, 556, 556, 333, 500, 278, 556, 500, 722, 500, 500, 500, 334, 260, 334, 584, 350, 556, 350, 222, 556, 333, 1000, 556, 556, 333, 1000, 667, 333, 1000, 350, 611, 350, 350, 222, 222, 333, 333, 350, 556, 1000, 333, 1000, 500, 333, 944, 350, 500, 667, 278, 333, 556, 556, 556, 556, 260, 556, 333, 737, 370, 556, 584, 333, 737, 552, 400, 549, 333, 333, 333, 576, 537, 333, 333, 333, 365, 556, 834, 834, 834, 611, 667, 667, 667, 667, 667, 667, 1000, 722, 667, 667, 667, 667, 278, 278, 278, 278, 722, 722, 778, 778, 778, 778, 778, 584, 778, 722, 722, 722, 722, 667, 667, 611, 556, 556, 556, 556, 556, 556, 889, 500, 556, 556, 556, 556, 278, 278, 278, 278, 556, 556, 556, 556, 556, 556, 556, 549, 611, 556, 556, 556, 556, 500, 556, 500};

    private FormWriter() {
    }

    public static void writeForms(File input, File output, FormObject[] formArr) throws IOException {
        AnnotBuffer mainBuff;
        AnnotInfo info = new AnnotInfo();
        info.mainBuffer = mainBuff = new AnnotBuffer(input, info);
        int prev = mainBuff.findFirstXREFOffset();
        mainBuff.movePos(prev);
        mainBuff.readSimpleXREF();
        mainBuff.updateAllObjStm();
        mainBuff.updatePageOffsets();
        int maxRef = info.offsetMap.maxKey;
        ++maxRef;
        ArrayList<AnnotDict> fieldDicts = new ArrayList<AnnotDict>();
        ArrayList<AnnotOREF> fieldRefs = new ArrayList<AnnotOREF>();
        AnnotDict mainCatDict = (AnnotDict)info.mainBuffer.getObjectValue(info.mainCatalog);
        AnnotOREF acroFormRef = (AnnotOREF)mainCatDict.keys.get("AcroForm");
        if (acroFormRef != null) {
            AnnotDict acroFormDict = (AnnotDict)info.mainBuffer.getObjectValue(acroFormRef);
            acroFormDict.keys.remove("XFA");
            fieldRefs.add(acroFormRef);
            fieldDicts.add(acroFormDict);
            HashMap<String, List<FormObject>> radioObjMap = new HashMap<String, List<FormObject>>();
            for (FormObject formObj : formArr) {
                maxRef = FormWriter.updateForm(formObj, info, fieldRefs, fieldDicts, maxRef, radioObjMap);
            }
            FormWriter.selectRadio(info, radioObjMap, fieldRefs, fieldDicts);
        }
        maxRef = FormWriter.updateAnnotations(info, fieldRefs, fieldDicts, formArr, maxRef);
        byte[] appendData = FormWriter.getUpdatedFormStream(info, (int)input.length(), prev, maxRef, fieldRefs, fieldDicts);
        FormWriter.appendDataToFile(input, output, appendData);
    }

    private static int updateForm(FormObject formObj, AnnotInfo info, List<AnnotOREF> fieldRefs, List<AnnotDict> fieldDicts, int Ref2, HashMap<String, List<FormObject>> radioObjMap) throws IOException {
        int maxRef = Ref2;
        switch (formObj.getFormType()) {
            case 3: {
                FormWriter.editTextField(info, fieldRefs, fieldDicts, formObj, maxRef, false, false);
                ++maxRef;
                break;
            }
            case 4: {
                FormWriter.editTextField(info, fieldRefs, fieldDicts, formObj, maxRef, true, false);
                ++maxRef;
                break;
            }
            case 5: {
                FormWriter.editTextField(info, fieldRefs, fieldDicts, formObj, maxRef, false, true);
                ++maxRef;
                break;
            }
            case 6: {
                FormWriter.editTextField(info, fieldRefs, fieldDicts, formObj, maxRef, true, true);
                ++maxRef;
                break;
            }
            case 9: {
                FormWriter.selectCheckBox(info, fieldRefs, fieldDicts, formObj);
                break;
            }
            case 8: {
                FormWriter.selectRadioButton(radioObjMap, formObj);
                break;
            }
            case 2: {
                FormWriter.selectChoice(info, fieldRefs, fieldDicts, formObj, maxRef);
                ++maxRef;
                break;
            }
            case 1: {
                FormWriter.selectList(info, fieldRefs, fieldDicts, formObj, maxRef);
                ++maxRef;
                break;
            }
        }
        return maxRef;
    }

    private static void appendDataToFile(File input, File output, byte[] appendData) throws IOException {
        try (FileInputStream fis = new FileInputStream(input);
             FileOutputStream fos = new FileOutputStream(output);){
            int n2;
            byte[] buffer = new byte[1024];
            while ((n2 = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, n2);
            }
            fos.write(appendData);
        }
    }

    private static void selectRadioButton(HashMap<String, List<FormObject>> radioObjMap, FormObject formObj) {
        String parentRef = formObj.getParentRef();
        if (radioObjMap.containsKey(parentRef)) {
            List<FormObject> fl = radioObjMap.get(parentRef);
            fl.add(formObj);
        } else {
            ArrayList<FormObject> fl = new ArrayList<FormObject>();
            fl.add(formObj);
            radioObjMap.put(parentRef, fl);
        }
    }

    private static void selectRadio(AnnotInfo info, HashMap<String, List<FormObject>> radioObjMap, List<AnnotOREF> fieldRefs, List<AnnotDict> fieldDicts) throws IOException {
        for (String parentRefStr : radioObjMap.keySet()) {
            AnnotOREF parentRef = AnnotLEX.getRefFromString(parentRefStr);
            AnnotDict parentDict = (AnnotDict)info.mainBuffer.getObjectValue(parentRef);
            fieldRefs.add(parentRef);
            fieldDicts.add(parentDict);
            List<FormObject> radioList = radioObjMap.get(parentRefStr);
            boolean hasSelection = false;
            String curValue = null;
            for (FormObject ff : radioList) {
                if (!ff.isSelected()) continue;
                curValue = ff.getValue();
                hasSelection = true;
                break;
            }
            if (hasSelection) {
                parentDict.keys.put("V", new AnnotString(curValue, curValue.getBytes()));
            } else {
                parentDict.keys.remove("V");
            }
            for (FormObject ff : radioList) {
                AnnotOREF radioRef = AnnotLEX.getRefFromString(ff.getObjectRefAsString());
                AnnotDict radioDict = (AnnotDict)info.mainBuffer.getObjectValue(radioRef);
                fieldRefs.add(radioRef);
                fieldDicts.add(radioDict);
                FormWriter.selectRadioChild(info, ff.isSelected(), radioDict);
            }
        }
    }

    private static byte[] getUpdatedFormStream(AnnotInfo info, int fileLen, int prev, int maxUsed, List<AnnotOREF> fieldRefs, List<AnnotDict> fieldDicts) throws IOException {
        int objOff = fileLen;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int[] fieldOffsets = new int[fieldRefs.size() * 2];
        int ii = fieldRefs.size();
        for (int i2 = 0; i2 < ii; ++i2) {
            int fieldRef = fieldRefs.get((int)i2).num;
            AnnotDict fieldDict = fieldDicts.get(i2);
            int pos = i2 << 1;
            fieldOffsets[pos] = fieldRef;
            fieldOffsets[pos + 1] = objOff;
            if (fieldDict.keys.containsKey("Length")) {
                byte[] startBytes = AnnotLEX.textToBytes(fieldRef + " 0 obj\n");
                byte[] midBytes = AnnotLEX.textToBytes(fieldDicts.get(i2).toText() + "stream\n");
                byte[] streamBytes = fieldDicts.get((int)i2).rawStream.getByteData();
                byte[] endBytes = AnnotLEX.textToBytes("\nendstream\nendobj\n");
                bos.write(startBytes);
                bos.write(midBytes);
                bos.write(streamBytes);
                bos.write(endBytes);
                objOff += startBytes.length + midBytes.length + streamBytes.length + endBytes.length;
                continue;
            }
            String dictionaryStr = fieldRef + " 0 obj\n" + fieldDicts.get(i2).toText() + "\nendobj\n";
            byte[] dictBytes = AnnotLEX.textToBytes(dictionaryStr);
            bos.write(dictBytes);
            objOff += dictBytes.length;
        }
        int current = objOff;
        if (info.xrefType == 1) {
            FormWriter.handleType1(info, prev, maxUsed, bos, fieldOffsets, current);
        } else {
            FormWriter.handleOtherTypes(info, prev, maxUsed, bos, fieldOffsets, current);
        }
        bos.close();
        return bos.toByteArray();
    }

    private static void handleOtherTypes(AnnotInfo info, int prev, int maxUsed, ByteArrayOutputStream bos, int[] fieldOffsets, int current) throws IOException {
        byte[] xrefsBytes = new byte[]{120, 114, 101, 102, 10};
        bos.write(xrefsBytes);
        StringBuilder temp = new StringBuilder();
        int ii = fieldOffsets.length / 2;
        for (int i2 = 0; i2 < ii; ++i2) {
            int pos = i2 << 1;
            int fieldRef = fieldOffsets[pos];
            int fieldOffset = fieldOffsets[pos + 1];
            temp.append(fieldRef);
            temp.append(" 1\n");
            temp.append(AnnotLEX.getZeroLead(fieldOffset));
            temp.append(" 00000 n \n");
        }
        temp.append("trailer\n<</Size ");
        temp.append(maxUsed + 1);
        temp.append(" /Root ");
        temp.append(info.mainCatalog.ref);
        temp.append(" /Prev ");
        temp.append(prev);
        temp.append(">>\n");
        temp.append("startxref\n");
        temp.append(current);
        temp.append("\n%%EOF\n");
        bos.write(AnnotLEX.textToBytes(temp.toString()));
    }

    private static void handleType1(AnnotInfo info, int prev, int maxUsed, ByteArrayOutputStream bos, int[] fieldOffsets, int current) throws IOException {
        byte[] wBytes;
        StringBuilder sb = new StringBuilder("[");
        try (ByteArrayOutputStream wBos = new ByteArrayOutputStream();){
            int ii = fieldOffsets.length / 2;
            for (int i2 = 0; i2 < ii; ++i2) {
                int pos = i2 << 1;
                int ref = fieldOffsets[pos];
                int offset = fieldOffsets[pos + 1];
                wBos.write(1);
                wBos.write(AnnotLEX.toBytes32(offset));
                wBos.write(0);
                sb.append(ref);
                sb.append(" 1 ");
            }
            sb.append(']');
            wBos.close();
            wBytes = wBos.toByteArray();
        }
        String dictStr = maxUsed + 1 + " 0 obj\n<</Type /XRef /Root " + info.mainCatalog.ref + " /Prev " + prev + " /Index " + sb + " /W [1 4 1] /Size " + maxUsed + "/Length " + wBytes.length + ">>stream\n";
        bos.write(AnnotLEX.textToBytes(dictStr));
        bos.write(wBytes);
        dictStr = "\nendstream\nendobj\nstartxref\n" + current + "\n%%EOF\n";
        bos.write(AnnotLEX.textToBytes(dictStr));
    }

    private static int updateAnnotations(AnnotInfo info, List<AnnotOREF> fieldRefs, List<AnnotDict> fieldDicts, FormObject[] formArr, int maxRef) throws IOException {
        HashMap<AnnotOREF, AnnotDict> pageDictsObj = new HashMap<AnnotOREF, AnnotDict>();
        block0: for (FormObject formObj : formArr) {
            AnnotDict pageDict;
            if (formObj.getPageNumber() == -1) continue;
            if (formObj.getNameAsConstant(1147962727) != -1 && formObj.getNameAsConstant(5668) == -1) {
                if (formObj.getObjectRefAsString().contains("X") || !AnnotationUtils.isEditableAnnotation(formObj) || !FormWriter.updateAnnotationValues(info, fieldRefs, fieldDicts, formObj, maxRef)) continue;
                ++maxRef;
                continue;
            }
            if (formObj.getNameAsConstant(608780341) != -1 || formObj.getNameAsConstant(1147962727) != -1 || formObj.getNameAsConstant(5668) != -1) continue;
            AnnotOREF page = info.pageOffsets[formObj.getPageNumber() - 1];
            if (pageDictsObj.containsKey(page)) {
                pageDict = (AnnotDict)pageDictsObj.get(page);
            } else {
                pageDict = (AnnotDict)info.mainBuffer.getObjectValue(page);
                pageDictsObj.put(page, pageDict);
            }
            AnnotArray annots = (AnnotArray)pageDict.keys.get("Annots");
            for (int i2 = 0; i2 != annots.items.size(); ++i2) {
                AnnotOREF refObj = (AnnotOREF)annots.items.get(i2);
                if (!refObj.toText().equals(formObj.getObjectRefAsString())) continue;
                annots.items.remove(refObj);
                continue block0;
            }
        }
        if (!pageDictsObj.keySet().isEmpty()) {
            Set values = pageDictsObj.keySet();
            for (AnnotOREF dict : values) {
                fieldRefs.add(dict);
                fieldDicts.add((AnnotDict)pageDictsObj.get(dict));
            }
        }
        return maxRef;
    }

    private static boolean updateAnnotationValues(AnnotInfo info, List<AnnotOREF> fieldRefs, List<AnnotDict> fieldDicts, FormObject formObject, int maxRef) throws IOException {
        PdfObject n2;
        PdfObject ap2;
        String URI2;
        PdfObject A2;
        String defaultStyle;
        int w2;
        PdfObject bs2;
        float opacity;
        float fraction;
        String name;
        String modifiedDate;
        String author;
        float[] ic;
        String ref = formObject.getObjectRefAsString();
        AnnotOREF refObj = AnnotLEX.getRefFromString(ref);
        AnnotDict fieldDict = (AnnotDict)info.mainBuffer.getObjectValue(refObj);
        fieldRefs.add(refObj);
        fieldDicts.add(fieldDict);
        float[] rect = formObject.getFloatArray(573911876);
        fieldDict.keys.put("Rect", new AnnotArray(rect));
        float[] c2 = formObject.getFloatArray(19);
        if (c2 != null) {
            fieldDict.keys.put("C", new AnnotArray(c2));
        }
        if ((ic = formObject.getFloatArray(6419)) != null) {
            fieldDict.keys.put("IC", new AnnotArray(ic));
        }
        if ((author = formObject.getTextStreamValue(36)) != null) {
            fieldDict.keys.put("T", new AnnotString(author, author.getBytes()));
        }
        if ((modifiedDate = formObject.getTextStreamValue(29)) != null) {
            fieldDict.keys.put("M", new AnnotString(modifiedDate, modifiedDate.getBytes()));
        }
        if ((name = formObject.getTextStreamValue(506543413)) != null) {
            fieldDict.keys.put("Name", new AnnotName(name));
        }
        if ((fraction = (opacity = formObject.getFloatNumber(4881)) % 1.0f) > 0.0f) {
            fieldDict.keys.put("CA", new AnnotNumber(Float.valueOf(opacity), Float.toString(fraction).length() - 2));
        } else {
            fieldDict.keys.put("CA", new AnnotNumber(Float.valueOf(opacity), 0));
        }
        byte[] contents = formObject.getTextStreamValueAsByte(1216184967);
        if (contents != null) {
            fieldDict.keys.put("Contents", new AnnotString(StringUtils.getTextString(contents, true), contents));
        }
        if ((bs2 = formObject.getDictionary(4643)) != null && (w2 = bs2.getInt(39)) >= 0) {
            AnnotDict bsDict = new AnnotDict();
            fieldDict.keys.put("BS", bsDict);
            bsDict.keys.put("W", new AnnotNumber(w2));
        }
        if ((defaultStyle = formObject.getTextStreamValue(5155)) != null) {
            fieldDict.keys.put("DS", new AnnotString(defaultStyle, defaultStyle.getBytes()));
        }
        if ((A2 = formObject.getDictionary(17)) != null && A2.getNameAsConstant(35) == 2433561 && (URI2 = A2.getTextStreamValue(2433561)) != null) {
            AnnotDict aDict = new AnnotDict();
            aDict.keys.put("Type", new AnnotName("Action"));
            aDict.keys.put("S", new AnnotName("URI"));
            aDict.keys.put("URI", new AnnotString(URI2, URI2.getBytes()));
            fieldDict.keys.put("A", aDict);
        }
        if ((ap2 = formObject.getDictionary(4384)) != null && (n2 = ap2.getDictionary(30)) != null) {
            FormWriter.updateAPObject(info, formObject, fieldDict, fieldDicts, fieldRefs, maxRef);
            return true;
        }
        return false;
    }

    private static void updateAPObject(AnnotInfo info, FormObject formObject, AnnotDict fieldDict, List<AnnotDict> fieldDicts, List<AnnotOREF> fieldRefs, int maxRef) {
        AnnotDict apDict = new AnnotDict();
        fieldDict.keys.put("AP", apDict);
        AnnotDict nDict = new AnnotDict();
        AnnotOREF nDictRef = new AnnotOREF(maxRef, 0);
        apDict.keys.put("N", nDictRef);
        FormWriter.updateGenericAPObject(info, formObject, nDict);
        fieldDicts.add(nDict);
        fieldRefs.add(nDictRef);
    }

    private static void updateGenericAPObject(AnnotInfo info, FormObject formObject, AnnotDict nDict) {
        float[] matrix;
        PdfObject AP = formObject.getDictionary(4384);
        FormObject N2 = (FormObject)AP.getDictionary(30);
        float[] bbox = N2.getFloatArray(303185736);
        if (bbox != null && bbox.length > 0) {
            nDict.keys.put("BBox", new AnnotArray(bbox));
        }
        if ((matrix = N2.getFloatArray(1145198201)) != null && matrix.length > 0) {
            nDict.keys.put("Matrix", new AnnotArray(matrix));
        }
        nDict.keys.put("Subtype", new AnnotName("N"));
        nDict.keys.put("FormType", new AnnotNumber(1));
        nDict.keys.put("Type", new AnnotName("XObject"));
        String nStr = FormWriter.updateAPResourceObject(formObject, nDict) + AnnotationUtils.createAPStream(formObject);
        if (!nStr.isEmpty()) {
            byte[] nBytes = AnnotLEX.textToBytes(nStr);
            nDict.keys.put("Length", new AnnotNumber(nBytes.length));
            nDict.rawStream = new AnnotBuffer(nBytes, info);
        }
    }

    private static String updateAPResourceObject(FormObject formObject, AnnotDict nDict) {
        StringBuilder builder = new StringBuilder();
        PdfObject AP = formObject.getDictionary(4384);
        FormObject N2 = (FormObject)AP.getDictionary(30);
        ResourcesObject res = (ResourcesObject)N2.getDictionary(2004251818);
        if (res != null) {
            PdfKeyPairsIterator keyPairs;
            PdfObject font;
            AnnotDict resource = new AnnotDict();
            PdfObject extGS = res.getDictionary(-1938465939);
            if (extGS != null) {
                PdfKeyPairsIterator gsIterator = extGS.getKeyPairsIterator();
                if (gsIterator != null) {
                    resource.keys.put("ExtGState", FormWriter.createAnnotDictFromKeyPairs(gsIterator));
                }
                builder.append("/GS0 gs ");
            }
            if ((font = res.getDictionary(373243460)) != null && (keyPairs = font.getKeyPairsIterator()) != null) {
                resource.keys.put("Font", FormWriter.createAnnotDictFromKeyPairs(keyPairs));
            }
            nDict.keys.put("Resources", resource);
        }
        return builder.toString();
    }

    private static AnnotDict createAnnotDictFromKeyPairs(PdfKeyPairsIterator keyPairs) {
        AnnotDict annotDict = new AnnotDict();
        while (keyPairs.hasMorePairs()) {
            String fontKey = keyPairs.getNextKeyAsString();
            byte[] data = keyPairs.getNextValueAsBytes();
            String fontData = StringUtils.getTextString(data, true);
            annotDict.keys.put(fontKey, new AnnotDirectString(fontData));
            keyPairs.nextPair();
        }
        return annotDict;
    }

    private static void editTextField(AnnotInfo info, List<AnnotOREF> fieldRefs, List<AnnotDict> fieldDicts, FormObject formObject, int maxRef, boolean isPassword, boolean isMulti) throws IOException {
        String fieldText;
        String ref = formObject.getObjectRefAsString();
        AnnotOREF refObj = AnnotLEX.getRefFromString(ref);
        AnnotDict fieldDict = (AnnotDict)info.mainBuffer.getObjectValue(refObj);
        fieldRefs.add(refObj);
        fieldDicts.add(fieldDict);
        String appearText = fieldText = formObject.getValue();
        if (isPassword) {
            int len = fieldText.length();
            StringBuilder sb = new StringBuilder(len);
            for (int i2 = 0; i2 < len; ++i2) {
                sb.append('*');
            }
            appearText = sb.toString();
        }
        AnnotDict mainCatDict = (AnnotDict)info.mainBuffer.getObjectValue(info.mainCatalog);
        AnnotOREF acroFormRef = (AnnotOREF)mainCatDict.keys.get("AcroForm");
        if (acroFormRef != null) {
            AnnotDict acroFormDict = (AnnotDict)info.mainBuffer.getObjectValue(acroFormRef);
            AnnotArray fields = (AnnotArray)acroFormDict.keys.get("Fields");
            ArrayList fieldItems = (ArrayList)fields.items;
            AnnotOREF parentRef = (AnnotOREF)fieldDict.keys.get("Parent");
            if (parentRef != null) {
                for (AnnotObject f2 : fieldItems) {
                    if (((AnnotOREF)f2).num != parentRef.num) continue;
                    AnnotDict acroParent = (AnnotDict)info.mainBuffer.getObjectValue(parentRef);
                    acroParent.keys.put("V", new AnnotString(fieldText, fieldText.getBytes()));
                    fieldRefs.add(parentRef);
                    fieldDicts.add(acroParent);
                    break;
                }
            }
        }
        AnnotDict apDict = new AnnotDict();
        fieldDict.keys.put("V", new AnnotString(fieldText, fieldText.getBytes()));
        fieldDict.keys.put("AP", apDict);
        AnnotArray rectArr = (AnnotArray)fieldDict.keys.get("Rect");
        AnnotNumber[] rect = new AnnotNumber[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            rect[i3] = (AnnotNumber)info.mainBuffer.getObjectValue(rectArr.items.get(i3));
        }
        float fw = rect[2].toValue().floatValue() - rect[0].toValue().floatValue();
        float fh = rect[3].toValue().floatValue() - rect[1].toValue().floatValue();
        AnnotDict nDict = new AnnotDict();
        AnnotOREF nDictRef = new AnnotOREF(maxRef, 0);
        apDict.keys.put("N", nDictRef);
        nDict.keys.put("BBox", new AnnotArray(new float[]{0.0f, 0.0f, fw, fh}));
        nDict.keys.put("Matrix", new AnnotArray(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}));
        nDict.keys.put("Subtype", new AnnotName("Form"));
        nDict.keys.put("Resources", new AnnotDict());
        nDict.keys.put("FormType", new AnnotNumber(1));
        nDict.keys.put("Type", new AnnotName("XObject"));
        String textFieldStream = isMulti ? FormWriter.createMultiLineTextFieldStream(appearText, fw, fh) : FormWriter.createSingleLineTextFieldStream(appearText, fh);
        byte[] nBytes = AnnotLEX.textToBytes(textFieldStream);
        nDict.keys.put("Length", new AnnotNumber(nBytes.length));
        nDict.rawStream = new AnnotBuffer(nBytes, info);
        fieldDicts.add(nDict);
        fieldRefs.add(nDictRef);
    }

    private static String createSingleLineTextFieldStream(String appearText, float fontHeight) {
        float desc = 8.0f;
        float mid = fontHeight - 8.0f > 0.0f ? (fontHeight - 8.0f) / 2.0f : 0.0f;
        return "/Tx BMC\nBT\n/Arial 10 Tf\n0 g\n2 " + mid + " Td\n(" + appearText + ") Tj\nET\nEMC";
    }

    private static String createMultiLineTextFieldStream(String appearText, float fontWidth, float fontHeight) {
        StringBuilder sb = new StringBuilder();
        float curW = 0.0f;
        StringBuilder output = new StringBuilder();
        String curWord = "";
        String curLine = "";
        int ii = appearText.length();
        for (int i2 = 0; i2 < ii; ++i2) {
            int cc = appearText.codePointAt(i2);
            char ch = appearText.charAt(i2);
            float cw = FormWriter.findCodeWidth(cc);
            if (curW + cw > fontWidth) {
                if (curWord.equals(curLine)) {
                    output.append(curWord).append('\n');
                    curWord = "";
                    curLine = "";
                    curW = 0.0f;
                } else {
                    output.append('\n');
                    curW = FormWriter.findStringWidth(curWord);
                    curLine = curWord;
                }
            }
            curW += cw;
            if (cc == 10) {
                output.append(curWord).append('\n');
                curWord = "";
                curLine = "";
                curW = 0.0f;
                continue;
            }
            if (AnnotLEX.isWhiteSpace(cc)) {
                output.append(curWord).append(' ');
                curWord = "";
                curLine = curLine + " ";
                continue;
            }
            curWord = curWord + ch;
            curLine = curLine + ch;
        }
        if (!curWord.isEmpty()) {
            output.append(curWord);
        }
        String[] outputs = output.toString().split("\n");
        float lineH = 12.0f;
        float paraH = (float)outputs.length * 12.0f;
        float startY = (fontHeight - paraH) / 2.0f + paraH - 10.0f;
        startY = startY < 0.0f ? 0.0f : startY;
        sb.append("/Tx BMC\nBT\n/Arial ");
        sb.append(10);
        sb.append(" Tf\n 0 g\n");
        sb.append("2 ");
        sb.append(startY);
        sb.append(" Td\n(");
        sb.append(outputs[0]);
        sb.append(") Tj\n");
        int ii2 = outputs.length;
        for (int i3 = 1; i3 < ii2; ++i3) {
            sb.append("0 ");
            sb.append(-12.0f);
            sb.append(" Td\n(");
            sb.append(outputs[i3]);
            sb.append(") Tj\n");
        }
        sb.append("ET\nEMC");
        return sb.toString();
    }

    private static void selectCheckBox(AnnotInfo info, List<AnnotOREF> fieldRefs, List<AnnotDict> fieldDicts, FormObject formObject) throws IOException {
        String ref = formObject.getObjectRefAsString();
        AnnotOREF refObj = AnnotLEX.getRefFromString(ref);
        AnnotDict fieldDict = (AnnotDict)info.mainBuffer.getObjectValue(refObj);
        fieldRefs.add(refObj);
        fieldDicts.add(fieldDict);
        String onVal = "Yes";
        String offVal = "Off";
        AnnotObject apObj = fieldDict.keys.get("AP");
        if (apObj != null) {
            AnnotDict ap2 = (AnnotDict)apObj;
            AnnotObject dObj = ap2.keys.get("N");
            if (dObj != null) {
                AnnotDict d2 = (AnnotDict)dObj;
                for (String dk : d2.keys.keySet()) {
                    String lc = dk.toLowerCase();
                    if ("off".equals(lc)) continue;
                    onVal = dk;
                }
            }
            if (formObject.isSelected()) {
                fieldDict.keys.put("AS", new AnnotName(onVal));
                fieldDict.keys.put("V", new AnnotName(onVal));
            } else {
                fieldDict.keys.put("AS", new AnnotName("Off"));
                fieldDict.keys.put("V", new AnnotName("Off"));
            }
        }
    }

    private static void selectChoice(AnnotInfo info, List<AnnotOREF> fieldRefs, List<AnnotDict> fieldDicts, FormObject formObject, int maxRef) throws IOException {
        String ref = formObject.getObjectRefAsString();
        AnnotOREF refObj = AnnotLEX.getRefFromString(ref);
        AnnotDict fieldDict = (AnnotDict)info.mainBuffer.getObjectValue(refObj);
        fieldRefs.add(refObj);
        fieldDicts.add(fieldDict);
        String curValue = formObject.getSelectedItem();
        int curIndex = formObject.getSelectedIndex();
        fieldDict.keys.put("V", new AnnotString(curValue, curValue.getBytes()));
        AnnotArray aa2 = new AnnotArray();
        aa2.items.add(new AnnotNumber(curIndex));
        fieldDict.keys.put("I", aa2);
        AnnotDict apDict = new AnnotDict();
        fieldDict.keys.put("AP", apDict);
        AnnotArray rectArr = (AnnotArray)fieldDict.keys.get("Rect");
        AnnotNumber[] rect = new AnnotNumber[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            rect[i2] = (AnnotNumber)info.mainBuffer.getObjectValue(rectArr.items.get(i2));
        }
        float fw = rect[2].toValue().floatValue() - rect[0].toValue().floatValue();
        float fh = rect[3].toValue().floatValue() - rect[1].toValue().floatValue();
        int fontSize = 10;
        AnnotDict nDict = new AnnotDict();
        AnnotOREF nDictRef = new AnnotOREF(maxRef, 0);
        apDict.keys.put("N", nDictRef);
        nDict.keys.put("BBox", new AnnotArray(new float[]{0.0f, 0.0f, fw, fh}));
        nDict.keys.put("Matrix", new AnnotArray(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}));
        nDict.keys.put("Subtype", new AnnotName("Form"));
        nDict.keys.put("Resources", new AnnotDict());
        nDict.keys.put("FormType", new AnnotNumber(1));
        nDict.keys.put("Type", new AnnotName("XObject"));
        float desc = 8.0f;
        float mid = fh - 8.0f > 0.0f ? (fh - 8.0f) / 2.0f : 0.0f;
        String nStr = "/Tx BMC\nBT\n/Arial 10 Tf\n0 g\n2 " + mid + " Td\n(" + curValue + ") Tj\nET\nEMC";
        byte[] nBytes = AnnotLEX.textToBytes(nStr);
        nDict.keys.put("Length", new AnnotNumber(nBytes.length));
        nDict.rawStream = new AnnotBuffer(nBytes, info);
        fieldDicts.add(nDict);
        fieldRefs.add(nDictRef);
    }

    private static void selectList(AnnotInfo info, List<AnnotOREF> fieldRefs, List<AnnotDict> fieldDicts, FormObject formObject, int maxRef) throws IOException {
        String ref = formObject.getObjectRefAsString();
        AnnotOREF refObj = AnnotLEX.getRefFromString(ref);
        AnnotDict fieldDict = (AnnotDict)info.mainBuffer.getObjectValue(refObj);
        fieldRefs.add(refObj);
        fieldDicts.add(fieldDict);
        boolean isMultiSelect = formObject.getFieldFlags()[22];
        AnnotDict apDict = new AnnotDict();
        fieldDict.keys.put("AP", apDict);
        AnnotArray rectArr = (AnnotArray)fieldDict.keys.get("Rect");
        AnnotNumber[] rect = new AnnotNumber[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            rect[i2] = (AnnotNumber)info.mainBuffer.getObjectValue(rectArr.items.get(i2));
        }
        float fw = rect[2].toValue().floatValue() - rect[0].toValue().floatValue();
        float fh = rect[3].toValue().floatValue() - rect[1].toValue().floatValue();
        int fontSize = formObject.getTextSize();
        AnnotDict nDict = new AnnotDict();
        AnnotOREF nDictRef = new AnnotOREF(maxRef, 0);
        apDict.keys.put("N", nDictRef);
        nDict.keys.put("BBox", new AnnotArray(new float[]{0.0f, 0.0f, fw, fh}));
        nDict.keys.put("Matrix", new AnnotArray(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}));
        nDict.keys.put("Subtype", new AnnotName("Form"));
        nDict.keys.put("Resources", new AnnotDict());
        nDict.keys.put("FormType", new AnnotNumber(1));
        nDict.keys.put("Type", new AnnotName("XObject"));
        StringBuilder nStr = new StringBuilder("/Tx BMC\n");
        nStr.append(FormWriter.getListAPStreamSelectionSegment(formObject, isMultiSelect, fieldDict, fontSize, fh, fw));
        nStr.append("0 g\n");
        String DA = formObject.getTextStreamValue(5137);
        if (DA == null) {
            nStr.append("/Arial ").append(fontSize).append(" Tf\n0 g\n");
        } else {
            nStr.append(DA).append('\n');
        }
        String[] items = formObject.getItemsList();
        for (int i3 = 0; i3 != items.length; ++i3) {
            nStr.append("BT\n2 ").append(fh - (float)((fontSize + 4) * (i3 + 1)) + 2.0f).append(" Td\n(").append(items[i3]).append(") Tj\nET\n");
        }
        nStr.append("EMC");
        byte[] nBytes = AnnotLEX.textToBytes(nStr.toString());
        nDict.keys.put("Length", new AnnotNumber(nBytes.length));
        nDict.rawStream = new AnnotBuffer(nBytes, info);
        fieldDicts.add(nDict);
        fieldRefs.add(nDictRef);
    }

    private static String getListAPStreamSelectionSegment(FormObject formObject, boolean isMultiSelect, AnnotDict fieldDict, float fontSize, float formHeight, float formWidth) {
        StringBuilder segment = new StringBuilder("0.600006 0.756866 0.854904 rg\n");
        if (isMultiSelect) {
            String[] curValues = formObject.getSelectedItems();
            int[] indices = formObject.getSelectionIndices();
            fieldDict.keys.put("V", new AnnotArray(curValues));
            fieldDict.keys.put("I", new AnnotArray(indices));
            for (int i2 = 0; i2 != indices.length; ++i2) {
                float yMax = formHeight - (fontSize + 4.0f) * (float)(indices[i2] + 1);
                float yMin = formHeight - (fontSize + 4.0f) * (float)(indices[i2] + 2);
                segment.append("1 ").append(yMax).append(' ').append(formWidth - 1.0f).append(' ').append(yMax - yMin).append(" re\n");
                segment.append("f\n");
            }
        } else {
            String curValue = formObject.getSelectedItem();
            int curIndex = formObject.getSelectedIndex();
            fieldDict.keys.put("V", new AnnotString(curValue, curValue.getBytes()));
            AnnotArray aa2 = new AnnotArray();
            aa2.items.add(new AnnotNumber(curIndex));
            fieldDict.keys.put("I", aa2);
            float yMax = formHeight - (fontSize + 4.0f) * (float)(curIndex + 1);
            float yMin = formHeight - (fontSize + 4.0f) * (float)(curIndex + 2);
            segment.append("1 ").append(yMax).append(' ').append(formWidth - 1.0f).append(' ').append(yMax - yMin).append(" re\n");
            segment.append("f\n");
        }
        return segment.toString();
    }

    private static void selectRadioChild(AnnotInfo info, boolean isChecked, AnnotDict fieldDict) throws IOException {
        AnnotObject apObj = fieldDict.keys.get("AP");
        if (apObj != null) {
            AnnotDict ap2 = (AnnotDict)info.mainBuffer.getObjectValue(apObj);
            String onVal = "Yes";
            String offVal = "Off";
            AnnotObject dObj = ap2.keys.get("N");
            if (dObj != null) {
                AnnotDict d2 = (AnnotDict)info.mainBuffer.getObjectValue(dObj);
                for (String dk : d2.keys.keySet()) {
                    String lc = dk.toLowerCase();
                    if ("off".equals(lc)) continue;
                    onVal = dk;
                }
            }
            if (isChecked) {
                fieldDict.keys.put("AS", new AnnotName(onVal));
            } else {
                fieldDict.keys.put("AS", new AnnotName("Off"));
            }
        }
    }

    private static float findCodeWidth(int cc) {
        return cc < 256 ? (float)ARIAL[cc] / 1000.0f * 10.0f : 10.0f;
    }

    private static float findStringWidth(String str) {
        float tw = 0.0f;
        int ii = str.length();
        for (int i2 = 0; i2 < ii; ++i2) {
            int ch = str.codePointAt(i2);
            if (ch < 256) {
                tw += (float)ARIAL[ch] / 1000.0f * 10.0f;
                continue;
            }
            tw += 10.0f;
        }
        return tw;
    }
}

