/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class CircleAnnotation
extends WritableAnnotation {
    public CircleAnnotation(int page, float x0, float y0, float x1, float y1) {
        super(WritableAnnotation.AnnotationType.CIRCLE, page, x0, y0, x1, y1);
        this.strokeColor = new float[]{0.1607f, 0.4784f, 0.8f};
        this.nonStrokeColor = null;
    }

    public CircleAnnotation(int page, float x0, float y0, float x1, float y1, FormObject form) {
        super(WritableAnnotation.AnnotationType.CIRCLE, page, x0, y0, x1, y1, form);
        this.strokeColor = new float[]{0.1607f, 0.4784f, 0.8f};
        this.nonStrokeColor = null;
    }

    @Override
    public String getDictString() {
        if (this.form != null && this.form.getNameAsConstant(608780341) == -1 && this.form.getNameAsConstant(1147962727) == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<</Type /Annot /Subtype /");
        sb.append(this.getTypeString());
        if (this.form != null) {
            PdfObject bs2;
            float[] ic;
            float[] rect = this.form.getFloatArray(573911876);
            CircleAnnotation.appendValues(" /Rect [ ", sb, rect);
            float[] c2 = this.form.getFloatArray(19);
            if (c2 != null) {
                CircleAnnotation.appendValues(" /C [ ", sb, c2);
            }
            if ((ic = this.form.getFloatArray(6419)) != null) {
                CircleAnnotation.appendValues(" /IC [ ", sb, ic);
            }
            sb.append(" /M (");
            sb.append(this.form.getTextStreamValue(29));
            sb.append(")  /T (");
            sb.append(this.form.getTextStreamValue(36));
            sb.append(") /F ");
            sb.append(this.form.getInt(22));
            sb.append(' ');
            float CA = this.form.getFloatNumber(4881);
            if (CA != 1.0f) {
                sb.append(" /CA ");
                sb.append(this.form.getFloatNumber(4881));
                sb.append(' ');
            }
            if ((bs2 = this.form.getDictionary(4643)) != null) {
                sb.append(" /BS << ");
                if (bs2.getInt(39) != -1) {
                    sb.append("/W ");
                    sb.append(bs2.getInt(39));
                }
                sb.append(" >>");
            }
            if (this.apRef != -1) {
                sb.append(" /AP << /N ");
                sb.append(this.apRef);
                sb.append(" 0 R >>");
            }
        } else {
            CircleAnnotation.appendValues(" /Rect [ ", sb, this.rect);
            sb.append(this.getStrokeColorString());
            sb.append(this.getNonStrokeColorString());
        }
        sb.append(">>");
        return sb.toString();
    }

    private static void appendValues(String prefix, StringBuilder sb, float[] ic) {
        sb.append(prefix);
        for (float anIc : ic) {
            sb.append(anIc);
            sb.append(' ');
        }
        sb.append(']');
    }

    @Override
    public String getAPString(int parentObj) {
        FormObject N2;
        PdfObject AP;
        super.getAPString(parentObj);
        StringBuilder sb = new StringBuilder();
        if (this.form != null && (AP = this.form.getDictionary(4384)) != null && (N2 = (FormObject)AP.getDictionary(30)) != null) {
            byte[] stream = N2.getDecodedStream();
            sb.append("<< /Type /XObject /Subtype /Form");
            sb.append(" /FormType ");
            sb.append(N2.getInt(982024818));
            sb.append(" /Length ");
            sb.append(stream.length);
            float[] bbox = N2.getFloatArray(303185736);
            CircleAnnotation.appendValues(" /BBox [ ", sb, bbox);
            float ca = this.form.getFloatNumber(4881);
            if (ca != 1.0f) {
                sb.append(" /Resources <<");
                sb.append("/ExtGState <</GS0 <</Type /ExtGState /AIS false /CA ").append(ca).append(" /ca ").append(ca).append(" >> >>");
                sb.append(" >>");
            }
            sb.append(">>");
            sb.append("stream\n");
            sb.append(StringUtils.getTextString(N2.getDecodedStream(), true));
            sb.append("\nendstream");
        }
        return sb.toString();
    }
}

