/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.annotation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jpedal.io.annotation.WritableAnnotation;
import org.jpedal.io.annotation.utils.AnnotArray;
import org.jpedal.io.annotation.utils.AnnotBuffer;
import org.jpedal.io.annotation.utils.AnnotDict;
import org.jpedal.io.annotation.utils.AnnotInfo;
import org.jpedal.io.annotation.utils.AnnotLEX;
import org.jpedal.io.annotation.utils.AnnotOREF;
import org.jpedal.io.annotation.utils.AnnotObject;

public final class AnnotationWriter {
    private AnnotationWriter() {
    }

    public static void writeAnnotations(File input, File output, WritableAnnotation[] annotArr) throws IOException {
        AnnotBuffer mainBuff;
        AnnotInfo info = new AnnotInfo();
        info.mainBuffer = mainBuff = new AnnotBuffer(input, info);
        int prev = mainBuff.findFirstXREFOffset();
        mainBuff.movePos(prev);
        mainBuff.readSimpleXREF();
        mainBuff.updateAllObjStm();
        mainBuff.updatePageOffsets();
        int maxRef = info.offsetMap.maxKey;
        byte[] appendData = AnnotationWriter.saveAnnotationObjects(info, (int)input.length(), prev, ++maxRef, annotArr);
        mainBuff.close();
        boolean justAppend = input.equals(output);
        try (FileOutputStream fos = new FileOutputStream(output, justAppend);){
            if (!justAppend) {
                try (FileInputStream fis = new FileInputStream(input);){
                    int n2;
                    byte[] buffer = new byte[1024];
                    while ((n2 = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, n2);
                    }
                }
            }
            fos.write(appendData);
        }
    }

    private static byte[] saveAnnotationObjects(AnnotInfo info, int fileLen, int prev, int maxRef, WritableAnnotation[] annotArr) throws IOException {
        int objRef = maxRef;
        int objOff = fileLen;
        ArrayList<int[]> annotOffsets = new ArrayList<int[]>();
        HashMap<String, Integer> pageOffsetsObj = new HashMap<String, Integer>();
        HashMap<String, int[]> pageOffsetsObj2 = new HashMap<String, int[]>();
        HashMap<String, AnnotDict> pageDictsObj = new HashMap<String, AnnotDict>();
        AnnotBuffer tBuff = info.mainBuffer;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (WritableAnnotation anAnnotArr : annotArr) {
            for (byte[] res : anAnnotArr.getResources(objRef)) {
                if (res == null || res.length == 0) continue;
                objOff += AnnotationWriter.saveAnnotationBytes(res, anAnnotArr.getPage(), objRef, objOff, tBuff, annotOffsets, pageOffsetsObj, null, info, bos);
                ++objRef;
            }
            String ap2 = anAnnotArr.getAPString(objRef);
            if (ap2 != null && !ap2.isEmpty()) {
                objOff += AnnotationWriter.saveAnnotation(ap2, anAnnotArr.getPage(), objRef, objOff, tBuff, annotOffsets, pageOffsetsObj, null, info, bos);
                ++objRef;
            }
            objOff += AnnotationWriter.saveAnnotation(anAnnotArr.getDictString(), anAnnotArr.getPage(), objRef, objOff, tBuff, annotOffsets, pageOffsetsObj, pageDictsObj, info, bos);
            String popupDict = anAnnotArr.getPopupString(objRef);
            ++objRef;
            if (popupDict == null) continue;
            objOff += AnnotationWriter.saveAnnotation(popupDict, anAnnotArr.getPage(), objRef, objOff, tBuff, annotOffsets, pageOffsetsObj, pageDictsObj, info, bos);
            ++objRef;
        }
        int curPageStart = fileLen + bos.size();
        for (String pn : pageOffsetsObj.keySet()) {
            int pageRef = (Integer)pageOffsetsObj.get(pn);
            pageOffsetsObj2.put(pn, new int[]{pageRef, curPageStart});
            AnnotDict pageDict = pageDictsObj.get(pn);
            String pageDictStr = pageRef + " 0 obj\n" + pageDict.toText() + "\nendobj\n";
            byte[] dictBytes = AnnotLEX.textToBytes(pageDictStr);
            bos.write(dictBytes);
            curPageStart = fileLen + bos.size();
        }
        int current = fileLen + bos.size();
        if (info.xrefType == 1) {
            AnnotationWriter.generateStreamXREF(info, bos, prev, current, maxRef, annotOffsets, pageOffsetsObj2);
        } else {
            AnnotationWriter.generateSimpleXREF(info, bos, prev, current, maxRef, annotOffsets, pageOffsetsObj2);
        }
        bos.close();
        return bos.toByteArray();
    }

    private static int saveAnnotation(String dictString, int pageNum, int objRef, int objOff, AnnotBuffer tBuff, List<int[]> annotOffsets, HashMap<String, Integer> pageOffsetsObj, HashMap<String, AnnotDict> pageDictsObj, AnnotInfo info, ByteArrayOutputStream bos) throws IOException {
        if (dictString == null) {
            return 0;
        }
        return AnnotationWriter.saveAnnotationBytes(AnnotLEX.textToBytes(dictString), pageNum, objRef, objOff, tBuff, annotOffsets, pageOffsetsObj, pageDictsObj, info, bos);
    }

    private static int saveAnnotationBytes(byte[] dictBytes, int pageNum, int objRef, int objOff, AnnotBuffer tBuff, List<int[]> annotOffsets, HashMap<String, Integer> pageOffsetsObj, HashMap<String, AnnotDict> pageDictsObj, AnnotInfo info, ByteArrayOutputStream bos) throws IOException {
        if (dictBytes == null) {
            return 0;
        }
        annotOffsets.add(new int[]{objRef, objOff});
        int bosLength = bos.size();
        bos.write(AnnotLEX.textToBytes(objRef + " 0 obj\n"));
        bos.write(dictBytes);
        bos.write(AnnotLEX.textToBytes("\nendobj\n"));
        bosLength = bos.size() - bosLength;
        if (pageDictsObj != null) {
            AnnotDict pageDict;
            String pageNumStr = String.valueOf(pageNum);
            AnnotOREF page = info.pageOffsets[pageNum];
            if (pageDictsObj.containsKey(pageNumStr)) {
                pageDict = pageDictsObj.get(pageNumStr);
            } else {
                pageDict = (AnnotDict)tBuff.getObjectValue(page);
                pageDictsObj.put(pageNumStr, pageDict);
            }
            AnnotObject annotName = pageDict.keys.get("Annots");
            pageOffsetsObj.put(pageNumStr, page.num);
            if (annotName != null) {
                if (AnnotLEX.isRef(annotName)) {
                    AnnotObject annotRef = tBuff.getObjectValue(annotName);
                    if (AnnotLEX.isArray(annotRef)) {
                        AnnotArray tArr = (AnnotArray)annotRef;
                        AnnotArray temp = new AnnotArray();
                        int jj = tArr.items.size();
                        for (int j2 = 0; j2 < jj; ++j2) {
                            temp.items.add(tArr.items.get(j2));
                        }
                        temp.items.add(new AnnotOREF(objRef, 0));
                        pageDict.keys.put("Annots", temp);
                    } else {
                        AnnotArray temp = new AnnotArray();
                        temp.items.add(annotName);
                        temp.items.add(new AnnotOREF(objRef, 0));
                        pageDict.keys.put("Annots", temp);
                    }
                } else if (AnnotLEX.isArray(annotName)) {
                    AnnotArray aa2 = (AnnotArray)annotName;
                    aa2.items.add(new AnnotOREF(objRef, 0));
                } else {
                    AnnotArray temp = new AnnotArray();
                    temp.items.add(new AnnotOREF(objRef, 0));
                    pageDict.keys.put("Annots", temp);
                }
            } else {
                AnnotArray temp = new AnnotArray();
                temp.items.add(new AnnotOREF(objRef, 0));
                pageDict.keys.put("Annots", temp);
            }
        }
        return bosLength;
    }

    private static void generateStreamXREF(AnnotInfo info, ByteArrayOutputStream bos, int prev, int current, int maxRef, List<int[]> annotOffsets, HashMap<String, int[]> pageOffsetsObj) throws IOException {
        String dictStr;
        int totalAnnots = annotOffsets.size();
        StringBuilder indexBuilder = new StringBuilder();
        indexBuilder.append('[');
        try (ByteArrayOutputStream wBytes = new ByteArrayOutputStream();){
            for (String pn : pageOffsetsObj.keySet()) {
                int ref = pageOffsetsObj.get(pn)[0];
                int offset = pageOffsetsObj.get(pn)[1];
                wBytes.write(1);
                wBytes.write(AnnotLEX.toBytes32(offset));
                wBytes.write(0);
                indexBuilder.append(ref);
                indexBuilder.append(" 1 ");
            }
            indexBuilder.append(maxRef).append(' ').append(totalAnnots).append(']');
            for (int[] annotOffset : annotOffsets) {
                int offset = annotOffset[1];
                wBytes.write(1);
                wBytes.write(AnnotLEX.toBytes32(offset));
                wBytes.write(0);
            }
            wBytes.close();
            int size = maxRef + totalAnnots + 1;
            dictStr = size + " 0 obj\n<</Type /XRef /Root " + info.mainCatalog.ref + " /Prev " + prev + " /Index " + indexBuilder + " /W [1 4 1] /Size " + size + "/Length " + wBytes.size() + ">>stream\n";
            bos.write(AnnotLEX.textToBytes(dictStr));
            bos.write(wBytes.toByteArray());
        }
        dictStr = "\nendstream\nendobj\nstartxref\n" + current + "\n%%EOF\n";
        bos.write(AnnotLEX.textToBytes(dictStr));
    }

    private static void generateSimpleXREF(AnnotInfo info, ByteArrayOutputStream bos, int prev, int current, int maxRef, List<int[]> annotOffsets, HashMap<String, int[]> pageOffsetsObj) throws IOException {
        byte[] trailer = new byte[]{120, 114, 101, 102, 10};
        bos.write(trailer);
        StringBuilder temp = new StringBuilder();
        for (String string : pageOffsetsObj.keySet()) {
            int pageRef = pageOffsetsObj.get(string)[0];
            int pageOffset = pageOffsetsObj.get(string)[1];
            temp.append(pageRef).append(" 1\n").append(AnnotLEX.getZeroLead(pageOffset)).append(" 00000 n \n");
        }
        int totalAnnots = annotOffsets.size();
        if (totalAnnots != 0) {
            temp.append(maxRef).append(' ').append(totalAnnots).append('\n');
            for (int[] offsets : annotOffsets) {
                temp.append(AnnotLEX.getZeroLead(offsets[1])).append(" 00000 n \n");
            }
        }
        int n2 = maxRef + totalAnnots;
        temp.append("trailer\n<</Size ").append(n2).append(" /Root ");
        temp.append(info.mainCatalog.ref).append(" /Prev ").append(prev).append(">>\n");
        temp.append("startxref\n").append(current).append("\n%%EOF\n");
        bos.write(AnnotLEX.textToBytes(temp.toString()));
    }
}

