/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;

final class TempStoreImage {
    private TempStoreImage() {
    }

    static byte[] getBytes(BufferedImage img) {
        byte[] data = new byte[img.getWidth() * img.getHeight() * 4 + 9];
        byte[] w2 = TempStoreImage.numToBytes(img.getWidth());
        System.arraycopy(w2, 0, data, 0, 4);
        byte[] h2 = TempStoreImage.numToBytes(img.getHeight());
        System.arraycopy(h2, 0, data, 4, 4);
        data[8] = 2;
        Raster parentRaster = img.getRaster().getParent();
        if (parentRaster != null && (parentRaster.getWidth() > img.getWidth() || parentRaster.getHeight() > img.getHeight())) {
            TempStoreImage.handleTranslatedImage(img, data);
            return data;
        }
        switch (img.getType()) {
            case 1: {
                data = TempStoreImage.handleIntRGB(img);
                break;
            }
            case 2: 
            case 3: {
                TempStoreImage.handleIntARGB(img, data);
                break;
            }
            case 4: {
                TempStoreImage.handleIntBGR(img, data);
                break;
            }
            case 5: {
                TempStoreImage.handle3ByteBGR(img, data);
                break;
            }
            case 6: 
            case 7: {
                TempStoreImage.handle4ByteABGR(img, data);
                break;
            }
            default: {
                TempStoreImage.getBytesForDefaultImage(img, data);
            }
        }
        return data;
    }

    private static void handleTranslatedImage(BufferedImage img, byte[] data) {
        int p2 = 9;
        for (int y2 = 0; y2 < img.getHeight(); ++y2) {
            for (int x2 = 0; x2 < img.getWidth(); ++x2) {
                int v2 = img.getRGB(x2, y2);
                data[p2++] = (byte)(v2 >> 24 & 0xFF);
                data[p2++] = (byte)(v2 >> 16 & 0xFF);
                data[p2++] = (byte)(v2 >> 8 & 0xFF);
                data[p2++] = (byte)(v2 & 0xFF);
            }
        }
    }

    private static void getBytesForDefaultImage(BufferedImage img, byte[] data) {
        int p2 = 9;
        BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        img2.getGraphics().drawImage(img, 0, 0, null);
        int[] pixels = ((DataBufferInt)img2.getRaster().getDataBuffer()).getData();
        int ii = img.getWidth() * img.getHeight();
        for (int i2 = 0; i2 < ii; ++i2) {
            int v2 = pixels[i2];
            data[p2++] = (byte)(v2 >> 24 & 0xFF);
            data[p2++] = (byte)(v2 >> 16 & 0xFF);
            data[p2++] = (byte)(v2 >> 8 & 0xFF);
            data[p2++] = (byte)(v2 & 0xFF);
        }
    }

    private static void handle4ByteABGR(BufferedImage img, byte[] data) {
        int p2 = 9;
        byte[] pixBytes = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        int pp = 0;
        int ii = img.getWidth() * img.getHeight();
        for (int i2 = 0; i2 < ii; ++i2) {
            data[p2++] = pixBytes[pp];
            data[p2++] = pixBytes[pp + 3];
            data[p2++] = pixBytes[pp + 2];
            data[p2++] = pixBytes[pp + 1];
            pp += 4;
        }
    }

    private static void handle3ByteBGR(BufferedImage img, byte[] data) {
        int p2 = 9;
        byte[] pixBytes = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        int pp = 0;
        int ii = img.getWidth() * img.getHeight();
        for (int i2 = 0; i2 < ii; ++i2) {
            data[p2++] = -1;
            data[p2++] = pixBytes[pp + 2];
            data[p2++] = pixBytes[pp + 1];
            data[p2++] = pixBytes[pp];
            pp += 3;
        }
    }

    private static void handleIntBGR(BufferedImage img, byte[] data) {
        int p2 = 9;
        int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int ii = img.getWidth() * img.getHeight();
        for (int i2 = 0; i2 < ii; ++i2) {
            int v2 = pixels[i2];
            data[p2++] = -1;
            data[p2++] = (byte)(v2 & 0xFF);
            data[p2++] = (byte)(v2 >> 8 & 0xFF);
            data[p2++] = (byte)(v2 >> 16 & 0xFF);
        }
    }

    private static void handleIntARGB(BufferedImage img, byte[] data) {
        int p2 = 9;
        int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int ii = img.getWidth() * img.getHeight();
        for (int i2 = 0; i2 < ii; ++i2) {
            int v2 = pixels[i2];
            data[p2++] = (byte)(v2 >> 24 & 0xFF);
            data[p2++] = (byte)(v2 >> 16 & 0xFF);
            data[p2++] = (byte)(v2 >> 8 & 0xFF);
            data[p2++] = (byte)(v2 & 0xFF);
        }
    }

    private static byte[] handleIntRGB(BufferedImage img) {
        byte[] w2 = TempStoreImage.numToBytes(img.getWidth());
        byte[] h2 = TempStoreImage.numToBytes(img.getHeight());
        int p2 = 9;
        byte[] data = new byte[img.getWidth() * img.getHeight() * 3 + 9];
        System.arraycopy(w2, 0, data, 0, 4);
        System.arraycopy(h2, 0, data, 4, 4);
        data[8] = 1;
        int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int dim = img.getWidth() * img.getHeight();
        for (int i2 = 0; i2 < dim; ++i2) {
            int v2 = pixels[i2];
            data[p2++] = (byte)(v2 >> 16 & 0xFF);
            data[p2++] = (byte)(v2 >> 8 & 0xFF);
            data[p2++] = (byte)(v2 & 0xFF);
        }
        return data;
    }

    static BufferedImage getImage(byte[] data) {
        BufferedImage img;
        int w2 = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        int h2 = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        byte type = data[8];
        if (type == 1) {
            img = new BufferedImage(w2, h2, 1);
            int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
            int p2 = 0;
            int pp = 9;
            int dim = w2 * h2;
            for (int i2 = 0; i2 < dim; ++i2) {
                pixels[p2++] = (data[pp++] & 0xFF) << 16 | (data[pp++] & 0xFF) << 8 | data[pp++] & 0xFF;
            }
        } else {
            img = new BufferedImage(w2, h2, 2);
            int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
            int p3 = 0;
            int pp = 9;
            int ii = w2 * h2;
            for (int i3 = 0; i3 < ii; ++i3) {
                pixels[p3++] = (data[pp++] & 0xFF) << 24 | (data[pp++] & 0xFF) << 16 | (data[pp++] & 0xFF) << 8 | data[pp++] & 0xFF;
            }
        }
        return img;
    }

    private static byte[] numToBytes(int num) {
        return new byte[]{(byte)(num >> 24), (byte)(num >> 16 & 0xFF), (byte)(num >> 8 & 0xFF), (byte)(num & 0xFF)};
    }
}

