/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.idrsolutions.image.filter.ASCII85FilterOptions;
import com.idrsolutions.image.filter.ASCIIHexFilterOptions;
import com.idrsolutions.image.filter.CCITTFilterOptions;
import com.idrsolutions.image.filter.DCTFilterOptions;
import com.idrsolutions.image.filter.Filter;
import com.idrsolutions.image.filter.FlateFilterOptions;
import com.idrsolutions.image.filter.JPXFilterOptions;
import com.idrsolutions.image.filter.LZWFilterOptions;
import com.idrsolutions.image.filter.RunLengthFilterOptions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.IdrInputStream;
import org.jpedal.io.IdrOutputStream;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.filter.ASCII85;
import org.jpedal.io.filter.ASCIIHex;
import org.jpedal.io.filter.CCITT;
import org.jpedal.io.filter.DCT;
import org.jpedal.io.filter.Flate;
import org.jpedal.io.filter.JPX;
import org.jpedal.io.filter.LZW;
import org.jpedal.io.filter.RunLength;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.jbig2.io.JBIG2;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class PdfFilteredReader {
    public static final int A85 = 1116165;
    public static final int AHx = 0x111848;
    public static final int ASCII85Decode = 1582784916;
    public static final int ASCIIHexDecode = 2074112677;
    public static final int CCITTFaxDecode = 2108391315;
    public static final int CCF = 0x131316;
    public static final int Crypt = 1112096855;
    public static final int DCTDecode = 1180911742;
    public static final int Fl = 5692;
    public static final int FlateDecode = 2005566619;
    public static final int JBIG2Decode = 1247500931;
    public static final int JPXDecode = 1399277700;
    public static final int LZW = 1845799;
    public static final int LZWDecode = 1566984326;
    public static final int RL = 8732;
    public static final int RunLengthDecode = -1815163937;
    private final Map<String, String> cachedObjects = new HashMap<String, String>();
    private BufferedOutputStream streamCache;
    private BufferedInputStream bis;
    private boolean hasError;
    private byte[] encHash;

    public byte[] decodeFilters(PdfObject[] DecodeParmsArray, byte[] data, PdfArrayIterator filters, int width, int height, String cacheName, PdfObject pdfObject) throws Exception {
        if (filters.getTokenCount() > 0) {
            return this.decode(DecodeParmsArray, data, filters, width, height, cacheName, pdfObject);
        }
        return data;
    }

    private byte[] decode(PdfObject[] DecodeParmsArray, byte[] data, PdfArrayIterator filters, int w2, int h2, String cacheName, PdfObject pdfObject) throws Exception {
        int parmsCount = DecodeParmsArray.length;
        PdfObject DecodeParms = null;
        if (parmsCount > 0) {
            DecodeParms = DecodeParmsArray[0];
        }
        byte[] globalData = PdfFilteredReader.getGlobalData(DecodeParms);
        boolean isCached = cacheName != null;
        int counter = 0;
        while (filters.hasMoreTokens()) {
            int filterType = filters.getNextValueAsConstant(true);
            if (parmsCount > 1) {
                PdfObject Globals;
                DecodeParms = DecodeParmsArray[counter];
                globalData = null;
                if (DecodeParms != null && (Globals = DecodeParms.getDictionary(1314558361)) != null) {
                    globalData = Globals.getDecodedStream();
                }
            }
            if (isCached) {
                if (filterType == 1112096855) {
                    ++counter;
                    continue;
                }
                this.setupCachedObjectForDecoding(cacheName);
            }
            data = this.getDecodedData(data, w2, h2, cacheName, DecodeParms, globalData, filterType, pdfObject);
            if (isCached) {
                this.flushCache();
            }
            ++counter;
        }
        return data;
    }

    public byte[] getDecodedData(byte[] data, int w2, int h2, String cacheName, PdfObject decodeParms, byte[] globalData, int filterType, PdfObject pdfObject) throws Exception {
        switch (filterType) {
            case 1180911742: {
                DCTFilterOptions options = decodeParms != null ? new DCTFilterOptions(decodeParms.getInt(-1263544861)) : new DCTFilterOptions();
                data = this.applyFilter(data, cacheName, filterType, false, new DCT(options));
                break;
            }
            case 5692: 
            case 2005566619: {
                FlateFilterOptions options = decodeParms != null ? new FlateFilterOptions(decodeParms.getInt(-1344207655), decodeParms.getInt(1010783618), decodeParms.getInt(1162902911), decodeParms.getInt(1970893723)) : new FlateFilterOptions();
                data = this.applyFilter(data, cacheName, filterType, false, new Flate(options));
                break;
            }
            case 1116165: 
            case 1582784916: {
                ASCII85FilterOptions options = new ASCII85FilterOptions();
                data = this.applyFilter(data, cacheName, filterType, false, new ASCII85(options));
                break;
            }
            case 0x131316: 
            case 2108391315: {
                CCITTFilterOptions options = decodeParms != null ? new CCITTFilterOptions(w2, h2, decodeParms.getInt(1162902911), decodeParms.getInt(27), decodeParms.getBoolean(1297445940), decodeParms.getBoolean(-823077984), decodeParms.getBoolean(1517116800), 1) : new CCITTFilterOptions(w2, h2);
                data = this.applyFilter(data, cacheName, filterType, false, new CCITT(options));
                break;
            }
            case 1399277700: {
                JPXFilterOptions options = new JPXFilterOptions();
                JPX jpx = new JPX(options);
                data = this.applyFilter(data, cacheName, filterType, false, jpx);
                pdfObject.setIntNumber(-789460276, jpx.getRawColorSpace());
                break;
            }
            case 1845799: 
            case 1566984326: {
                LZWFilterOptions options = decodeParms != null ? new LZWFilterOptions(decodeParms.getInt(-1344207655), decodeParms.getInt(1010783618), decodeParms.getInt(1162902911), decodeParms.getInt(1838971823), decodeParms.getInt(1970893723), decodeParms.getInt(574572355)) : new LZWFilterOptions();
                data = this.applyFilter(data, cacheName, filterType, true, new LZW(options, w2, h2));
                break;
            }
            case -1815163937: 
            case 8732: {
                RunLengthFilterOptions options = new RunLengthFilterOptions();
                data = this.applyFilter(data, cacheName, filterType, false, new RunLength(options));
                break;
            }
            case 1247500931: {
                data = PdfFilteredReader.getJBIGBytes(data, globalData, this.bis, this.streamCache);
                break;
            }
            case 0x111848: 
            case 2074112677: {
                ASCIIHexFilterOptions options = new ASCIIHexFilterOptions();
                data = this.applyFilter(data, cacheName, filterType, false, new ASCIIHex(options));
                break;
            }
            case 1112096855: {
                break;
            }
        }
        return data;
    }

    private static byte[] getGlobalData(PdfObject decodeParms) {
        PdfObject Globals;
        byte[] globalData = null;
        if (decodeParms != null && (Globals = decodeParms.getDictionary(1314558361)) != null) {
            globalData = Globals.getDecodedStream();
        }
        return globalData;
    }

    private byte[] applyFilter(byte[] data, String cacheName, int filterType, boolean resetDataToNull, Filter filter) {
        block8: {
            try {
                if (data != null) {
                    if (data.length > 0) {
                        data = filter.decode(data);
                    } else {
                        LogWriter.writeLog("[PDF] Do not try to decompress zero length data stream");
                    }
                } else if (this.bis != null) {
                    filter.setEncHash(this.encHash);
                    filter.decode(this.bis, this.streamCache, cacheName, this.cachedObjects);
                }
                if (!this.hasError && filter.hasError()) {
                    this.hasError = true;
                }
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception " + ee + " in " + PdfFilteredReader.getFilterName(filterType) + " decompression");
                if (!resetDataToNull) break block8;
                data = null;
            }
        }
        return data;
    }

    private void flushCache() throws IOException {
        if (this.bis != null) {
            this.bis.close();
            this.bis = null;
        }
        if (this.streamCache != null) {
            this.streamCache.flush();
            this.streamCache.close();
            this.streamCache = null;
        }
    }

    private static byte[] getJBIGBytes(byte[] data, byte[] globalData, BufferedInputStream bis, BufferedOutputStream streamCache) throws Exception {
        if (data == null) {
            data = new byte[bis.available()];
            bis.read(data);
            int ptr = -1;
            for (int ii = data.length - 1; ii > 9; --ii) {
                if (data[ii] != 101 || data[ii + 1] != 110 || data[ii + 2] != 100 || data[ii + 3] != 115 || data[ii + 4] != 116 || data[ii + 5] != 114 || data[ii + 6] != 101 || data[ii + 7] != 97 || data[ii + 8] != 109) continue;
                ptr = ii - 1;
                break;
            }
            if (ptr != -1) {
                if (data[ptr] == 10 && data[ptr - 1] == 13) {
                    --ptr;
                }
                byte[] tmp = data;
                data = new byte[ptr];
                System.arraycopy(tmp, 0, data, 0, ptr);
            }
            data = JBIG2.JBIGDecode(data, globalData);
            streamCache.write(data);
            data = null;
        } else {
            data = JBIG2.JBIGDecode(data, globalData);
        }
        return data;
    }

    private static String getFilterName(int filterType) {
        switch (filterType) {
            case 1116165: {
                return "A85";
            }
            case 0x111848: {
                return "AHx";
            }
            case 1582784916: {
                return "ASCII85Decode";
            }
            case 2074112677: {
                return "ASCIIHexDecode";
            }
            case 2108391315: {
                return "CCITTFaxDecode";
            }
            case 0x131316: {
                return "CCF";
            }
            case 1112096855: {
                return "Crypt";
            }
            case 1180911742: {
                return "DCTDecode";
            }
            case 5692: {
                return "Fl";
            }
            case 2005566619: {
                return "FlateDecode";
            }
            case 1247500931: {
                return "JBIG2Decode";
            }
            case -1815163937: 
            case 8732: 
            case 1845799: 
            case 1399277700: 
            case 1566984326: {
                return "";
            }
        }
        return "Unknown";
    }

    private void setupCachedObjectForDecoding(String cacheName) throws Exception {
        File tempFile2 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
        this.cachedObjects.put(tempFile2.getAbsolutePath(), "x");
        ObjectStore.copy(cacheName, tempFile2.getAbsolutePath());
        File rawFile = new File(cacheName);
        rawFile.delete();
        if (this.encHash != null) {
            this.streamCache = new BufferedOutputStream(new IdrOutputStream(Files.newOutputStream(Paths.get(cacheName, new String[0]), new OpenOption[0]), new CryptoIDR(this.encHash)));
            this.bis = new BufferedInputStream(new IdrInputStream(Files.newInputStream(tempFile2.toPath(), new OpenOption[0]), new CryptoIDR(this.encHash)));
        } else {
            this.streamCache = new BufferedOutputStream(Files.newOutputStream(Paths.get(cacheName, new String[0]), new OpenOption[0]));
            this.bis = new BufferedInputStream(Files.newInputStream(tempFile2.toPath(), new OpenOption[0]));
        }
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void setEncHash(byte[] encHash) {
        this.encHash = encHash;
    }
}

