/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.IdrInputStream;
import org.jpedal.io.IdrOutputStream;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.io.types.CompressedObjects;
import org.jpedal.io.types.ObjectReader;
import org.jpedal.io.types.Offsets;
import org.jpedal.io.types.RefTable;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.EncryptionObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;

public class PdfFileReader {
    private ObjectReader objectReader;
    private PrivateKey key;
    private Certificate certificate;
    private LinearizedHintTable linHintTable;
    private byte[] lastCompressedStream;
    private Map<String, String> lastOffsetStart;
    private Map<String, String> lastOffsetEnd;
    private PdfObject compressedObj;
    private int lastFirst = -1;
    private int lastCompressedID = -1;
    private RefTable refTable;
    PdfObject encyptionObj;
    private DecryptionFactory decryption;
    private byte[] encryptionPassword;
    private RandomAccessBuffer pdf_datafile;
    private Offsets offset = new Offsets(2000);
    public static int alwaysCacheInMemory = 16384;
    private long eof;
    private int[] ObjLengthTable;

    public PdfObject getInfoObject() {
        return this.refTable.getInfoObject();
    }

    public byte[] getID() {
        return this.refTable.getID();
    }

    public PdfObject getRootObject() {
        return this.refTable.getRootObject();
    }

    public void setCacheSize(int miniumumCacheSize) {
        this.objectReader.setCacheSize(miniumumCacheSize);
    }

    public byte[] getBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    public void init(RandomAccessBuffer pdf_datafile) {
        this.pdf_datafile = pdf_datafile;
        try {
            this.eof = pdf_datafile.length();
        }
        catch (IOException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        this.objectReader = new ObjectReader(pdf_datafile, this.eof, this);
        this.refTable = new RefTable(pdf_datafile, this.eof, this.offset);
    }

    public final void readObject(PdfObject pdfObject) {
        if (pdfObject.isDataExternal() && this.linHintTable != null) {
            this.readExternalObject(pdfObject);
        } else {
            byte[] raw;
            String objectRef = pdfObject.getObjectRefAsString();
            int id2 = pdfObject.getObjectRefID();
            boolean isCompressed = this.offset.isCompressed(id2);
            pdfObject.setCompressedStream(isCompressed);
            if (isCompressed) {
                raw = this.readCompressedObject(pdfObject);
            } else {
                this.movePointer(this.offset.elementAt(id2));
                if (objectRef.charAt(0) == '<') {
                    raw = this.objectReader.readObjectData(-1, pdfObject);
                } else if (this.ObjLengthTable == null || this.offset.isRefTableInvalid()) {
                    raw = this.getPointer() == 0L ? new byte[]{} : this.objectReader.readObjectData(-1, pdfObject);
                } else if (id2 > this.ObjLengthTable.length || this.ObjLengthTable[id2] == 0) {
                    LogWriter.writeLog(objectRef + " cannot have offset 0");
                    raw = new byte[]{};
                } else {
                    raw = this.objectReader.readObjectData(this.ObjLengthTable[id2], pdfObject);
                }
            }
            if (raw.length > 1) {
                ObjectDecoder objDecoder = new ObjectDecoder(this);
                objDecoder.readDictionaryAsObject(pdfObject, 0, raw);
            }
        }
    }

    private void readExternalObject(PdfObject pdfObject) {
        int ref = pdfObject.getObjectRefID();
        int generation = pdfObject.getObjectRefGeneration();
        byte[] pageData = this.readObjectAsByteArray(pdfObject, this.isCompressed(ref, generation), ref, generation);
        pdfObject.setUnresolvedData(pageData, 540096309);
        ObjectDecoder.resolveFully(pdfObject, this);
    }

    private byte[] readCompressedObject(PdfObject pdfObject) {
        byte[] raw;
        int objectID = pdfObject.getObjectRefID();
        int compressedID = (int)this.offset.elementAt(objectID);
        String startID = null;
        int First2 = this.lastFirst;
        boolean isCached = true;
        byte[] compressedStream = this.lastCompressedStream;
        Map<String, String> offsetStart = this.lastOffsetStart;
        Map<String, String> offsetEnd = this.lastOffsetEnd;
        PdfObject Extends = null;
        if (this.lastOffsetStart != null && compressedID == this.lastCompressedID) {
            startID = this.lastOffsetStart.get(String.valueOf(objectID));
        }
        while (startID == null) {
            if (Extends != null) {
                this.compressedObj = Extends;
            } else if (compressedID != this.lastCompressedID) {
                isCached = false;
                this.movePointer(this.offset.elementAt(compressedID));
                raw = this.objectReader.readObjectData(this.ObjLengthTable[compressedID], null);
                this.compressedObj = new CompressedObject(compressedID, 0);
                ObjectDecoder objDecoder = new ObjectDecoder(this);
                objDecoder.readDictionaryAsObject(this.compressedObj, 0, raw);
            }
            offsetStart = new HashMap<String, String>();
            offsetEnd = new HashMap<String, String>();
            First2 = this.compressedObj.getInt(960643930);
            compressedStream = this.compressedObj.getDecodedStream();
            CompressedObjects.extractCompressedObjectOffset(offsetStart, offsetEnd, First2, compressedStream, compressedID, this.offset);
            startID = offsetStart.get(String.valueOf(objectID));
            Extends = this.compressedObj.getDictionary(894663815);
            if (Extends != null) continue;
        }
        if (!isCached) {
            this.lastCompressedStream = compressedStream;
            this.lastCompressedID = compressedID;
            this.lastOffsetStart = offsetStart;
            this.lastOffsetEnd = offsetEnd;
            this.lastFirst = First2;
        }
        int start = First2 + Integer.parseInt(startID);
        int end = compressedStream.length;
        String endID = offsetEnd.get(String.valueOf(objectID));
        if (endID != null) {
            end = First2 + Integer.parseInt(endID);
        }
        int streamLength = end - start;
        raw = new byte[streamLength];
        System.arraycopy(compressedStream, start, raw, 0, streamLength);
        pdfObject.setInCompressedStream(true);
        return raw;
    }

    public final byte[] readStream(PdfObject pdfObject, boolean cacheValue, boolean decompress, boolean keepRaw, boolean isMetaData, boolean isCompressedStream, String cacheName) {
        boolean isCachedOnDisk = pdfObject.isCached();
        byte[] stream = null;
        if (!isCachedOnDisk) {
            stream = pdfObject.getDecodedStream();
        }
        if (stream == null) {
            stream = this.getStream(pdfObject, cacheValue, decompress, keepRaw, isMetaData, isCompressedStream, cacheName, isCachedOnDisk);
        }
        return stream;
    }

    private byte[] getStream(PdfObject pdfObject, boolean cacheValue, boolean decompress, boolean keepRaw, boolean isMetaData, boolean isCompressedStream, String cacheName, boolean isCachedOnDisk) {
        byte[] stream = pdfObject.stream;
        if (isCachedOnDisk) {
            stream = PdfFileReader.decryptCaschedStream(pdfObject, isMetaData, isCompressedStream, cacheName, stream, this.decryption);
        }
        if (stream != null) {
            try {
                if (!(this.decryption == null || isCompressedStream || !this.decryption.getBooleanValue(102) && isMetaData)) {
                    stream = this.decryption.decrypt(stream, pdfObject.getObjectRefAsString(), false, null, false, false);
                }
            }
            catch (PdfSecurityException e2) {
                stream = null;
                LogWriter.writeLog("Exception " + e2 + " with " + pdfObject.getObjectRefAsString());
            }
        }
        if (keepRaw) {
            pdfObject.stream = null;
        }
        int length = 1;
        if (stream != null || isCachedOnDisk) {
            int newLength;
            int newW;
            int height = 1;
            int width = 1;
            int newH = pdfObject.getInt(959926393);
            if (newH != -1) {
                height = newH;
            }
            if ((newW = pdfObject.getInt(959726687)) != -1) {
                width = newW;
            }
            if ((newLength = pdfObject.getInt(1043816557)) != -1) {
                length = newLength;
            } else if (stream != null) {
                length = stream.length;
            }
            if (height * width == 1) {
                width = length;
            }
            PdfArrayIterator filters = pdfObject.getMixedArray(1011108731);
            int firstValue = -1;
            if (filters != null && filters.hasMoreTokens()) {
                firstValue = filters.getNextValueAsConstant(false);
            }
            if (filters != null && firstValue != -1) {
                try {
                    PdfFilteredReader filter = new PdfFilteredReader();
                    if (this.encryptionPassword != null) {
                        filter.setEncHash(this.encryptionPassword);
                    }
                    stream = filter.decodeFilters(ObjectUtils.setupDecodeParms(pdfObject, this), stream, filters, width, height, cacheName, pdfObject);
                    pdfObject.setStreamMayBeCorrupt(filter.hasError());
                }
                catch (Exception e3) {
                    LogWriter.writeLog("[PDF] Problem " + e3 + " decompressing stream ");
                    stream = null;
                    isCachedOnDisk = false;
                }
                length = 1;
            } else if (stream != null && length < stream.length) {
                if (length > 0) {
                    stream = PdfFileReader.resize(length, stream);
                } else if (stream.length == 1 && length == 0) {
                    stream = new byte[]{};
                }
            }
        }
        if (stream != null && cacheValue) {
            pdfObject.setDecodedStream(stream);
        }
        if (decompress && isCachedOnDisk && cacheName != null) {
            stream = PdfFileReader.getCachedStream(cacheName, length, this.encryptionPassword);
        }
        return stream;
    }

    private static byte[] getCachedStream(String cacheName, int length, byte[] encryptionPassword) {
        byte[] stream;
        int streamLength;
        block19: {
            streamLength = (int)new File(cacheName).length();
            stream = new byte[streamLength];
            try (FileInputStream fis = new FileInputStream(cacheName);){
                if (encryptionPassword != null) {
                    CryptoIDR crypto = new CryptoIDR(encryptionPassword);
                    try (IdrInputStream cryptStream = new IdrInputStream(fis, crypto);){
                        cryptStream.read(stream);
                        break block19;
                    }
                }
                try (BufferedInputStream is = new BufferedInputStream(fis);){
                    is.read(stream);
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        if (length != 1 && length < streamLength) {
            stream = PdfFileReader.resize(length, stream);
        }
        return stream;
    }

    private static byte[] decryptCaschedStream(PdfObject pdfObject, boolean isMetaData, boolean isCompressedStream, String cacheName, byte[] stream, DecryptionFactory decryption) {
        try {
            if (!(decryption == null || isCompressedStream || !decryption.getBooleanValue(102) && isMetaData)) {
                decryption.decrypt(null, pdfObject.getObjectRefAsString(), false, cacheName, false, false);
            }
        }
        catch (Exception e2) {
            stream = null;
            LogWriter.writeLog("Exception " + e2);
        }
        return stream;
    }

    private static byte[] resize(int length, byte[] bytes) {
        byte[] newStream = new byte[length];
        System.arraycopy(bytes, 0, newStream, 0, length);
        bytes = newStream;
        return bytes;
    }

    public int getPDFflag(Integer flag) {
        if (this.decryption == null) {
            return -1;
        }
        return this.decryption.getPDFflag(flag);
    }

    public void spoolStreamDataToDisk(File tmpFile, long start, int size) throws Exception {
        this.movePointer(start);
        if (this.encryptionPassword != null) {
            try (IdrOutputStream array = new IdrOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)), new CryptoIDR(this.encryptionPassword));){
                this.spoolToDisk(start, size, array);
            }
        }
        try (BufferedOutputStream array = new BufferedOutputStream(new FileOutputStream(tmpFile));){
            this.spoolToDisk(start, size, array);
        }
    }

    private void spoolToDisk(long start, int size, OutputStream array) {
        boolean hasValues = false;
        boolean startStreamFound = false;
        int bufSize = 128;
        int startStreamCount = 0;
        int realPos = 0;
        int XXX = 0x200000;
        int ptr = 0;
        int maxPtr = bufSize;
        byte[] readData = new byte[maxPtr];
        byte[] buffer = new byte[bufSize];
        try {
            int i2 = bufSize - 1;
            while (true) {
                if (++i2 == bufSize) {
                    long pointer = this.getPointer();
                    if (start == -1L) {
                        start = pointer;
                    }
                    if (pointer + (long)bufSize > this.eof) {
                        bufSize = (int)(this.eof - pointer);
                    }
                    buffer = new byte[bufSize += 6];
                    this.pdf_datafile.read(buffer);
                    i2 = 0;
                }
                byte currentByte = buffer[i2];
                if (startStreamFound && (hasValues || currentByte != 13 && currentByte != 10)) {
                    array.write(currentByte);
                    hasValues = true;
                    ++realPos;
                }
                if (startStreamCount < 6 && currentByte == ObjectReader.startStream[startStreamCount]) {
                    if (++startStreamCount == 6) {
                        startStreamFound = true;
                    }
                } else {
                    startStreamCount = 0;
                }
                if (realPos < size) {
                    readData[ptr] = currentByte;
                    if (++ptr != maxPtr) continue;
                    maxPtr = maxPtr < 0x200000 ? (maxPtr *= 2) : (maxPtr += 100000);
                    byte[] tmpArray = new byte[maxPtr];
                    System.arraycopy(readData, 0, tmpArray, 0, readData.length);
                    readData = tmpArray;
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            LogWriter.writeLog(e2);
        }
    }

    public void spoolStreamDataToDisk(File tmpFile, long start) throws Exception {
        if (this.encryptionPassword != null) {
            try (BufferedOutputStream array = new BufferedOutputStream(new IdrOutputStream(new FileOutputStream(tmpFile), new CryptoIDR(this.encryptionPassword)));){
                this.movePointer(start);
                this.processData(array);
            }
        }
        try (BufferedOutputStream array = new BufferedOutputStream(new FileOutputStream(tmpFile));){
            this.movePointer(start);
            this.processData(array);
        }
    }

    private void processData(BufferedOutputStream array) {
        boolean hasValues = false;
        int bufSize = 128;
        int startStreamCount = 0;
        boolean startStreamFound = false;
        int ptr = 0;
        int maxPtr = 128;
        byte[] readData = new byte[128];
        int charReached = 0;
        byte[] buffer = null;
        try {
            int i2 = 127;
            while (true) {
                if (++i2 == 128) {
                    buffer = this.getNextByteBlock();
                    i2 = 0;
                }
                if (buffer == null) break;
                byte currentByte = buffer[i2];
                if (startStreamFound && (hasValues || currentByte != 13 && currentByte != 10)) {
                    array.write(currentByte);
                    hasValues = true;
                }
                if (currentByte == ObjectDecoder.endPattern[charReached]) {
                    if (++charReached == 6) {
                        break;
                    }
                } else {
                    charReached = 0;
                }
                if (startStreamCount < 6 && currentByte == ObjectReader.startStream[startStreamCount]) {
                    if (!startStreamFound && ++startStreamCount == 6) {
                        startStreamFound = true;
                    }
                } else {
                    startStreamCount = 0;
                }
                readData[ptr] = currentByte;
                if (++ptr != maxPtr) continue;
                maxPtr = maxPtr < 4096 ? (maxPtr *= 2) : (maxPtr += 100000);
                byte[] tmpArray = new byte[maxPtr];
                System.arraycopy(readData, 0, tmpArray, 0, readData.length);
                readData = tmpArray;
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " reading object");
        }
    }

    private byte[] getNextByteBlock() {
        long pointer = this.getPointer();
        int nextBuffer = 128;
        if (pointer + 128L > this.eof) {
            nextBuffer = (int)(this.eof - pointer);
        }
        if (nextBuffer == 0) {
            return null;
        }
        byte[] buffer = new byte[nextBuffer += 6];
        try {
            this.pdf_datafile.read(buffer);
        }
        catch (IOException ex) {
            LogWriter.writeLog("Unable to fill buffer " + ex);
        }
        return buffer;
    }

    void closeFile() throws IOException {
        if (this.pdf_datafile != null) {
            this.pdf_datafile.close();
            this.pdf_datafile = null;
        }
    }

    public long getOffset(int currentID) {
        return this.offset.elementAt(currentID);
    }

    public int getOffsetLength(int currentID) {
        return this.ObjLengthTable[currentID];
    }

    public byte[] getBytes(long start, int count) {
        byte[] buffer = new byte[count];
        this.movePointer(start);
        try {
            this.pdf_datafile.read(buffer);
        }
        catch (IOException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        return buffer;
    }

    public void storeLinearizedTables(LinearizedHintTable linHintTable) {
        this.linHintTable = linHintTable;
    }

    public void dispose() {
        if (this.decryption != null) {
            this.decryption.flush();
            this.decryption.dispose();
        }
        if (this.decryption != null) {
            this.decryption.setCipherNull();
        }
        this.decryption = null;
        this.compressedObj = null;
        if (this.linHintTable != null) {
            this.linHintTable = null;
        }
        try {
            if (this.pdf_datafile != null) {
                this.pdf_datafile.close();
            }
        }
        catch (IOException e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
        this.pdf_datafile = null;
        if (this.offset != null) {
            this.offset.dispose();
        }
        this.offset = null;
    }

    public final ObjectReader getObjectReader() {
        return this.objectReader;
    }

    public final boolean validateFileStart() throws PdfException {
        block7: {
            if (this.eof == 0L) {
                throw new PdfException("Zero byte PDF file");
            }
            try {
                this.movePointer(0L);
                byte[] filestart = new byte[4];
                this.pdf_datafile.read(filestart);
                if (filestart[0] == 37 && filestart[1] == 80 && filestart[2] == 68 && filestart[3] == 70) {
                    return true;
                }
                this.movePointer(0L);
                int block = 255;
                if (this.eof < 255L) {
                    block = (int)this.eof;
                    PdfFileReader.scanForFileStart(block, 0, this.pdf_datafile);
                    break block7;
                }
                int offset = 0;
                while (!PdfFileReader.scanForFileStart(block, offset, this.pdf_datafile)) {
                    if (this.eof < (long)((offset += block) + block)) {
                        block = (int)this.eof - offset;
                        continue;
                    }
                    if (this.eof != (long)offset) continue;
                    break;
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception " + e2 + " in reading %PDF header at start of file");
            }
        }
        return false;
    }

    private static boolean scanForFileStart(int block, int currentOffset, RandomAccessBuffer pdf_datafile) throws IOException {
        byte[] filestart = new byte[block];
        pdf_datafile.read(filestart);
        for (int i2 = 0; i2 < block; ++i2) {
            if (filestart[i2] != 37 || filestart[i2 + 1] != 80 || filestart[i2 + 2] != 68 || filestart[i2 + 3] != 70 || filestart[i2 + 4] != 45) continue;
            pdf_datafile.setPaddingAtStartOfFile(currentOffset + i2);
            return true;
        }
        return false;
    }

    public final String getType() {
        String pdf_type = "";
        try {
            this.movePointer(0L);
            pdf_type = this.pdf_datafile.readLine();
            int pos = pdf_type.indexOf("%PDF");
            if (pos != -1) {
                pdf_type = pdf_type.substring(pos + 5);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " in reading type");
        }
        return pdf_type;
    }

    private void movePointer(long pointer) {
        try {
            if (pointer > this.pdf_datafile.length()) {
                LogWriter.writeLog("Attempting to access ref outside file");
            } else {
                this.pdf_datafile.seek(pointer);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " moving pointer to  " + pointer + " in file.");
        }
    }

    private long getPointer() {
        long old_pointer = 0L;
        try {
            old_pointer = this.pdf_datafile.getFilePointer();
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " getting pointer in file");
        }
        return old_pointer;
    }

    public final boolean isCompressed(int ref, int gen) {
        return this.offset.isCompressed(ref);
    }

    public DecryptionFactory getDecryptionObject() {
        return this.decryption;
    }

    public void setPassword(String password) {
        this.encryptionPassword = password.getBytes();
        if (this.decryption != null) {
            this.decryption.reset(this.encryptionPassword);
        }
    }

    public byte[] readObjectData(PdfObject pdfObject) {
        byte[] raw;
        byte[] data;
        String objectRef = pdfObject.getObjectRefAsString();
        int id2 = pdfObject.getObjectRefID();
        if (pdfObject.isDataExternal() && (data = this.readObjectAsByteArray(pdfObject, false, id2, 0)) == null) {
            pdfObject.setFullyResolved(false);
            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (15)");
            return null;
        }
        boolean isCompressed = this.offset.isCompressed(id2);
        pdfObject.setCompressedStream(isCompressed);
        if (isCompressed) {
            raw = this.readCompressedObjectData(pdfObject, this.offset);
        } else {
            this.movePointer(this.offset.elementAt(id2));
            if (objectRef.charAt(0) == '<') {
                raw = this.objectReader.readObjectData(-1, pdfObject);
            } else if (this.ObjLengthTable == null || this.offset.isRefTableInvalid()) {
                raw = this.getPointer() == 0L ? new byte[]{} : this.objectReader.readObjectData(-1, pdfObject);
            } else if (id2 > this.ObjLengthTable.length || this.ObjLengthTable[id2] == 0) {
                LogWriter.writeLog(objectRef + " cannot have offset 0");
                raw = new byte[]{};
            } else {
                raw = this.objectReader.readObjectData(this.ObjLengthTable[id2], pdfObject);
            }
        }
        return raw;
    }

    private byte[] readCompressedObjectData(PdfObject pdfObject, Offsets offset) {
        byte[] raw;
        int objectID = pdfObject.getObjectRefID();
        int compressedID = (int)offset.elementAt(objectID);
        String startID = null;
        int First2 = this.lastFirst;
        boolean isCached = true;
        byte[] compressedStream = this.lastCompressedStream;
        Map<String, String> offsetStart = this.lastOffsetStart;
        Map<String, String> offsetEnd = this.lastOffsetEnd;
        PdfObject Extends = null;
        if (this.lastOffsetStart != null) {
            startID = this.lastOffsetStart.get(String.valueOf(objectID));
        }
        while (startID == null) {
            if (Extends != null) {
                this.compressedObj = Extends;
            } else if (compressedID != this.lastCompressedID) {
                isCached = false;
                this.movePointer(offset.elementAt(compressedID));
                raw = this.objectReader.readObjectData(this.ObjLengthTable[compressedID], null);
                this.compressedObj = new CompressedObject(compressedID, 0);
                ObjectDecoder objDecoder = new ObjectDecoder(this);
                objDecoder.readDictionaryAsObject(this.compressedObj, 0, raw);
            }
            offsetStart = new HashMap<String, String>();
            offsetEnd = new HashMap<String, String>();
            First2 = this.compressedObj.getInt(960643930);
            compressedStream = this.compressedObj.getDecodedStream();
            CompressedObjects.extractCompressedObjectOffset(offsetStart, offsetEnd, First2, compressedStream, compressedID, offset);
            startID = offsetStart.get(String.valueOf(objectID));
            Extends = this.compressedObj.getDictionary(894663815);
            if (Extends != null) continue;
        }
        if (!isCached) {
            this.lastCompressedStream = compressedStream;
            this.lastCompressedID = compressedID;
            this.lastOffsetStart = offsetStart;
            this.lastOffsetEnd = offsetEnd;
            this.lastFirst = First2;
        }
        int start = First2 + Integer.parseInt(startID);
        int end = compressedStream.length;
        String endID = offsetEnd.get(String.valueOf(objectID));
        if (endID != null) {
            end = First2 + Integer.parseInt(endID);
        }
        int streamLength = end - start;
        raw = new byte[streamLength];
        System.arraycopy(compressedStream, start, raw, 0, streamLength);
        pdfObject.setInCompressedStream(true);
        return raw;
    }

    public byte[] readObjectAsByteArray(PdfObject pdfObject, boolean isCompressed, int objectID, int gen) {
        byte[] raw = null;
        if (this.linHintTable != null) {
            raw = this.linHintTable.getObjData(objectID);
        }
        if (raw == null) {
            if (isCompressed) {
                raw = this.readCompressedObjectAsByteArray(pdfObject, objectID, gen);
            } else {
                long objectOffset = this.offset.elementAt(objectID);
                if (objectOffset == 0L) {
                    return null;
                }
                this.movePointer(objectOffset);
                if (this.ObjLengthTable == null || this.offset.isRefTableInvalid()) {
                    raw = this.objectReader.readObjectData(-1, pdfObject);
                } else {
                    if (objectID > this.ObjLengthTable.length) {
                        return null;
                    }
                    raw = this.objectReader.readObjectData(this.ObjLengthTable[objectID], pdfObject);
                }
            }
        }
        int j2 = 0;
        if (raw.length > 15) {
            for (int i2 = 0; i2 < 10 && (raw[i2] != 111 || raw[i2 + 1] != 98 || raw[i2 + 2] != 106); ++i2) {
                if (raw[i2] != 101 || raw[i2 + 1] != 110 || raw[i2 + 2] != 100 || raw[i2 + 3] != 111 || raw[i2 + 4] != 98 || raw[i2 + 5] != 106) continue;
                j2 = i2 + 6;
                this.objectReader.fileIsBroken = true;
                break;
            }
        }
        while (raw[j2] == 10 || raw[j2] == 12 || raw[j2] == 32) {
            ++j2;
        }
        if (j2 > 0) {
            byte[] oldBuffer = raw;
            int newLength = raw.length - j2;
            raw = new byte[newLength];
            System.arraycopy(oldBuffer, j2, raw, 0, newLength);
        }
        return raw;
    }

    private byte[] readCompressedObjectAsByteArray(PdfObject pdfObject, int objectID, int gen) {
        byte[] raw;
        int compressedID = (int)this.offset.elementAt(objectID);
        String startID = null;
        Map<String, String> offsetStart = this.lastOffsetStart;
        Map<String, String> offsetEnd = this.lastOffsetEnd;
        int First2 = this.lastFirst;
        boolean isCached = true;
        byte[] compressedStream = this.lastCompressedStream;
        if (this.lastOffsetStart != null) {
            startID = this.lastOffsetStart.get(String.valueOf(objectID));
        }
        int lastCompressedID = -1;
        while (startID == null) {
            isCached = false;
            if (lastCompressedID == compressedID) {
                throw new RuntimeException("Compressed Object stream corrupted - PDF file broken");
            }
            try {
                this.pdf_datafile.seek(this.offset.elementAt(compressedID));
            }
            catch (IOException e2) {
                LogWriter.writeLog("Exception " + e2 + " moving pointer in file.");
            }
            lastCompressedID = compressedID;
            raw = this.objectReader.readObjectData(this.ObjLengthTable[compressedID], null);
            String compref = compressedID + " " + gen + " R";
            CompressedObject compressedObj = new CompressedObject(compref);
            ObjectDecoder objDecoder = new ObjectDecoder(this);
            objDecoder.readDictionaryAsObject(compressedObj, 0, raw);
            offsetStart = new HashMap<String, String>();
            offsetEnd = new HashMap<String, String>();
            First2 = ((PdfObject)compressedObj).getInt(960643930);
            compressedStream = compressedObj.getDecodedStream();
            CompressedObjects.extractCompressedObjectOffset(offsetStart, offsetEnd, First2, compressedStream, compressedID, this.offset);
            startID = offsetStart.get(String.valueOf(objectID));
            PdfObject Extends = ((PdfObject)compressedObj).getDictionary(894663815);
            String compressedRef = Extends == null ? null : Extends.getObjectRefAsString();
            if (compressedRef == null) continue;
            compressedID = Integer.parseInt(compressedRef.substring(0, compressedRef.indexOf(32)));
        }
        if (!isCached) {
            this.lastCompressedStream = compressedStream;
            this.lastOffsetStart = offsetStart;
            this.lastOffsetEnd = offsetEnd;
            this.lastFirst = First2;
        }
        int start = First2 + Integer.parseInt(startID);
        int end = compressedStream.length;
        String endID = offsetEnd.get(String.valueOf(objectID));
        if (endID != null) {
            end = First2 + Integer.parseInt(endID);
        }
        int streamLength = end - start;
        raw = new byte[streamLength];
        System.arraycopy(compressedStream, start, raw, 0, streamLength);
        pdfObject.setInCompressedStream(true);
        return raw;
    }

    public byte[] readPageIntoStream(PdfObject pdfObject) {
        byte[][] pageContents = pdfObject.getKeyArray(1216184967);
        byte[] binary_data = new byte[]{};
        if (pageContents == null || pageContents.length > 0 && pageContents[0] == null) {
            return binary_data;
        }
        int count = pageContents.length;
        for (int ii = 0; ii < count; ++ii) {
            StreamObject streamData = new StreamObject(new String(pageContents[ii]));
            streamData.isDataExternal(pdfObject.isDataExternal());
            this.readObject(streamData);
            byte[] decoded_stream_data = streamData.getDecodedStream();
            binary_data = ii == 0 && decoded_stream_data != null ? decoded_stream_data : PdfFileReader.appendData(binary_data, decoded_stream_data);
        }
        return binary_data;
    }

    private static byte[] appendData(byte[] binary_data, byte[] decoded_stream_data) {
        if (decoded_stream_data != null) {
            int current_length = binary_data.length + 1;
            int processed_length = decoded_stream_data.length;
            if (processed_length > 0) {
                while (processed_length > 0 && decoded_stream_data[processed_length - 1] == 0) {
                    --processed_length;
                }
                byte[] temp = new byte[current_length];
                System.arraycopy(binary_data, 0, temp, 0, current_length - 1);
                temp[current_length - 1] = 32;
                binary_data = new byte[current_length + processed_length];
                System.arraycopy(temp, 0, binary_data, 0, current_length);
                System.arraycopy(decoded_stream_data, 0, binary_data, current_length, processed_length);
            }
        }
        return binary_data;
    }

    public void setCertificate(Certificate certificate, PrivateKey key) {
        this.certificate = certificate;
        this.key = key;
    }

    public final PdfObject readReferenceTable(PdfObject linearObj) throws PdfException {
        PdfObject rootObj = this.refTable.readReferenceTable(linearObj, this, this.objectReader);
        PdfObject encryptObj = this.refTable.getEncryptionObject();
        if (encryptObj != null) {
            this.setupDecryption(encryptObj, this);
        }
        this.ObjLengthTable = this.offset.calculateObjectLength(this.eof);
        return rootObj;
    }

    private void setupDecryption(PdfObject encryptObj, PdfFileReader pdfFileReader) throws PdfSecurityException {
        try {
            byte[] ID2 = this.refTable.getID();
            this.decryption = this.certificate != null ? new DecryptionFactory(ID2, this.certificate, this.key) : new DecryptionFactory(ID2, this.encryptionPassword);
            if (this.encyptionObj == null) {
                byte[] encData = encryptObj.getUnresolvedData();
                if (encData[0] == 60) {
                    this.encyptionObj = new EncryptionObject(encryptObj.getObjectRefAsString());
                    ObjectDecoder objDecoder = new ObjectDecoder(this);
                    objDecoder.readDictionaryAsObject(this.encyptionObj, 0, encData);
                } else {
                    this.encyptionObj = new EncryptionObject(new String(encData));
                    this.readObject(this.encyptionObj);
                }
            }
            this.decryption.readEncryptionObject(this.encyptionObj, pdfFileReader);
        }
        catch (Error err) {
            LogWriter.writeLog("Error setting up decryption " + err.getMessage());
            throw new RuntimeException("Exception in code " + err.getMessage() + " please send to IDRsolutions");
        }
    }

    public byte[] getEncHash() {
        return this.encryptionPassword;
    }

    public int getOffsetCapacity() {
        return this.offset.getCapacity();
    }
}

