/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.util.HashMap;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.PageLabelObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class PageLabels
extends HashMap<Integer, String> {
    private final PdfFileReader objectReader;
    private final int pageCount;
    private static final String[] symbolLowerCase = new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"};
    private static final String[] symbolUpperCase = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final String[] lettersLowerCase = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "x", "w", "y", "z"};
    private static final String[] lettersUpperCase = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "X", "W", "Y", "Z"};
    private static final int[] power = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};

    PageLabels(PdfFileReader objectReader, int pageCount) {
        this.objectReader = objectReader;
        this.pageCount = pageCount;
    }

    void readLabels(PdfObject pageObj) {
        PdfArrayIterator numList = pageObj.getMixedArray(507854147);
        String objKey = pageObj.getArrayRef(507854147);
        if (numList != null && this.objectReader != null && numList.hasMoreTokens()) {
            boolean isFirstToken = true;
            int startPage = numList.getNextValueAsInteger(true) + 1;
            while (numList.hasMoreTokens()) {
                PageLabelObject labelObj = this.getObject(numList.getNextValueAsByte(true), objKey);
                int numbType = labelObj.getNameAsConstant(35);
                String pageLabel = labelObj.getTextStreamValue(32);
                int St = labelObj.getInt(9028);
                int pageNum = St > 0 ? St : 1;
                if (isFirstToken) {
                    if (numbType == 20 && pageLabel == null && St <= 0 && !numList.hasMoreTokens()) break;
                    if (startPage != 1) {
                        for (int i2 = 1; i2 < startPage; ++i2) {
                            this.put(i2, "");
                        }
                    }
                    isFirstToken = false;
                }
                int endPage = numList.hasMoreTokens() ? numList.getNextValueAsInteger(true) + 1 : this.pageCount + 1;
                for (int page = startPage; page < endPage; ++page) {
                    String convertedPage = pageLabel != null ? pageLabel + PageLabels.getNumberValue(numbType, pageNum) : PageLabels.getNumberValue(numbType, pageNum);
                    this.put(page, convertedPage);
                    ++pageNum;
                }
                startPage = endPage;
            }
        }
    }

    private PageLabelObject getObject(byte[] data, String ref) {
        PageLabelObject labelObj = new PageLabelObject(new String(data));
        labelObj.setUnresolvedData(data, 1768585381);
        if (ref != null) {
            labelObj.setRef(ref);
        }
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(labelObj);
        return labelObj;
    }

    private static String getNumberValue(int numbType, int page) {
        String convertedPage;
        switch (numbType) {
            case 49: {
                convertedPage = PageLabels.convertLetterToNumber(page, lettersLowerCase);
                break;
            }
            case 17: {
                convertedPage = PageLabels.convertLetterToNumber(page, lettersUpperCase);
                break;
            }
            case 20: {
                convertedPage = String.valueOf(page);
                break;
            }
            case 34: {
                convertedPage = PageLabels.convertToRoman(page, symbolUpperCase);
                break;
            }
            case 66: {
                convertedPage = PageLabels.convertToRoman(page, symbolLowerCase);
                break;
            }
            default: {
                convertedPage = "";
            }
        }
        return convertedPage;
    }

    private static String convertToRoman(int arabicNumber, String[] symbols) {
        StringBuilder romanNumeral = new StringBuilder();
        int x2 = 0;
        while (arabicNumber > 0) {
            int repeat = arabicNumber / power[x2];
            for (int chars = 1; chars <= repeat; ++chars) {
                romanNumeral.append(symbols[x2]);
            }
            arabicNumber %= power[x2];
            ++x2;
        }
        return romanNumeral.toString();
    }

    private static String convertLetterToNumber(int page, String[] letters) {
        StringBuilder finalLetters = new StringBuilder();
        int repeat = page / 26;
        int remainder = page % 26;
        if (repeat > 0) {
            for (int x2 = 0; x2 < repeat; ++x2) {
                finalLetters.append(letters[25]);
            }
        }
        if (remainder != 0) {
            finalLetters.append(letters[remainder - 1]);
        }
        return finalLetters.toString();
    }
}

