/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.DecodeParmsObject;
import org.jpedal.objects.raw.PdfObject;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    public static byte[] checkEndObject(byte[] array) {
        long objStart = -1L;
        long lastEndStream = -1L;
        int ObjStartCount = 0;
        for (int i2 = 0; i2 < array.length - 8; ++i2) {
            if (ObjStartCount < 2 && array[i2] == 32 && array[i2 + 1] == 111 && array[i2 + 2] == 98 && array[i2 + 3] == 106) {
                ++ObjStartCount;
                objStart = i2;
            }
            if (ObjStartCount >= 2 || array[i2] != 101 || array[i2 + 1] != 110 || array[i2 + 2] != 100 || array[i2 + 3] != 115 || array[i2 + 4] != 116 || array[i2 + 5] != 114 || array[i2 + 6] != 101 || array[i2 + 7] != 97 || array[i2 + 8] != 109) continue;
            lastEndStream = i2 + 9;
        }
        if (lastEndStream > 0L && objStart > lastEndStream) {
            byte[] newArray = new byte[(int)lastEndStream];
            System.arraycopy(array, 0, newArray, 0, (int)lastEndStream);
            array = newArray;
        }
        return array;
    }

    private static byte[] readRawValue(int j2, byte[] data, int start) {
        int stringLength = j2 - start;
        if (stringLength < 1) {
            return new byte[0];
        }
        byte[] newString = new byte[stringLength];
        System.arraycopy(data, start, newString, 0, stringLength);
        return newString;
    }

    public static byte[] readEscapedValue(int j2, byte[] data, int start, boolean keepReturns) {
        boolean escapedValues = false;
        for (int aa2 = start; aa2 < j2; ++aa2) {
            if (data[aa2] != 92 && (data[aa2] != 10 || data[aa2 - 1] != 13) && data[aa2] != 13) continue;
            escapedValues = true;
            break;
        }
        if (!escapedValues) {
            return ObjectUtils.readRawValue(j2, data, start);
        }
        return ObjectUtils.convertEscapedValues(j2, start, data, keepReturns);
    }

    private static byte[] convertEscapedValues(int j2, int start, byte[] data, boolean keepReturns) throws NumberFormatException {
        int jj = 0;
        int stringLength = j2 - start;
        byte[] newString = new byte[stringLength];
        for (int aa2 = start; aa2 < j2; ++aa2) {
            if (data[aa2] == 92) {
                byte nextByte;
                if (data[++aa2] == 13 && data[aa2 + 1] != 92 && newString[0] == -2 && newString[1] == -1) {
                    ++aa2;
                }
                if ((nextByte = data[aa2]) == 98) {
                    newString[jj] = 8;
                } else if (nextByte == 110) {
                    newString[jj] = 10;
                } else if (nextByte == 116) {
                    newString[jj] = 9;
                } else if (nextByte == 114) {
                    newString[jj] = 13;
                } else if (nextByte == 102) {
                    newString[jj] = 12;
                } else if (nextByte == 92) {
                    newString[jj] = 92;
                } else if (nextByte > 47 && nextByte < 58) {
                    StringBuilder octal = new StringBuilder(3);
                    boolean notOctal = false;
                    for (int ii = 0; ii < 3 && data[aa2] != 92 && data[aa2] != 41 && data[aa2] >= 48 && data[aa2] <= 57; ++ii) {
                        octal.append((char)data[aa2]);
                        if (data[aa2] > 55) {
                            notOctal = true;
                        }
                        ++aa2;
                    }
                    --aa2;
                    newString[jj] = notOctal ? (byte)Integer.parseInt(octal.toString()) : (byte)Integer.parseInt(octal.toString(), 8);
                } else if (!keepReturns && (nextByte == 13 || data[aa2] == 10 && data[aa2 - 1] == 13)) {
                    --jj;
                } else if (nextByte == 13 && data[aa2 + 1] == 10) {
                    --jj;
                    ++aa2;
                } else if (nextByte == 13) {
                    --jj;
                } else {
                    newString[jj] = nextByte;
                }
                ++jj;
                continue;
            }
            if (!keepReturns && (data[aa2] == 13 || data[aa2] == 10 && data[aa2 - 1] == 13)) {
                newString[jj] = 32;
                ++jj;
                continue;
            }
            newString[jj] = data[aa2];
            ++jj;
        }
        byte[] rawString = newString;
        newString = new byte[jj];
        System.arraycopy(rawString, 0, newString, 0, jj);
        return newString;
    }

    public static PdfObject[] setupDecodeParms(PdfObject pdfObject, PdfFileReader objReader) {
        PdfObject[] decodeParmsValues;
        Object[] DecodeParmsArray = pdfObject.getObjectArray(1888135062);
        if (DecodeParmsArray != null) {
            int count = DecodeParmsArray.length;
            decodeParmsValues = new PdfObject[count];
            for (int i2 = 0; i2 < count; ++i2) {
                byte[] decodeByteData = (byte[])DecodeParmsArray[i2];
                if (decodeByteData != null) {
                    String key = new String(decodeByteData);
                    DecodeParmsObject DecodeParms = new DecodeParmsObject(key);
                    DecodeParms.setUnresolvedData(decodeByteData, 1888135062);
                    ObjectDecoder objDecoder = new ObjectDecoder(objReader);
                    objDecoder.checkResolved(DecodeParms);
                    decodeParmsValues[i2] = DecodeParms;
                    continue;
                }
                decodeParmsValues[i2] = null;
            }
        } else {
            decodeParmsValues = new PdfObject[]{pdfObject.getDictionary(1888135062)};
        }
        return decodeParmsValues;
    }

    static int handleUnknownType(int i2, byte[] raw, int length) {
        int count = length - 1;
        for (int jj = i2; jj < count; ++jj) {
            if (raw[jj] == 82 && raw[jj - 2] == 48) {
                return jj;
            }
            if (raw[jj] == 60 && raw[jj + 1] == 60) {
                int levels = 0;
                do {
                    if (raw[jj] == 40 && !ObjectUtils.isEscaped(raw, jj)) {
                        jj = ObjectUtils.skipToEndOfTextStream(jj, count, raw);
                    }
                    if (raw[jj] == 60 && raw[jj + 1] == 60) {
                        ++levels;
                        continue;
                    }
                    if (raw[jj] != 62 || raw[jj + 1] != 62) continue;
                    --levels;
                    if (raw[jj + 2] != 62) continue;
                    ++jj;
                } while (levels != 0 && ++jj < count);
                return jj;
            }
            if (raw[jj] == 47) {
                return i2;
            }
            if (raw[jj] == 62 && raw[jj + 1] == 62) {
                return jj - 1;
            }
            if (raw[jj] != 40) continue;
            return ObjectUtils.skipToEndOfTextStream(jj, count, raw);
        }
        return i2;
    }

    private static int skipToEndOfTextStream(int jj, int count, byte[] raw) {
        while (jj < count && (raw[jj] != 41 || ObjectUtils.isEscaped(raw, jj))) {
            ++jj;
        }
        return jj;
    }

    public static boolean isEscaped(byte[] raw, int i2) {
        int j2 = i2 - 1;
        int escapedFound = 0;
        while (j2 > -1 && raw[j2] == 92) {
            --j2;
            ++escapedFound;
        }
        return escapedFound & true;
    }

    public static int setDirectValue(PdfObject pdfObject, int i2, byte[] raw, int PDFkeyInt) {
        int keyStart = ++i2;
        while (i2 < raw.length && raw[i2] != 32 && raw[i2] != 10 && raw[i2] != 13) {
            ++i2;
        }
        pdfObject.setConstant(PDFkeyInt, keyStart, i2 - keyStart, raw);
        return i2;
    }

    static void showData(PdfObject pdfObject, int i2, byte[] raw, String padding) {
        int length = raw.length;
        System.out.println("\n\n" + padding + " ------------readDictionaryAsObject ref=" + pdfObject.getObjectRefAsString() + " into " + pdfObject + "-----------------\ni=" + i2 + "\nData=>>>>");
        System.out.print(padding);
        for (int jj = i2; jj < length; ++jj) {
            System.out.print((char)raw[jj]);
            if (raw[jj] == 37) {
                jj = StreamReaderUtils.skipComment(raw, jj);
            }
            if (jj > 5 && raw[jj - 5] == 115 && raw[jj - 4] == 116 && raw[jj - 3] == 114 && raw[jj - 2] == 101 && raw[jj - 1] == 97 && raw[jj] == 109 || jj > 2 && raw[jj - 2] == 66 && raw[jj - 1] == 68 && raw[jj] == 67) break;
        }
        System.out.println(padding + "\n<<<<-----------------------------------------------------\n");
    }

    public static String showMixedValuesAsString(Object[] objectValues, String values) {
        if (objectValues == null) {
            return "null";
        }
        values = values + '[';
        int count = objectValues.length;
        for (int jj = 0; jj < count; ++jj) {
            if (objectValues[jj] == null) {
                values = values + "null ";
                continue;
            }
            if (objectValues[jj] instanceof byte[]) {
                values = values + new String((byte[])objectValues[jj]);
                if (count - jj <= 1) continue;
                values = values + " , ";
                continue;
            }
            values = ObjectUtils.showMixedValuesAsString((Object[])objectValues[jj], values) + ']';
            if (count - jj <= 1) continue;
            values = values + " ,";
        }
        return values;
    }

    public static int skipToEndOfObject(int start, byte[] data) {
        start += 2;
        int level = 1;
        while (level > 0) {
            if (data[start] == 60 && data[start + 1] == 60) {
                start += 2;
                ++level;
                continue;
            }
            if (data[start] == 62 && data[start + 1] == 62) {
                start += 2;
                --level;
                continue;
            }
            ++start;
        }
        return start;
    }
}

