/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.idrsolutions.image.JDeli;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jpedal.io.IdrInputStream;
import org.jpedal.io.TempStoreImage;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class ObjectStore {
    private static final Map<String, String> undeletedFiles = new ConcurrentHashMap<String, String>();
    public static boolean isMultiThreaded;
    private static boolean checkedThisSession;
    private static final String separator;
    private String currentFilename = "";
    private String currentFilePath = "";
    public static String temp_dir;
    public static String multiThreaded_root_dir;
    private String key = "jpedal" + Math.random() + '_';
    private final Map<String, String> tempFileNames = new HashMap<String, String>();
    public static final Integer IMAGE_WIDTH;
    public static final Integer IMAGE_HEIGHT;
    public static final Integer IMAGE_pX;
    public static final Integer IMAGE_pY;
    public static final Integer IMAGE_MASKCOL;
    public static final Integer IMAGE_DEPTH;
    public static final Integer IMAGE_COMPONENT_COUNT;
    public static long time;
    public String fullFileName;
    private static final Map<String, String> pagesOnDisk;
    private static final Map<String, String> pagesOnDiskAsBytes;
    private final Map<Integer, String> imagesOnDiskAsBytes = new HashMap<Integer, String>();
    private final Map<Integer, Integer> imagesOnDiskAsBytesW = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> imagesOnDiskAsBytesH = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> imagesOnDiskAsBytesD = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> imagesOnDiskAsBytespX = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> imagesOnDiskAsBytespY = new HashMap<Integer, Integer>();
    private final Map<Integer, byte[]> imagesOnDiskMask = new HashMap<Integer, byte[]>();
    private final Map<Integer, Integer> imagesOnDiskCompCount = new HashMap<Integer, Integer>();
    private static final boolean storeMemoryImages = true;
    private final Map<String, BufferedImage> memoryBufferMap = new HashMap<String, BufferedImage>();
    private int memoryBufferDim;
    private byte[] encHash;
    private byte[] idrPassword;

    public ObjectStore() {
        ObjectStore.setProperties();
        ObjectStore.init();
    }

    private static void setProperties() {
        String tempDir = System.getProperty("org.jpedal.tempDir");
        if (tempDir != null) {
            temp_dir = tempDir;
        }
    }

    private static void init() {
        try {
            if (temp_dir.isEmpty()) {
                temp_dir = System.getProperty("java.io.tmpdir");
            }
            if (isMultiThreaded) {
                temp_dir = multiThreaded_root_dir != null ? multiThreaded_root_dir + separator + "jpedal-" + System.currentTimeMillis() + separator : System.getProperty("java.io.tmpdir") + separator + "jpedal-" + System.currentTimeMillis() + separator;
            } else if (temp_dir.isEmpty()) {
                temp_dir = temp_dir + separator + "jpedal" + separator;
            } else if (!temp_dir.endsWith(separator)) {
                temp_dir = temp_dir + separator;
            }
            File f2 = new File(temp_dir);
            if (!f2.exists()) {
                f2.mkdirs();
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Unable to create temp dir at " + temp_dir + ' ' + e2);
        }
    }

    private void addMemoryImage(String ref, BufferedImage image) {
        int ih;
        int iw = image.getWidth();
        int dim = iw * (ih = image.getHeight());
        if (dim < 65536) {
            if (this.memoryBufferDim > 0x1000000) {
                this.memoryBufferDim = dim;
                this.memoryBufferMap.clear();
            }
            this.memoryBufferMap.put(ref, image);
            this.memoryBufferDim += dim;
        }
    }

    private BufferedImage getMemoryImage(String ref) {
        return this.memoryBufferMap.get(ref);
    }

    public String getCurrentFilename() {
        return this.currentFilename;
    }

    public String getCurrentFilepath() {
        return this.currentFilePath;
    }

    public final void storeFileName(String name) {
        this.fullFileName = name;
        int ptr = this.fullFileName.lastIndexOf(47);
        int ptr2 = this.fullFileName.lastIndexOf(92);
        if (ptr2 > ptr) {
            ptr = ptr2;
        }
        this.currentFilePath = ptr > 0 ? this.fullFileName.substring(0, ptr + 1) : "";
        int temp_pointer = name.indexOf(92);
        if (temp_pointer == -1) {
            temp_pointer = name.indexOf(47);
        }
        while (temp_pointer != -1) {
            if ((temp_pointer = (name = name.substring(temp_pointer + 1)).indexOf(92)) != -1) continue;
            temp_pointer = name.indexOf(47);
        }
        int pointer = name.lastIndexOf(46);
        if (pointer != -1) {
            name = name.substring(0, pointer);
        }
        name = Strip.stripAllSpaces(name);
        this.currentFilename = name.toLowerCase();
    }

    public boolean checkTempFileExists(String filename) {
        return this.tempFileNames.containsKey(temp_dir + this.key + filename);
    }

    public final boolean saveStoredImageAsBytes(String currentImage, BufferedImage image, boolean file_name_is_path) {
        try {
            File checkDir = new File(temp_dir);
            if (!checkDir.exists()) {
                checkDir.mkdirs();
            }
            String fileName = currentImage + ".jpl";
            if (!file_name_is_path) {
                fileName = temp_dir + this.key + currentImage + ".jpl";
            }
            if (image != null) {
                this.addMemoryImage(fileName, image);
            }
            if (image != null) {
                byte[] data = TempStoreImage.getBytes(image);
                ObjectStore.writeToFile(fileName, data, this.encHash);
            }
            this.tempFileNames.put(fileName, "#");
            return false;
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " flushing files");
            return true;
        }
    }

    public final void init(String current_key) {
        this.key = current_key + System.currentTimeMillis();
        File f2 = new File(temp_dir);
        if (!f2.exists()) {
            f2.mkdirs();
        }
    }

    public final void flush() {
        for (Integer n2 : this.imagesOnDiskAsBytes.keySet()) {
            File file;
            if (n2 == null || !(file = new File(this.imagesOnDiskAsBytes.get(n2))).exists()) continue;
            file.delete();
        }
        this.imagesOnDiskAsBytes.clear();
        this.imagesOnDiskAsBytesW.clear();
        this.imagesOnDiskAsBytesH.clear();
        this.imagesOnDiskAsBytesD.clear();
        this.imagesOnDiskAsBytespX.clear();
        this.imagesOnDiskAsBytespY.clear();
        this.imagesOnDiskMask.clear();
        this.imagesOnDiskCompCount.clear();
        Iterator<String> tempFilesToDelete = this.tempFileNames.keySet().iterator();
        while (tempFilesToDelete.hasNext()) {
            String string = tempFilesToDelete.next();
            File file = new File(string);
            if (!file.exists() || file.delete()) {
                tempFilesToDelete.remove();
                continue;
            }
            undeletedFiles.put(string, "x");
        }
        try {
            if (!checkedThisSession && temp_dir.length() > 2) {
                checkedThisSession = true;
                File[] fileArray = new File(temp_dir).listFiles();
                if (fileArray != null) {
                    for (File file : fileArray) {
                        String fileName = file.getName();
                        if (fileName.contains(this.key)) {
                            file.delete();
                        }
                        if (fileName.endsWith(".pdf") || !fileName.contains("jpedal") || System.currentTimeMillis() - file.lastModified() < time) continue;
                        file.delete();
                    }
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " flushing files");
        }
        for (String string : undeletedFiles.keySet()) {
            File delete_file2 = new File(string);
            if (delete_file2.exists() && !delete_file2.delete()) continue;
            undeletedFiles.remove(string);
        }
    }

    public BufferedImage loadStoredImage(String current_image) {
        BufferedImage bufferedImage;
        if (current_image == null) {
            return null;
        }
        String file_name = temp_dir + this.key + current_image + ".jpl";
        File file = new File(file_name);
        if (!file.exists()) {
            return null;
        }
        BufferedImage mem = this.getMemoryImage(file_name);
        if (mem != null) {
            return mem;
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] data = new byte[(int)file.length()];
            if (this.encHash != null) {
                CryptoIDR crypto = new CryptoIDR(this.encHash);
                try (IdrInputStream cryptStream = new IdrInputStream(fis, crypto);){
                    cryptStream.read(data);
                }
            }
            try (BufferedInputStream is = new BufferedInputStream(fis);){
                is.read(data);
            }
            bufferedImage = TempStoreImage.getImage(data);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
                try {
                    return JDeli.read(new File(file_name));
                }
                catch (Exception ex) {
                    LogWriter.writeLog(ex);
                    return null;
                }
            }
        }
        fis.close();
        return bufferedImage;
    }

    public final void saveAsCopy(String current_image, String destination) {
        String source = temp_dir + this.key + current_image;
        try (BufferedInputStream from = new BufferedInputStream(Files.newInputStream(Paths.get(source, new String[0]), new OpenOption[0]));
             BufferedOutputStream to = new BufferedOutputStream(Files.newOutputStream(Paths.get(destination, new String[0]), new OpenOption[0]));){
            ObjectStore.copy(from, to);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " copying file");
        }
    }

    public static void copy(File source, File destination) {
        try (BufferedInputStream from = new BufferedInputStream(Files.newInputStream(source.toPath(), new OpenOption[0]));
             BufferedOutputStream to = new BufferedOutputStream(Files.newOutputStream(destination.toPath(), new OpenOption[0]));){
            ObjectStore.copy(from, to);
        }
        catch (IOException e2) {
            LogWriter.writeLog("Exception " + e2 + " copying file");
        }
    }

    public static void copy(String source, String destination) {
        ObjectStore.copy(new File(source), new File(destination));
    }

    public static void copyWithFail(String source, String destination) throws IOException {
        try (BufferedInputStream from = new BufferedInputStream(Files.newInputStream(Paths.get(source, new String[0]), new OpenOption[0]));
             BufferedOutputStream to = new BufferedOutputStream(Files.newOutputStream(Paths.get(destination, new String[0]), new OpenOption[0]));){
            ObjectStore.copy(from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream from, OutputStream to) {
        int length = 0;
        try {
            int bytes_read;
            byte[] buffer = new byte[65535];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
                length += bytes_read;
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " copying file");
        }
        finally {
            if (to != null) {
                try {
                    to.close();
                }
                catch (Exception e3) {
                    LogWriter.writeLog("Exception " + e3 + " closing files");
                }
            }
            if (from != null) {
                try {
                    from.close();
                }
                catch (Exception e4) {
                    LogWriter.writeLog("Exception " + e4 + " closing files");
                }
            }
        }
        return length;
    }

    public static int copyAndEncrypt(BufferedInputStream from, FileOutputStream to, byte[] password) {
        int bytesRead = 0;
        byte[] data = new byte[65535];
        try {
            int bytesToRead;
            CryptoIDR crypt = new CryptoIDR(password);
            while ((bytesToRead = from.read(data, 0, data.length)) != -1) {
                data = crypt.encrypt(data, bytesRead);
                to.write(data, 0, bytesToRead);
                bytesRead += bytesToRead;
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " copying file");
        }
        try {
            to.close();
            from.close();
        }
        catch (Exception e3) {
            LogWriter.writeLog("Exception " + e3 + " closing files");
        }
        return bytesRead;
    }

    public static void flushPages() {
        try {
            File delete_file;
            for (String file : pagesOnDisk.keySet()) {
                if (file == null || !(delete_file = new File(pagesOnDisk.get(file))).exists()) continue;
                delete_file.delete();
            }
            pagesOnDisk.clear();
            for (String file : pagesOnDiskAsBytes.keySet()) {
                if (file == null || !(delete_file = new File(pagesOnDiskAsBytes.get(file))).exists()) continue;
                delete_file.delete();
            }
            pagesOnDiskAsBytes.clear();
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " flushing files");
        }
    }

    public static byte[] getCachedPageAsBytes(String key) {
        byte[] data = null;
        String cachedFile = pagesOnDiskAsBytes.get(key);
        if (cachedFile != null) {
            File file = new File(cachedFile);
            data = new byte[(int)file.length()];
            try (FileInputStream fis = new FileInputStream(file);){
                CryptoIDR crypto = new CryptoIDR(key.getBytes());
                try (IdrInputStream cryptStream = new IdrInputStream(fis, crypto);){
                    cryptStream.read(data);
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        return data;
    }

    public static void cachePageAsBytes(String key, byte[] bytes) {
        try {
            File delete_file;
            if (pagesOnDiskAsBytes.containsKey(key) && (delete_file = new File(pagesOnDiskAsBytes.get(key))).exists()) {
                delete_file.delete();
            }
            String ff = File.createTempFile("bytes", ".bin", new File(temp_dir)).getAbsolutePath();
            ObjectStore.writeToFile(ff, bytes, key.getBytes());
            pagesOnDiskAsBytes.put(key, ff);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
    }

    public void saveRawImageData(String pageImgCount, byte[] bytes, int w2, int h2, int bpc, int pX, int pY, byte[] maskCol, int componentCount) {
        try {
            String ff = File.createTempFile("image", ".bin", new File(temp_dir)).getAbsolutePath();
            ObjectStore.writeToFile(ff, bytes, this.encHash);
            Integer key = Integer.valueOf(pageImgCount);
            this.imagesOnDiskAsBytes.put(key, ff);
            this.imagesOnDiskAsBytesW.put(key, w2);
            this.imagesOnDiskAsBytesH.put(key, h2);
            this.imagesOnDiskAsBytesD.put(key, bpc);
            this.imagesOnDiskAsBytespX.put(key, pX);
            this.imagesOnDiskAsBytespY.put(key, pY);
            this.imagesOnDiskMask.put(key, maskCol);
            this.imagesOnDiskCompCount.put(key, componentCount);
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception: " + e2.getMessage());
        }
    }

    public boolean isRawImageDataSaved(String number) {
        return this.imagesOnDiskAsBytes.get(Integer.valueOf(number)) != null;
    }

    public byte[] getRawImageData(String i2) {
        byte[] data;
        block20: {
            String cachedFile = this.imagesOnDiskAsBytes.get(Integer.valueOf(i2));
            if (cachedFile != null) {
                File file = new File(cachedFile);
                data = new byte[(int)file.length()];
                try (FileInputStream fis = new FileInputStream(file);){
                    if (this.encHash != null) {
                        CryptoIDR crypto = new CryptoIDR(this.encHash);
                        try (IdrInputStream cryptStream = new IdrInputStream(fis, crypto);){
                            cryptStream.read(data);
                            break block20;
                        }
                    }
                    try (BufferedInputStream is = new BufferedInputStream(fis);){
                        is.read(data);
                    }
                }
                catch (Exception e2) {
                    LogWriter.writeLog("Exception: " + e2.getMessage());
                }
            } else {
                data = null;
            }
        }
        return data;
    }

    public Object getRawImageDataParameter(String imageID, Integer key) {
        Integer lookup = Integer.valueOf(imageID);
        Object returnVal = null;
        if (key.equals(IMAGE_WIDTH)) {
            returnVal = this.imagesOnDiskAsBytesW.get(lookup);
        } else if (key.equals(IMAGE_HEIGHT)) {
            returnVal = this.imagesOnDiskAsBytesH.get(lookup);
        } else if (key.equals(IMAGE_DEPTH)) {
            returnVal = this.imagesOnDiskAsBytesD.get(lookup);
        } else if (key.equals(IMAGE_pX)) {
            returnVal = this.imagesOnDiskAsBytespX.get(lookup);
        } else if (key.equals(IMAGE_pY)) {
            returnVal = this.imagesOnDiskAsBytespY.get(lookup);
        } else if (key.equals(IMAGE_MASKCOL)) {
            returnVal = this.imagesOnDiskMask.get(lookup);
        } else if (key.equals(IMAGE_COMPONENT_COUNT)) {
            returnVal = this.imagesOnDiskCompCount.get(lookup);
        }
        return returnVal;
    }

    public static File createTempFile(String filename) throws IOException {
        StringBuilder prefix = new StringBuilder(filename.substring(0, filename.lastIndexOf(46)));
        while (prefix.length() < 3) {
            prefix.append('a');
        }
        String suffix = filename.substring(filename.lastIndexOf(46));
        if (suffix.length() < 3) {
            suffix = "pdf";
        }
        File tempURLFile = File.createTempFile(prefix.toString(), suffix, new File(temp_dir));
        return tempURLFile;
    }

    public void setFileToDeleteOnFlush(String rawFileName) {
        this.tempFileNames.put(rawFileName, "#");
    }

    public String getKey() {
        return this.key;
    }

    public void setEncHash(byte[] pass) {
        this.encHash = pass;
    }

    public static void writeToFile(String fileName, byte[] data) throws IOException {
        ObjectStore.writeToFile(fileName, data, null);
    }

    public static void writeToFile(String fileName, byte[] data, byte[] password) throws IOException {
        if (password != null) {
            CryptoIDR crypto = new CryptoIDR(password);
            try {
                data = crypto.encrypt(data);
            }
            catch (Exception e2) {
                throw new IOException(e2);
            }
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(fileName));){
            fos.write(data);
        }
    }

    public static byte[] readFromFile(String fileName, byte[] password) throws IOException {
        byte[] data;
        block18: {
            File file = new File(fileName);
            data = new byte[(int)file.length()];
            try (FileInputStream fis = new FileInputStream(file);){
                if (password != null) {
                    CryptoIDR crypto = new CryptoIDR(password);
                    try (IdrInputStream cryptStream = new IdrInputStream(fis, crypto);){
                        cryptStream.read(data);
                        break block18;
                    }
                }
                try (BufferedInputStream is = new BufferedInputStream(fis);){
                    is.read(data);
                }
            }
            catch (Exception e2) {
                LogWriter.writeLog("Exception: " + e2.getMessage());
            }
        }
        return data;
    }

    public void flushPageLevelCaches() {
        this.memoryBufferMap.clear();
    }

    public void setIdrPassword(byte[] idrPassword) {
        this.idrPassword = idrPassword;
    }

    public byte[] getIdrPassword() {
        return this.idrPassword;
    }

    static {
        separator = System.getProperty("file.separator");
        temp_dir = "";
        IMAGE_WIDTH = 1;
        IMAGE_HEIGHT = 2;
        IMAGE_pX = 3;
        IMAGE_pY = 4;
        IMAGE_MASKCOL = 5;
        IMAGE_DEPTH = 7;
        IMAGE_COMPONENT_COUNT = 8;
        time = 14400000L;
        pagesOnDisk = new ConcurrentHashMap<String, String>();
        pagesOnDiskAsBytes = new ConcurrentHashMap<String, String>();
        ObjectStore.setProperties();
    }
}

